/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.grid;

import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.SortLabelRenderer;
import com.agentpp.common.StandardDialog;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBTablePanel;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.editors.IndexDialog;
import com.agentpp.explorer.grid.CellValueEditor;
import com.agentpp.explorer.grid.DisabledCellValueEditor;
import com.agentpp.explorer.grid.Index;
import com.agentpp.explorer.grid.MIBGridTablePanel_jButtonFindAgain_actionAdapter;
import com.agentpp.explorer.grid.MIBGridTablePanel_jButtonRefresh_actionAdapter;
import com.agentpp.explorer.grid.MIBGridTablePanel_jButtonSearch_actionAdapter;
import com.agentpp.explorer.grid.MIBTreeData;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.Controller;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.FormatTree;
import com.klg.jclass.higrid.GridScrollbarCallback;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridErrorListener;
import com.klg.jclass.higrid.HiGridFormatNodeAdapter;
import com.klg.jclass.higrid.HiGridFormatNodeEvent;
import com.klg.jclass.higrid.HiGridFormatNodeListener;
import com.klg.jclass.higrid.HiGridTraverseEvent;
import com.klg.jclass.higrid.HiGridTraverseListener;
import com.klg.jclass.higrid.HiGridUpdateAdapter;
import com.klg.jclass.higrid.HiGridUpdateEvent;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.SortLabelCellRenderer;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreeNode;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.snmp4j.smi.Variable;

public class MIBGridTablePanel
extends JPanel
implements HiGridErrorListener,
DataModelListener,
GridScrollbarCallback,
HiGridTraverseListener {
    private static final Color _$35989 = new Color(200, 215, 250);
    BorderLayout borderLayout1 = new BorderLayout();
    HiGrid hiGrid = new HiGrid();
    JMenu insertMenu;
    MIBTreeData data;
    JPanel toolBarPanel = new JPanel();
    JButton jButtonRefresh = new JButton();
    JFrame myFrame;
    RequestObserverPanel requestObserver;
    JScrollPane gridPane = new JScrollPane();
    HiGridFormatNodeListener formatNodeListener = new BaseExampleHiGridFormatNodeListener();
    JToolBar toolBar = new JToolBar();
    FlowLayout flowLayout1 = new FlowLayout();
    private int _$35995 = 0;
    private int _$35996 = 0;
    private int _$35997 = 0;
    private PatternMatcher _$35171 = new Perl5Matcher();
    private PatternCompiler _$35172 = new Perl5Compiler();
    private Pattern _$35173;
    private PatternMatcherInput _$29803;
    private MatchResult _$20126;
    private UserConfigFile _$4288;
    JButton jButtonSearch = new JButton();
    JButton jButtonFindAgain = new JButton();
    private boolean _$35177;

    public MIBGridTablePanel() {
        this(null, null, null, null);
    }

    public MIBGridTablePanel(JFrame jFrame, MIBTreeData mIBTreeData, UserConfigFile userConfigFile, RequestObserverPanel requestObserverPanel) {
        this.myFrame = jFrame;
        this.data = mIBTreeData;
        this._$4288 = userConfigFile;
        this.requestObserver = requestObserverPanel;
        this._$35177 = userConfigFile.getBoolean("mibexplorer.SetReadonly", false);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.add((Component)requestObserverPanel, "South");
        this.hiGrid.getHorizontalScrollbar().setDisplay(0);
        this.hiGrid.addHiGridFormatNodeListener(this.formatNodeListener);
        this.hiGrid.addHiGridUpdateListener(new AutoColumnSizeHiGridUpdateListener());
        this.hiGrid.setBatched(true);
        this.hiGrid.setRowtipVisible(true);
        this.hiGrid.getEditPopupMenu().setDefaultMenuList(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.insertMenu = new JMenu("Insert Row");
        JMenu jMenu = new JMenu("String Format");
        this._$36011(jMenu);
        this.hiGrid.getEditPopupMenu().add((Component)this.insertMenu, 0);
        this.hiGrid.getEditPopupMenu().add((Component)jMenu, 1);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new ExpandAction("Expand Current")), 6);
        this.hiGrid.setDataModel(mIBTreeData);
        this.hiGrid.setBatched(false);
        this.hiGrid.getErrorHandler().setShowErrorDialog(false);
        this.hiGrid.addHiGridErrorListener(this);
        this.hiGrid.setLevelIndented(false);
        this.hiGrid.getVerticalScrollbar().setRowtipCallback(this);
        SortLabelCellRenderer.setAscendingImage(SortLabelRenderer.ascendingIcon.getImage());
        SortLabelCellRenderer.setDescendingImage(SortLabelRenderer.descendingIcon.getImage());
        this.createFormats();
        this._$36024(new Integer(1));
        this._$10903();
        this.hiGrid.setSortable(new MIBTreeData.CellValueComparator(mIBTreeData));
        this.hiGrid.addHiGridTraverseListener(this);
    }

    public void afterTraverse(HiGridTraverseEvent hiGridTraverseEvent) {
        this._$5093("");
    }

    private void _$36011(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(new FormatAction("ASCII", "255a"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '255a', e.g. 'aBc' renders 'aBc'");
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu.add(new FormatAction("Decimal", "1d."));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1d.', e.g. 'aBc' renders '97.66.99'");
        jMenuItem.setMnemonic('D');
        jMenuItem = jMenu.add(new FormatAction("Hexadecimal", "1x:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1x:', e.g. 'aBc' renders '61:42:63'");
        jMenuItem.setMnemonic('H');
        jMenuItem = jMenu.add(new FormatAction("Octal", "1o:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1o:', e.g. 'aBc' renders '141:102:143'");
        jMenuItem.setMnemonic('O');
        jMenuItem = jMenu.add(new FormatAction("Binary", "1b:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1b:', e.g. 'aBc' renders '01100001:01000010:01100011'");
        jMenuItem.setMnemonic('B');
        jMenuItem = jMenu.add(new FormatAction("MIB", null));
        jMenuItem.setToolTipText("Sets the default display and input format for this string object as defined in the corresponding MIB module");
        jMenuItem.setMnemonic('M');
    }

    private void _$10903() {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class<?> clazz = classLoader.loadClass("java.awt.event.MouseWheelListener");
            Class<?> clazz2 = classLoader.loadClass("com.agentpp.common.grid.GridMouseWheelListener");
            Constructor<?> constructor = clazz2.getDeclaredConstructors()[0];
            Object[] objectArray = new Object[]{this.hiGrid};
            Object var6_13 = null;
            var6_13 = constructor.newInstance(objectArray);
            Class[] classArray = new Class[]{clazz};
            Method method = null;
            method = this.hiGrid.getClass().getMethod("addMouseWheelListener", classArray);
            objectArray[0] = var6_13;
            method.invoke((Object)this, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void createFormats() {
        FormatTree formatTree = this.hiGrid.getFormatTree();
        FormatNode formatNode = (FormatNode)formatTree.getRoot();
        this._$36035(formatNode);
    }

    private void _$36035(FormatNode formatNode) {
        RecordFormat recordFormat = formatNode.getRecordFormat();
        HeaderFormat headerFormat = formatNode.getHeaderFormat();
        Color color = new Color(220 - this._$35995 * 20 + this._$35997, 235 - this._$35995 * 20 + this._$35996, 250);
        headerFormat.setBackground(color);
        ++this._$35995;
        if (this._$35995 > 5) {
            this._$35995 = 0;
            this._$35997 = this._$35997 > -60 ? (this._$35997 -= 10) : 0;
            this._$35996 = this._$35996 < 20 ? (this._$35996 += 5) : 0;
        }
        this._$36040(recordFormat);
        for (int i = 0; i < formatNode.getChildCount(); ++i) {
            FormatNode formatNode2 = (FormatNode)formatNode.getChildAt(i);
            this._$36035(formatNode2);
        }
    }

    private void _$36040(RecordFormat recordFormat) {
        Vector vector = recordFormat.getDataFormats();
        Index index = (Index)((BaseMetaData)recordFormat.getMetaData()).getUserObject();
        this.insertMenu.add(new InsertAction(recordFormat.getMetaData().getDescription()));
        for (int i = 0; i < vector.size(); ++i) {
            CellFormat cellFormat = (CellFormat)vector.elementAt(i);
            try {
                if (i >= recordFormat.getMetaData().getColumnCount()) continue;
                String string = recordFormat.getMetaData().getColumnIdentifier(i);
                ColumnModel columnModel = recordFormat.getMetaData().getColumnObject(string);
                if (columnModel == null) continue;
                if (columnModel.getColumnName().endsWith("i")) {
                    cellFormat.setBackground(MIBTablePanel.INDEX_BACKGROUND);
                    cellFormat.setCellEditorName(DisabledCellValueEditor.class.getName());
                } else if (!columnModel.isReadOnly()) {
                    boolean bl;
                    MIBObjectType mIBObjectType = (MIBObjectType)index.getColumns().get(i);
                    boolean bl2 = bl = !MIBTreeData.isColumnReadOnly(mIBObjectType);
                    if (this._$35177 || bl) {
                        MIBTextualConvention mIBTextualConvention = this.data.getRepository().getEffectiveSyntax(mIBObjectType.getSyntax());
                        String string2 = CellValueEditor.getCellEditorSuffix(SMI.smiSyntax(mIBTextualConvention.getSyntax().getSyntax()), false);
                        cellFormat.setBackground(Color.blue);
                        cellFormat.setForeground(Color.white);
                        cellFormat.setCellEditorName("com.agentpp.explorer.grid.CellValueEditor" + string2);
                    } else {
                        cellFormat.setCellEditorName(DisabledCellValueEditor.class.getName());
                    }
                }
                cellFormat.setEditable(true);
                continue;
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jButtonRefresh.setIcon(MIBExplorerFrame.imageRefresh24);
        this.jButtonRefresh.setToolTipText("Refresh all");
        this.jButtonRefresh.addActionListener(new MIBGridTablePanel_jButtonRefresh_actionAdapter(this));
        this.toolBarPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.jButtonSearch.setToolTipText("Search the grid by a regular expression");
        this.jButtonSearch.setIcon(MIBExplorerFrame.imageFind24);
        this.jButtonSearch.addActionListener(new MIBGridTablePanel_jButtonSearch_actionAdapter(this));
        this.jButtonFindAgain.setToolTipText("Search again from the current position with the last search expression");
        this.jButtonFindAgain.setIcon(MIBExplorerFrame.imageFindAgain24);
        this.jButtonFindAgain.addActionListener(new MIBGridTablePanel_jButtonFindAgain_actionAdapter(this));
        this.add((Component)this.toolBarPanel, "North");
        this.toolBarPanel.add((Component)this.toolBar, null);
        this.toolBar.add((Component)this.jButtonSearch, null);
        this.toolBar.add((Component)this.jButtonFindAgain, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.jButtonRefresh, null);
        this.add((Component)this.hiGrid, "Center");
    }

    void jButtonRefresh_actionPerformed(ActionEvent actionEvent) {
        this.data.refresh(null, null);
    }

    public void processError(HiGridErrorEvent hiGridErrorEvent) {
        String string = hiGridErrorEvent.getException().getMessage();
        if (hiGridErrorEvent.getException() instanceof DataModelException) {
            DataModelException dataModelException = (DataModelException)hiGridErrorEvent.getException();
            Exception exception = dataModelException.getWrappedException();
            string = ((DataModelException)exception).getWrappedException().getMessage();
        }
        JOptionPane.showMessageDialog(this, string, "SNMP Error", 0);
    }

    public void newRow(String string) {
        BaseMetaData baseMetaData = (BaseMetaData)this.data.getMetaData(string);
        Index index = (Index)baseMetaData.getUserObject();
        IndexDialog indexDialog = new IndexDialog(this.data.getRepository(), index.getIndexValueConverter(), index.getIndexStructure(), this.myFrame, "Index of New Row for " + string, true, this._$4288.get("mibexplorer.vb.display.mode", null));
        indexDialog.setLocationRelativeTo(this);
        indexDialog.setVisible(true);
        if (indexDialog.getResult() == 0) {
            ObjectID objectID = indexDialog.getObjectID();
            MIBTreeData.MIBGridTable mIBGridTable = null;
            try {
                mIBGridTable = this.data.getTable(this.hiGrid.getDataModelListener(), objectID, index, string);
            }
            catch (DataModelException dataModelException) {
                JOptionPane.showMessageDialog(this, "Row cannot be inserted: " + dataModelException.getMessage(), "Row Insertion Failed", 0);
                return;
            }
            int n = mIBGridTable.getRow(objectID);
            if (n >= 0) {
                String[] stringArray = new String[]{"The row with index " + objectID.toString() + " already exists."};
                JOptionPane.showMessageDialog(this, stringArray, "Invalid Index", 0);
                return;
            }
            long l = mIBGridTable.addEmptyRow(indexDialog.getObjectID());
            this.hiGrid.resetRunTimeGrid();
            this.hiGrid.refresh();
            this._$35659(mIBGridTable, l);
        }
    }

    private void _$27543(TreeNode[] treeNodeArray) {
        for (int i = 1; i < treeNodeArray.length; ++i) {
            MIBTreeData.MIBGridTable mIBGridTable = (MIBTreeData.MIBGridTable)treeNodeArray[i];
            long l = mIBGridTable.getParentBookmark();
            RowNode rowNode = this.hiGrid.getRowNode(l);
            this.hiGrid.expandFolder(rowNode);
        }
    }

    private void _$36069(RowFormat rowFormat, Object object) {
        CellFormat cellFormat;
        int n = (Integer)object;
        Enumeration enumeration = rowFormat.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            cellFormat = (CellFormat)enumeration.nextElement();
            cellFormat.setBorderStyle(n);
        }
        enumeration = rowFormat.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            cellFormat = (CellFormat)enumeration.nextElement();
            cellFormat.setBorderStyle(n);
        }
    }

    private void _$4634(FormatNode formatNode, Object object) {
        this._$36069(formatNode.getRecordFormat(), object);
        this._$36069(formatNode.getHeaderFormat(), object);
        this._$36069(formatNode.getFooterFormat(), object);
        this._$36069(formatNode.getBeforeDetailsFormat(), object);
        this._$36069(formatNode.getAfterDetailsFormat(), object);
    }

    private void _$36075(FormatNode formatNode, Object object) {
        if (formatNode == null) {
            return;
        }
        this._$4634(formatNode, object);
        TreeIterator treeIterator = formatNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            formatNode = (FormatNode)treeIterator.get();
            this._$36075(formatNode, object);
            treeIterator.nextElement();
        }
    }

    private void _$36024(Object object) {
        FormatTree formatTree = this.hiGrid.getFormatTree();
        if (formatTree == null || formatTree.getRoot() == null) {
            return;
        }
        this._$36075((FormatNode)formatTree.getRoot(), object);
        this.hiGrid.refresh();
    }

    private void _$35659(MIBTreeData.MIBGridTable mIBGridTable, long l) {
        this._$27543(mIBGridTable.getPath());
        Controller controller = this.hiGrid.getController();
        RowNode rowNode = this.hiGrid.getRowNode(l);
        int n = mIBGridTable.getFirstWritableColumn();
        try {
            CellPosition cellPosition = new CellPosition(rowNode, n);
            controller.moveCurrentCell(cellPosition, n);
            if (cellPosition.getColumnIndex() > 0) {
                controller.makeCellEditorVisible();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$35659(MIBTreeData.MIBGridTable mIBGridTable, long l, int n) {
        this._$27543(mIBGridTable.getPath());
        Controller controller = this.hiGrid.getController();
        RowNode rowNode = this.hiGrid.getRowNode(l);
        CellPosition cellPosition = new CellPosition(rowNode, n);
        controller.moveCurrentCell(cellPosition, n);
    }

    private void _$5093(String string) {
        this.requestObserver.setMessage(string);
    }

    private Pattern _$35328(String string, boolean bl) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this._$35172.compile(string);
            }
            catch (MalformedPatternException malformedPatternException) {
                if (bl) break block2;
                JOptionPane.showMessageDialog(this, malformedPatternException.getMessage(), "Malformed Search Expression", 0);
            }
        }
        return pattern;
    }

    public String setRowtipText(RowNode rowNode, int n, Adjustable adjustable) {
        return "Row index: " + Integer.toString(n);
    }

    public void positionRowtip(Container container, Component component) {
        if (container != null) {
            component.setSize(200, 24);
            Dimension dimension = container.getSize();
            Dimension dimension2 = component.getSize();
            int n = 0;
            int n2 = (dimension.height - dimension2.height) / 2;
            component.setLocation(n, n2);
        }
    }

    boolean matchPattern(String string, String string2, boolean bl) {
        String string3;
        String string4;
        return bl ? string.equals(string2) : (string4 = string.toLowerCase()).indexOf(string3 = string2.toLowerCase()) != -1;
    }

    private boolean _$35330(Pattern pattern, boolean bl) {
        this._$5093("");
        CellPosition cellPosition = this.hiGrid.getCurrentCellPosition();
        this._$35173 = pattern;
        if (cellPosition == null) {
            cellPosition = new CellPosition(this.hiGrid.getRowNode(0), 0);
        }
        MIBTreeData.MIBGridTable mIBGridTable = (MIBTreeData.MIBGridTable)this.data.getCurrentGlobalTable();
        long l = this.data.getCurrentGlobalBookmark();
        int n = mIBGridTable.getRowIndex(l);
        if (!this._$36094(pattern, cellPosition.getColumnIndex(), mIBGridTable, n)) {
            this._$5093("Search complete!");
            return false;
        }
        return true;
    }

    private boolean _$36094(Pattern pattern, int n, MIBTreeData.MIBGridTable mIBGridTable, int n2) {
        for (int i = n2; i < mIBGridTable.getNumDataRows(); ++i) {
            Object object;
            int n3;
            int n4;
            long l = mIBGridTable.getRowIdentifier(i);
            for (n4 = n3 = i == n2 ? n + 1 : 0; n4 < mIBGridTable.getColumns().size(); ++n4) {
                object = null;
                try {
                    object = mIBGridTable.getCell(l, mIBGridTable.getMetaData().getColumnIdentifier(n4));
                }
                catch (DataModelException dataModelException) {
                    dataModelException.printStackTrace();
                }
                if (object == null) continue;
                this._$29803 = new PatternMatcherInput(object.toString());
                if (!this._$35171.contains(this._$29803, pattern)) continue;
                this._$35659(mIBGridTable, l, n4);
                return true;
            }
            for (n4 = 0; n4 < mIBGridTable.getChildCount(); ++n4) {
                object = (MIBTreeData.MIBGridTable)mIBGridTable.getChildAt(n4);
                if (!this._$36094(pattern, -1, (MIBTreeData.MIBGridTable)object, 0)) continue;
                return true;
            }
        }
        return false;
    }

    void jButtonSearch_actionPerformed(ActionEvent actionEvent) {
        SearchReplacePanel searchReplacePanel = new SearchReplacePanel();
        searchReplacePanel.setReplaceEnabled(false);
        searchReplacePanel.setSearchExpressions(this._$4288.getArray("mibexplorer.SearchExpression"));
        StandardDialog standardDialog = new StandardDialog((Frame)this.myFrame, "Find", true, true);
        standardDialog.setCenterPanel(searchReplacePanel);
        standardDialog.setLocationRelativeTo(this);
        do {
            Pattern pattern;
            standardDialog.setVisible(true);
            if (standardDialog.getResult() != 0 || (pattern = this._$35328(searchReplacePanel.getSearchExpression(), false)) == null) continue;
            this._$4288.putArray("mibexplorer.SearchExpression", searchReplacePanel.getSearchExpressions());
            this._$35330(pattern, true);
            break;
        } while (standardDialog.getResult() == 0);
    }

    void jButtonSearchAgain_actionPerformed(ActionEvent actionEvent) {
        this._$35330(this._$35173, true);
    }

    void jButtonReplace_actionPerformed(ActionEvent actionEvent) {
        SearchReplacePanel searchReplacePanel = new SearchReplacePanel();
        searchReplacePanel.setReplaceEnabled(true);
        searchReplacePanel.setSearchExpressions(this._$4288.getArray("mibexplorer.SearchExpression"));
        searchReplacePanel.setSubstitutionStrings(this._$4288.getArray("mibexplorer.SearchReplace"));
        StandardDialog standardDialog = new StandardDialog((Frame)this.myFrame, "Replace", true, true);
        standardDialog.setCenterPanel(searchReplacePanel);
        standardDialog.setLocationRelativeTo(this.myFrame);
        do {
            Pattern pattern;
            standardDialog.setVisible(true);
            if (standardDialog.getResult() != 0 || (pattern = this._$35328(searchReplacePanel.getSearchExpression(), false)) == null) continue;
            this._$4288.putArray("mibexplorer.SearchExpression", searchReplacePanel.getSearchExpressions());
            this._$4288.putArray("mibexplorer.SearchReplace", searchReplacePanel.getSubstitutionStrings());
            break;
        } while (standardDialog.getResult() == 0);
    }

    public void beforeInsertRow(DataModelEvent dataModelEvent) {
    }

    public void beforeReset(DataModelEvent dataModelEvent) {
    }

    public void beforeRequery(DataModelEvent dataModelEvent) {
    }

    public void beforeEditCell(DataModelEvent dataModelEvent) {
    }

    public void beforeDeleteRow(DataModelEvent dataModelEvent) {
    }

    public void beforeCommitAll(DataModelEvent dataModelEvent) {
    }

    public void beforeCancelAll(DataModelEvent dataModelEvent) {
    }

    public void beforeCancelRowChanges(DataModelEvent dataModelEvent) {
    }

    public void beforeCommitConditional(DataModelEvent dataModelEvent) {
    }

    public void beforeCommitRow(DataModelEvent dataModelEvent) {
    }

    public void beforeMoveToCurrentRow(DataModelEvent dataModelEvent) {
    }

    public void beforeDeleteTable(DataModelEvent dataModelEvent) {
    }

    public void originatorNavigateRow(DataModelEvent dataModelEvent) {
    }

    public void afterReset(DataModelEvent dataModelEvent) {
    }

    public void afterMoveToCurrentRow(DataModelEvent dataModelEvent) {
    }

    public void afterRequeryRowAndDetails(DataModelEvent dataModelEvent) {
    }

    public void afterRequeryTable(DataModelEvent dataModelEvent) {
    }

    public void afterChangeOfRowData(DataModelEvent dataModelEvent) {
    }

    public void afterInsertRow(DataModelEvent dataModelEvent) {
    }

    public void afterDeleteRow(DataModelEvent dataModelEvent) {
    }

    public void beginEvents(DataModelEvent dataModelEvent) {
    }

    public void endEvents(DataModelEvent dataModelEvent) {
    }

    public void initialize(DataModelEvent dataModelEvent) {
    }

    void jButtonFindAgain_actionPerformed(ActionEvent actionEvent) {
        this._$35330(this._$35173, true);
    }

    public boolean isDisableReadOnly() {
        return this._$35177;
    }

    public void setDisableReadOnly(boolean bl) {
        this._$35177 = bl;
    }

    class FormatAction
    extends AbstractAction {
        private String _$5168;

        public FormatAction(String string, String string2) {
            super(string);
            this._$5168 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CellPosition cellPosition = MIBGridTablePanel.this.hiGrid.getCurrentCellPosition();
            if (cellPosition == null) {
                JOptionPane.showMessageDialog(MIBGridTablePanel.this, "Please select a cell in a string column to change the columns display format!", "Display Format", 0);
                return;
            }
            int n = cellPosition.getColumnIndex();
            MIBTreeData.MIBGridTable mIBGridTable = (MIBTreeData.MIBGridTable)MIBGridTablePanel.this.hiGrid.getCurrentRowNode().getDataTableModel();
            ValueConverter valueConverter = (ValueConverter)mIBGridTable.getIndex().getValueConverter().get(n);
            if (SMI.isString(valueConverter.getEffectiveSyntax().getSyntax())) {
                MIBTreeData.CellValue cellValue;
                String string;
                int n2;
                Variable[] variableArray = new Variable[mIBGridTable.getNumDataRows()];
                for (n2 = 0; n2 < mIBGridTable.getNumDataRows(); ++n2) {
                    long l = mIBGridTable.getRowIdentifier(n2);
                    string = null;
                    try {
                        string = mIBGridTable.getMetaData().getColumnIdentifier(n);
                        cellValue = (MIBTreeData.CellValue)mIBGridTable.getCell(l, string);
                        variableArray[n2] = valueConverter.fromNative(cellValue.value);
                        continue;
                    }
                    catch (DataModelException dataModelException) {
                        dataModelException.printStackTrace();
                    }
                }
                if (this._$5168 != null) {
                    valueConverter.setDisplayHint(this._$5168);
                } else {
                    MIBObjectType mIBObjectType = (MIBObjectType)mIBGridTable.getIndex().getColumns().get(n);
                    MIBTextualConvention mIBTextualConvention = MIBGridTablePanel.this.data.getRepository().getEffectiveSyntax(mIBObjectType.getSyntax());
                    if (mIBTextualConvention.getDisplayHint() != null) {
                        valueConverter.setDisplayHint(MIBObject.getUnquotedString(mIBTextualConvention.getDisplayHint()));
                    } else {
                        valueConverter.setDisplayHint(null);
                    }
                }
                for (n2 = 0; n2 < mIBGridTable.getNumDataRows(); ++n2) {
                    long l = mIBGridTable.getRowIdentifier(n2);
                    string = null;
                    try {
                        string = mIBGridTable.getMetaData().getColumnIdentifier(n);
                        cellValue = (MIBTreeData.CellValue)mIBGridTable.getCell(l, string);
                        cellValue.value = valueConverter.toNative(variableArray[n2]);
                        continue;
                    }
                    catch (DataModelException dataModelException) {
                        dataModelException.printStackTrace();
                    }
                }
                MIBGridTablePanel.this.hiGrid.refresh();
            } else {
                JOptionPane.showMessageDialog(MIBGridTablePanel.this, "The display format can only be changed for OCTET STRING columns!", "Display Format", 0);
            }
        }
    }

    class ExpandAction
    extends AbstractAction {
        public ExpandAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MIBTreeData.MIBGridTable mIBGridTable = (MIBTreeData.MIBGridTable)MIBGridTablePanel.this.hiGrid.getCurrentRowNode().getDataTableModel();
            for (int i = 0; i < mIBGridTable.getNumDataRows(); ++i) {
                long l = mIBGridTable.getRowIdentifier(i);
                MIBGridTablePanel.this.hiGrid.expandFolder(MIBGridTablePanel.this.hiGrid.getRowNode(l));
            }
        }
    }

    class InsertAction
    extends AbstractAction {
        public InsertAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MIBGridTablePanel.this.newRow(actionEvent.getActionCommand());
        }
    }

    class AutoColumnSizeHiGridUpdateListener
    extends HiGridUpdateAdapter {
        AutoColumnSizeHiGridUpdateListener() {
        }

        public void afterCreateRow(HiGridUpdateEvent hiGridUpdateEvent) {
            RowNode rowNode = hiGridUpdateEvent.getRowNode();
            DataTableModel dataTableModel = rowNode.getDataTableModel();
            RowFormat rowFormat = rowNode.getRowFormat();
            boolean bl = false;
            if (rowFormat == null || dataTableModel == null) {
                return;
            }
            Enumeration enumeration = rowFormat.getDataFormats().elements();
            while (enumeration.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                String string = cellFormat.getName();
                Object object = null;
                if (rowFormat instanceof RecordFormat) {
                    try {
                        object = dataTableModel.getResultData(rowNode.getBookmark(), string);
                    }
                    catch (Exception exception) {}
                } else if (rowFormat instanceof HeaderFormat) {
                    object = cellFormat.getText();
                }
                if (object == null) continue;
                int n = this._$36059(MIBGridTablePanel.this.hiGrid, cellFormat.getFont(), object.toString());
                if (cellFormat.getWidth() >= n) continue;
                cellFormat.setWidth(n);
                bl = true;
            }
            if (bl) {
                MIBGridTablePanel.this.hiGrid.refresh();
            }
        }

        private int _$36059(Component component, Font font, String string) {
            FontMetrics fontMetrics = component.getFontMetrics(font);
            return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
        }
    }

    class BaseExampleHiGridFormatNodeListener
    extends HiGridFormatNodeAdapter {
        BaseExampleHiGridFormatNodeListener() {
        }

        public void beforeCreateFormatNodeContents(HiGridFormatNodeEvent hiGridFormatNodeEvent) {
            CellStyleModel cellStyleModel = MIBGridTablePanel.this.hiGrid.getRecordCellStyle();
            cellStyleModel.setBackground(Color.white);
        }
    }
}

