/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.editors;

import com.agentpp.explorer.MIBInstance;
import com.agentpp.explorer.editors.InstanceEditor;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.ValueConverter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class InstanceNumberEditor
extends JTextField
implements InstanceEditor {
    private static final int _$53767 = 0;
    private static final int _$7946 = 1;
    private static final int _$53768 = 2;
    private static final int _$53769 = 3;
    private NumberFormat _$53770 = NumberFormat.getNumberInstance(Locale.US);
    private boolean _$53771 = false;
    private int _$6240 = 0;
    private int _$53772 = 0;
    private MIBInstance _$31280;

    public InstanceNumberEditor() {
        this._$53770.setParseIntegerOnly(true);
    }

    public JComponent getEditorComponent() {
        return this;
    }

    public void setAllowNegative(boolean bl) {
        this._$53771 = bl;
    }

    public Object getValue() {
        Number number = new Long(0L);
        try {
            String string = this.getText();
            if (this._$53772 > 0) {
                Long l = ValueConverter.scanLong("d-" + this._$53772, string);
                if (l != null) {
                    return l;
                }
                return number;
            }
            number = this._$53770.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return number;
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    public void setInstance(MIBInstance mIBInstance) {
        this._$31280 = mIBInstance;
        this._$53771 = SMI.isUnsignedNumeric(this._$31280.getValueConverter().getEffectiveSyntax().getSyntax());
        super.setText(this._$31280.getDisplayValue().toString());
    }

    public MIBInstance getInstance() {
        try {
            this._$31280.setNewValue(this.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this._$31280;
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                boolean bl = false;
                switch (InstanceNumberEditor.this._$6240) {
                    case 0: {
                        bl = Character.isDigit(cArray[i]) || InstanceNumberEditor.this._$53771 && cArray[i] == '-' && i == 0 && n == 0 || InstanceNumberEditor.this._$53772 > 0 && cArray[i] == '.';
                        break;
                    }
                    case 1: {
                        bl = Character.isDigit(cArray[i]) || cArray[i] >= 'A' && cArray[i] <= 'F' || cArray[i] >= 'a' && cArray[i] <= 'f';
                        break;
                    }
                    case 2: {
                        bl = cArray[i] >= '0' && cArray[i] <= '7';
                        break;
                    }
                    case 3: {
                        bl = cArray[i] >= '0' && cArray[i] <= '1';
                        break;
                    }
                }
                if (!bl) continue;
                cArray2[n2++] = cArray[i];
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

