/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.editors;

import com.agentpp.mib.MIBObject;
import java.util.StringTokenizer;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;

public class DisplayHint {
    String displayHint;

    public DisplayHint(String string) {
        this.displayHint = MIBObject.getUnquotedString(string);
    }

    public String formatValue(Object object) {
        if (object instanceof OctetString) {
            return this.formatString((OctetString)object);
        }
        if (object instanceof Integer32) {
            return this.formatLong(((Integer32)object).getValue());
        }
        if (object instanceof UnsignedInteger32) {
            return this.formatLong(((UnsignedInteger32)object).getValue());
        }
        return null;
    }

    public String formatLong(long l) {
        String string = null;
        if (this.displayHint == null || this.displayHint.length() < 1) {
            return "" + l;
        }
        char c = this.displayHint.charAt(0);
        switch (c) {
            case 'd': {
                StringTokenizer stringTokenizer;
                int n = -1;
                if (this.displayHint.length() > 1 && (stringTokenizer = new StringTokenizer(this.displayHint, "-")).hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        n = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
                string = "" + l;
                if (n <= 0) break;
                int n2 = string.length() - n;
                if (n2 <= 0) {
                    string = "." + string;
                    break;
                }
                string = string.substring(0, n2) + "." + string.substring(n2);
                break;
            }
            case 'b': {
                string = Long.toBinaryString(l);
                break;
            }
            case 'o': {
                string = Long.toOctalString(l);
                break;
            }
            case 'x': {
                string = Long.toHexString(l);
            }
        }
        return string;
    }

    public String formatString(OctetString octetString) {
        if (this.displayHint == null) {
            return octetString.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        block6: while (n2 < octetString.length() && n < this.displayHint.length()) {
            int n3;
            int n4 = 1;
            Character c = null;
            Character c2 = null;
            if (this.displayHint.charAt(n) == '*') {
                n4 = 0xFF & octetString.get(n2++);
            }
            for (n3 = ++n; n3 < this.displayHint.length() && Character.isDigit(this.displayHint.charAt(n3)); ++n3) {
            }
            if (n3 == n) {
                return octetString.toString();
            }
            String string = null;
            if (n3 >= this.displayHint.length()) {
                return octetString.toString();
            }
            string = this.displayHint.substring(n, n3);
            int n5 = Integer.parseInt(string);
            n = n3;
            char c3 = this.displayHint.charAt(n++);
            if (n < this.displayHint.length() && !Character.isDigit(this.displayHint.charAt(n)) && this.displayHint.charAt(n) != '*') {
                c = new Character(this.displayHint.charAt(n));
                if (++n < this.displayHint.length() && !Character.isDigit(this.displayHint.charAt(n)) && this.displayHint.charAt(n) != '*') {
                    c2 = new Character(this.displayHint.charAt(n));
                    ++n;
                }
            }
            for (int i = 0; i < n4; ++i) {
                if (n2 + n5 >= octetString.length()) {
                    n5 = octetString.length() - n2;
                }
                if (n5 > 0) {
                    if (n2 >= octetString.length()) continue block6;
                    byte[] byArray = new byte[n5];
                    System.arraycopy(octetString.getValue(), n2, byArray, 0, n5);
                    n2 += n5;
                    if (c3 == 'a') {
                        stringBuffer.append(byArray);
                    } else {
                        long l = 0L;
                        int n6 = byArray.length;
                        for (int j = 0; j < n6; ++j) {
                            l = l * 256L + (long)(byArray[j] & 0xFF);
                        }
                        switch (c3) {
                            case 'd': {
                                stringBuffer.append(Long.toString(l));
                                break;
                            }
                            case 'b': {
                                stringBuffer.append(Long.toBinaryString(l));
                                break;
                            }
                            case 'o': {
                                stringBuffer.append(Long.toOctalString(l));
                                break;
                            }
                            case 'x': {
                                stringBuffer.append(Long.toHexString(l));
                            }
                        }
                    }
                }
                if (c != null && n2 < octetString.length()) {
                    stringBuffer.append(c);
                }
                if (i + 1 < n4) {
                    stringBuffer.append(c2);
                }
                if (n < this.displayHint.length()) continue;
                n = 0;
            }
        }
        return stringBuffer.toString();
    }

    public OctetString scanString(String string) {
        if (this.displayHint == null) {
            return new OctetString(string);
        }
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        if (string == null || this.displayHint == null) {
            return null;
        }
        OctetString octetString = new OctetString();
        while (n2 < this.displayHint.length() && n < string.length()) {
            int n6;
            n3 = n2;
            bl2 = false;
            n4 = 0;
            while (n2 < this.displayHint.length() && Character.isDigit(this.displayHint.charAt(n2))) {
                n4 = n4 * 10 + this.displayHint.charAt(n2) - 48;
                bl2 = true;
                ++n2;
            }
            if (!bl2) {
                n4 = 1;
            }
            bl = false;
            switch (this.displayHint.charAt(n2)) {
                case 'a': {
                    if (n4 < string.length() - n) {
                        octetString.append(string.substring(n, n + n4));
                        n += n4;
                        break;
                    }
                    octetString.append(string.substring(n));
                    n = string.length();
                    break;
                }
                case 'b': {
                    n5 = 0;
                    while (string.charAt(n) == '0' || string.charAt(n) == '1') {
                        bl = true;
                        n5 = n5 << 1 | string.charAt(n) - 48;
                        ++n;
                    }
                    break;
                }
                case 'd': {
                    n6 = n;
                    while (n < string.length() && Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                    try {
                        n5 = Integer.parseInt(string.substring(n6, n), 10);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'o': {
                    n6 = n;
                    while (n < string.length() && string.charAt(n) >= '0' && string.charAt(n) <= '7') {
                        ++n;
                    }
                    try {
                        n5 = Integer.parseInt(string.substring(n6, n), 8);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'x': {
                    n6 = n;
                    while (n < string.length() && (string.charAt(n) >= '0' && string.charAt(n) <= '9' || string.charAt(n) >= 'A' && string.charAt(n) <= 'F' || string.charAt(n) >= 'a' && string.charAt(n) <= 'f')) {
                        ++n;
                    }
                    try {
                        n5 = Integer.parseInt(string.substring(n6, n), 8);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n2;
            if (bl) {
                while (n4 > 0) {
                    n6 = (byte)(n5 >> (n4 - 1) * 8 & 0xFF);
                    octetString.append((byte)n6);
                    --n4;
                }
            }
            if (n2 < this.displayHint.length() && this.displayHint.charAt(n2) != '*') {
                if (!Character.isDigit(this.displayHint.charAt(n2))) {
                    ++n2;
                }
                if (n < string.length() && !Character.isDigit(string.charAt(n))) {
                    ++n;
                }
            }
            if (n2 < this.displayHint.length() || n >= string.length()) continue;
            n2 = n3;
        }
        return octetString;
    }

    public static Long scanLong(String string, String string2) {
        if (string == null) {
            try {
                return new Long(string2);
            }
            catch (Exception exception) {
                return new Long(0L);
            }
        }
        Long l = null;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if ((string = MIBObject.getUnquotedString(string)) == null || string.length() < 1 || string2 == null || string2.length() < 1) {
            return null;
        }
        switch (string.charAt(0)) {
            case 'd': {
                if (string.length() < 2) {
                    return null;
                }
                if (string.charAt(1) != '-') break;
                if (Character.isDigit(string.charAt(2))) {
                    n2 = 0;
                    n3 = 0;
                    while (n3 + 2 < string.length() && Character.isDigit(string.charAt(2 + n3))) {
                        n2 = n2 * 10 + (string.charAt(2 + n3) - 48);
                        ++n3;
                    }
                }
                if (2 + n3 < string.length()) break;
                if (string2.charAt(0) == '-') {
                    bl = true;
                    ++n;
                }
                int n4 = -1;
                l2 = 0L;
                while (n < string2.length() && (Character.isDigit(string2.charAt(n)) || string2.charAt(n) == '.')) {
                    if (string2.charAt(n) == '.') {
                        if (n4 >= 0) break;
                        n4 = 0;
                    } else {
                        l2 = l2 * 10L + (long)(string2.charAt(n) - 48);
                        if (n4 >= 0) {
                            ++n4;
                        }
                    }
                    ++n;
                }
                if (n < string2.length()) break;
                while (n4 < n2) {
                    l2 *= 10L;
                    ++n4;
                }
                while (n4 > n2) {
                    l2 /= 10L;
                    --n4;
                }
                l = new Long(bl ? -1L * l2 : l2);
                break;
            }
            case 'x': {
                if (string.length() > 1) break;
                try {
                    l = new Long(Long.parseLong(string2, 16));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 'o': {
                if (string.length() > 1) break;
                try {
                    l = new Long(Long.parseLong(string2, 8));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 'b': {
                if (string.length() > 1) break;
                try {
                    l = new Long(Long.parseLong(string2, 2));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
        return l;
    }
}

