/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.FilePanel;
import com.agentpp.common.PreferencesItem;
import com.agentpp.explorer.cfg.TrapReceiverSettings_enableAutoInhibition_itemAdapter;
import com.agentpp.explorer.cfg.TrapReceiverSettings_enableTrapHistory_itemAdapter;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TrapReceiverSettings
extends JPanel
implements PreferencesItem {
    public static final ExampleFileFilter TRAP_HISTORY_FILTER = new ExampleFileFilter("his", "Trap History");
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox beep = new JCheckBox();
    JCheckBox bring2Front = new JCheckBox();
    JCSpinField autoInhibition = new JCSpinField();
    JCheckBox enableAutoInhibition = new JCheckBox();
    JLabel jLabelTrapsPerSecond = new JLabel();
    JCheckBox enableTrapHistory = new JCheckBox();
    FilePanel trapHistory = new FilePanel();

    public TrapReceiverSettings() {
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.trapHistory.setFilter(TRAP_HISTORY_FILTER);
        this.trapHistory.setLabelText("Trap History File:");
        this.trapHistory.setMode(0);
    }

    private void _$4361() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.beep.setText("Beep when a new trap/notification has been received.");
        this.bring2Front.setText("Bring trap receiver to front on new traps/notifications.");
        this.enableAutoInhibition.setText("Enable auto inhibition threshold:");
        this.enableAutoInhibition.addItemListener(new TrapReceiverSettings_enableAutoInhibition_itemAdapter(this));
        this.jLabelTrapsPerSecond.setText("traps / second");
        this.enableTrapHistory.setText("Enable trap history saved in file:");
        this.enableTrapHistory.addItemListener(new TrapReceiverSettings_enableTrapHistory_itemAdapter(this));
        this.add((Component)this.beep, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.bring2Front, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.enableAutoInhibition, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelTrapsPerSecond, new GridBagConstraints(2, 2, 1, 3, 0.0, 1.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.autoInhibition, new GridBagConstraints(1, 2, 1, 4, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.enableTrapHistory, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 10, 10), 0, 0));
        this.add((Component)this.trapHistory, new GridBagConstraints(0, 4, 3, 1, 0.0, 1.0, 11, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.autoInhibition.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(999), null, false, null, new Integer(10), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(0)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "Trap Receiver";
    }

    public String getTitle() {
        return "Trap Receiver Preferences";
    }

    public String getDescription() {
        return "In order to be able to receive traps (SNMPv1), notifications and informs (SNMPv2c and SNMPv3) you need to specify listen addresses and ports first.\nIn addition, the behavior of the trap receiver can be configured by the settings available here:\nTo protect the application against trap storms an auto-inhibition threshold can be specified in maximum traps/seconds that are allowed. If more traps arrive, the will be capured in background but the trap receiver will not be updated any more until the user deactivates the inhibition.\nReceived traps can be stored in a history file that is automatically loaded on application restart.\n";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        if (this.enableAutoInhibition.isSelected()) {
            userConfigFile.putInteger("mibexplorer.trap.autoinhibition.queue.size", ((Number)this.autoInhibition.getValue()).intValue());
        } else {
            userConfigFile.putInteger("mibexplorer.trap.autoinhibition.queue.size", 0);
        }
        userConfigFile.putBoolean("mibexplorer.trap.beep", this.beep.isSelected());
        userConfigFile.putBoolean("mibexplorer.trap.toFront", this.bring2Front.isSelected());
        if (this.enableTrapHistory.isSelected()) {
            File file = new File(this.trapHistory.getPath());
            this.enableTrapHistory.setSelected(file.isFile() && file.exists() && file.canRead() && file.canWrite());
        }
        userConfigFile.putBoolean("mibexplorer.NotificationPersistency", this.enableTrapHistory.isSelected());
        userConfigFile.put("mibexplorer.NotificationHistoryPath", this.trapHistory.getPath());
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        int n = userConfigFile.getInteger("mibexplorer.trap.autoinhibition.queue.size", 0);
        this.autoInhibition.setValue(new Integer(n));
        this.enableAutoInhibition.setSelected(n > 0);
        this.autoInhibition.setEnabled(n > 0);
        this.beep.setSelected(userConfigFile.getBoolean("mibexplorer.trap.beep", true));
        this.bring2Front.setSelected(userConfigFile.getBoolean("mibexplorer.trap.toFront", true));
        boolean bl = userConfigFile.getBoolean("mibexplorer.NotificationPersistency", false);
        this.enableTrapHistory.setSelected(bl);
        this.trapHistory.setPath(userConfigFile.get("mibexplorer.NotificationHistoryPath", ""));
        this.trapHistory.setEnabled(bl);
    }

    public void enableAutoInhibition_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            this.autoInhibition.setEnabled(false);
        } else {
            this.autoInhibition.setEnabled(true);
            this.autoInhibition.setValue(new Integer(100));
        }
    }

    public void enableTrapHistory_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            this.trapHistory.setEnabled(false);
        } else {
            this.trapHistory.setEnabled(true);
        }
    }
}

