/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.editors.cell.LogLevelCellEditor;
import com.agentpp.explorer.editors.cell.ObjectIDCellEditor;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.log4j.Level;

public class TrapPriorities
extends JPanel
implements PreferencesItem,
ActionListener,
JCCellDisplayListener {
    private static final String[] _$5516 = new String[]{"Subtree", "Severity", "Script", "Comment"};
    private static final int[] _$14753 = new int[]{20, 12, 25, 10};
    private static final int _$29649 = 0;
    private static final int _$42087 = 1;
    private static final int _$42088 = 2;
    private static final int _$42089 = 3;
    private static final String _$6173 = "Add";
    private static final String _$31618 = "Remove";
    private static final String _$42090 = "Script...";
    private BorderLayout _$4239 = new BorderLayout();
    private MIBRepository _$18643;
    private ExtendedListTable _$4160;
    private JCEditableVectorDataSource _$4260 = new JCEditableVectorDataSource();
    private JCCellStyle _$29667;
    private JCCellStyle _$29909;
    private TableSorter _$6193;
    private JPanel _$14495 = new JPanel();
    private JButton _$18874 = new JButton();
    private JButton _$18875 = new JButton();
    private String _$42268 = "";

    public TrapPriorities(MIBRepository mIBRepository, boolean bl) {
        this._$18643 = mIBRepository;
        this._$4160 = new ExtendedListTable(){

            public String getToolTipText(MouseEvent mouseEvent) {
                JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
                if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                    return null;
                }
                int n = jCCellPosition.row;
                int n2 = jCCellPosition.column;
                Object object = TrapPriorities.this._$4260.getTableDataItem(n, n2);
                if (object == null) {
                    return null;
                }
                return object.toString();
            }

            public boolean isPopupAllowed(int n, int n2) {
                int n3 = TableUtils.getFirstSelectedRow(TrapPriorities.this._$4160);
                TablePopupMenu tablePopupMenu = super.getPopupMenu();
                if (n3 >= 0) {
                    tablePopupMenu.getComponent(1).setEnabled(true);
                } else {
                    tablePopupMenu.getComponent(1).setEnabled(false);
                }
                return true;
            }
        };
        this._$4260.setNumRows(10);
        this._$4260.setNumColumns(_$5516.length);
        this._$4260.setColumnLabels(_$5516);
        this._$4160.setDataSource(this._$4260);
        this._$4160.setRowHidden(0, true);
        this._$4160.setRowLabelDisplay(false);
        this._$4160.setPopupMenuEnabled(true);
        if (!bl) {
            this._$4160.setColumnHidden(2, true);
        }
        this._$6193 = new TableSorter((JCTable)this._$4160, (JCVectorDataSource)this._$4260, false);
        this._$6193.addSortColumn(0);
        TablePopupMenu tablePopupMenu = this._$4160.getPopupMenu();
        tablePopupMenu.addItem(_$6173, this);
        tablePopupMenu.addItem(_$31618, this);
        tablePopupMenu.addItem(_$42090, this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$4634();
        this._$4160.addCellDisplayListener(this);
    }

    public TrapPriorities() {
        this((MIBRepository)null, false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = TableUtils.getFirstSelectedRow(this._$4160);
        if (actionEvent.getActionCommand().equals(_$6173)) {
            this.jButtonAdd_actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(_$31618)) {
            this.jButtonRemove_actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(_$42090)) {
            JFileChooser jFileChooser = new JFileChooser(this._$42268);
            jFileChooser.setFileFilter(new ExampleFileFilter("vm", "MIB Explorer Script"));
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showOpenDialog(this) == 0) {
                this._$4260.setTableDataItem(jFileChooser.getSelectedFile().getPath(), n, 2);
            }
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this._$4239);
        this._$18874.setToolTipText("Add a new row");
        this._$18874.setText(_$6173);
        this._$18874.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapPriorities.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this._$18875.setToolTipText("Remove selected rows");
        this._$18875.setText(_$31618);
        this._$18875.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapPriorities.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this._$4160, "Center");
        this.add((Component)this._$14495, "South");
        this._$14495.add((Component)this._$18874, null);
        this._$14495.add((Component)this._$18875, null);
    }

    private void _$31962(UserConfigFile userConfigFile) {
        this._$42268 = userConfigFile.get("mibexplorer.scriptsPath", ".");
        this._$4260.setNumRows(1);
        Vector vector = userConfigFile.getArray("mibexplorer.trap.priorities.OID");
        Vector vector2 = userConfigFile.getArray("mibexplorer.trap.priorities.level", vector.size());
        Vector vector3 = userConfigFile.getArray("mibexplorer.trap.priorities.script", vector.size());
        Vector vector4 = userConfigFile.getArray("mibexplorer.trap.priorities.comment", vector.size());
        for (int i = 0; i < vector.size() && i < vector2.size(); ++i) {
            Vector<Object> vector5 = new Vector<Object>(_$5516.length);
            String string = (String)vector.elementAt(i);
            if (string == null) {
                string = "";
            }
            vector5.add(new ObjectID(string));
            vector5.add(new Integer(Level.toLevel(vector2.elementAt(i).toString()).toInt()));
            if (i < vector3.size()) {
                vector5.add(vector3.elementAt(i));
            } else {
                vector5.add("");
            }
            if (i < vector4.size()) {
                vector5.add(vector4.elementAt(i));
            } else {
                vector5.add("");
            }
            this._$4260.addRow(Integer.MAX_VALUE, null, vector5);
        }
        this._$6193.sort();
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getRow() == -1 || jCCellDisplayEvent.getDisplayData() == null) {
            return;
        }
        switch (jCCellDisplayEvent.getColumn()) {
            case 0: {
                if (!(jCCellDisplayEvent.getCellData() instanceof ObjectID)) break;
                ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                String string = this._$18643.getObjectName(objectID);
                if (string == null) {
                    string = this._$18643.getPathSuffix(objectID);
                }
                if (string == null) break;
                jCCellDisplayEvent.setDisplayData(string);
                break;
            }
            case 1: {
                int n = ((Number)jCCellDisplayEvent.getCellData()).intValue();
                jCCellDisplayEvent.setDisplayData(Level.toLevel(n).toString());
                break;
            }
        }
    }

    private void _$4634() {
        this._$29667 = new JCCellStyle(this._$4160.getDefaultCellStyle());
        this._$29667.setEditable(true);
        this._$29667.setBackground(Color.blue);
        this._$29667.setForeground(Color.white);
        this._$29909 = new JCCellStyle(this._$29667);
        this._$29909.setCellEditor(new LogLevelCellEditor());
        this._$4160.setCellStyle(-997, 1, this._$29909);
        for (int i = 0; i < _$14753.length; ++i) {
            this._$4160.setCharWidth(i, _$14753[i]);
        }
        this._$4160.setCellEditor(ObjectID.class, new ObjectIDCellEditor(this._$18643));
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        Vector<Object> vector = new Vector<Object>(_$5516.length);
        vector.add(new ObjectID());
        vector.add(new Integer(20000));
        vector.add("");
        vector.add("");
        this._$4260.addRow(Integer.MAX_VALUE, null, vector);
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        TableUtils.removeSelectedRows(this._$4160, this._$4260);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "Trap Priorities";
    }

    public String getTitle() {
        return "Trap and Alarm Priority Settings";
    }

    public String getDescription() {
        return "With the below table you can specify (logging) severities for categories of incoming traps, notifications, and inform messages. The severity is determined by analysis of the notification ID. For each incoming trap/notification, the Trap Priorities table will be searched for the entry (category) whose subtree OID is the longest possible match. The severity for this message will then be set to the severity specified for the matched category.\nIn the MIB Explorer Pro edition, you can also specify a script and a comment for each category. The Velocity MIB Explorer script will be executed when a new trap/notification matching the category has been received.";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        this._$6193.sort();
        Vector<String> vector = new Vector<String>(this._$4260.getNumRows() - 1);
        Vector<String> vector2 = new Vector<String>(this._$4260.getNumRows() - 1);
        Vector<Object> vector3 = new Vector<Object>(this._$4260.getNumRows() - 1);
        Vector<Object> vector4 = new Vector<Object>(this._$4260.getNumRows() - 1);
        for (int i = 1; i < this._$4260.getNumRows(); ++i) {
            vector.add(this._$4160.getDataView().getTableDataItem(i, 0).toString());
            int n = ((Number)this._$4160.getDataView().getTableDataItem(i, 1)).intValue();
            vector2.add(Level.toLevel(n).toString());
            vector3.add(this._$4160.getDataView().getTableDataItem(i, 2));
            vector4.add(this._$4160.getDataView().getTableDataItem(i, 3));
        }
        userConfigFile.putArray("mibexplorer.trap.priorities.OID", vector);
        userConfigFile.putArray("mibexplorer.trap.priorities.level", vector2);
        userConfigFile.putArray("mibexplorer.trap.priorities.script", vector3);
        userConfigFile.putArray("mibexplorer.trap.priorities.comment", vector4);
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this._$31962(userConfigFile);
    }
}

