/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.FilePanel;
import com.agentpp.common.PreferencesItem;
import com.agentpp.explorer.cfg.HidePasswordAdapter;
import com.agentpp.util.UserConfigFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class TransportProtocolSettingsTLS
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelKeyStore = new JLabel();
    JLabel jLabelTlsVersion = new JLabel();
    FilePanel keyStore = new FilePanel();
    JLabel jLabelKeyStorePassword = new JLabel();
    JPasswordField keyStorePassword = new JPasswordField();
    JCheckBox hideSecret = new JCheckBox();
    JButton testKeyStore = new JButton(new TestKeyStoreAction());
    JComboBox tlsVersion = new JComboBox();

    public TransportProtocolSettingsTLS() {
        this.keyStore.setLabelText(null);
        this.keyStore.setDefaultPath(System.getProperty("javax.net.ssl.keyStore", ""));
        this.keyStore.setEnabled(true);
        this.keyStore.setMode(0);
        this.keyStore.setPathTextEnabled(true);
        this.tlsVersion.addItem("TLSv1");
        if (System.getProperty("java.version").compareTo("1.7") >= 0) {
            this.tlsVersion.addItem("TLSv1.1");
            this.tlsVersion.addItem("TLSv1.2");
        }
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$4361() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelKeyStore.setText("Key Store File:");
        this.jLabelTlsVersion.setText("TLS Version:");
        this.jLabelKeyStorePassword.setText("Key Store Password:");
        this.hideSecret.setText("Show Password");
        this.hideSecret.addItemListener(new HidePasswordAdapter(this));
        this.add((Component)this.jLabelTlsVersion, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.tlsVersion, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelKeyStore, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.keyStore, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.testKeyStore, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 12, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelKeyStorePassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.keyStorePassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this.hideSecret, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "TLS Security";
    }

    public String getTitle() {
        return "TLS Security Settings";
    }

    public String getDescription() {
        return "The TLS transport mapping (TLSTM) as defined by RFC 5953 uses certificate keys for server and client authentication. Thus server (agent) and client (MIB Explorer) need certificates (keys) to be able to exchange SNMP messages over TLS (SSL v3.1 or later).\nHere the Java key store file and the password to access it can be configured. By leaving the configuration empty, both values are read from the 'javax.net.ssl.keyStore' and 'javax.net.ssl.keyStorePassword' system properties which can be configured on the command line with the Java -D option.\n\nNOTE: The key store password is stored in plain text in your config file if set here!";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        userConfigFile.put("mibexplorer.transport.tls.keyStore.password", new String(this.keyStorePassword.getPassword()));
        userConfigFile.put("mibexplorer.transport.tls.keyStore.file", new String(this.keyStore.getPath()));
        userConfigFile.put("mibexplorer.transport.tls.version", (String)this.tlsVersion.getSelectedItem());
    }

    public boolean isOK() {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(this.getKeyStore());
            keyStore.load(fileInputStream, this.getKeyStorePassword() != null ? this.getKeyStorePassword().toCharArray() : null);
            return true;
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String getKeyStore() {
        String string = this.keyStore.getPath();
        if (string == null || string.length() == 0) {
            string = System.getProperty("javax.net.ssl.keyStore");
        }
        return string;
    }

    public String getKeyStorePassword() {
        String string = new String(this.keyStorePassword.getPassword());
        if (string == null || string.length() == 0) {
            string = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        return string;
    }

    public String getTlsVersion() {
        return (String)this.tlsVersion.getSelectedItem();
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.tlsVersion.setSelectedItem(userConfigFile.get("mibexplorer.transport.tls.version", "TLSv1"));
        this.keyStorePassword.setText(userConfigFile.get("mibexplorer.transport.tls.keyStore.password", System.getProperty("javax.net.ssl.keyStorePassword", "")));
        this.keyStore.setPath(userConfigFile.get("mibexplorer.transport.tls.keyStore.file", System.getProperty("javax.net.ssl.keyStore", "")));
    }

    public void hideSecret_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.keyStorePassword.setEchoChar('\u0000');
        } else {
            this.keyStorePassword.setEchoChar('*');
        }
    }

    class TestKeyStoreAction
    extends AbstractAction {
        public TestKeyStoreAction() {
            super("Test");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!TransportProtocolSettingsTLS.this.isOK()) {
                JOptionPane.showMessageDialog(TransportProtocolSettingsTLS.this, new String[]{"Key store file", "'" + TransportProtocolSettingsTLS.this.getKeyStore() + "'", "could not be loaded!"}, "Key Store Error", 0);
            } else {
                JOptionPane.showMessageDialog(TransportProtocolSettingsTLS.this, new String[]{"Key store file", "'" + TransportProtocolSettingsTLS.this.getKeyStore() + "'", "successfully loaded."}, "Key Store OK", 1);
            }
        }
    }
}

