/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.explorer.cfg.SNMPv3Settings_jButtonGenDefaultEngineID_actionAdapter;
import com.agentpp.explorer.editors.OctetTextField;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.smi.OctetString;

public class SNMPv3Settings
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelAuthEngineID = new JLabel();
    OctetTextField authoritativeEngineID = new OctetTextField();
    JLabel jLabelEngineBoots = new JLabel();
    JCSpinField engineBoots = new JCSpinField();
    JLabel jLabelReportStrategy = new JLabel();
    JComboBox reportStrategy = new JComboBox();
    private static boolean _$32978 = false;
    JButton jButtonGenDefaultEngineID = new JButton();
    JLabel jLabelChanges = new JLabel();

    public SNMPv3Settings() {
        for (SNMP4JSettings.ReportSecurityLevelStrategy reportSecurityLevelStrategy : SNMP4JSettings.ReportSecurityLevelStrategy.values()) {
            this.reportStrategy.addItem(reportSecurityLevelStrategy);
        }
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$4361() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelAuthEngineID.setText("Authoritative Engine ID*:");
        this.jLabelEngineBoots.setText("Engine Boots*:");
        this.jLabelReportStrategy.setText("Report Security Level Strategy:");
        this.jButtonGenDefaultEngineID.setToolTipText("Generate default authoritative engine ID");
        this.jButtonGenDefaultEngineID.setText("Default");
        this.jButtonGenDefaultEngineID.addActionListener(new SNMPv3Settings_jButtonGenDefaultEngineID_actionAdapter(this));
        this.jLabelChanges.setFont(new Font("Dialog", 2, 11));
        this.jLabelChanges.setText("* Changes will take affect with next start of the application.");
        this.add((Component)this.jLabelAuthEngineID, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelEngineBoots, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelReportStrategy, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.engineBoots.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(Integer.MAX_VALUE), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(1)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.add((Component)this.engineBoots, new GridBagConstraints(1, 1, 2, 2, 0.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jButtonGenDefaultEngineID, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.authoritativeEngineID, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.reportStrategy, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelChanges, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "SNMPv3";
    }

    public String getTitle() {
        return "SNMPv3 Settings";
    }

    public String getDescription() {
        return "The SNMPv3 settings local engine ID and engine boots counter do not need to be changed manually in general. However, if you encounter connectivity problems then a probable cause might be an agent that is using the same engine ID as shown below. In this case, you should change the local engine ID to make it unique again.\nThe engine boots counter should be strictly monotonic increased. It is automatically increased by one on each restart of MIB Explorer.";
    }

    public String getTooltip() {
        return "";
    }

    public static String getDefaultEngineID() {
        String string = "01:";
        OctetString octetString = new OctetString();
        try {
            octetString.setValue(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            string = "04:";
            octetString.setValue("MIBExplorer".getBytes());
        }
        return "80:00:13:70:" + string + octetString.toHexString();
    }

    public static int getEngineBoots(UserConfigFile userConfigFile) {
        int n = userConfigFile.getInteger("mibexplorer.EngineBoots", 0);
        if (n < 0) {
            n = 0;
        }
        if (!_$32978) {
            n = n < 0 || n == Integer.MAX_VALUE ? 0 : ++n;
            userConfigFile.putInteger("mibexplorer.EngineBoots", n);
        }
        return n;
    }

    public static OctetString getEngineID(UserConfigFile userConfigFile) {
        return OctetString.fromHexString(userConfigFile.get("mibexplorer.EngineID", SNMPv3Settings.getDefaultEngineID()));
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        OctetString octetString = OctetTextField.getOctetString(this.authoritativeEngineID.getText());
        if (octetString == null || octetString.length() < 5 || octetString.length() > 32) {
            octetString = OctetTextField.getOctetString(SNMPv3Settings.getDefaultEngineID());
            userConfigFile.put("mibexplorer.EngineID", SNMPv3Settings.getDefaultEngineID());
        } else {
            userConfigFile.put("mibexplorer.EngineID", this.authoritativeEngineID.getText());
        }
        userConfigFile.putInteger("mibexplorer.EngineBoots", ((Number)this.engineBoots.getValue()).intValue());
        userConfigFile.put("mibexplorer.ReportStrategy", this.reportStrategy.getSelectedItem().toString());
        SNMP4JSettings.setReportSecurityLevelStrategy((SNMP4JSettings.ReportSecurityLevelStrategy)((Object)this.reportStrategy.getSelectedItem()));
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.authoritativeEngineID.setText(userConfigFile.get("mibexplorer.EngineID", SNMPv3Settings.getDefaultEngineID()));
        this.engineBoots.setValue(new Integer(SNMPv3Settings.getEngineBoots(userConfigFile)));
        this.reportStrategy.setSelectedItem((Object)SNMP4JSettings.ReportSecurityLevelStrategy.valueOf(userConfigFile.get("mibexplorer.ReportStrategy", "standard")));
    }

    public void jButtonGenDefaultEngineID_actionPerformed(ActionEvent actionEvent) {
        this.authoritativeEngineID.setText(SNMPv3Settings.getDefaultEngineID());
    }
}

