/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.common.PreferencesPanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.explorer.cfg.GeneralSettings;
import com.agentpp.explorer.cfg.HttpServerSettings;
import com.agentpp.explorer.cfg.JdbcDriverRegistration;
import com.agentpp.explorer.cfg.ListenTransportConfig;
import com.agentpp.explorer.cfg.LookAndFeelSettings;
import com.agentpp.explorer.cfg.MIBSettings;
import com.agentpp.explorer.cfg.MonitorSettings;
import com.agentpp.explorer.cfg.SNMPSettings;
import com.agentpp.explorer.cfg.SNMPv3Settings;
import com.agentpp.explorer.cfg.ServerSettings;
import com.agentpp.explorer.cfg.TlsAcceptedDN;
import com.agentpp.explorer.cfg.TlsSecurityNameMapping;
import com.agentpp.explorer.cfg.TransportChangeEvent;
import com.agentpp.explorer.cfg.TransportChangeListener;
import com.agentpp.explorer.cfg.TransportPreferences;
import com.agentpp.explorer.cfg.TransportProtocolSettingsTLS;
import com.agentpp.explorer.cfg.TransportSettings;
import com.agentpp.explorer.cfg.TrapPriorities;
import com.agentpp.explorer.cfg.TrapReceiverSettings;
import com.agentpp.explorer.cfg.ViewSettings;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.explorer.traps.TrapSelector;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.slimdao.jdbc.DriverLoader;
import com.agentpp.util.UserConfigFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.DefaultTlsTmSecurityCallback;
import org.snmp4j.transport.tls.SecurityNameMapping;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences
implements TransportChangeListener {
    public static String[] TRANSPORT_TYPES = new String[]{"udp", "tcp", "tls"};
    private TransportIpAddress[] _$30617 = null;
    private TransportMapping[] _$30618 = null;
    private TransportSettings[] _$30619 = new TransportSettings[TRANSPORT_TYPES.length];
    private ListenTransportConfig[] _$30620 = new ListenTransportConfig[TRANSPORT_TYPES.length];
    private TransportProtocolSettingsTLS _$30621;
    private TlsSecurityNameMapping _$30622;
    private TlsAcceptedDN _$30623;
    private TlsAcceptedDN _$30624;
    private Vector[] _$30625;
    private UserConfigFile _$4288;
    private Snmp _$4261;
    private TrapProxy _$18901;
    private MIBRepository _$18643;
    private DefaultRepositoryManager _$18642;
    private boolean _$30626;
    private DriverLoader _$19096;

    public Preferences(UserConfigFile userConfigFile, Snmp snmp, TrapProxy trapProxy, MIBRepository mIBRepository, DefaultRepositoryManager defaultRepositoryManager, boolean bl, DriverLoader driverLoader) {
        this._$4288 = userConfigFile;
        this._$4261 = snmp;
        this._$18901 = trapProxy;
        this._$18643 = mIBRepository;
        this._$18642 = defaultRepositoryManager;
        this._$30626 = bl;
        this._$19096 = driverLoader;
        this._$30627();
        for (int i = 0; i < TRANSPORT_TYPES.length; ++i) {
            this._$30619[i] = new TransportSettings();
            this._$30619[i].setAddressType(TRANSPORT_TYPES[i]);
            this._$30619[i].addTransportChangeListener(this);
            this._$30620[i] = new ListenTransportConfig();
            this._$30620[i].setAddressType(TRANSPORT_TYPES[i]);
            this._$30620[i].addTransportChangeListener(this);
        }
        this._$30621 = new TransportProtocolSettingsTLS();
        this._$30621.loadProperties(userConfigFile);
        this._$30622 = new TlsSecurityNameMapping();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this._$30630(arrayList, arrayList2);
        this._$30623 = new TlsAcceptedDN(arrayList, TlsAcceptedDN.DnType.SubjectDN);
        this._$30624 = new TlsAcceptedDN(arrayList2, TlsAcceptedDN.DnType.IssuerDN);
    }

    public boolean edit(JFrame jFrame, final HelpBroker helpBroker) {
        Serializable serializable;
        Serializable serializable2;
        JPanel jPanel;
        StandardDialog standardDialog = new StandardDialog(jFrame, "Preferences", true, true, false, true){

            public void init() {
                helpBroker.enableHelpOnButton(this.jButtonHelp, "Preferences", null);
            }
        };
        PreferencesPanel preferencesPanel = new PreferencesPanel();
        preferencesPanel.addItem(new GeneralSettings(), null);
        preferencesPanel.addItem(new MIBSettings(), null);
        preferencesPanel.addItem(new SNMPSettings(), null);
        if (this._$30626) {
            jPanel = new ServerSettings();
            preferencesPanel.addItem((PreferencesItem)((Object)jPanel), null);
            preferencesPanel.addItem(new HttpServerSettings(), (PreferencesItem)((Object)jPanel));
        }
        preferencesPanel.addItem(new SNMPv3Settings(), null);
        jPanel = new TransportPreferences();
        preferencesPanel.addItem((PreferencesItem)((Object)jPanel), null);
        preferencesPanel.addItem(this._$30619[0], (PreferencesItem)((Object)jPanel));
        preferencesPanel.addItem(this._$30619[1], (PreferencesItem)((Object)jPanel));
        if (this._$30626) {
            preferencesPanel.addItem(this._$30619[2], (PreferencesItem)((Object)jPanel));
            preferencesPanel.addItem(this._$30621, this._$30619[2]);
            preferencesPanel.addItem(this._$30622, this._$30619[2]);
            serializable2 = new ArrayList();
            serializable = new ArrayList<String>();
            this._$30630((List<String>)((Object)serializable2), (List<String>)((Object)serializable));
            this._$30623 = new TlsAcceptedDN((List<String>)((Object)serializable2), TlsAcceptedDN.DnType.SubjectDN);
            this._$30624 = new TlsAcceptedDN((List<String>)((Object)serializable), TlsAcceptedDN.DnType.IssuerDN);
            preferencesPanel.addItem(this._$30623, this._$30619[2]);
            preferencesPanel.addItem(this._$30624, this._$30619[2]);
        }
        serializable2 = new TrapReceiverSettings();
        preferencesPanel.addItem((PreferencesItem)((Object)serializable2), null);
        preferencesPanel.addItem(new TrapPriorities(this._$18643, this._$30626), (PreferencesItem)((Object)serializable2));
        preferencesPanel.addItem(this._$30620[0], (PreferencesItem)((Object)serializable2));
        preferencesPanel.addItem(this._$30620[1], (PreferencesItem)((Object)serializable2));
        if (this._$30626) {
            preferencesPanel.addItem(this._$30620[2], (PreferencesItem)((Object)serializable2));
        }
        serializable = new ViewSettings();
        preferencesPanel.addItem((PreferencesItem)((Object)serializable), null);
        preferencesPanel.addItem(new LookAndFeelSettings(), (PreferencesItem)((Object)serializable));
        if (this._$30626) {
            MonitorSettings monitorSettings = new MonitorSettings();
            JdbcDriverRegistration jdbcDriverRegistration = new JdbcDriverRegistration(this._$19096);
            preferencesPanel.addItem(monitorSettings, null);
            preferencesPanel.addItem(jdbcDriverRegistration, monitorSettings);
        }
        standardDialog.setCenterPanel(preferencesPanel);
        preferencesPanel.load(this._$4288);
        preferencesPanel.setSelectedItem((PreferencesItem)((Object)jPanel));
        standardDialog.setLocationRelativeTo(jFrame);
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            preferencesPanel.save(this._$4288);
            this._$30627();
            return true;
        }
        return false;
    }

    private void _$30630(List<String> list, List<String> list2) {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            String string = this._$30621.getKeyStore();
            if (string == null) {
                return;
            }
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, this._$30621.getKeyStorePassword() != null ? this._$30621.getKeyStorePassword().toCharArray() : null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                Certificate certificate = keyStore.getCertificate(string2);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)certificate;
                Principal principal = x509Certificate.getSubjectDN();
                if (principal != null) {
                    list.add(principal.getName());
                }
                if ((principal = x509Certificate.getIssuerDN()) == null) continue;
                list2.add(principal.getName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public boolean initTransportMappings(JFrame jFrame) {
        int n;
        this.getTransportAddresses();
        boolean bl = false;
        if (this._$30618 == null) {
            this._$30618 = new TransportMapping[TRANSPORT_TYPES.length];
            for (n = 0; n < TRANSPORT_TYPES.length; ++n) {
                if (this._$30617[n] == null) continue;
                try {
                    this._$30618[n] = this._$30649(n);
                    this._$4261.addTransportMapping(this._$30618[n]);
                    this._$30618[n].listen();
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(jFrame, new String[]{"Could not bind transport address '" + this._$30617[0] + "."}, "Binding Error", 0);
                }
            }
        }
        if (this._$30625 == null) {
            this._$30625 = new Vector[TRANSPORT_TYPES.length];
            for (n = 0; n < TRANSPORT_TYPES.length; ++n) {
                this._$30625[n] = ListenTransportConfig.getAddresses(this._$4288, TRANSPORT_TYPES[n]);
                Vector<Address> vector = new Vector<Address>();
                for (int i = 0; i < this._$30625[n].size(); ++i) {
                    String string = (String)this._$30625[n].get(i);
                    try {
                        Address address = GenericAddress.parse(string);
                        if (address == null || !this._$4261.addNotificationListener(address, new TrapSelector(address.toString(), this._$18901))) continue;
                        vector.add(address);
                        continue;
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(jFrame, new String[]{"Could not bind transport address '" + string + "."}, "Binding Error", 0);
                    }
                }
                this._$30625[n] = vector;
            }
        }
        return bl;
    }

    private TransportMapping _$30649(int n) throws IOException {
        AbstractTransportMapping abstractTransportMapping = null;
        switch (n) {
            case 0: {
                abstractTransportMapping = new DefaultUdpTransportMapping((UdpAddress)this._$30617[n]);
                TransportSettings cfr_ignored_0 = this._$30619[n];
                ((DefaultUdpTransportMapping)abstractTransportMapping).setMaxInboundMessageSize(TransportSettings.getMaxInboundBufferSize(this._$4288, TRANSPORT_TYPES[n]));
                break;
            }
            case 1: {
                abstractTransportMapping = new DefaultTcpTransportMapping((TcpAddress)this._$30617[n]);
                TransportSettings cfr_ignored_1 = this._$30619[n];
                ((DefaultTcpTransportMapping)abstractTransportMapping).setMaxInboundMessageSize(TransportSettings.getMaxInboundBufferSize(this._$4288, TRANSPORT_TYPES[n]));
                break;
            }
            case 2: {
                List<String> list;
                List<String> list2;
                Object object;
                Object object2;
                TLSTM tLSTM = new TLSTM((TlsAddress)this._$30617[n]);
                TransportSettings cfr_ignored_2 = this._$30619[n];
                tLSTM.setMaxInboundMessageSize(Math.min(TransportSettings.getMaxInboundBufferSize(this._$4288, TRANSPORT_TYPES[n]), tLSTM.getMaxInboundMessageSize()));
                try {
                    if (Class.forName("javax.net.ssl.X509ExtendedTrustManager") != null) {
                        object2 = Class.forName("org.snmp4j.transport.tls.TLSTMExtendedTrustManagerFactory");
                        object = ((Class)object2).getConstructors()[0];
                        list2 = (TLSTM.TLSTMTrustManagerFactory)((Constructor)object).newInstance(tLSTM);
                        tLSTM.setTrustManagerFactory((TLSTM.TLSTMTrustManagerFactory)((Object)list2));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                object2 = new DefaultTlsTmSecurityCallback();
                this._$30622.loadProperties(this._$4288);
                this._$30623.loadProperties(this._$4288);
                this._$30624.loadProperties(this._$4288);
                object = this._$30622.getMappings();
                list2 = object.iterator();
                while (list2.hasNext()) {
                    list = (SecurityNameMapping)list2.next();
                    ((DefaultTlsTmSecurityCallback)object2).addSecurityNameMapping(((SecurityNameMapping)((Object)list)).getFingerprint(), ((SecurityNameMapping)((Object)list)).getType(), ((SecurityNameMapping)((Object)list)).getData(), ((SecurityNameMapping)((Object)list)).getSecurityName());
                }
                list2 = this._$30623.getDN();
                for (String object3 : list2) {
                    ((DefaultTlsTmSecurityCallback)object2).addAcceptedSubjectDN(object3);
                }
                list = this._$30624.getDN();
                for (String string : list) {
                    ((DefaultTlsTmSecurityCallback)object2).addAcceptedIssuerDN(string);
                }
                tLSTM.setSecurityCallback((TlsTmSecurityCallback<X509Certificate>)object2);
                tLSTM.setKeyStore(this._$30621.getKeyStore());
                tLSTM.setKeyStorePassword(this._$30621.getKeyStorePassword());
                if (this._$30621.getTlsVersion() != null) {
                    tLSTM.setTlsProtocols(new String[]{this._$30621.getTlsVersion()});
                }
                abstractTransportMapping = tLSTM;
                break;
            }
        }
        return abstractTransportMapping;
    }

    private Address _$30669(String string) {
        Address address = TransportSettings.getAddress(this._$4288, string);
        if (address == null) {
            address = GenericAddress.parse(string + ":0.0.0.0/0");
        }
        return address;
    }

    public TransportIpAddress[] getTransportAddresses() {
        if (this._$30617 == null) {
            this._$30617 = new TransportIpAddress[TRANSPORT_TYPES.length];
            boolean bl = false;
            for (int i = 0; i < TRANSPORT_TYPES.length; ++i) {
                this._$30617[i] = TransportSettings.getAddress(this._$4288, TRANSPORT_TYPES[i]);
                if (this._$30617[i] == null) continue;
                bl = true;
            }
            if (!bl && !this._$4288.getBoolean("mibexplorer.transport.configured.", false)) {
                this._$4288.put("mibexplorer.transport.address." + TRANSPORT_TYPES[0], "0.0.0.0/0");
                this._$30617[0] = new UdpAddress("0.0.0.0/0");
            }
        }
        return this._$30617;
    }

    @Override
    public void transportAddressChanged(TransportChangeEvent transportChangeEvent) {
        Address address = transportChangeEvent.getAddress();
        transportChangeEvent.setAccepted(true);
        for (int i = 0; i < TRANSPORT_TYPES.length; ++i) {
            if (!TRANSPORT_TYPES[i].equals(transportChangeEvent.getAddressType())) continue;
            if (transportChangeEvent.getSource() instanceof TransportSettings) {
                this._$30672(transportChangeEvent, address, i);
                continue;
            }
            if (!(transportChangeEvent.getSource() instanceof ListenTransportConfig)) continue;
            if (transportChangeEvent.getEventType() == 3) {
                if (this._$30625[i].contains(transportChangeEvent.getAddress())) continue;
                transportChangeEvent.setAccepted(false);
                break;
            }
            this._$30673(transportChangeEvent, address, i);
        }
    }

    private void _$30673(TransportChangeEvent transportChangeEvent, Address address, int n) {
        switch (transportChangeEvent.getEventType()) {
            case 2: {
                transportChangeEvent.setAccepted(this._$4261.removeNotificationListener(address));
                this._$30625[n].remove(transportChangeEvent.getAddress());
                break;
            }
            case 1: {
                transportChangeEvent.setAccepted(this._$4261.addNotificationListener(address, new TrapSelector(address.toString(), this._$18901)));
                if (!transportChangeEvent.isAccepted()) break;
                this._$30625[n].add(transportChangeEvent.getAddress());
                break;
            }
            default: {
                transportChangeEvent.setAccepted(false);
            }
        }
    }

    public void enableTransport(String string) throws IOException {
        for (int i = 0; i < TRANSPORT_TYPES.length; ++i) {
            if (!TRANSPORT_TYPES[i].equals(string.toLowerCase())) continue;
            this._$30617[i] = (TransportIpAddress)this._$30669(string);
            TransportMapping transportMapping = this._$30649(i);
            this._$4261.addTransportMapping(transportMapping);
            transportMapping.listen();
            this._$4288.put("mibexplorer.transport.address." + string, this._$30617[i].toString());
        }
    }

    private void _$30672(TransportChangeEvent transportChangeEvent, Address address, int n) {
        if (address == null || transportChangeEvent.getEventType() == 2) {
            if (this._$30618[n] != null) {
                this._$4261.removeTransportMapping(this._$30618[n]);
                try {
                    this._$30618[n].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._$30618[n] = null;
            }
            return;
        }
        TransportIpAddress transportIpAddress = this._$30617[n];
        if (transportIpAddress != null && transportIpAddress.equals(address)) {
            return;
        }
        this._$30617[n] = (TransportIpAddress)address;
        try {
            TransportMapping transportMapping;
            if (this._$30618[n] != null) {
                this._$4261.removeTransportMapping(this._$30618[n]);
                this._$30618[n].close();
            }
            this._$30618[n] = transportMapping = this._$30649(n);
            this._$4261.addTransportMapping(transportMapping);
            transportMapping.listen();
            transportChangeEvent.setAccepted(true);
        }
        catch (IOException iOException) {
            this._$30617[n] = transportIpAddress;
            try {
                this._$30618[n] = this._$30649(n);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            transportChangeEvent.setAccepted(false);
        }
    }

    private void _$30627() {
        this._$18642.setMaxErrors(this._$4288.getInteger("mibexplorer.compile.maxerrors", 20));
        this._$18642.setUseCompression(this._$4288.getBoolean("mibexplorer.compile.usecompression", true));
    }
}

