/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.FilePanel;
import com.agentpp.common.PreferencesItem;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MIBSettings
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    FilePanel repositoryPath = new FilePanel();
    JCheckBox lenientCompilation = new JCheckBox();
    JLabel jLabeLenientText = new JLabel();
    JLabel jLabelParseErrors = new JLabel();
    JCSpinField maxParseErrors = new JCSpinField();
    JLabel jLabelLenientText2 = new JLabel();
    JCheckBox useCompression = new JCheckBox();
    JCheckBox updateNewer = new JCheckBox();
    JCheckBox compileFileName = new JCheckBox();

    public MIBSettings() {
        this.repositoryPath.setLabelText("MIB Repository Path:");
        this.repositoryPath.setMode(1);
        try {
            this._$6884();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$6884() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.lenientCompilation.setText("Compile MIBs leniently (disables most syntax checks of the MIB compiler)*");
        this.jLabeLenientText.setFont(new Font("Dialog", 2, 10));
        this.jLabeLenientText.setText("*Warning: Undetected syntax errors may cause application problems!");
        this.jLabelParseErrors.setText("Maximum Errors / MIB File:");
        this.jLabelLenientText2.setFont(new Font("Dialog", 2, 10));
        this.jLabelLenientText2.setText(" Leniently compiled MIB modules will be marked with '(!)'.");
        this.useCompression.setToolTipText("Use GZIP compression to store compiled MIB files.");
        this.useCompression.setText("Compress MIB module files in the MIB repository");
        this.compileFileName.setToolTipText("Record the original file name without directory information in the compiled MIB module.");
        this.compileFileName.setText("Record file name of the imported MIB file in the MIB repository");
        this.updateNewer.setText("When compiling 'new' MIB modules update existing if LAST-UPDATED is newer");
        this.add((Component)this.repositoryPath, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabeLenientText, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 15, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.jLabelParseErrors, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this.maxParseErrors, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lenientCompilation, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.compileFileName, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.updateNewer, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelLenientText2, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 10), 0, 0));
        this.add((Component)this.useCompression, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.maxParseErrors.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(0), new Integer(999), null, true, null, new Integer(10), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(20)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "MIB Compiler";
    }

    public String getTitle() {
        return "MIB Compiler Settings";
    }

    public String getDescription() {
        return "MIB Explorer compiles MIB files into an internal format for faster and more reliable (independent) access to MIB data. The compiled MIB modules are stored in a directory called 'MIB repository' that is exclusively used by MIB Explorer. To create a new MIB repository, specify an empty directory.\nThe maximum parse errors specify the number of errors the MIB compiler should collect before bailing out.\nIf you got a MIB module that has many errors, you might want to compile it with the 'lenient' mode which reduces the error reporting to the absolute minimum. Although this might work in most cases, lenient compiled MIB modules might cause problems - therefore they are marked with '(!)' in the module list.";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        userConfigFile.put("mibexplorer.RepositoryPath", this.repositoryPath.getPath());
        userConfigFile.putBoolean("mibexplorer.compile.leniently", this.lenientCompilation.isSelected());
        userConfigFile.putInteger("mibexplorer.compile.maxerrors", ((Number)this.maxParseErrors.getValue()).intValue());
        userConfigFile.putBoolean("mibexplorer.compile.usecompression", this.useCompression.isSelected());
        userConfigFile.putBoolean("mibexplorer.compile.newIfLastUpdateNewer", this.updateNewer.isSelected());
        userConfigFile.putBoolean("mibexplorer.compile.storeFilename", this.compileFileName.isSelected());
        System.setProperty("com.agentpp.smi.storeMIBFileName", "" + this.compileFileName.isSelected());
    }

    public boolean isOK() {
        boolean bl;
        File file = new File(this.repositoryPath.getPath());
        boolean bl2 = bl = file.isDirectory() && file.canWrite() && file.canRead();
        if (!bl) {
            JOptionPane.showMessageDialog(this, new String[]{"The specified MIB repository path '" + file.getPath() + "'", "is not a directory or is not readable and writable.", "Please choose a valid (e.g. empty) repository directory before saving!"}, "Invalid MIB Repository Path", 0);
        }
        return bl;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.repositoryPath.setPath(userConfigFile.get("mibexplorer.RepositoryPath", "mibrepository"));
        this.lenientCompilation.setSelected(userConfigFile.getBoolean("mibexplorer.compile.leniently", false));
        this.maxParseErrors.setValue(new Integer(userConfigFile.getInteger("mibexplorer.compile.maxerrors", 20)));
        this.useCompression.setSelected(userConfigFile.getBoolean("mibexplorer.compile.usecompression", true));
        this.updateNewer.setSelected(userConfigFile.getBoolean("mibexplorer.compile.newIfLastUpdateNewer", true));
        this.compileFileName.setSelected(userConfigFile.getBoolean("mibexplorer.compile.storeFilename", false));
    }
}

