/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.explorer.cfg.ListenTransportAddresses;
import com.agentpp.explorer.cfg.TransportChangeEvent;
import com.agentpp.explorer.cfg.TransportChangeListener;
import com.agentpp.util.UserConfigFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;

public class ListenTransportConfig
extends JPanel
implements PreferencesItem,
TransportChangeListener {
    BorderLayout borderLayout1 = new BorderLayout();
    private String _$14693 = "udp";
    ListenTransportAddresses listenTransportAddresses = new ListenTransportAddresses();
    transient Vector transportChangeListeners = new Vector(2);

    public ListenTransportConfig() {
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.listenTransportAddresses.addTransportChangeListener(this);
    }

    private void _$4361() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.listenTransportAddresses, "Center");
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return this._$14693.toUpperCase() + " Trap Addresses";
    }

    public String getTitle() {
        return this._$14693.toUpperCase() + " Transport Address Configuration for Notification/Trap Reception";
    }

    public String getDescription() {
        return "In order to be able to receive " + this._$14693.toUpperCase() + " traps, " + "notifications, and inform requests, you need to specify the local " + "listen address(es) and port(s) here.\n" + "If the status of a listen port is 'Unavailable' then the port is used " + "by another application or MIB Explorer has insufficient system rights " + "to bind the port (on UNIX super-user rights are needed to bind ports " + "below 1024).";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        Vector vector = this.listenTransportAddresses.getAddresses();
        userConfigFile.putArray("mibexplorer.TrapAddress." + this._$14693, vector);
    }

    public boolean isOK() {
        return true;
    }

    public static Vector getAddresses(UserConfigFile userConfigFile, String string) {
        Vector vector = userConfigFile.getArray("mibexplorer.TrapAddress." + string);
        return vector;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("mibexplorer.TrapAddress." + this._$14693);
        this.listenTransportAddresses.setAddresses(vector);
    }

    public void setAddressType(String string) {
        this._$14693 = string;
        this.listenTransportAddresses.setAddressType(string);
    }

    public String getAddressType() {
        return this._$14693;
    }

    public synchronized void addTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.add(transportChangeListener);
    }

    public synchronized void removeTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.remove(transportChangeListener);
    }

    protected void fireTransportAddressChanged(TransportChangeEvent transportChangeEvent) {
        if (this.transportChangeListeners != null) {
            Vector vector = this.transportChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TransportChangeListener)vector.elementAt(i)).transportAddressChanged(transportChangeEvent);
            }
        }
    }

    public void transportAddressChanged(TransportChangeEvent transportChangeEvent) {
        TransportChangeEvent transportChangeEvent2 = new TransportChangeEvent(this, transportChangeEvent.getAddress(), this._$14693, transportChangeEvent.getEventType());
        this.fireTransportAddressChanged(transportChangeEvent2);
        transportChangeEvent.setAccepted(transportChangeEvent2.isAccepted());
    }
}

