/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.cfg.NewJdbcDriverPanel;
import com.agentpp.explorer.cfg.TransportChangeEvent;
import com.agentpp.explorer.cfg.TransportChangeListener;
import com.agentpp.slimdao.jdbc.DriverLoader;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JdbcDriverRegistration
extends JPanel
implements PreferencesItem,
JCCellDisplayListener,
JCSelectListener {
    private static final String[] _$19095 = new String[]{"mibexplorer.db.driver.reg.className", "mibexplorer.db.driver.reg.jarFile"};
    JCTable table = new FlexListTable();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonRemove = new JButton();
    private JCVectorDataSource _$4260;
    private TableSorter _$6193;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Border border2;
    private NewJdbcDriverPanel _$5047;
    private DriverLoader _$19096;
    transient Vector transportChangeListeners = new Vector(2);

    public JdbcDriverRegistration(DriverLoader driverLoader) {
        this._$19096 = driverLoader;
        this.init();
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.table.addSelectListener(this);
        this.table.addCellDisplayListener(this);
        this._$5047 = new NewJdbcDriverPanel(null);
    }

    public void init() {
        this._$4260 = new JCVectorDataSource();
        this._$4260.setNumColumns(3);
        this._$4260.setColumnLabel(0, "Driver Class Name");
        this._$4260.setColumnLabel(1, "Status");
        this._$4260.setColumnLabel(2, "JAR File");
        this._$6193 = new TableSorter(this.table, this._$4260);
        this.table.setDataSource(this._$4260);
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.setPixelWidth(-998, 33001);
        this.table.setVisibleColumns(-999);
        this.table.setVisibleRows(5);
        this.table.setRowLabelDisplay(false);
        this.table.setColumnLabelDisplay(true);
        this.table.setResizeEven(true);
        this.table.setSelectionPolicy(2);
        this._$18905();
    }

    private void _$4361() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JdbcDriverRegistration.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JdbcDriverRegistration.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.verticalFlowLayout1.setHgap(10);
        this.verticalFlowLayout1.setVgap(10);
        this.jPanelButtons.setBorder(this.border2);
        this.setBorder(null);
        this.add((Component)this.table, "Center");
        this.add((Component)this.jPanelButtons, "East");
        this.jPanelButtons.add((Component)this.jButtonAdd, null);
        this.jPanelButtons.add((Component)this.jButtonRemove, null);
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this._$5047.addDrivers(userConfigFile);
        List<String[]> list = userConfigFile.getTable(_$19095);
        this._$4260.deleteRows(1, this._$4260.getNumRows() - 1);
        for (String[] stringArray : list) {
            Vector vector = new Vector(3);
            String string = stringArray[0];
            String string2 = stringArray[1];
            this._$19103(vector, string, string2);
            this._$4260.addRow(Integer.MAX_VALUE, null, vector);
        }
    }

    public static void loadDrivers(UserConfigFile userConfigFile, DriverLoader driverLoader) {
        List<String[]> list = userConfigFile.getTable(_$19095);
        HashMap<URL, String> hashMap = new HashMap<URL, String>();
        for (String[] stringArray : list) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            URL uRL = null;
            try {
                uRL = new URL("jar:file:" + string2 + "!/");
                hashMap.put(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        driverLoader.registerDrivers(hashMap);
    }

    private void _$19103(Vector vector, String string, String string2) {
        Boolean bl = Boolean.FALSE;
        URL uRL = null;
        try {
            uRL = new URL("jar:file:" + string2 + "!/");
            if (string != null && string2 != null) {
                if (this._$19096.isRegistered(uRL, string)) {
                    bl = Boolean.TRUE;
                } else {
                    HashMap<URL, String> hashMap = new HashMap<URL, String>(2);
                    hashMap.put(uRL, string);
                    Map map = this._$19096.registerDrivers(hashMap);
                    if (map.size() > 0) {
                        bl = Boolean.TRUE;
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        vector.add(string);
        vector.add(bl);
        vector.add(string2);
    }

    public boolean isOK() {
        return true;
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 1; i < this._$4260.getNumRows(); ++i) {
            String[] stringArray = new String[]{(String)this._$4260.getTableDataItem(i, 0), (String)this._$4260.getTableDataItem(i, 2)};
            arrayList.add(stringArray);
        }
        userConfigFile.putTable(_$19095, arrayList);
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        this._$5047.setPreferredSize(new Dimension(600, 160));
        if (JOptionPane.showOptionDialog(this, this._$5047, "Register JDBC Driver", 2, -1, null, new String[]{"Add", "Cancel"}, "Add") == 0 && this._$5047.isOK()) {
            Vector vector = new Vector(3);
            this._$19103(vector, this._$5047.getDriverClass(), this._$5047.getJarFilePath());
            this._$4260.addRow(Integer.MAX_VALUE, null, vector);
        }
        this._$18905();
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        for (JCCellRange jCCellRange : collection) {
            TableUtils.setRangeAfterCopy(jCCellRange);
            this._$4260.deleteRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
        }
        this._$18905();
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() instanceof Boolean) {
            if (((Boolean)jCCellDisplayEvent.getCellData()).booleanValue()) {
                jCCellDisplayEvent.setDisplayData("OK");
            } else {
                jCCellDisplayEvent.setDisplayData("Failed");
            }
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getStartRow() == 0) {
            jCSelectEvent.setCancelled(true);
        }
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$18905();
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    private void _$18905() {
        this.jButtonRemove.setEnabled(this.table.getSelectedCells() != null && this._$4260.getNumRows() > 1);
    }

    public synchronized void addTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.add(transportChangeListener);
    }

    public synchronized void removeTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.remove(transportChangeListener);
    }

    protected void fireTransportAddressChanged(TransportChangeEvent transportChangeEvent) {
        if (this.transportChangeListeners != null) {
            Vector vector = this.transportChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TransportChangeListener)vector.elementAt(i)).transportAddressChanged(transportChangeEvent);
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "JDBC Drivers";
    }

    public String getTitle() {
        return "JDBC Driver Registration";
    }

    public String getDescription() {
        return "Because of licensing and performance issues, MIB Explorer cannot bundle JDBC drivers for any database type you might want to use. To load a JDBC driver you have to add a row to the table below by specifying the JDBC driver class name and the JAR file which contains the driver.";
    }

    public String getTooltip() {
        return "";
    }
}

