/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.snmp4j.SNMP4JSettings;

public class GeneralSettings
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelUndoRedoSteps = new JLabel();
    JCSpinField undoRedoSteps = new JCSpinField();
    JCheckBox autoLoadMIBSet = new JCheckBox();
    JCheckBox askBeforeOverwrite = new JCheckBox();
    JCheckBox allowSet4ReadOnly = new JCheckBox();
    JCheckBox supportBitString = new JCheckBox();
    JCheckBox noGetBulk = new JCheckBox();
    JLabel effectiveAfterRestartText = new JLabel();
    JLabel jLabelTreeInstances = new JLabel();
    JCSpinField maxTreeInstances = new JCSpinField();

    public GeneralSettings() {
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.undoRedoSteps.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(100), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(100)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.maxTreeInstances.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(0), new Integer(100000), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(0)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
    }

    private void _$4361() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelUndoRedoSteps.setText("Maximum number of Undo/Redo steps:");
        this.autoLoadMIBSet.setText("Load a target's associated MIB set (if present) when the target is selected");
        this.askBeforeOverwrite.setText("Confirm overwriting files");
        this.allowSet4ReadOnly.setText("Enable SET for variables with MAX-ACCESS 'read-only'");
        this.supportBitString.setToolTipText("Activates BIT STRING support for backward compatibility with SNMPv2c draft implementations");
        this.supportBitString.setText("Support obsolete RFC 1442 BIT STRING syntax*");
        this.noGetBulk.setText("Use always GETNEXT instead of GETBULK");
        this.noGetBulk.setToolTipText("Enable this option for devices that support SNMPv2c/v3 but not GETBULK");
        this.effectiveAfterRestartText.setFont(new Font("Tahoma", 2, 11));
        this.effectiveAfterRestartText.setText("* Changing this setting takes effect after restarting MIB Explorer");
        this.jLabelTreeInstances.setText("Maximum number of instances retrieved for MIB tree (0 = no limit):");
        this.add((Component)this.jLabelUndoRedoSteps, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.autoLoadMIBSet, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.allowSet4ReadOnly, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.supportBitString, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.noGetBulk, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.askBeforeOverwrite, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.effectiveAfterRestartText, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelTreeInstances, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.maxTreeInstances, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.undoRedoSteps, new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "General";
    }

    public String getTitle() {
        return "General Settings";
    }

    public String getDescription() {
        return "";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        userConfigFile.putInteger("mibexplorer.MaxUndoSteps", ((Number)this.undoRedoSteps.getValue()).intValue());
        userConfigFile.putBoolean("mibexplorer.AutoLoadMIBSet", this.autoLoadMIBSet.isSelected());
        userConfigFile.putBoolean("mibexplorer.AskBeforeOverwritingFile", this.askBeforeOverwrite.isSelected());
        userConfigFile.putBoolean("mibexplorer.SetReadonly", this.allowSet4ReadOnly.isSelected());
        userConfigFile.putBoolean("mibexplorer.BitString", this.supportBitString.isSelected());
        userConfigFile.putBoolean("mibexplorer.NoGetBulk", this.noGetBulk.isSelected());
        userConfigFile.putInteger("mibexplorer.tree.maxBrowseInstances", ((Number)this.maxTreeInstances.getValue()).intValue());
        SNMP4JSettings.setNoGetBulk(this.noGetBulk.isSelected());
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.undoRedoSteps.setValue(new Integer(userConfigFile.getInteger("mibexplorer.MaxUndoSteps", 100)));
        this.autoLoadMIBSet.setSelected(userConfigFile.getBoolean("mibexplorer.AutoLoadMIBSet", true));
        this.askBeforeOverwrite.setSelected(userConfigFile.getBoolean("mibexplorer.AskBeforeOverwritingFile", true));
        this.allowSet4ReadOnly.setSelected(userConfigFile.getBoolean("mibexplorer.SetReadonly", false));
        this.supportBitString.setSelected(userConfigFile.getBoolean("mibexplorer.BitString", false));
        this.noGetBulk.setSelected(userConfigFile.getBoolean("mibexplorer.NoGetBulk", false));
        this.maxTreeInstances.setValue(new Integer(userConfigFile.getInteger("mibexplorer.tree.maxBrowseInstances", 0)));
        SNMP4JSettings.setNoGetBulk(this.noGetBulk.isSelected());
    }
}

