/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.ber;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.ToolPanelPlugin;
import com.agentpp.explorer.ber.BERLogPanel_buttonEnable_itemAdapter;
import com.agentpp.explorer.ber.BERLogPanel_clearLog_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_insertPacket_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_openCaptureFile_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_saveCaptureFile_actionAdapter;
import com.agentpp.explorer.ber.BERNode;
import com.agentpp.explorer.ber.BERTreeBuilder;
import com.agentpp.explorer.ber.BERTreeCellRenderer;
import com.agentpp.explorer.editors.OctetTextField;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.dom4j.DocumentFactory;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.TransportListener;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BERLogPanel
extends JPanel
implements ToolPanelPlugin,
TransportListener,
JCSelectListener,
JCCellDisplayListener,
TreeSelectionListener {
    private static final String[] _$31052 = new String[]{"Transport", "Source", "Destination", "Size", "Message"};
    private static final int[] _$31053 = new int[]{6, 15, 15, 4};
    private static final String _$31054 = "TCP";
    private static final String _$31055 = "UDP";
    private SimpleDateFormat _$20424 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private SimpleDateFormat _$30206 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final int _$31056 = 0;
    private static final int _$31057 = 1;
    private static final int _$15014 = 2;
    private static final int _$31058 = 4;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayoutText = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    ExtendedListTable logTable = new ExtendedListTable();
    JSplitPane splitPaneMessage = new JSplitPane();
    JTextPane messageContent = new JTextPane();
    JScrollPane treeScrollPane = new JScrollPane();
    JScrollPane textScrollPane = new JScrollPane();
    JTree tree = new JTree();
    JPanel textPanel = new JPanel();
    TableSorter tableSorter;
    BERTreeCellRenderer cellRenderer = new BERTreeCellRenderer();
    private BERTreeBuilder _$31066 = new BERTreeBuilder();
    private boolean _$10701;
    private UserConfigFile _$4288;
    JCVectorDataSource logModel = new JCVectorDataSource();
    JPanel buttonPanel = new JPanel();
    DecimalFormat indexFormat = new DecimalFormat("000000");
    JToggleButton buttonEnable = new JToggleButton();
    JButton openCaptureFile = new JButton();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton saveCaptureFile = new JButton();
    JButton clearLog = new JButton();
    JButton insertPacket = new JButton();
    private boolean _$31075 = false;
    private RowAppender _$31077 = new RowAppender();

    public BERLogPanel() {
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logModel.setNumColumns(_$31052.length);
        this.logModel.setNumRows(0);
        this.logModel.setColumnLabels(_$31052);
        this.logTable.setDataSource(this.logModel);
        this.logTable.addCellDisplayListener(this);
        this.logTable.addSelectListener(this);
        this.logTable.setCharWidth(-1, 14);
        this.logTable.setPopupMenuEnabled(true);
        this.logTable.getPopupMenu().add(new RemoveAction("Remove Selected"));
        this.tree.addTreeSelectionListener(this);
        this._$31079();
        this.buttonEnable.setSelected(false);
        this.tableSorter = new TableSorter(this.logTable, this.logModel);
        for (int i = 0; i < _$31053.length; ++i) {
            this.logTable.setCharWidth(i, _$31053[i]);
        }
    }

    public BERLogPanel(UserConfigFile userConfigFile, boolean bl) {
        this();
        this._$4288 = userConfigFile;
        this._$31075 = bl;
        this._$31066.setDecryptPDUs(this._$31075);
    }

    private void _$31079() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No Packet Selected", false)));
    }

    private void _$4361() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jSplitPane1.setOrientation(0);
        this.splitPaneMessage.setLeftComponent(this.treeScrollPane);
        this.splitPaneMessage.setOneTouchExpandable(true);
        this.messageContent.setFont(new Font("Monospaced", 0, 11));
        this.messageContent.setToolTipText("Displays selected SNMP message in HEX format - Octets represented by selected ASN.1 tree node are highlighted");
        this.tree.setToolTipText("ASN.1 (BER) Tree");
        this.logTable.setToolTipText("Select a message to show in ASN.1/BER tree panel");
        this.buttonEnable.setToolTipText("Capture SNMP packets received and sent in the packet log");
        this.buttonEnable.setHorizontalAlignment(2);
        this.buttonEnable.setText("Capture Packets");
        this.buttonEnable.addItemListener(new BERLogPanel_buttonEnable_itemAdapter(this));
        this.openCaptureFile.setToolTipText("Open capture file and replace log contents with file contents");
        this.openCaptureFile.setHorizontalAlignment(2);
        this.openCaptureFile.setText("Open...");
        this.openCaptureFile.setIcon(MIBExplorerFrame.imageOpen16);
        this.openCaptureFile.addActionListener(new BERLogPanel_openCaptureFile_actionAdapter(this));
        this.buttonPanel.setLayout(this.verticalFlowLayout1);
        this.saveCaptureFile.setToolTipText("Save captured packets into a XML file");
        this.saveCaptureFile.setHorizontalAlignment(2);
        this.saveCaptureFile.setIcon(MIBExplorerFrame.imageSaveAs16);
        this.saveCaptureFile.setText("Save as...");
        this.saveCaptureFile.addActionListener(new BERLogPanel_saveCaptureFile_actionAdapter(this));
        this.clearLog.setHorizontalAlignment(2);
        this.clearLog.setText("Clear");
        this.clearLog.setIcon(MIBExplorerFrame.imageDelete16);
        this.clearLog.addActionListener(new BERLogPanel_clearLog_actionAdapter(this));
        this.insertPacket.setHorizontalAlignment(2);
        this.insertPacket.setText("Analyse...");
        this.insertPacket.setIcon(MIBExplorerFrame.imageInfo16);
        this.insertPacket.setToolTipText("Analyse a SNMP message by entering their bytes");
        this.insertPacket.addActionListener(new BERLogPanel_insertPacket_actionAdapter(this));
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.logTable, "left");
        this.jSplitPane1.add((Component)this.splitPaneMessage, "right");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.splitPaneMessage.add((Component)this.textScrollPane, "bottom");
        this.splitPaneMessage.add((Component)this.treeScrollPane, "top");
        this.treeScrollPane.getViewport().add(this.tree);
        this.textScrollPane.getViewport().add(this.textPanel);
        this.textPanel.setLayout(this.borderLayoutText);
        this.textPanel.add((Component)this.messageContent, "Center");
        this.add((Component)this.buttonPanel, "West");
        this.buttonPanel.add(this.buttonEnable);
        this.buttonPanel.add(this.clearLog);
        this.buttonPanel.add(this.openCaptureFile);
        this.buttonPanel.add(this.saveCaptureFile);
        this.buttonPanel.add(this.insertPacket);
        this.messageContent.setEditable(false);
        this.tree.setCellRenderer(this.cellRenderer);
    }

    public void initDividerLocations() {
        this.splitPaneMessage.setDividerLocation(0.4);
        this.jSplitPane1.setDividerLocation(0.5);
    }

    public synchronized void addEntry(Address address, Address address2, byte[] byArray) {
        Vector<Object> vector = new Vector<Object>(_$31052.length);
        if (address instanceof TcpAddress) {
            vector.add(_$31054);
        } else {
            vector.add(_$31055);
        }
        vector.add(address);
        vector.add(address2);
        vector.add(new Integer(byArray.length));
        vector.add(new OctetString(byArray));
        if (this._$31077.addRow(new Date(), vector)) {
            SwingUtilities.invokeLater(this._$31077);
        }
    }

    private synchronized void _$17306(Date date, Address address, Address address2, OctetString octetString) {
        Vector<Object> vector = new Vector<Object>(_$31052.length);
        if (address instanceof TcpAddress) {
            vector.add(_$31054);
        } else {
            vector.add(_$31055);
        }
        vector.add(address);
        vector.add(address2);
        vector.add(new Integer(octetString.length()));
        vector.add(octetString);
        if (this._$31077.addRow(date, vector)) {
            SwingUtilities.invokeLater(this._$31077);
        }
    }

    public void setTarget(GenTarget genTarget) {
    }

    public void setTargets(Hashtable hashtable) {
    }

    public void processMessage(TransportMapping transportMapping, Address address, ByteBuffer byteBuffer, TransportStateReference transportStateReference) {
        if (this._$10701) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byteBuffer.rewind();
            this.addEntry(address, (Address)transportMapping.getListenAddress(), byArray);
        }
    }

    public void processMessage(TransportMapping transportMapping, Address address, byte[] byArray, TransportStateReference transportStateReference) {
        if (this._$10701) {
            this.addEntry((Address)transportMapping.getListenAddress(), address, byArray);
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public synchronized void afterSelect(JCSelectEvent jCSelectEvent) {
        int n = TableUtils.getFirstSelectedRow(this.logTable);
        if (n >= 0) {
            Address address = (Address)this.logModel.getTableDataItem(n, 1);
            Address address2 = (Address)this.logModel.getTableDataItem(n, 2);
            OctetString octetString = (OctetString)this.logModel.getTableDataItem(n, 4);
            Date date = (Date)this.logModel.getTableRowLabel(n);
            TreeModel treeModel = this._$31066.getTree(address, address2, octetString, date);
            this.tree.setModel(treeModel);
            this._$27658();
            this.messageContent.setText(this._$31095(octetString).toString());
            this.messageContent.setCaretPosition(0);
            this._$6253(this.messageContent);
        }
    }

    private void _$27658() {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public void setEnabled(boolean bl) {
        this._$10701 = bl;
    }

    public boolean isEnabled() {
        return this._$10701;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getRow() >= 0) {
            if (jCCellDisplayEvent.getColumn() == 4 && jCCellDisplayEvent.getCellData() != null) {
                jCCellDisplayEvent.setDisplayData(((OctetString)jCCellDisplayEvent.getCellData()).toHexString());
            } else if (jCCellDisplayEvent.getCellData() instanceof Date) {
                jCCellDisplayEvent.setDisplayData(this._$20424.format((Date)jCCellDisplayEvent.getCellData()));
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (defaultMutableTreeNode2.getUserObject() instanceof BERTreeBuilder.MessageNode) {
            Object object;
            int n = -1;
            int n2 = 0;
            boolean bl = false;
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof BERNode) {
                object = (BERNode)defaultMutableTreeNode.getUserObject();
                n = ((BERNode)object).getPos();
                n2 = n + ((BERNode)object).getLength();
                if (((BERNode)object).isDecrypted()) {
                    bl = true;
                }
            }
            object = (BERTreeBuilder.MessageNode)defaultMutableTreeNode2.getUserObject();
            OctetString octetString = bl ? ((BERTreeBuilder.MessageNode)object).getDecryptedMessage() : ((BERTreeBuilder.MessageNode)object).getMessage();
            StringBuffer stringBuffer = this._$31095(octetString);
            this.messageContent.setText(stringBuffer.toString());
            this._$6253(this.messageContent);
            this._$31104(this.messageContent, n, n2);
        }
    }

    private StringBuffer _$31095(OctetString octetString) {
        StringBuffer stringBuffer = new StringBuffer(octetString.length() * 4);
        for (int i = 0; i < octetString.length(); i += 16) {
            stringBuffer.append(this.indexFormat.format(i));
            stringBuffer.append(" ");
            for (int j = 0; j < 2; ++j) {
                if (i + j * 8 < octetString.length()) {
                    stringBuffer.append(octetString.substring(i + j * 8, Math.min(i + j * 8 + 8, octetString.length())).toHexString(' '));
                    for (int k = 0; k < i + j * 8 + 8 - octetString.length(); ++k) {
                        stringBuffer.append("   ");
                    }
                } else {
                    stringBuffer.append("                       ");
                }
                stringBuffer.append("  ");
            }
            stringBuffer.append(octetString.substring(i, Math.min(octetString.length(), i + 16)).toASCII('.'));
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    private int _$31105(int n) {
        int n2 = n / 16;
        int n3 = n % 16;
        return 74 * n2 + 7 + n3 * 3 + n3 / 8;
    }

    private int _$31106(int n) {
        int n2 = n / 16;
        int n3 = n % 16;
        return 74 * n2 + 7 + 48 + 2 + n3;
    }

    private void _$31104(JTextPane jTextPane, int n, int n2) {
        if (n < 0 || n2 < n) {
            return;
        }
        int n3 = n / 16;
        int n4 = n % 16;
        int n5 = n2 - n;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setUnderline(simpleAttributeSet, true);
        int n6 = 0;
        for (int i = 0; i < (n4 + n5 + 1) / 16 + 1; ++i) {
            int n7 = 0;
            int n8 = 16;
            if (i == 0) {
                n7 = n4;
                n8 = Math.min(16 - n7, n5);
            } else if (i + 1 >= (n4 + n5 + 1) / 16 + 1) {
                n8 = n2 % 16;
            }
            int n9 = n8 * 3;
            int n10 = this._$31105(n3 * 16 + i * 16 + n7);
            if (n6 == 0) {
                n6 = n10;
            }
            jTextPane.getStyledDocument().setCharacterAttributes(n10, n9, simpleAttributeSet, false);
            int n11 = n8;
            int n12 = this._$31106(n3 * 16 + i * 16 + n7);
            jTextPane.getStyledDocument().setCharacterAttributes(n12, n11, simpleAttributeSet, false);
        }
        try {
            jTextPane.setCaretPosition(n6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void _$6253(JTextPane jTextPane) {
        jTextPane.getStyledDocument().setCharacterAttributes(0, jTextPane.getText().length(), new SimpleAttributeSet(), true);
    }

    public void buttonEnable_itemStateChanged(ItemEvent itemEvent) {
        this._$10701 = itemEvent.getStateChange() == 1;
    }

    public void clearLog_actionPerformed(ActionEvent actionEvent) {
        this._$31073();
    }

    private synchronized void _$31073() {
        if (this.logModel.getNumRows() > 0) {
            this.logModel.deleteRows(0, this.logModel.getNumRows());
            this._$31079();
        }
    }

    public void openCaptureFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$4288.get("mibexplorer.capture.dir", ""));
        jFileChooser.setDialogTitle("Open Capture File");
        jFileChooser.setFileSelectionMode(0);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("xml", "XML Capture Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._$4288.put("mibexplorer.capture.dir", jFileChooser.getSelectedFile().getParent());
            this._$31120(jFileChooser.getSelectedFile());
        }
    }

    public void saveCaptureFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$4288.get("mibexplorer.capture.dir", ""));
        jFileChooser.setDialogTitle("Save Capture File");
        jFileChooser.setFileSelectionMode(0);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("xml", "XML Capture Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        if (jFileChooser.showSaveDialog(this) == 0) {
            this._$4288.put("mibexplorer.capture.dir", jFileChooser.getSelectedFile().getParent());
            try {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".XML")) {
                    file = new File(file.getParentFile(), file.getName() + ".xml");
                }
                if (file.exists() && JOptionPane.showConfirmDialog(this, "File '" + jFileChooser.getSelectedFile().getPath() + "' already exists! Overwrite it?", "Confirm Overwrite", 2, 3) == 2) {
                    return;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                DOMDocument dOMDocument = this._$31122();
                XMLWriter xMLWriter = new XMLWriter(fileOutputStream, new OutputFormat(" ", true));
                xMLWriter.write(dOMDocument);
                xMLWriter.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, new String[]{"An error occurred while trying to write capture file: ", iOException.getMessage()}, "Capture File not Saved", 0);
                return;
            }
        }
    }

    private DOMDocument _$31122() {
        DOMDocument dOMDocument = new DOMDocument();
        DOMElement dOMElement = new DOMElement("Capture");
        DOMAttribute dOMAttribute = new DOMAttribute(new QName("xmlns:xsi"), "http://www.w3.org/2001/XMLSchema-instance");
        dOMElement.add(dOMAttribute);
        DOMAttribute dOMAttribute2 = new DOMAttribute(new QName("xsi:noNamespaceSchemaLocation"), "MIBExplorerCaptureFile.xsd");
        dOMElement.add(dOMAttribute2);
        for (int i = 0; i < this.logModel.getNumRows(); ++i) {
            DOMElement dOMElement2 = new DOMElement("Packet");
            dOMElement2.addAttribute("time", this._$30206.format((Date)this.logModel.getTableRowLabel(i)));
            dOMElement2.addAttribute("source", this.logModel.getTableDataItem(i, 1).toString());
            dOMElement2.addAttribute("destination", this.logModel.getTableDataItem(i, 2).toString());
            dOMElement2.addAttribute("transport", (String)this.logModel.getTableDataItem(i, 0));
            OctetString octetString = (OctetString)this.logModel.getTableDataItem(i, 4);
            dOMElement2.setText(octetString.toString(16).toUpperCase());
            dOMElement.add(dOMElement2);
        }
        dOMDocument.setRootElement(dOMElement);
        return dOMDocument;
    }

    private void _$31120(File file) {
        try {
            DOMDocument dOMDocument = BERLogPanel._$18800(new FileInputStream(file), DOMDocumentFactory.getInstance());
            this._$31073();
            NodeList nodeList = dOMDocument.getElementsByTagName("Packet");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Address address;
                Address address2;
                DOMElement dOMElement = (DOMElement)nodeList.item(i);
                Date date = this._$30206.parse(dOMElement.attributeValue("time"));
                String string = dOMElement.attributeValue("transport");
                String string2 = dOMElement.attributeValue("source");
                String string3 = dOMElement.attributeValue("destination");
                if (string.equals(_$31054)) {
                    address2 = TcpAddress.parse(string2);
                    address = TcpAddress.parse(string3);
                } else {
                    address2 = UdpAddress.parse(string2);
                    address = UdpAddress.parse(string3);
                }
                OctetString octetString = OctetString.fromString(dOMElement.getText(), 16);
                this._$17306(date, address2, address, octetString);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, new String[]{"File '" + file + "' is not a valid capture XML file.", "File cannot be loaded!"}, "Invalid Capture File", 0);
        }
    }

    private static DOMDocument _$18800(InputStream inputStream, DocumentFactory documentFactory) throws Exception {
        SAXReader sAXReader = new SAXReader(documentFactory, false);
        InputSource inputSource = new InputSource(inputStream);
        sAXReader.setFeature("http://xml.org/sax/features/validation", false);
        DOMDocument dOMDocument = (DOMDocument)sAXReader.read(inputSource);
        return dOMDocument;
    }

    void insertPacket_actionPerformed(ActionEvent actionEvent) {
        OctetTextField octetTextField = new OctetTextField(false);
        octetTextField.setColumns(40);
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.add(new JLabel("Please enter packet to analyse as colon separated HEX string: "));
        jPanel.add(octetTextField);
        if (JOptionPane.showConfirmDialog(this, jPanel, "Analyze SNMP Packet", 2, -1) == 0) {
            try {
                OctetString octetString = OctetTextField.getOctetString(octetTextField.getText());
                this.addEntry(new UdpAddress(), new UdpAddress(), octetString.getValue());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, new String[]{"The entered value could not be interpreted", "as a hexdecimal string. Please use only '0'-'9' and 'a'-'f'", "and separate each byte with a ':'."}, "Format Error", 0);
            }
        }
    }

    public boolean onExit() {
        return false;
    }

    class RowAppender
    implements Runnable {
        LinkedList rows;

        RowAppender() {
        }

        public synchronized boolean addRow(Object object, Object object2) {
            boolean bl = false;
            if (this.rows == null) {
                this.rows = new LinkedList();
                bl = true;
            }
            this.rows.add(new Object[]{object, object2});
            return bl;
        }

        public synchronized void run() {
            LinkedList linkedList = this.rows;
            this.rows = null;
            for (Object[] objectArray : linkedList) {
                BERLogPanel.this.logModel.addRow(Integer.MAX_VALUE, objectArray[0], (Vector)objectArray[1]);
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableUtils.removeSelectedRows(BERLogPanel.this.logTable, BERLogPanel.this.logModel);
        }
    }
}

