/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.SortLabel;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.UserConfigurationEvent;
import com.agentpp.explorer.UserConfigurationListener;
import com.agentpp.explorer.editors.OctetTextField;
import com.agentpp.explorer.editors.cell.OctetStringCellEditor;
import com.agentpp.snmp.UserProfile;
import com.klg.jclass.cell.editors.JCCheckBoxCellEditor;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UserConfiguration
extends JPanel
implements ActionListener,
JCEditCellListener,
JCValidateListener,
JCCellDisplayListener {
    private static final int _$30222 = 1;
    private static final int _$31611 = 0;
    private static final int _$31612 = 2;
    private static final int _$31613 = 3;
    private static final int _$31614 = 4;
    private static final int _$31615 = 5;
    private static final int _$31616 = 6;
    private static final int _$31617 = 7;
    static final String ACTION_ADD = "Add User";
    static final String ACTION_EDIT = "Edit Name";
    static final String ACTION_REMOVE = "Remove User";
    static final String ACTION_LOCALIZE = "Localize User";
    private static final String _$6177 = "Default";
    private static final String _$6178 = "Hexadecimal";
    private static final String _$6179 = "Decimal";
    private static final String[] _$5516 = new String[]{"User Name", "Security Name", "Auth Protocol", "Auth Passphrase", "Priv Protocol", "Priv Passphrase", "Principal", "Localization Engine ID"};
    private static OctetStringCellEditor[] _$6181 = new OctetStringCellEditor[_$5516.length];
    private static final String[] _$6182 = new String[]{"", "MD5", "SHA"};
    private static final String[] _$6183 = new String[]{"", "DES", "3DES", "AES128", "AES192", "AES256", "AES192-KeyExt3DES", "AES256-KeyExt3DES"};
    BorderLayout borderLayout1 = new BorderLayout();
    JMenu editMenu = new JMenu("Format");
    int userNameEditableRow = 0;
    transient Vector userConfigurationListeners;
    PopupListTable table = new PopupListTable(){

        public boolean isEditable(int n, int n2) {
            String string;
            n = UserConfiguration.this._$4419(n);
            if (n2 == 0 ? n != UserConfiguration.this.userNameEditableRow : n2 > 2 && n2 < 6 && ((string = (String)UserConfiguration.this.userModel.getTableDataItem(n, 2)) == null || string.length() == 0)) {
                return false;
            }
            if (n2 == 5) {
                string = (String)UserConfiguration.this.userModel.getTableDataItem(n, 4);
                return string != null && string.length() > 0;
            }
            return true;
        }

        public boolean isPopupAllowed(int n, int n2) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            JCCellPosition jCCellPosition = UserConfiguration.this.table.XYToCell(n, n2);
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$5516.length && _$6181[jCCellPosition.column] != null) {
                UserConfiguration.this.editMenu.setEnabled(true);
            } else {
                UserConfiguration.this.editMenu.setEnabled(false);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            Object object = UserConfiguration.this.userModel.getTableDataItem(UserConfiguration.this._$4419(jCCellPosition.row), jCCellPosition.column);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
    };
    JCEditableVectorDataSource userModel = new JCEditableVectorDataSource();
    JCComboBoxCellEditor authProtocolEditor = new JCComboBoxCellEditor(_$6182);
    JCComboBoxCellEditor privProtocolEditor = new JCComboBoxCellEditor(_$6183);
    JCStringCellEditor userNameEditor = new JCStringCellEditor();
    private OctetStringCellEditor _$31626 = new OctetStringCellEditor();
    private TableSorter _$6193;

    public UserConfiguration() {
        this.userModel.setNumColumns(_$5516.length);
        this.userModel.setColumnLabels(_$5516);
        this.userModel.setNumRows(1);
        this.table.setDataSource(this.userModel);
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$4634();
        this._$6193 = new TableSorter(this.table, this.userModel);
        this._$6193.addSortColumn(0);
        TablePopupMenu tablePopupMenu = this.table.getPopupMenu();
        tablePopupMenu.addItem(ACTION_ADD, this);
        tablePopupMenu.addItem(ACTION_EDIT, this);
        tablePopupMenu.addItem(ACTION_REMOVE, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_LOCALIZE, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.editMenu);
        JMenuItem jMenuItem = this.editMenu.add(new FormatAction(_$6177));
        jMenuItem.setMnemonic('F');
        jMenuItem = this.editMenu.add(new FormatAction(_$6178));
        jMenuItem.setMnemonic('H');
        jMenuItem = this.editMenu.add(new FormatAction(_$6179));
        jMenuItem.setMnemonic('D');
        this.table.setFocusIndicator(4);
        this.table.addEditCellListener(this);
        this.table.addCellDisplayListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.table);
    }

    public static String getSecurityProtocolName(OID oID) {
        if (oID == null) {
            return "";
        }
        if (AuthMD5.ID.equals(oID)) {
            return "MD5";
        }
        if (AuthSHA.ID.equals(oID)) {
            return "SHA";
        }
        if (PrivDES.ID.equals(oID)) {
            return "DES";
        }
        if (Priv3DES.ID.equals(oID)) {
            return "3DES";
        }
        if (PrivAES128.ID.equals(oID)) {
            return "AES128";
        }
        if (PrivAES192.ID.equals(oID)) {
            return "AES192";
        }
        if (PrivAES256.ID.equals(oID)) {
            return "AES256";
        }
        if (PrivAES192With3DESKeyExtension.ID.equals(oID)) {
            return "AES192-KeyExt3DES";
        }
        if (PrivAES256With3DESKeyExtension.ID.equals(oID)) {
            return "AES256-KeyExt3DES";
        }
        return null;
    }

    public static OID getSecurityProtocol(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("MD5")) {
            return AuthMD5.ID;
        }
        if (string.equals("SHA")) {
            return AuthSHA.ID;
        }
        if (string.equals("DES")) {
            return PrivDES.ID;
        }
        if (string.equals("3DES")) {
            return Priv3DES.ID;
        }
        if (string.equals("AES128")) {
            return PrivAES128.ID;
        }
        if (string.equals("AES192")) {
            return PrivAES192.ID;
        }
        if (string.equals("AES256")) {
            return PrivAES256.ID;
        }
        if (string.equals("AES192-KeyExt3DES")) {
            return PrivAES192With3DESKeyExtension.ID;
        }
        if (string.equals("AES256-KeyExt3DES")) {
            return PrivAES256With3DESKeyExtension.ID;
        }
        return null;
    }

    public void setUsers(Hashtable hashtable) {
        this.userModel.setNumRows(1);
        for (UserProfile userProfile : hashtable.values()) {
            Vector vector = this._$22591(userProfile);
            this.userModel.addRow(Integer.MAX_VALUE, userProfile, vector);
        }
        this._$6193.sort();
    }

    public void setSelectedUser(String string) {
        if (string != null) {
            SortableDataViewModel sortableDataViewModel = (SortableDataViewModel)this.table.getDataView();
            TableDataModel tableDataModel = sortableDataViewModel.getDataSource();
            for (int i = 0; i < this.table.getNumRows(); ++i) {
                if (!string.equals(tableDataModel.getTableDataItem(i, 0))) continue;
                this.table.setRowSelection(sortableDataViewModel.getViewRow(i), sortableDataViewModel.getViewRow(i));
            }
            TableUtils.getFirstSelectedRow(this.table);
        }
    }

    private String _$6222(String string) {
        int n = 1;
        String string2 = string;
        for (int i = 1; i < this.userModel.getNumRows(); ++i) {
            if (!this.userModel.getTableDataItem(i, 0).equals(string2)) continue;
            string2 = string + " " + n++;
            i = 0;
        }
        return string2;
    }

    public Hashtable getUsers() {
        Hashtable<String, UserProfile> hashtable = new Hashtable<String, UserProfile>(this.userModel.getNumRows() + 10);
        for (int i = 1; i < this.userModel.getNumRows(); ++i) {
            UserProfile userProfile = this._$31633(i);
            hashtable.put(userProfile.getName(), userProfile);
        }
        return hashtable;
    }

    public boolean checkInconsistentUSMUsers() {
        for (int i = 1; i < this.userModel.getNumRows(); ++i) {
            String string = (String)this.userModel.getTableDataItem(i, 0);
            OID oID = UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(i, 2));
            OctetString octetString = (OctetString)this.userModel.getTableDataItem(i, 3);
            if (oID != null && (octetString == null || octetString.length() < 8)) {
                JOptionPane.showMessageDialog(this, new String[]{"The authentication passphrase provided for user", "'" + string + "' has not the required minimum", "length of eight characters. Authentication has been", "disabled for this user."}, "Invalid Authentication Passphrase", 2);
                this.userModel.setTableDataItem("", i, 2);
            }
            OID oID2 = UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(i, 4));
            OctetString octetString2 = (OctetString)this.userModel.getTableDataItem(i, 5);
            if (oID2 == null || octetString2 != null && octetString2.length() >= 8) continue;
            JOptionPane.showMessageDialog(this, new String[]{"The privacy passphrase provided for user", "'" + string + "' has not the required minimum", "length of eight characters. Privacy has been", "disabled for this user."}, "Invalid Privacy Passphrase", 2);
            this.userModel.setTableDataItem("", i, 4);
        }
        return true;
    }

    private UserProfile _$31633(int n) {
        UsmUser usmUser = this._$5912(n);
        UserProfile userProfile = (UserProfile)this.userModel.getTableRowLabel(n);
        userProfile.setName((String)this.userModel.getTableDataItem(n, 0));
        userProfile.setUser(usmUser);
        userProfile.setPrincipal((Boolean)this.userModel.getTableDataItem(n, 6));
        return userProfile;
    }

    private UsmUser _$5912(int n) {
        OctetString octetString = (OctetString)this.userModel.getTableDataItem(n, 7);
        UsmUser usmUser = new UsmUser((OctetString)this.userModel.getTableDataItem(n, 1), UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(n, 2)), (OctetString)this.userModel.getTableDataItem(n, 3), UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(n, 4)), (OctetString)this.userModel.getTableDataItem(n, 5), octetString != null && octetString.length() > 0 ? octetString : null);
        return usmUser;
    }

    private void _$4361() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.table, "Center");
        this.table.setRowLabelDisplay(false);
        this.table.setRowHidden(0, true);
        this.table.setPopupMenuEnabled(true);
    }

    private void _$4634() {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this.authProtocolEditor);
        this.table.setCellStyle(-997, 2, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this.privProtocolEditor);
        this.table.setCellStyle(-997, 4, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this.userNameEditor.removeValidateListener(this);
        this.userNameEditor.addValidateListener(this);
        jCCellStyle.setCellEditor(this.userNameEditor);
        this.table.setCellStyle(-997, 0, jCCellStyle);
        this.table.setCellEditor(OctetString.class, this._$31626);
        this.table.setPixelWidth(-997, 33002);
        this.table.setCellEditor(Boolean.class, new JCCheckBoxCellEditor());
        this._$6237(3, 0);
        this._$6237(5, 0);
        this._$6237(1, 0);
        this._$6237(7, 16);
    }

    private void _$6237(int n, int n2) {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        UserConfiguration._$6181[n] = new OctetStringCellEditor();
        _$6181[n].setMode(n2);
        jCCellStyle.setCellEditor(_$6181[n]);
        this.table.setCellStyle(-997, n, jCCellStyle);
    }

    private Vector _$22591(UserProfile userProfile) {
        Vector<Object> vector = new Vector<Object>(_$5516.length);
        vector.add(userProfile.getName());
        vector.add(userProfile.getUser().getSecurityName());
        vector.add(UserConfiguration.getSecurityProtocolName(userProfile.getUser().getAuthenticationProtocol()));
        vector.add(userProfile.getUser().getAuthenticationPassphrase());
        vector.add(UserConfiguration.getSecurityProtocolName(userProfile.getUser().getPrivacyProtocol()));
        vector.add(userProfile.getUser().getPrivacyPassphrase());
        vector.add(new Boolean(userProfile.isPrincipal()));
        vector.add(userProfile.getUser().getLocalizationEngineID());
        return vector;
    }

    private int _$4419(int n) {
        int n2 = n;
        if (n2 < 0) {
            return n2;
        }
        if (this.table.getDataView() instanceof SortableDataViewModel) {
            n2 = ((SortableDataViewModel)this.table.getDataView()).getDataRow(n2);
        }
        return n2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ACTION_ADD)) {
            UsmUser usmUser = new UsmUser(new OctetString(), null, new OctetString(), null, new OctetString());
            UserProfile userProfile = new UserProfile(this._$6222("New User"), usmUser);
            this.userModel.addRow(Integer.MAX_VALUE, userProfile, this._$22591(userProfile));
            this.table.setRowSelection(this.table.getNumRows() - 1, 1);
            this.table.beginEdit(this.table.getNumRows() - 1, 0);
        } else if (actionEvent.getActionCommand().equals(ACTION_REMOVE)) {
            int[] nArray = TableUtils.getSelectedRows(this.table);
            Arrays.sort(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                UserProfile userProfile = this._$31633(nArray[i] - i);
                UserConfigurationEvent userConfigurationEvent = new UserConfigurationEvent(this, userProfile, 1);
                this.fireUserConfigChanged(userConfigurationEvent);
                if (userConfigurationEvent.isCanceled()) {
                    JOptionPane.showMessageDialog(this, new String[]{"The USM user '" + userProfile.getName() + "' is still referenced by one or more targets.", "Please remove those references before deleting this user!"}, "USM User Still Referenced", 2);
                    break;
                }
                this.userModel.deleteRows(nArray[i] - i, 1);
            }
            this.table.clearSelection();
            this._$6193.sort();
        } else if (actionEvent.getActionCommand().equals(ACTION_EDIT)) {
            int n = TableUtils.getFirstMarkedRow(this.table);
            if (n >= 0) {
                if (this.table.getDataView() instanceof SortableDataViewModel) {
                    n = ((SortableDataViewModel)this.table.getDataView()).getViewRow(n);
                }
                this.userNameEditableRow = n;
                this.table.beginEdit(n, 0);
            }
        } else if (actionEvent.getActionCommand().equals(ACTION_LOCALIZE)) {
            this._$31635();
        }
    }

    private void _$31635() throws HeadlessException {
        int n = TableUtils.getFirstMarkedRow(this.table);
        if (this.userModel.getTableDataItem(n, 7) == null || ((OctetString)this.userModel.getTableDataItem(n, 7)).length() == 0) {
            this.table.cancelEdit(true);
            OctetTextField octetTextField = new OctetTextField(false);
            octetTextField.setColumns(40);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(new JLabel("Target engine ID for localization: "));
            jPanel.add(octetTextField);
            if (JOptionPane.showConfirmDialog(this, jPanel, "Localization Engine ID", 2, -1) == 0) {
                OctetString octetString = OctetTextField.getOctetString(octetTextField.getText());
                UsmUser usmUser = this._$5912(n);
                if (usmUser.getAuthenticationProtocol() != null) {
                    byte[] byArray = SecurityProtocols.getInstance().passwordToKey(usmUser.getAuthenticationProtocol(), usmUser.getAuthenticationPassphrase(), octetString.getValue());
                    this.userModel.setTableDataItem(new OctetString(byArray), n, 3);
                    if (usmUser.getPrivacyProtocol() != null) {
                        byte[] byArray2 = SecurityProtocols.getInstance().passwordToKey(usmUser.getPrivacyProtocol(), usmUser.getAuthenticationProtocol(), usmUser.getPrivacyPassphrase(), octetString.getValue());
                        this.userModel.setTableDataItem(new OctetString(byArray2), n, 5);
                    }
                    this.userModel.setTableDataItem(octetString, n, 7);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, new String[]{"The selected user is already localized!", "To relocalize, delete the localization engine ID and", "reenter the (unlocalized) passphrases and then call ", "this function again."}, "Already Localized", 0);
        }
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        String string;
        this.userNameEditableRow = 0;
        int n = this._$4419(jCEditCellEvent.getRow());
        if (jCEditCellEvent.getColumn() == 2) {
            String string2 = (String)this.userModel.getTableDataItem(n, 2);
            if (string2 == null || string2.length() == 0) {
                this.userModel.setTableDataItem(new OctetString(), n, 3);
                this.userModel.setTableDataItem("", n, 4);
                this.userModel.setTableDataItem(new OctetString(), n, 5);
            }
        } else if (jCEditCellEvent.getColumn() == 4 && ((string = (String)this.userModel.getTableDataItem(n, 4)) == null || string.length() == 0)) {
            this.userModel.setTableDataItem(new OctetString(), n, 5);
        }
    }

    public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
        Object object = jCValidateEvent.getOldValue();
        Object object2 = jCValidateEvent.getValue();
        if (jCValidateEvent.getSource().equals(this.userNameEditor)) {
            if (object2 == null) {
                jCValidateEvent.setValid(false);
                return;
            }
            if (object != null && !object.equals(object2) || object == null && object2 != null) {
                String string = (String)object2;
                for (int i = 1; i < this.userModel.getNumRows(); ++i) {
                    if (!string.equals(this.userModel.getTableDataItem(i, 0))) continue;
                    jCValidateEvent.setValid(false);
                    return;
                }
            }
        }
    }

    public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
    }

    public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
    }

    private void _$6273(int n, int n2) {
        String string = "";
        _$6181[n2].setMode(n);
        switch (n) {
            case 16: {
                string = " [HEX]";
                break;
            }
            case 10: {
                string = " [DEC]";
            }
        }
        SortLabel sortLabel = (SortLabel)this.userModel.getTableColumnLabel(n2);
        sortLabel.setLabel(_$5516[n2] + string);
        this.userModel.fireColumnLabelChanged(n2);
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        OctetString octetString;
        int n = jCCellDisplayEvent.getColumn();
        int n2 = jCCellDisplayEvent.getRow();
        if (n2 < 0) {
            return;
        }
        if (n >= 0 && n < _$5516.length && _$6181[n] != null && _$6181[n].getMode() != 0 && (octetString = (OctetString)jCCellDisplayEvent.getCellData()) != null) {
            jCCellDisplayEvent.setDisplayData(octetString.toString(':', _$6181[n].getMode()));
        }
    }

    public synchronized void addUserConfigurationListener(UserConfigurationListener userConfigurationListener) {
        if (this.userConfigurationListeners == null) {
            this.userConfigurationListeners = new Vector(2);
        }
        this.userConfigurationListeners.add(userConfigurationListener);
    }

    public synchronized void removeUserConfigurationListener(UserConfigurationListener userConfigurationListener) {
        if (this.userConfigurationListeners != null) {
            this.userConfigurationListeners.remove(userConfigurationListener);
        }
    }

    protected void fireUserConfigChanged(UserConfigurationEvent userConfigurationEvent) {
        if (this.userConfigurationListeners != null) {
            Vector vector = this.userConfigurationListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((UserConfigurationListener)vector.elementAt(i)).userConfigChanged(userConfigurationEvent);
            }
        }
    }

    class FormatAction
    extends AbstractAction {
        public FormatAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = UserConfiguration.this.table.getPopupCellPosition();
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$5516.length) {
                if (actionEvent.getActionCommand().equals(UserConfiguration._$6177)) {
                    UserConfiguration.this._$6273(0, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(UserConfiguration._$6178)) {
                    UserConfiguration.this._$6273(16, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(UserConfiguration._$6179)) {
                    UserConfiguration.this._$6273(10, jCCellPosition.column);
                }
            }
        }
    }
}

