/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.SortLabel;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.RowMove;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.UserConfigurationEvent;
import com.agentpp.explorer.UserConfigurationListener;
import com.agentpp.explorer.editors.CheckboxIntegerCellEditor;
import com.agentpp.explorer.editors.CheckboxIntegerCellRenderer;
import com.agentpp.explorer.editors.cell.OctetStringCellEditor;
import com.agentpp.explorer.editors.cell.ValidatorValidationListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCIntegerCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTraverseCellEvent;
import com.klg.jclass.table.JCTraverseCellListener;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;

public class TargetConfiguration
extends JPanel
implements GenTargetListener,
ActionListener,
JCCellDisplayListener,
JCSelectListener,
JCTraverseCellListener,
JCEditCellListener,
JCValidateListener,
UserConfigurationListener {
    private static final int _$15014 = 1;
    private static final int _$15015 = 2;
    private static final int _$15016 = 3;
    private static final int _$15017 = 4;
    private static final int _$15018 = 5;
    private static final int _$15019 = 6;
    private static final int _$15020 = 8;
    private static final int _$15021 = 9;
    private static final int _$15022 = 7;
    private static final int _$15023 = 0;
    private static final int _$15024 = 10;
    private static final int _$15025 = 11;
    private static final int _$15026 = 12;
    private static final String[] _$5516 = new String[]{"Active", "Name", "Transport", "Address", "Version", "Timeout", "Retries", "MIB Set", "Community", "User", "Engine ID", "Context", "Context Engine ID"};
    private static OctetStringCellEditor[] _$6181 = new OctetStringCellEditor[_$5516.length];
    private static final int[] _$14753 = new int[]{20, 110, 60, 115, 50, 52, 48};
    private static final String[] _$15027 = new String[]{"SNMPv1", "SNMPv2c", "SNMPv3"};
    private static final int[] _$15028 = new int[]{0, 1, 3};
    private static final String[] _$15031 = new String[]{_$15027[0], _$15027[1], "SNMPv2p", _$15027[2]};
    private static final String[] _$15032 = new String[]{"UDP", "TCP", "TLS"};
    static final String ACTION_ADD = "Add Target";
    static final String ACTION_DELETE = "Delete Target";
    static final String ACTION_EDIT = "Edit Name";
    static final String ACTION_DUPLICATE = "Duplicate Target";
    static final String ACTION_TEST = "Test Connectivity";
    static final String ACTION_MOVE_UP = "Move up";
    static final String ACTION_MOVE_DOWN = "Move down";
    static final String ACTION_SET = "Set Active";
    static final String ACTION_ENGINEID = "Discover Engine ID";
    static final String ACTION_USERS = "Edit Users...";
    static final String ACTION_ASCII = "Default";
    static final String ACTION_HEX = "Hexadecimal";
    static final String ACTION_DEC = "Decimal";
    BorderLayout borderLayout1 = new BorderLayout();
    int targetNameEditRow = 0;
    JMenu editMenu = new JMenu("Format");
    PopupListTable table = new PopupListTable(){

        public boolean isEditable(int n, int n2) {
            if (n2 < 8) {
                return n2 != 1 || n == TargetConfiguration.this.targetNameEditRow;
            }
            if (super.getDataView().getTableDataItem(n, 4) instanceof Number) {
                if (n2 == 8 && ((Number)super.getDataView().getTableDataItem(n, 4)).intValue() < 3) {
                    return true;
                }
                if (n2 > 8 && ((Number)super.getDataView().getTableDataItem(n, 4)).intValue() == 3) {
                    return true;
                }
            }
            return false;
        }

        public boolean isPopupAllowed(int n, int n2) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            JCCellPosition jCCellPosition = TargetConfiguration.this.table.XYToCell(n, n2);
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$5516.length && _$6181[jCCellPosition.column] != null) {
                TargetConfiguration.this.editMenu.setEnabled(true);
            } else {
                TargetConfiguration.this.editMenu.setEnabled(false);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            int n = TableUtils.getDataRows(TargetConfiguration.this.table, new int[]{jCCellPosition.row})[0];
            Object object = TargetConfiguration.this._$15043.getTableDataItem(n, jCCellPosition.column);
            if (object != null) {
                switch (jCCellPosition.column) {
                    case 0: {
                        if ((Integer)object == 0) {
                            return "Active Target";
                        }
                        return "Inactive Target";
                    }
                }
                return object.toString();
            }
            return null;
        }
    };
    private UserConfigFile _$4288;
    private Hashtable _$4957 = new Hashtable();
    private Hashtable _$5979 = new Hashtable();
    private JCEditableVectorDataSource _$15043;
    private CheckboxIntegerCellEditor _$15044 = new CheckboxIntegerCellEditor();
    private JCComboBoxCellEditor _$15045 = new JCComboBoxCellEditor();
    private JCComboBoxCellEditor _$15046 = new JCComboBoxCellEditor(_$15027, _$15028);
    private JCComboBoxCellEditor _$15047 = new JCComboBoxCellEditor(_$15032);
    private JCStringCellEditor _$15048 = new JCStringCellEditor();
    private JCStringCellEditor _$15049 = new JCStringCellEditor();
    private JCStringValidator _$15050 = new JCStringValidator(){

        public boolean validate(Object object) {
            boolean bl = super.validate(object);
            if (bl) {
                if (object == null) {
                    return false;
                }
                String string = (String)object;
                if (string.indexOf(47) >= 0 && string.indexOf(47) < 3 || string.indexOf(47) != string.lastIndexOf(47)) {
                    return false;
                }
            }
            return bl;
        }
    };
    private JCIntegerCellEditor _$15051 = new JCIntegerCellEditor();
    private JCIntegerValidator _$15052 = new JCIntegerValidator();
    private JCIntegerCellEditor _$15053 = new JCIntegerCellEditor();
    private JCIntegerValidator _$15054 = new JCIntegerValidator();
    private String[] _$5448 = new String[0];
    private JCComboBoxCellEditor _$15055 = new JCComboBoxCellEditor();
    JPanel jPanelButtons = new JPanel();
    private TableSorter _$6193;
    private Snmp _$4261;

    public TargetConfiguration(UserConfigFile userConfigFile, Snmp snmp) {
        this._$4288 = userConfigFile;
        this._$4261 = snmp;
        this._$15043 = new JCEditableVectorDataSource();
        this._$15043.setNumColumns(_$5516.length);
        this._$15043.setNumRows(0);
        this._$15043.addRow(Integer.MAX_VALUE, null, this._$15056(new GenTarget("", new UdpAddress())));
        this._$15043.setColumnLabels(_$5516);
        try {
            this._$4361();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$15050.setInvalidChars("<>|\u00b0^!\"\u00a7$%&/()=?\\`\u00b4'#+~*;:,");
        this._$15052.setMin(1);
        this._$15052.setMax(99999);
        this._$15054.setMin(0);
        this._$15054.setMax(99);
        this._$15051.addValidateListener(new ValidatorValidationListener(this._$15052));
        this._$15053.addValidateListener(new ValidatorValidationListener(this._$15054));
        TablePopupMenu tablePopupMenu = this.table.getPopupMenu();
        tablePopupMenu.addItem(ACTION_SET, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_ADD, this);
        tablePopupMenu.addItem(ACTION_DUPLICATE, this);
        tablePopupMenu.addItem(ACTION_EDIT, this);
        tablePopupMenu.addItem(ACTION_DELETE, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_MOVE_UP, this);
        tablePopupMenu.addItem(ACTION_MOVE_DOWN, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_TEST, this);
        tablePopupMenu.addItem(ACTION_ENGINEID, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.editMenu);
        JMenuItem jMenuItem = this.editMenu.add(new FormatAction(ACTION_ASCII));
        jMenuItem.setMnemonic('F');
        jMenuItem = this.editMenu.add(new FormatAction(ACTION_HEX));
        jMenuItem.setMnemonic('H');
        jMenuItem = this.editMenu.add(new FormatAction(ACTION_DEC));
        jMenuItem.setMnemonic('D');
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.addCellDisplayListener(this);
        this.table.addTraverseCellListener(this);
        this.table.addEditCellListener(this);
        this._$6193 = new TableSorter((JCTable)this.table, (JCVectorDataSource)this._$15043, true);
        this._$6193.addSortColumn(1);
        for (int i = 0; i < _$14753.length; ++i) {
            this.table.setPixelWidth(i, _$14753[i]);
        }
        this._$4634();
        this.setPreferredSize(new Dimension(900, 400));
        this.table.setFocusIndicator(4);
        ToolTipManager.sharedInstance().registerComponent(this.table);
    }

    private int _$4419(int n) {
        int n2 = n;
        if (this.table.getDataView() instanceof SortableDataViewModel) {
            n2 = ((SortableDataViewModel)this.table.getDataView()).getViewRow(n2);
        }
        return n2;
    }

    private void _$4634() {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15045);
        this.table.setCellStyle(-997, 9, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15046);
        this.table.setCellStyle(-997, 4, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15047);
        this.table.setCellStyle(-997, 2, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15055);
        this.table.setCellStyle(-997, 7, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$15048.removeValidateListener(this);
        this._$15048.addValidateListener(this);
        jCCellStyle.setCellEditor(this._$15048);
        this.table.setCellStyle(-997, 1, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$15049.removeValidateListener(this);
        this._$15049.addValidateListener(new ValidatorValidationListener(this._$15050));
        jCCellStyle.setCellEditor(this._$15049);
        this.table.setCellStyle(-997, 3, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15051);
        this.table.setCellStyle(-997, 5, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15053);
        this.table.setCellStyle(-997, 6, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15044);
        jCCellStyle.setCellRenderer(new CheckboxIntegerCellRenderer());
        this.table.setCellStyle(-997, 0, jCCellStyle);
        this._$6237(8);
        this._$6237(10);
        this._$6237(12);
        this._$6237(11);
        this._$6273(16, 10);
        this._$6273(16, 12);
        this.table.setSelectedBackground(Color.lightGray);
        this.table.setSelectedForeground(Color.black);
    }

    private void _$6237(int n) {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        TargetConfiguration._$6181[n] = new OctetStringCellEditor();
        jCCellStyle.setCellEditor(_$6181[n]);
        this.table.setCellStyle(-997, n, jCCellStyle);
    }

    public TargetConfiguration() {
        this(null, null);
    }

    private void _$4361() throws Exception {
        this.table.setDataSource(this._$15043);
        this.table.setFrozenRows(1);
        this.setLayout(this.borderLayout1);
        this.table.setRowLabelDisplay(false);
        this.add((Component)this.table, "Center");
        this.add((Component)this.jPanelButtons, "South");
        this.table.setPopupMenuEnabled(true);
    }

    public void setMibSets(Vector vector) {
        Vector<String> vector2 = new Vector<String>(vector);
        vector2.add(0, "");
        this._$5448 = vector2.toArray(new String[vector2.size()]);
        this._$15055.setModel(new DefaultComboBoxModel<String>(this._$5448));
    }

    public static Hashtable loadAllTargets(UserConfigFile userConfigFile) {
        String string;
        Hashtable<String, GenTarget> hashtable = new Hashtable<String, GenTarget>();
        int n = 0;
        GenTarget genTarget = null;
        while ((string = userConfigFile.get("mibexplorer.Target" + n++, null)) != null && string.length() > 0) {
            genTarget = TargetConfiguration.loadTarget(userConfigFile, string);
            hashtable.put(string, genTarget);
        }
        return hashtable;
    }

    private Vector _$15056(GenTarget genTarget) {
        Vector<Object> vector = new Vector<Object>(_$5516.length);
        vector.add(new Integer(1));
        vector.add(genTarget.getName());
        vector.add(genTarget.getAddressType());
        vector.add(genTarget.getAddressString());
        vector.add(new Integer(genTarget.getVersion()));
        vector.add(new Integer(genTarget.getTimeout()));
        vector.add(new Integer(genTarget.getRetries()));
        vector.add(genTarget.getMIBSet());
        vector.add(genTarget.getCommunity());
        vector.add(genTarget.getUser());
        vector.add(genTarget.getEngineID());
        vector.add(genTarget.getContext());
        vector.add(genTarget.getContextEngineID());
        return vector;
    }

    public boolean save() {
        this.table.commitEdit(true);
        this._$15070();
        List list = this._$15072();
        if (list.size() > 0) {
            JOptionPane.showMessageDialog(this, new String[]{"The following SNMPv3 targets do not have an USM user defined:", "" + list, "Please assign an user for each target before saving the configuration!"}, "SNMPv3 Targets without USM User", 0);
            return false;
        }
        List list2 = this._$15074();
        if (list2 != null && list2.size() > 0 && JOptionPane.showConfirmDialog(this, new String[]{"The following user profiles have ambigous security names: ", "" + list2 + ". ", "For correct authentication and encryption, it is highly recommended", "that two user profiles with the same security name have different", "localization engine IDs and at most one of them is not localized.", "Otherwise, it is not defined which user credentials are used.", "Do you want to save the target and user configuration anyway?"}, "Ambigous Security Names", 0, 2) == 1) {
            return false;
        }
        this._$15075();
        this._$15076();
        return true;
    }

    private List _$15072() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Vector vector = this.getUserNames();
        for (int i = 0; i < this._$15043.getNumRows(); ++i) {
            UserProfile userProfile;
            Integer n = (Integer)this._$15043.getTableDataItem(i, 4);
            if (n == null || n != 3 || (userProfile = (UserProfile)this._$15043.getTableDataItem(i, 9)) != null && vector.contains(userProfile.getName())) continue;
            linkedList.add(this._$15043.getTableDataItem(i, 1));
        }
        return linkedList;
    }

    private List _$15074() {
        HashSet<UserProfile> hashSet = new HashSet<UserProfile>();
        HashMap<UsmUserTable.UsmUserKey, UserProfile> hashMap = new HashMap<UsmUserTable.UsmUserKey, UserProfile>();
        Object object = this._$5979.elements();
        while (object.hasMoreElements()) {
            UserProfile userProfile = (UserProfile)object.nextElement();
            OctetString octetString = userProfile.getUser().getLocalizationEngineID();
            UsmUserTable.UsmUserKey usmUserKey = new UsmUserTable.UsmUserKey(octetString, userProfile.getUser().getSecurityName());
            UserProfile userProfile2 = (UserProfile)hashMap.get(usmUserKey);
            if (userProfile2 != null) {
                hashSet.add(userProfile);
                hashSet.add(userProfile2);
            }
            hashMap.put(usmUserKey, userProfile);
        }
        object = new ArrayList(hashSet);
        Collections.sort(object);
        return object;
    }

    public void load() {
        this._$15082();
        this._$15064();
    }

    private void _$15082() {
        String string;
        this._$5979 = new Hashtable();
        this._$15045.removeAllItems();
        int n = 0;
        UserProfile userProfile = null;
        while ((string = this._$4288.get("mibexplorer.USMUser" + n++, null)) != null && string.length() > 0) {
            userProfile = TargetConfiguration._$15083(this._$4288, string);
            this._$5979.put(string, userProfile);
        }
        this._$15084();
    }

    private void _$15084() {
        this._$15045.removeAllItems();
        this._$15045.addItem(null);
        Vector vector = this.getUserNames();
        Collections.sort(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this._$15045.addItem(this._$5979.get(enumeration.nextElement()));
        }
    }

    private synchronized void _$15085(int n) {
        if (this._$15043.getNumRows() <= 2) {
            return;
        }
        for (int i = 0; i < this._$15043.getNumRows(); ++i) {
            this._$15043.setTableDataItem(new Integer(i == n ? 0 : 1), i, 0);
        }
        this._$6193.sort();
    }

    private void _$15064() {
        String string;
        this._$4957 = new Hashtable();
        this._$15043.setNumRows(1);
        int n = 0;
        GenTarget genTarget = null;
        String string2 = this._$4288.get("mibexplorer.ActiveTarget", null);
        while ((string = this._$4288.get("mibexplorer.Target" + n++, null)) != null && string.length() > 0) {
            genTarget = this.loadTarget(string);
            this._$4957.put(string, genTarget);
            this._$15043.addRow(Integer.MAX_VALUE, genTarget, this._$15056(genTarget));
        }
        GenTarget genTarget2 = null;
        if (string2 != null) {
            genTarget2 = (GenTarget)this._$4957.get(string2);
        }
        if (genTarget2 != null) {
            this.setSelectedTarget(genTarget2);
        }
    }

    public Object[] getTargetIdentifiers() {
        Object[] objectArray = this._$4957.values().toArray();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static Address _$5426(UserConfigFile userConfigFile, String string) {
        String string2 = userConfigFile.get("mibexplorer.Address_" + string, "127.0.0.1/161");
        String string3 = userConfigFile.get("mibexplorer.TargetTransport_" + string, "udp");
        return GenericAddress.parse(string3 + ":" + string2);
    }

    private Address _$5426(String string) {
        return TargetConfiguration._$5426(this._$4288, string);
    }

    public static GenTarget loadTarget(UserConfigFile userConfigFile, String string) {
        int n = TargetConfiguration._$15090(userConfigFile, string);
        String string2 = userConfigFile.get("mibexplorer.Address_" + string, "127.0.0.1/161");
        String string3 = userConfigFile.get("mibexplorer.TargetTransport_" + string, "udp");
        GenTarget genTarget = new GenTarget(string, string3, string2);
        if (n < 3) {
            genTarget.setCommunity(new OctetString(TargetConfiguration._$15067(userConfigFile, string)));
        } else {
            genTarget.setUser(TargetConfiguration.getUser(userConfigFile, string));
        }
        genTarget.setAddressType(userConfigFile.get("mibexplorer.TargetTransport_" + string, "UDP"));
        genTarget.setAddressString(userConfigFile.get("mibexplorer.Address_" + string, "127.0.0.1/161"));
        genTarget.setVersion(n);
        genTarget.setTimeout(TargetConfiguration._$5865(userConfigFile, string));
        genTarget.setRetries(TargetConfiguration._$5866(userConfigFile, string));
        String string4 = userConfigFile.get("mibexplorer.USMContext_" + string, "");
        String string5 = userConfigFile.get("mibexplorer.USMContextEngineID_" + string, null);
        String string6 = userConfigFile.get("mibexplorer.TargetEngineID_" + string, null);
        genTarget.setContext(OctetString.fromHexString(string4));
        if (string5 != null && string5.length() > 0) {
            genTarget.setContextEngineID(OctetString.fromHexString(string5));
        } else {
            genTarget.setContextEngineID(new OctetString());
        }
        if (string6 != null && string6.length() > 0) {
            genTarget.setEngineID(OctetString.fromHexString(string6));
        } else {
            genTarget.setEngineID(new OctetString());
        }
        genTarget.setMIBSet(userConfigFile.get("mibexplorer.TargetMIBSet_" + string, null));
        return genTarget;
    }

    public boolean isTarget(String string) {
        return this._$4957.get(string) != null;
    }

    private static OctetString _$15101(String string) {
        OctetString octetString = OctetString.fromHexString(string);
        while (octetString.length() < 8 && octetString.length() > 0) {
            octetString.append(octetString);
        }
        return octetString;
    }

    private void _$15103(UserProfile userProfile) {
        this._$4288.remove("mibexplorer.USMSecurityName_" + userProfile.getName());
        this._$4288.remove("mibexplorer.USMAuthProtocol_" + userProfile.getName());
        this._$4288.remove("mibexplorer.USMAuthPassphrase_" + userProfile.getName());
        this._$4288.remove("mibexplorer.USMPrivProtocol_" + userProfile.getName());
        this._$4288.remove("mibexplorer.USMPrivPassphrase_" + userProfile.getName());
    }

    private void _$15104(String string) {
        this._$4288.remove("mibexplorer.Community_" + string);
        this._$4288.remove("mibexplorer.SNMP_" + string);
        this._$4288.remove("mibexplorer.Retries_" + string);
        this._$4288.remove("mibexplorer.Timeout_" + string);
        this._$4288.remove("mibexplorer.TargetMIBSet_" + string);
        this._$4288.remove("mibexplorer.USMContextEngineID_" + string);
        this._$4288.remove("mibexplorer.USMContext_" + string);
        this._$4288.remove("mibexplorer.TargetEngineID_" + string);
        this._$4957.remove(string);
    }

    public UserProfile getUser(String string) {
        return TargetConfiguration.getUser(this._$4288, string);
    }

    public static UserProfile getUser(UserConfigFile userConfigFile, String string) {
        try {
            String string2 = userConfigFile.get("mibexplorer.USMActive_" + string, null);
            return TargetConfiguration._$15083(userConfigFile, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isUser(String string) {
        return this._$5979.containsKey(string);
    }

    public Hashtable getUsers() {
        return this._$5979;
    }

    public void setUsers(Hashtable hashtable) {
        this._$5979 = hashtable;
        this._$15084();
        for (int i = 1; i < this._$15043.getNumRows(); ++i) {
            UserProfile userProfile = (UserProfile)this._$15043.getTableDataItem(i, 9);
            if (userProfile == null || this._$5979.get(userProfile.getName()) != null) continue;
            this._$15043.setTableDataItem(null, i, 9);
        }
    }

    public Vector getUserNames() {
        Vector<String> vector = new Vector<String>(this._$5979.size() + 1);
        int n = 0;
        Enumeration enumeration = this._$5979.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(((UserProfile)enumeration.nextElement()).getName());
            ++n;
        }
        return vector;
    }

    public GenTarget getTarget(String string) {
        return (GenTarget)this._$4957.get(string);
    }

    public Vector getTargetsForUser(String string) {
        Vector<GenTarget> vector = new Vector<GenTarget>();
        Enumeration enumeration = this._$4957.elements();
        while (enumeration.hasMoreElements()) {
            GenTarget genTarget = (GenTarget)enumeration.nextElement();
            if (genTarget.getUser() == null || !genTarget.getUser().getName().equals(string)) continue;
            vector.addElement(genTarget);
        }
        return vector;
    }

    public GenTarget loadTarget(String string) {
        UserProfile userProfile;
        GenTarget genTarget = TargetConfiguration.loadTarget(this._$4288, string);
        if (genTarget.getUser() != null && (userProfile = (UserProfile)this._$5979.get(genTarget.getUser().getName())) != null) {
            genTarget.setUser(userProfile);
        }
        return genTarget;
    }

    public Target getTarget() {
        String string = this._$4288.get("mibexplorer.ActiveTarget", null);
        if (string == null) {
            return null;
        }
        GenTarget genTarget = this.loadTarget(string);
        if (genTarget != null) {
            return genTarget.getTarget();
        }
        return null;
    }

    public String getSelectedUserName() {
        int n = TableUtils.getFirstSelectedRow(this.table);
        UserProfile userProfile = (UserProfile)this._$15043.getTableDataItem(n, 9);
        if (userProfile == null) {
            return null;
        }
        return userProfile.getName();
    }

    private static OctetString _$15067(UserConfigFile userConfigFile, String string) {
        String string2 = userConfigFile.get("mibexplorer.Community_" + string, new OctetString("public").toHexString());
        return OctetString.fromHexString(string2);
    }

    private static int _$5866(UserConfigFile userConfigFile, String string) {
        return Integer.valueOf(userConfigFile.get("mibexplorer.Retries_" + string, "3"));
    }

    private static int _$5865(UserConfigFile userConfigFile, String string) {
        return Integer.valueOf(userConfigFile.get("mibexplorer.Timeout_" + string, "20"));
    }

    private static int _$15090(UserConfigFile userConfigFile, String string) {
        return Integer.parseInt(userConfigFile.get("mibexplorer.SNMP_" + string, "2"));
    }

    private static UserProfile _$15083(UserConfigFile userConfigFile, String string) {
        try {
            String string2 = userConfigFile.get("mibexplorer.USMSecurityName_" + string, "");
            String string3 = userConfigFile.get("mibexplorer.USMAuthProtocol_" + string, null);
            String string4 = userConfigFile.get("mibexplorer.USMPrivProtocol_" + string, null);
            OID oID = string3 == null ? null : new OID(string3);
            OID oID2 = string4 == null ? null : new OID(string4);
            OctetString octetString = TargetConfiguration._$15101(userConfigFile.get("mibexplorer.USMAuthPassphrase_" + string, ""));
            OctetString octetString2 = TargetConfiguration._$15101(userConfigFile.get("mibexplorer.USMPrivPassphrase_" + string, ""));
            boolean bl = userConfigFile.getBoolean("mibexplorer.USMPrincipal_" + string, false);
            OctetString octetString3 = null;
            String string5 = userConfigFile.get("mibexplorer.USMLocalizationID_" + string, null);
            if (string5 != null && string5.length() > 0) {
                try {
                    octetString3 = OctetString.fromHexString(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            UserProfile userProfile = new UserProfile(string, new UsmUser(OctetString.fromHexString(string2), octetString.length() == 0 ? null : oID, octetString, octetString2.length() == 0 ? null : oID2, octetString2, octetString3));
            userProfile.setPrincipal(bl);
            return userProfile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public GenTarget getActiveTarget() {
        if (this._$15043.getNumRows() > 1) {
            for (int i = 1; i < this.table.getNumRows(); ++i) {
                GenTarget genTarget = (GenTarget)this._$15043.getTableRowLabel(i);
                Integer n = (Integer)this._$15043.getTableDataItem(i, 0);
                if (n == null || n != 0) continue;
                this._$15113(i, genTarget);
                return genTarget;
            }
            GenTarget genTarget = (GenTarget)this._$15043.getTableRowLabel(1);
            this._$15113(1, genTarget);
            return genTarget;
        }
        return null;
    }

    public Hashtable getTargets() {
        return this._$4957;
    }

    public void saveTarget(GenTarget genTarget, boolean bl) {
        String string = genTarget.getName();
        this._$4288.put("mibexplorer.Address_" + string, genTarget.getAddressString());
        this._$4288.put("mibexplorer.TargetTransport_" + string, genTarget.getAddressType());
        this._$4288.put("mibexplorer.Retries_" + string, "" + genTarget.getRetries());
        this._$4288.put("mibexplorer.Timeout_" + string, "" + genTarget.getTimeout());
        this._$4288.put("mibexplorer.SNMP_" + string, "" + genTarget.getVersion());
        this._$4288.put("mibexplorer.Community_" + string, genTarget.getCommunity() == null ? null : genTarget.getCommunity().toHexString());
        this._$4288.put("mibexplorer.TargetMIBSet_" + string, genTarget.getMIBSet());
        if (genTarget.getUser() != null) {
            this._$4288.put("mibexplorer.USMActive_" + string, genTarget.getUser().getName());
        }
        this._$4288.put("mibexplorer.USMContext_" + string, genTarget.getContext() == null ? null : genTarget.getContext().toHexString());
        if (genTarget.getContextEngineID() != null) {
            this._$4288.put("mibexplorer.USMContextEngineID_" + string, new OctetString(genTarget.getContextEngineID()).toHexString());
        } else {
            this._$4288.put("mibexplorer.USMContextEngineID_" + string, null);
        }
        if (genTarget.getEngineID() != null) {
            this._$4288.put("mibexplorer.TargetEngineID_" + string, new OctetString(genTarget.getEngineID()).toHexString());
        } else {
            this._$4288.put("mibexplorer.TargetEngineID_" + string, null);
        }
        if (bl) {
            this.saveUser(genTarget.getUser());
        }
    }

    private void _$15070() {
        for (int i = 1; i < this._$15043.getNumRows(); ++i) {
            GenTarget genTarget = (GenTarget)this._$15043.getTableRowLabel(i);
            this._$4957.remove(genTarget.getName());
            this._$15113(i, genTarget);
        }
    }

    private void _$15113(int n, GenTarget genTarget) {
        genTarget.setAddress(null);
        genTarget.setName((String)this._$15043.getTableDataItem(n, 1));
        genTarget.setAddressType((String)this._$15043.getTableDataItem(n, 2));
        genTarget.setAddressString((String)this._$15043.getTableDataItem(n, 3));
        genTarget.setVersion(((Number)this._$15043.getTableDataItem(n, 4)).intValue());
        genTarget.setTimeout(((Number)this._$15043.getTableDataItem(n, 5)).intValue());
        genTarget.setRetries(((Number)this._$15043.getTableDataItem(n, 6)).intValue());
        genTarget.setCommunity((OctetString)this._$15043.getTableDataItem(n, 8));
        genTarget.setContext((OctetString)this._$15043.getTableDataItem(n, 11));
        genTarget.setEngineID((OctetString)this._$15043.getTableDataItem(n, 10));
        genTarget.setContextEngineID((OctetString)this._$15043.getTableDataItem(n, 12));
        genTarget.setMIBSet((String)this._$15043.getTableDataItem(n, 7));
        UserProfile userProfile = (UserProfile)this._$15043.getTableDataItem(n, 9);
        genTarget.setUser(userProfile);
        this._$4957.put(genTarget.getName(), genTarget);
    }

    private void _$15076() {
        int n = 0;
        Object object = this._$4957.elements();
        while (object.hasMoreElements()) {
            GenTarget genTarget = (GenTarget)object.nextElement();
            this.saveTarget(genTarget, true);
            this._$4288.put("mibexplorer.Target" + n++, genTarget.getName());
        }
        this._$4288.put("mibexplorer.Target" + n++, "");
        object = this.getActiveTarget();
        if (object != null) {
            this._$4288.put("mibexplorer.ActiveTarget", ((GenTarget)object).getName());
        } else {
            this._$4288.remove("mibexplorer.ActiveTarget");
        }
    }

    public void removeUser(String string) {
        this._$5979.remove(string);
        this._$4288.remove("mibexplorer.USMSecurityName_" + string);
        this._$4288.remove("mibexplorer.USMAuthProtocol_" + string);
        this._$4288.remove("mibexplorer.USMAuthPassphrase_" + string);
        this._$4288.remove("mibexplorer.USMPrivProtocol_" + string);
        this._$4288.remove("mibexplorer.USMPrivPassphrase_" + string);
        this._$4288.remove("mibexplorer.USMPrincipal_" + string);
        this._$15114();
    }

    public void saveUser(UserProfile userProfile) {
        if (userProfile == null) {
            return;
        }
        this._$4288.put("mibexplorer.USMSecurityName_" + userProfile.getName(), userProfile.getUser().getSecurityName().toHexString());
        if (userProfile.getUser().getAuthenticationProtocol() == null) {
            this._$4288.put("mibexplorer.USMAuthProtocol_" + userProfile.getName(), "");
        } else {
            this._$4288.put("mibexplorer.USMAuthProtocol_" + userProfile.getName(), userProfile.getUser().getAuthenticationProtocol().toString());
        }
        this._$4288.put("mibexplorer.USMAuthPassphrase_" + userProfile.getName(), userProfile.getUser().getAuthenticationPassphrase().toHexString());
        if (userProfile.getUser().getPrivacyProtocol() == null) {
            this._$4288.put("mibexplorer.USMPrivProtocol_" + userProfile.getName(), "");
        } else {
            this._$4288.put("mibexplorer.USMPrivProtocol_" + userProfile.getName(), userProfile.getUser().getPrivacyProtocol().toString());
        }
        this._$4288.put("mibexplorer.USMPrivPassphrase_" + userProfile.getName(), userProfile.getUser().getPrivacyPassphrase().toHexString());
        this._$4288.putBoolean("mibexplorer.USMPrincipal_" + userProfile.getName(), userProfile.isPrincipal());
        if (userProfile.getUser().getLocalizationEngineID() == null) {
            this._$4288.put("mibexplorer.USMLocalizationID_" + userProfile.getName(), "");
        } else {
            this._$4288.put("mibexplorer.USMLocalizationID_" + userProfile.getName(), userProfile.getUser().getLocalizationEngineID().toHexString());
        }
    }

    private void _$15114() {
        ArrayList arrayList = new ArrayList(this._$5979.size() + 1);
        Iterator iterator = this._$5979.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this._$4288.putArray("mibexplorer.USMUser", arrayList);
    }

    private void _$15075() {
        Vector<String> vector = new Vector<String>(this._$5979.size() + 1);
        Enumeration enumeration = this._$5979.elements();
        while (enumeration.hasMoreElements()) {
            UserProfile userProfile = (UserProfile)enumeration.nextElement();
            this.saveUser(userProfile);
            vector.add(userProfile.getName());
        }
        this._$15114();
    }

    public void setSelectedTarget(GenTarget genTarget) {
        for (int i = 1; i < this._$15043.getNumRows(); ++i) {
            if (!genTarget.getName().equals(((GenTarget)this._$15043.getTableRowLabel(i)).getName())) continue;
            this._$15085(i);
        }
    }

    public GenTarget getCurrentTarget(String string) {
        GenTarget genTarget = null;
        if (string == null) {
            genTarget = this.getActiveTarget();
        }
        if (string != null) {
            genTarget = (GenTarget)this._$4957.get(string);
        }
        if (genTarget == null) {
            genTarget = new GenTarget(this._$6222(ACTION_ASCII), new UdpAddress("127.0.0.1/161"));
            genTarget.setAddressString("127.0.0.1/161");
            genTarget.setAddressType("UDP");
            genTarget.setVersion(0);
            genTarget.setCommunity(new OctetString("public"));
        }
        return genTarget;
    }

    private String _$6222(String string) {
        int n = 1;
        String string2 = string;
        for (int i = 1; i < this._$15043.getNumRows(); ++i) {
            if (!((GenTarget)this._$15043.getTableRowLabel(i)).getName().equals(string2)) continue;
            string2 = string + " " + n++;
            i = 0;
        }
        return string2;
    }

    public void addTarget(GenTarget genTarget) {
        Object object;
        if (this._$4957.containsKey(genTarget.getName())) {
            object = this._$6222(genTarget.getName());
            genTarget.setName((String)object);
        }
        object = this._$15056(genTarget);
        this._$15043.addRow(Integer.MAX_VALUE, genTarget, (Vector)object);
        this.saveTarget(genTarget, false);
        this._$4288.put("mibexplorer.Target" + this._$4957.size(), genTarget.getName());
        this._$4957.put(genTarget.getName(), genTarget);
    }

    public void targetChanged(GenTargetEvent genTargetEvent) {
    }

    public void addUser(UserProfile userProfile) {
        this._$5979.put(userProfile.getName(), userProfile);
        this.saveUser(userProfile);
        this._$15114();
    }

    public void updateUser(UserProfile userProfile) {
        this._$5979.put(userProfile.getName(), userProfile);
        for (int i = 0; i < this._$15043.getNumRows(); ++i) {
            UserProfile userProfile2 = (UserProfile)this._$15043.getTableDataItem(i, 9);
            if (userProfile2 == null || !userProfile2.getName().equals(userProfile.getName())) continue;
            this._$15043.setTableDataItem(userProfile, i, 9);
        }
        this.saveUser(userProfile);
        this._$15114();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ACTION_ADD)) {
            GenTarget genTarget = new GenTarget(this._$6222("New Target"), new UdpAddress("127.0.0.1/161"));
            genTarget.setAddressString("127.0.0.1/161");
            genTarget.setAddressType("UDP");
            genTarget.setVersion(1);
            genTarget.setCommunity(new OctetString("public"));
            genTarget.setRetries(1);
            genTarget.setTimeout(1000);
            this._$15043.addRow(Integer.MAX_VALUE, genTarget, this._$15056(genTarget));
            if (!this.table.beginEdit(this._$15043.getNumRows() - 1, 1)) return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_MOVE_UP)) {
            int n;
            Collection collection = this.table.getSelectedCells();
            if (collection == null || collection.size() == 0) {
                return;
            }
            JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
            collection.toArray(jCCellRangeArray);
            for (n = 0; n < jCCellRangeArray.length; ++n) {
                TableUtils.setRangeAfterCopy(jCCellRangeArray[n]);
            }
            for (n = 0; n < jCCellRangeArray.length; ++n) {
                if (jCCellRangeArray[n].start_row <= 1) continue;
                new RowMove(this.table, this._$15043, jCCellRangeArray[n].start_row, jCCellRangeArray[n].end_row - jCCellRangeArray[n].start_row + 1, -1);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_MOVE_DOWN)) {
            int n;
            Collection collection = this.table.getSelectedCells();
            if (collection == null || collection.size() == 0) {
                return;
            }
            JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
            collection.toArray(jCCellRangeArray);
            for (n = 0; n < jCCellRangeArray.length; ++n) {
                TableUtils.setRangeAfterCopy(jCCellRangeArray[n]);
            }
            for (n = 0; n < jCCellRangeArray.length; ++n) {
                if (jCCellRangeArray[n].end_row == this._$15043.getNumRows() - 1) continue;
                new RowMove(this.table, this._$15043, jCCellRangeArray[n].start_row, jCCellRangeArray[n].end_row - jCCellRangeArray[n].start_row + 1, 1);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_DUPLICATE)) {
            int[] nArray = TableUtils.getSelectedRows(this.table);
            if (nArray.length == 0) {
                return;
            }
            Arrays.sort(nArray);
            String string = (String)this._$15043.getTableDataItem(nArray[0], 1);
            GenTarget genTarget = this.getCurrentTarget(string);
            GenTarget genTarget2 = new GenTarget(this._$6222(string), genTarget.getAddress());
            genTarget2.setAddressString(genTarget.getAddressString());
            genTarget2.setAddressType(genTarget.getAddressType());
            genTarget2.setVersion(genTarget.getVersion());
            genTarget2.setCommunity(genTarget.getCommunity());
            genTarget2.setRetries(genTarget.getRetries());
            genTarget2.setTimeout(genTarget.getTimeout());
            genTarget2.setUser(genTarget.getUser());
            genTarget2.setContext(genTarget.getContext());
            genTarget2.setContextEngineID(genTarget.getContextEngineID());
            genTarget2.setEngineID(genTarget.getEngineID());
            this._$15043.addRow(Integer.MAX_VALUE, genTarget2, this._$15056(genTarget2));
            if (!this.table.beginEdit(this._$15043.getNumRows() - 1, 1)) return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_DELETE)) {
            int[] nArray = TableUtils.getSelectedRows(this.table);
            Arrays.sort(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                String string = (String)this._$15043.getTableDataItem(nArray[i] - i, 1);
                this._$15104(string);
                this._$15043.deleteRows(nArray[i] - i, 1);
            }
            this.table.clearSelection();
            this._$6193.sort();
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_SET)) {
            if (this._$15043.getNumRows() <= 2) return;
            this._$15085(TableUtils.getFirstMarkedRow(this.table));
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_ENGINEID)) {
            int n = TableUtils.getFirstMarkedRow(this.table);
            if (n < 0) return;
            this._$15119(n);
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_EDIT)) {
            int n = TableUtils.getFirstMarkedRow(this.table);
            if (n < 0) return;
            if (this.table.getDataView() instanceof SortableDataViewModel) {
                n = ((SortableDataViewModel)this.table.getDataView()).getViewRow(n);
            }
            this.targetNameEditRow = n;
            this.table.beginEdit(n, 1);
            return;
        }
        if (!actionEvent.getActionCommand().equals(ACTION_TEST)) return;
        int[] nArray = TableUtils.getSelectedRows(this.table);
        if (nArray.length == 0) {
            return;
        }
        Arrays.sort(nArray);
        String string = (String)this._$15043.getTableDataItem(nArray[0], 1);
        GenTarget genTarget = this.getCurrentTarget(string);
        if (genTarget == null) return;
        PDU pDU = genTarget.makePDU();
        pDU.add(new VariableBinding(new OID("1.3.6.1")));
        ResponseEvent responseEvent = null;
        try {
            responseEvent = this._$4261.getNext(pDU, genTarget.getTarget());
            if (responseEvent != null && responseEvent.getResponse() != null) {
                if (responseEvent.getResponse().getErrorStatus() == 0) {
                    JOptionPane.showMessageDialog(this, "Test success! Agent returned:\n" + responseEvent.getResponse().getVariableBindings().toString(), "Target Validated", 1);
                    return;
                } else {
                    JOptionPane.showMessageDialog(this, "Test failure! Agent unexpected error:\n" + responseEvent.getResponse().getErrorStatusText(), "Non-SNMP Compliant Target Detected", 1);
                }
                return;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Invalid target. Test result:\n" + iOException.getMessage(), "Target Invalid", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "Test request timed out.", "Time Out", 2);
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        OctetString octetString;
        int n = jCCellDisplayEvent.getColumn();
        int n2 = jCCellDisplayEvent.getRow();
        if (n2 < 0) {
            return;
        }
        switch (n) {
            case 4: {
                if (!(jCCellDisplayEvent.getCellData() instanceof Number)) break;
                int n3 = ((Number)jCCellDisplayEvent.getDisplayData()).intValue();
                jCCellDisplayEvent.setDisplayData(_$15031[n3]);
            }
        }
        if (n >= 0 && n < _$5516.length && _$6181[n] != null && _$6181[n].getMode() != 0 && (octetString = (OctetString)jCCellDisplayEvent.getCellData()) != null) {
            jCCellDisplayEvent.setDisplayData(octetString.toString(':', _$6181[n].getMode()));
        }
    }

    private void _$15119(int n) {
        GenTarget genTarget = (GenTarget)this._$15043.getTableRowLabel(n);
        this._$15113(n, genTarget);
        byte[] byArray = this._$4261.discoverAuthoritativeEngineID(genTarget.getAddress(), genTarget.getTimeout() * 10);
        if (byArray == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            OctetString octetString = new OctetString(byArray);
            this._$15043.setTableDataItem(octetString, n, 10);
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
    }

    public void traverseCell(JCTraverseCellEvent jCTraverseCellEvent) {
    }

    public void afterTraverseCell(JCTraverseCellEvent jCTraverseCellEvent) {
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
        switch (jCEditCellEvent.getColumn()) {
            case 0: {
                int n = jCEditCellEvent.getRow();
                int n2 = jCEditCellEvent.getColumn();
                Integer n3 = (Integer)this.table.getDataView().getDataSource().getTableDataItem(n, n2);
                if (n3 == null || n3 != 0) break;
                jCEditCellEvent.setCancelled(true);
                break;
            }
            case 1: {
                String string = (String)this._$15043.getTableDataItem(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
                if (string == null) {
                    jCEditCellEvent.setCancelled(true);
                    return;
                }
                for (int i = 1; i < this._$15043.getNumRows(); ++i) {
                    if (i == jCEditCellEvent.getRow() || !string.equals(this._$15043.getTableDataItem(i, 1))) continue;
                    jCEditCellEvent.setCancelled(true);
                    return;
                }
                break;
            }
        }
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        this.targetNameEditRow = 0;
        if (jCEditCellEvent.getColumn() == 0) {
            int n = jCEditCellEvent.getRow();
            n = TableUtils.getDataRows(this.table, new int[]{n})[0];
            this._$15085(n);
        }
    }

    public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
        Object object = jCValidateEvent.getOldValue();
        Object object2 = jCValidateEvent.getValue();
        if (object2 == null) {
            jCValidateEvent.setValid(false);
            return;
        }
        if (object != null && !object.equals(object2) || object == null && object2 != null) {
            String string = (String)object2;
            for (int i = 1; i < this._$15043.getNumRows(); ++i) {
                if (!string.equals(this._$15043.getTableDataItem(i, 1))) continue;
                jCValidateEvent.setValid(false);
                return;
            }
        }
    }

    public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
    }

    public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
    }

    private void _$6273(int n, int n2) {
        String string = "";
        _$6181[n2].setMode(n);
        switch (n) {
            case 16: {
                string = " [HEX]";
                break;
            }
            case 10: {
                string = " [DEC]";
            }
        }
        SortLabel sortLabel = (SortLabel)this._$15043.getTableColumnLabel(n2);
        sortLabel.setLabel(_$5516[n2] + string);
        this._$15043.fireColumnLabelChanged(n2);
    }

    public void userConfigChanged(UserConfigurationEvent userConfigurationEvent) {
        if (userConfigurationEvent.getType() == 1) {
            String string = userConfigurationEvent.getUser().getName();
            for (int i = 1; i < this._$15043.getNumRows(); ++i) {
                String string2;
                UserProfile userProfile = (UserProfile)this._$15043.getTableDataItem(i, 9);
                if (userProfile == null || (string2 = userProfile.getName()) == null || !string.equals(string2)) continue;
                userConfigurationEvent.setCanceled(true);
                return;
            }
        }
    }

    class FormatAction
    extends AbstractAction {
        public FormatAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = TargetConfiguration.this.table.getPopupCellPosition();
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$5516.length) {
                if (actionEvent.getActionCommand().equals(TargetConfiguration.ACTION_ASCII)) {
                    TargetConfiguration.this._$6273(0, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(TargetConfiguration.ACTION_HEX)) {
                    TargetConfiguration.this._$6273(16, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(TargetConfiguration.ACTION_DEC)) {
                    TargetConfiguration.this._$6273(10, jCCellPosition.column);
                }
            }
        }
    }
}

