/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import com.objectspace.jgl.Pair;
import java.util.Vector;

public class SMITableUtils {
    public static MIBObjectType getRowStatus(MIBRepository mIBRepository, MIBObjectType mIBObjectType) {
        if (mIBObjectType.isTable()) {
            Vector vector = mIBRepository.getColumnarObjectsOfTable(mIBObjectType, false, true);
            for (int i = 0; i < vector.size(); ++i) {
                MIBObjectType mIBObjectType2 = (MIBObjectType)vector.get(i);
                if (!mIBObjectType2.getSyntax().getSyntax().equals("RowStatus")) continue;
                return mIBObjectType2;
            }
        }
        return null;
    }

    public static String getPathSuffixWithIndex(MIBRepository mIBRepository, ObjectID objectID) {
        Pair pair = null;
        try {
            pair = mIBRepository.getSplittedObjectID(objectID);
            if (pair.second != null && ((ObjectID)pair.second).size() > 0) {
                ObjectID objectID2 = (ObjectID)pair.first;
                ObjectID objectID3 = (ObjectID)pair.second;
                MIBObject mIBObject = mIBRepository.getObject(objectID2);
                MIBObjectType mIBObjectType = (MIBObjectType)mIBRepository.getParent(mIBObject);
                if (mIBObjectType != null) {
                    IndexStruct[] indexStructArray;
                    if (mIBObjectType.getIndexPart().isAugment()) {
                        mIBObjectType = (MIBObjectType)mIBRepository.getObject(mIBObjectType.getIndexPart().getIndexPart()[0]);
                    }
                    if ((indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(mIBRepository)) != null) {
                        try {
                            ObjectID[] objectIDArray = mIBRepository.getIndexObjectIDs(objectID3, indexStructArray);
                            ValueConverter[] valueConverterArray = SMITableUtils.getIndexValueConverter(mIBRepository, mIBObjectType);
                            return mIBObject.getName() + "." + IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray);
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mIBRepository.getPathSuffix(objectID);
    }

    public static ValueConverter[] getIndexValueConverter(MIBRepository mIBRepository, MIBObjectType mIBObjectType) {
        if (!mIBObjectType.isTable()) {
            return null;
        }
        Vector vector = mIBRepository.getColumnarObjectsOfTable(mIBObjectType, true, false);
        if (mIBObjectType.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])mIBObjectType.userObject;
        }
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i = 0; i < valueConverterArray.length; ++i) {
            MIBObjectType mIBObjectType2 = (MIBObjectType)vector.elementAt(i);
            MIBTextualConvention mIBTextualConvention = mIBRepository.getEffectiveSyntax(mIBObjectType2.getSyntax());
            valueConverterArray[i] = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        mIBObjectType.userObject = valueConverterArray;
        return valueConverterArray;
    }
}

