/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.MemoryStatus;
import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.snmp.GenTarget;
import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.UnsupportedAddressClassException;

public class RequestObserverPanel
extends JPanel
implements RequestObserver {
    JButton jButtonStop = new JButton();
    private TimingOut _$31361;
    private Snmp _$4261;
    private Timer _$4297 = new Timer();
    private volatile transient boolean _$27262 = false;
    private boolean _$31362 = false;
    private JPanel _$23855 = new JPanel();
    private JProgressBar _$31363 = new JProgressBar();
    private JLabel _$29915 = new JLabel();
    private BorderLayout _$4239 = new BorderLayout();
    private FlowLayout _$18948 = new FlowLayout();
    private JPanel _$23856 = new JPanel();
    private VerticalFlowLayout _$18753 = new VerticalFlowLayout();
    private Hashtable _$31364 = new Hashtable(10);
    private boolean _$31365;

    public RequestObserverPanel(Snmp snmp) {
        this(snmp, false);
    }

    public RequestObserverPanel(Snmp snmp, boolean bl) {
        this._$31362 = bl;
        this._$4261 = snmp;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RequestObserverPanel() {
        this((Snmp)null);
    }

    void jbInit() throws Exception {
        this.setLayout(this._$4239);
        this.setMessage(" ");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Stop16.gif");
        this.jButtonStop.setIcon(new ImageIcon(uRL));
        this.jButtonStop.setToolTipText("Cancel current request");
        this.jButtonStop.setEnabled(false);
        this.jButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestObserverPanel.this.jButtonStop_actionPerformed(actionEvent);
            }
        });
        this._$23855.setLayout(this._$18948);
        this._$18948.setAlignment(0);
        this._$23856.setLayout(this._$18753);
        this._$18753.setAlignment(2);
        this.add((Component)this._$23855, "West");
        this._$23855.add((Component)this.jButtonStop, null);
        this._$23855.add((Component)this._$31363, null);
        this._$23855.add((Component)this._$29915, null);
        this.add((Component)this._$23856, "East");
        if (this._$31362) {
            this._$23856.add((Component)new MemoryStatus(), null);
        }
    }

    public void stop() {
        if (this._$31361 != null) {
            this._$31361.stop();
            this._$31361 = null;
            this._$27262 = true;
            this.setMessage("Stopped.");
            this.stopped();
        }
    }

    synchronized void jButtonStop_actionPerformed(ActionEvent actionEvent) {
        this.stop();
    }

    public void stopped() {
    }

    public void requestFinishedWithError(String string) {
        this.requestFinished();
        this.setMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String string) {
        JLabel jLabel = this._$29915;
        synchronized (jLabel) {
            if (string != null && string.trim().length() > 0 && !string.endsWith(".") && !string.endsWith("!")) {
                string = string + ".";
            }
            this._$29915.setText(string);
        }
    }

    public synchronized void requestFinished() {
        if (this._$31361 != null) {
            this._$31361.stop();
            this._$31361 = null;
        }
        this.updateTimerButtons();
        this.setMessage("Finished.");
    }

    public synchronized void addOutstanding(Object object, ResponseListener responseListener) {
        this._$31364.put(object, responseListener);
    }

    public synchronized void removeOutstanding(Object object) {
        this._$31364.remove(object);
    }

    public void setCurrentRequest(PDU pDU, ResponseListener responseListener, String string) {
        if (this._$31361 != null) {
            this._$31361.reset(pDU, responseListener);
            if (string != null) {
                this.setMessage(string);
            }
        }
    }

    public void updateTimerButtons() {
        this.jButtonStop.setEnabled(this._$31361 != null);
    }

    public synchronized boolean isRequestCanceled() {
        return this._$31361 == null;
    }

    public synchronized String getMessage() {
        return this._$29915.getText();
    }

    public synchronized void request(int n, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) {
        if (this._$31361 != null) {
            this._$31361.stop();
        }
        this._$31361 = null;
        if (target == null) {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage("Timeout on engine ID discovery!");
            return;
        }
        if (target.getAddress() == null) {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage("Could not resolve " + genTarget.getAddressType() + " address: " + genTarget.getAddressString());
            return;
        }
        int n2 = genTarget.getTimeout() * (1 + genTarget.getRetries());
        this._$31363.setMaximum(n2);
        this._$31363.setMinimum(0);
        this._$31363.setValue(0);
        this._$31361 = new TimingOut(pDU, responseListener, n2);
        this.updateTimerButtons();
        this._$4297.scheduleAtFixedRate((TimerTask)this._$31361, 0L, 10L);
        try {
            if (string == null) {
                String string2 = RequestObserverPanel.getRequestTypeString(n);
                if (string2 != null) {
                    if (target.getVersion() == 0 && n == -91) {
                        string2 = RequestObserverPanel.getRequestTypeString(-95);
                    }
                    this.setMessage("Sending " + string2 + " request to " + target.getAddress().toString());
                }
            } else {
                this.setMessage(string);
            }
            switch (n) {
                case -91: {
                    this._$4261.getBulk(pDU, target, object, responseListener);
                    break;
                }
                case -96: {
                    this._$4261.get(pDU, target, object, responseListener);
                    break;
                }
                case -95: {
                    this._$4261.getNext(pDU, target, object, responseListener);
                    break;
                }
                case -93: {
                    this._$4261.set(pDU, target, object, responseListener);
                }
            }
            SnmpLogger.logRequest(pDU, genTarget);
            if (this._$31365) {
                this._$31364.put(pDU, responseListener);
            }
        }
        catch (UnsupportedAddressClassException unsupportedAddressClassException) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.error("Failed to send request: " + unsupportedAddressClassException.getMessage());
            this.stop();
            String string3 = "UDP";
            if (unsupportedAddressClassException.getAddressClass().equals(TcpAddress.class)) {
                string3 = "TCP";
            }
            String[] stringArray = new String[]{"The transport '" + string3 + "' is not available or not enabled.", "Please verify under Preferences/Transport that this transport", "is enabled and then try again!"};
            JOptionPane.showMessageDialog(this, stringArray, "Unavailable Transport", 0);
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.fatal("Failed to send request: " + exception.getMessage());
            exception.printStackTrace();
            this.stop();
            this.setMessage("Failed to send request: " + exception.getMessage());
        }
    }

    public synchronized void resendRequest(int n, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) {
        if (target == null) {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage("Timeout on engine ID discovery!");
            return;
        }
        if (this._$31361 != null) {
            this._$31361.reset(pDU, responseListener);
        } else {
            if (this._$31364.size() == 0) {
                return;
            }
            int n2 = genTarget.getTimeout() * (1 + genTarget.getRetries());
            this._$31361 = new TimingOut(pDU, responseListener, n2);
            this._$4297.scheduleAtFixedRate((TimerTask)this._$31361, 0L, 10L);
        }
        this.updateTimerButtons();
        try {
            if (string == null) {
                String string2 = RequestObserverPanel.getRequestTypeString(n);
                if (string2 != null) {
                    this.setMessage("Sending " + string2 + " request to " + target.getAddress().toString());
                }
            } else {
                this.setMessage(string);
            }
            switch (n) {
                case -91: {
                    this._$4261.getBulk(pDU, target, object, responseListener);
                    break;
                }
                case -96: {
                    this._$4261.get(pDU, target, object, responseListener);
                    break;
                }
                case -95: {
                    this._$4261.getNext(pDU, target, object, responseListener);
                    break;
                }
                case -93: {
                    this._$4261.set(pDU, target, object, responseListener);
                }
            }
            SnmpLogger.logRequest(pDU, genTarget);
            if (this._$31365) {
                this._$31364.put(pDU, responseListener);
            }
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.error("Failed to send request: " + exception.getMessage());
            this.setMessage("Failed to send request: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static String getRequestTypeString(int n) {
        String string = null;
        switch (n) {
            case -91: {
                string = "BULK";
                break;
            }
            case -96: {
                string = "GET";
                break;
            }
            case -95: {
                string = "GETNEXT";
                break;
            }
            case -93: {
                string = "SET";
            }
        }
        return string;
    }

    public void setMultiRequestEnabled(boolean bl) {
        this._$31365 = bl;
    }

    public boolean isMultiRequestEnabled() {
        return this._$31365;
    }

    class TimingOut
    extends TimerTask {
        private int _$29951 = 0;
        private int _$5471;
        private PDU _$4276;
        private ResponseListener _$21254;
        private int _$29952 = 10;

        public TimingOut(PDU pDU, ResponseListener responseListener, int n) {
            this._$4276 = pDU;
            this._$21254 = responseListener;
            this._$5471 = n;
        }

        public void reset(PDU pDU, ResponseListener responseListener) {
            this._$4276 = pDU;
            this._$21254 = responseListener;
            this._$29951 = 0;
        }

        public void setStepping(int n) {
            this._$29952 = n;
        }

        public void stop() {
            this.cancel();
            RequestObserverPanel.this._$4261.cancel(this._$4276, this._$21254);
            this._$29951 = 0;
            RequestObserverPanel.this._$31363.setValue(this._$29951);
            RequestObserverPanel.this.updateTimerButtons();
        }

        public void run() {
            if (this._$29951 < this._$5471) {
                this._$29951 += this._$29952;
            } else {
                RequestObserverPanel.this._$31363.setValue(this._$5471);
                return;
            }
            RequestObserverPanel.this._$31363.setValue(this._$29951);
        }
    }
}

