/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.io.ByteFilterInputStream;
import com.agentpp.common.xml.XMLUtils;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MultiTabbedPanel;
import com.agentpp.explorer.MultiVariablePanel;
import com.agentpp.explorer.TabbedControlledPanel;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractElement;
import org.snmp4j.Snmp;

public class PDUTabbedPanel
extends MultiTabbedPanel {
    JButton jButtonNewTrap = new JButton();

    public PDUTabbedPanel(UserConfigFile userConfigFile, JFrame jFrame, MIBObjectListener mIBObjectListener, Snmp snmp, MIBRepository mIBRepository, Hashtable hashtable) {
        super(userConfigFile, jFrame, mIBObjectListener, snmp, mIBRepository, null, hashtable, "PDU", new String[]{".PDU", ".XML"});
        this.jButtonNewTrap.setIcon(MIBExplorerFrame.imageNew16);
        this.jButtonNewTrap.setToolTipText("Create a new TRAP, NOTIFICATION, or INFORM PDU panel");
        this.jButtonNewTrap.setText("New Trap");
        this.jButtonNewTrap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PDUTabbedPanel.this.jButtonNewTrap_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.jButtonNewTrap, 1);
    }

    void jButtonNewTrap_actionPerformed(ActionEvent actionEvent) {
        MultiVariablePanel multiVariablePanel = new MultiVariablePanel(this.myFrame, this.session, this.rep, this.targets, this.config);
        multiVariablePanel.addTrapObjects(System.currentTimeMillis() - applicationStart);
        multiVariablePanel.setTarget(this.target);
        multiVariablePanel.addComponentLinkListener(this);
        multiVariablePanel.addActionListener(this);
        multiVariablePanel.addMIBObjectListener(this.listener);
        String string = "PDU " + (this.jTabbedPane.getComponentCount() + 1);
        this.jTabbedPane.addTab(string, multiVariablePanel);
        multiVariablePanel.setTitle(string);
        this.updateButtons();
    }

    protected void saveData(TabbedControlledPanel tabbedControlledPanel, File file) throws IOException {
        tabbedControlledPanel.setFile(file);
        if (file.getName().toUpperCase().endsWith(".XML")) {
            this.saveDataXML(tabbedControlledPanel, file);
        } else {
            MultiVariablePanel multiVariablePanel = (MultiVariablePanel)tabbedControlledPanel;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            ((JCEditableVectorDataSource)multiVariablePanel.getData()).removeTableDataListener(multiVariablePanel.getTable().getDataView());
            objectOutputStream.writeObject(multiVariablePanel.getData());
            objectOutputStream.flush();
            objectOutputStream.close();
            ((JCEditableVectorDataSource)multiVariablePanel.getData()).addTableDataListener(multiVariablePanel.getTable().getDataView());
        }
    }

    protected void saveDataXML(TabbedControlledPanel tabbedControlledPanel, File file) throws IOException {
        Object object;
        MultiVariablePanel multiVariablePanel = (MultiVariablePanel)tabbedControlledPanel;
        JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)multiVariablePanel.getData();
        DOMDocument dOMDocument = new DOMDocument();
        DOMElement dOMElement = new DOMElement("PDU");
        DOMAttribute dOMAttribute = new DOMAttribute(new QName("xmlns:xsi"), "http://www.w3.org/2001/XMLSchema-instance");
        dOMElement.add(dOMAttribute);
        DOMAttribute dOMAttribute2 = new DOMAttribute(new QName("xsi:noNamespaceSchemaLocation"), "MIBExplorerPDU.xsd");
        dOMElement.add(dOMAttribute2);
        dOMDocument.setRootElement(dOMElement);
        for (int i = 1; i < jCEditableVectorDataSource.getNumRows(); ++i) {
            object = new DOMElement("VariableBinding");
            DOMElement dOMElement2 = new DOMElement("Converter");
            DOMElement dOMElement3 = new DOMElement("OID");
            DOMElement dOMElement4 = new DOMElement("Variable");
            ((AbstractElement)object).add(dOMElement3);
            ((AbstractElement)object).add(dOMElement4);
            ((AbstractElement)object).addAttribute("syntax", jCEditableVectorDataSource.getTableDataItem(i, 1).toString());
            dOMElement3.setText(jCEditableVectorDataSource.getTableDataItem(i, 0).toString());
            Object object2 = jCEditableVectorDataSource.getTableDataItem(i, 2);
            String string = "String";
            if (object2 instanceof Long) {
                string = "Long";
            } else if (object2 instanceof ComparableIpAddress) {
                string = "IpAddress";
            } else if (object2 instanceof ObjectID) {
                string = "OID";
            } else if (object2 instanceof BigDecimal) {
                string = "BigDecimal";
            }
            dOMElement4.addAttribute("type", string);
            dOMElement4.addAttribute("value", object2.toString());
            ValueConverter valueConverter = (ValueConverter)jCEditableVectorDataSource.getTableDataItem(i, 3);
            if (valueConverter != null) {
                dOMElement2.addAttribute("smiSyntax", "" + valueConverter.getSMISyntax());
                dOMElement2.addAttribute("displayHint", valueConverter.getDisplayHint());
                if (valueConverter.getObjectType() != null) {
                    DOMElement dOMElement5 = new DOMElement("ObjectType");
                    dOMElement5.addAttribute("name", valueConverter.getObjectType().getName());
                    dOMElement5.addAttribute("oid", valueConverter.getObjectType().getOid().toString());
                    if (valueConverter.getObjectType().hasDefaultValue()) {
                        dOMElement5.addAttribute("defaultValue", valueConverter.getObjectType().getDefaultValue());
                    }
                    if (valueConverter.getObjectType().getSyntax() != null) {
                        dOMElement5.add(this._$33411(valueConverter.getObjectType().getSyntax()));
                    }
                    dOMElement2.add(dOMElement5);
                }
                dOMElement2.add(this._$33411(valueConverter.getEffectiveSyntax()));
                ((AbstractElement)object).add(dOMElement2);
            }
            dOMElement.add((Element)object);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        object = new XMLWriter(fileOutputStream, new OutputFormat(" ", true));
        ((XMLWriter)object).write(dOMDocument);
        ((XMLWriter)object).flush();
        fileOutputStream.close();
    }

    private DOMElement _$33411(MIBSyntax mIBSyntax) {
        DOMElement dOMElement = new DOMElement("Syntax");
        dOMElement.addAttribute("type", "" + mIBSyntax.getType());
        dOMElement.addAttribute("syntax", mIBSyntax.getSyntax());
        if (mIBSyntax.hasEnums()) {
            DOMElement dOMElement2 = new DOMElement("Enumeration");
            for (MIBEnum mIBEnum : mIBSyntax.getEnumsVector()) {
                DOMElement dOMElement3 = new DOMElement("Enum");
                dOMElement3.addAttribute("value", mIBEnum.getValue());
                dOMElement3.addAttribute("label", mIBEnum.getLabel());
                dOMElement2.add(dOMElement3);
            }
            dOMElement.add(dOMElement2);
        } else if (mIBSyntax.hasRanges()) {
            DOMElement dOMElement4 = new DOMElement("Ranges");
            for (MIBRange mIBRange : mIBSyntax.getRangesVector()) {
                DOMElement dOMElement5 = new DOMElement("Range");
                dOMElement5.addAttribute("lowerBound", "" + mIBRange.getLowerValue());
                dOMElement5.addAttribute("upperBound", "" + mIBRange.getUpperValue());
                dOMElement4.add(dOMElement5);
            }
            dOMElement.add(dOMElement4);
        }
        return dOMElement;
    }

    public TabbedControlledPanel createPanel() {
        MultiVariablePanel multiVariablePanel = new MultiVariablePanel(this.myFrame, this.session, this.rep, this.targets, this.config);
        return multiVariablePanel;
    }

    protected void loadData(TabbedControlledPanel tabbedControlledPanel, File file) throws IOException, ClassNotFoundException {
        if (file.getName().toUpperCase().endsWith(".XML")) {
            this.loadDataXML(tabbedControlledPanel, file);
            return;
        }
        MultiVariablePanel multiVariablePanel = (MultiVariablePanel)tabbedControlledPanel;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)objectInputStream.readObject();
            multiVariablePanel.setData(jCEditableVectorDataSource);
        }
        catch (InvalidClassException invalidClassException) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteFilterInputStream byteFilterInputStream = new ByteFilterInputStream(fileInputStream, ByteFilterInputStream.serialVersionUIDPatternLiveTable5, ByteFilterInputStream.serialVersionUIDPatternLiveTable62);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteFilterInputStream);
            JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)objectInputStream.readObject();
            multiVariablePanel.setData(jCEditableVectorDataSource);
        }
    }

    protected void loadDataXML(TabbedControlledPanel tabbedControlledPanel, File file) throws IOException, ClassNotFoundException {
        MultiVariablePanel multiVariablePanel = (MultiVariablePanel)tabbedControlledPanel;
        try {
            DOMDocument dOMDocument = XMLUtils.readDOMDocument(new FileInputStream(file), DOMDocumentFactory.getInstance());
            JCEditableVectorDataSource jCEditableVectorDataSource = new JCEditableVectorDataSource();
            jCEditableVectorDataSource.setNumColumns(4);
            jCEditableVectorDataSource.setNumRows(1);
            DOMElement dOMElement = (DOMElement)dOMDocument.selectSingleNode("PDU");
            if (dOMElement != null) {
                List list = dOMElement.selectNodes("VariableBinding");
                for (DOMElement dOMElement2 : list) {
                    DOMElement dOMElement3 = (DOMElement)dOMElement2.element("Converter");
                    DOMElement dOMElement4 = (DOMElement)dOMElement2.element("OID");
                    DOMElement dOMElement5 = (DOMElement)dOMElement2.element("Variable");
                    Vector<Object> vector = new Vector<Object>(5);
                    ObjectID objectID = new ObjectID(dOMElement4.getText());
                    if (!objectID.isValid()) continue;
                    vector.add(objectID);
                    int n = Integer.parseInt(dOMElement2.getAttribute("syntax"));
                    vector.add(new Integer(n));
                    String string = dOMElement5.getAttribute("value");
                    String string2 = dOMElement5.getAttribute("type");
                    Object object = string2.equals("Long") ? new Long(string) : (string2.equals("IpAddress") ? new ComparableIpAddress(string) : (string2.equals("OID") ? new ObjectID(string) : (string2.equals("BigDecimal") ? new BigDecimal(string) : string)));
                    vector.add(object);
                    vector.add(this._$33417(dOMElement3));
                    jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(jCEditableVectorDataSource.getNumRows()), vector);
                }
            }
            multiVariablePanel.setData(jCEditableVectorDataSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("The XML input file could not be read, please check its format");
        }
    }

    private ValueConverter _$33417(DOMElement dOMElement) {
        Serializable serializable;
        if (dOMElement == null) {
            return null;
        }
        int n = Integer.parseInt(dOMElement.attributeValue("smiSyntax"));
        ValueConverter valueConverter = new ValueConverter(n);
        valueConverter.setDisplayHint(dOMElement.attributeValue("displayHint"));
        DOMElement dOMElement2 = (DOMElement)dOMElement.element("ObjectType");
        if (dOMElement2 != null) {
            serializable = new MIBObjectType(new ObjectID(dOMElement2.attributeValue("oid")), dOMElement2.attributeValue("name"), new Integer(-1));
            ((MIBObjectType)serializable).setSyntax(this._$33419((DOMElement)dOMElement2.element("Syntax")));
            valueConverter.setObjectType((MIBObjectType)serializable);
        }
        serializable = (DOMElement)dOMElement.element("Syntax");
        valueConverter.setEffectiveSyntax(this._$33419((DOMElement)serializable));
        return valueConverter;
    }

    private MIBSyntax _$33419(DOMElement dOMElement) {
        if (dOMElement != null) {
            MIBSyntax mIBSyntax = new MIBSyntax(dOMElement.attributeValue("syntax"), Integer.parseInt(dOMElement.attributeValue("type")));
            DOMElement dOMElement2 = (DOMElement)dOMElement.element("Enumeration");
            if (dOMElement2 != null) {
                List list = dOMElement2.selectNodes("Enum");
                for (DOMElement dOMElement3 : list) {
                    MIBEnum mIBEnum = new MIBEnum(dOMElement3.attributeValue("name"), dOMElement3.attributeValue("label"));
                    mIBSyntax.addEnum(mIBEnum);
                }
            } else {
                DOMElement dOMElement4 = (DOMElement)dOMElement.element("Ranges");
                if (dOMElement4 != null) {
                    List list = dOMElement4.selectNodes("Range");
                    for (DOMElement dOMElement5 : list) {
                        MIBRange mIBRange = new MIBRange(dOMElement5.attributeValue("lowerBound"), dOMElement5.attributeValue("upperBound"));
                        mIBSyntax.addRange(mIBRange);
                    }
                }
            }
            return mIBSyntax;
        }
        return null;
    }
}

