/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ChangeManager;
import com.agentpp.common.ComponentLinkEvent;
import com.agentpp.common.ComponentLinkListener;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StandardFrame;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.table.ExtendedTable;
import com.agentpp.common.table.JTableColumnResizeEmulator;
import com.agentpp.common.table.PopupTable;
import com.agentpp.common.table.RowMove;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.DraggableTreeNode;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBInstance;
import com.agentpp.explorer.MIBTablePanel;
import com.agentpp.explorer.MultiPDUDialog;
import com.agentpp.explorer.PDUTabbedPanel;
import com.agentpp.explorer.PDUTypePanel;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.SelectTargetsPanel;
import com.agentpp.explorer.TabbedControlledPanel;
import com.agentpp.explorer.editors.cell.EnumCellEditor;
import com.agentpp.explorer.editors.cell.IpAddressCellEditor;
import com.agentpp.explorer.editors.cell.ObjectIDCellEditor;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.editors.BaseCellEditor;
import com.klg.jclass.cell.editors.JCBigDecimalCellEditor;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCIntegerCellEditor;
import com.klg.jclass.cell.editors.JCLongCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableCellInfo;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MultiVariablePanel
extends TabbedControlledPanel
implements ResponseListener,
JCCellDisplayListener,
JCValueListener,
JCEditCellListener,
DropTargetListener,
JCSelectListener,
MouseListener,
ActionListener {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String[] TITLES = new String[]{"Object ID", "Syntax", "Value", ""};
    private static final int[] _$29654 = new int[]{25, 15, 20, 0};
    public static final int COL_OID = 0;
    public static final int COL_SYNTAX = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_VALUE_CONVERTER = 3;
    public static final String ACTION_UNLOCK = "Unlock";
    public static final String[] WIRE_SYNTAXES = new String[]{SMI.SMI_SYNTAX[0], SMI.SMI_SYNTAX[1], SMI.SMI_SYNTAX[2], SMI.SMI_SYNTAX[4], SMI.SMI_SYNTAX[11], SMI.SMI_SYNTAX[3], SMI.SMI_SYNTAX[6], SMI.SMI_SYNTAX[12], SMI.SMI_SYNTAX[9], SMI.SMI_SYNTAX[10], SMI.SMI_SYNTAX[14]};
    public static final int[] WIRE_SYNTAX_IDS = new int[]{0, 1, 2, 4, 11, 3, 6, 12, 9, 10, 14};
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelNorth = new JPanel();
    JPanel jPanelCenter = new JPanel();
    JToolBar jToolBar1 = new JToolBar();
    JButton jButtonNewRow = new JButton();
    JButton jButtonCopyRow = new JButton();
    JButton jButtonRefresh = new JButton();
    Border border1;
    private File _$29896;
    private boolean _$29897 = true;
    private JFrame _$18902;
    private JCEditableVectorDataSource _$4260 = new JCEditableVectorDataSource();
    private Snmp _$4261;
    private Target _$773 = null;
    private GenTarget _$4262;
    private MIBRepository _$18643;
    private PopupTable _$4160;
    private PDU _$4276;
    private JCCellStyle _$29667;
    JButton jButtonUndo = new JButton();
    private ChangeManager _$29661 = new ChangeManager();
    private CellEdit _$29663 = null;
    JButton jButtonRedo = new JButton();
    private JCSpinField _$29899 = new JCSpinField();
    private JComboBox _$31953 = new JComboBox();
    private DefaultComboBoxModel _$31954 = new DefaultComboBoxModel();
    private Timer _$4297;
    BorderLayout borderLayout4 = new BorderLayout();
    JProgressBar jProgressBarTimer = new JProgressBar();
    JButton jButtonPlay = new JButton();
    JButton jButtonPause = new JButton();
    private int _$29904 = 5;
    private boolean _$29905 = false;
    Border border2;
    private boolean _$29665 = false;
    JLabel jLabelRefresh = new JLabel();
    JToolBar jToolBarRefresh = new JToolBar();
    FlowLayout flowLayout3 = new FlowLayout();
    JButton jButtonApply = new JButton();
    private JCCellStyle _$29909;
    private DropTarget _$4322;
    private DropTarget _$29910;
    private Hashtable _$4957;
    private UserConfigFile _$4288;
    JButton jButtonDeleteRow = new JButton();
    JButton jButtonMultiSet = new JButton();
    JToggleButton jToggleButtonExport = new JToggleButton();
    JButton jButtonMoveUp = new JButton();
    JButton jButtonMoveDown = new JButton();
    RequestObserverPanel observer;
    private String _$4364;
    JButton jButtonZoomIn = new JButton();
    JButton jButtonZoomOut = new JButton();
    JMenu dhMenu = new JMenu("String Format");
    private transient Vector _$29914;
    private SnmpLogger _$4326;
    StandardFrame f = null;
    private File _$18765;
    public static ImageIcon imageZoomIn16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/ZoomIn16.gif"));
    public static ImageIcon imageZoomOut16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/ZoomOut16.gif"));
    public static ImageIcon imageSaveAs16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif"));
    public static ImageIcon imageNew16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/New16.gif"));
    public static ImageIcon imagePause16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Pause16.gif"));
    public static ImageIcon imagePlay16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Play16.gif"));
    public static ImageIcon imageExport16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Export16.gif"));
    public static ImageIcon imagePreferences16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Preferences16.gif"));
    public static ImageIcon imageEdit16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Edit16.gif"));
    public static ImageIcon imageHelp16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Help16.gif"));
    public static ImageIcon imageSendMail16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SendMail16.gif"));
    public static ImageIcon imageDeleteRow16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/table/RowDelete16.gif"));
    public static ImageIcon imageUndo16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Undo16.gif"));
    public static ImageIcon imageRedo16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Redo16.gif"));
    public static ImageIcon imageRefresh16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Refresh16.gif"));
    public static ImageIcon imageUp16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/navigation/Up16.gif"));
    public static ImageIcon imageDown16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/navigation/Down16.gif"));
    private transient Vector _$29657;
    private transient Vector _$29933;

    public MultiVariablePanel() {
        this._$4160 = new PopupTable();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MultiVariablePanel(JFrame jFrame, Snmp snmp, MIBRepository mIBRepository, Hashtable hashtable, UserConfigFile userConfigFile) {
        this._$18902 = jFrame;
        this._$4261 = snmp;
        this.observer = new RequestObserverPanel(snmp);
        this._$18643 = mIBRepository;
        this._$4326 = new SnmpLogger(mIBRepository);
        this._$4260 = this._$4260;
        this._$4288 = userConfigFile;
        this._$4957 = hashtable;
        this._$773 = this._$773;
        this._$31962();
        this._$31963(MultiPDUDialog.NON_TRAP_PDU_TYPES);
        this._$4160 = new ExtendedTable(){

            public boolean isPopupAllowed(int n, int n2) {
                TablePopupMenu tablePopupMenu = super.getPopupMenu();
                JCCellPosition jCCellPosition = MultiVariablePanel.this._$4160.XYToCell(n, n2);
                int n3 = MultiVariablePanel.this._$4419(jCCellPosition.row, jCCellPosition.column);
                if (n3 < 0) {
                    return false;
                }
                ValueConverter valueConverter = (ValueConverter)MultiVariablePanel.this._$4260.getTableDataItem(n3, 3);
                if (valueConverter == null || !SMI.isString(valueConverter.getEffectiveSyntax().getSyntax())) {
                    MultiVariablePanel.this.dhMenu.setEnabled(false);
                } else {
                    MultiVariablePanel.this.dhMenu.setEnabled(true);
                }
                return true;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                ValueConverter valueConverter;
                JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
                if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                    return null;
                }
                int n = MultiVariablePanel.this._$4419(jCCellPosition.row, jCCellPosition.column);
                int n2 = MultiVariablePanel.this._$29694(jCCellPosition.row, jCCellPosition.column);
                Object object = MultiVariablePanel.this._$4260.getTableDataItem(n, n2);
                if (object == null) {
                    return null;
                }
                if (n2 == 2 && object instanceof String && (valueConverter = (ValueConverter)MultiVariablePanel.this._$4260.getTableDataItem(n, 3)) != null) {
                    OctetString octetString = (OctetString)valueConverter.fromNative(object);
                    return ValueConverter.getPrintableString(octetString);
                }
                return object.toString();
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this._$4160);
        this._$4160.setRowHidden(0, true);
        this._$4160.setColumnLabelDisplay(true);
        this._$4160.setRowLabelDisplay(true);
        this._$4160.setResizeEven(false);
        this._$4160.setDataSource(this._$4260);
        this._$4160.setVisibleColumns(this._$4260.getNumColumns());
        this._$4160.setVisibleRows(20);
        this._$4160.setColumnHidden(3, true);
        this._$4160.setPopupMenuEnabled(false);
        this._$4160.setAllowCellResize(2);
        this._$4160.setCharWidth(-1, 2);
        this._$4160.setVertSBTrackColumn(-1);
        this._$4160.setAutoScroll(1);
        this._$4160.setCharHeight(-1, 1);
        TablePopupMenu tablePopupMenu = this._$4160.getPopupMenu();
        tablePopupMenu.addItem(ACTION_UNLOCK, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.dhMenu);
        this.dhMenu.setMnemonic('F');
        JMenuItem jMenuItem = this.dhMenu.add(new FormatAction("ASCII", "255a"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '255a', e.g. 'aBc' renders 'aBc'");
        jMenuItem.setMnemonic('A');
        jMenuItem = this.dhMenu.add(new FormatAction("Decimal", "1d."));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1d.', e.g. 'aBc' renders '97.66.99'");
        jMenuItem.setMnemonic('D');
        jMenuItem = this.dhMenu.add(new FormatAction("Hexadecimal", "1x:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1x:', e.g. 'aBc' renders '61:42:63'");
        jMenuItem.setMnemonic('H');
        jMenuItem = this.dhMenu.add(new FormatAction("Octal", "1o:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1o:', e.g. 'aBc' renders '141:102:143'");
        jMenuItem.setMnemonic('O');
        jMenuItem = this.dhMenu.add(new FormatAction("Binary", "1b:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1b:', e.g. 'aBc' renders '01100001:01000010:01100011'");
        jMenuItem.setMnemonic('B');
        jMenuItem = this.dhMenu.add(new FormatAction("MIB", null));
        jMenuItem.setToolTipText("Sets the default display and input format for this string object as defined in the corresponding MIB module");
        jMenuItem.setMnemonic('M');
        this._$4160.setPopupMenuEnabled(true);
        this._$4634();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$4160.addCellDisplayListener(this);
        this._$4160.addSelectListener(this);
        this._$4160.addEditCellListener(this);
        this._$4160.addResizeCellMotionListener(new JTableColumnResizeEmulator(2));
        this._$4160.addMouseListener(this);
        this._$29899.addValueListener(this);
        this._$4160.setSelectionPolicy(2);
        this.updateButtons();
        this._$31966();
    }

    public void setTargets(Hashtable hashtable) {
        this._$4957 = hashtable;
    }

    public void setTarget(GenTarget genTarget) {
        this._$4262 = genTarget;
    }

    private void _$31966() {
        this._$4322 = new DropTarget(this._$4160, 3, this);
    }

    private void _$31967() {
        this._$4160.getCellAreaHandler().createRequiredCellAreas();
        if (this._$29910 == null) {
            this._$29910 = new DropTarget(this._$4160.getCellAreaHandler().findByType(0), 3, this);
        }
    }

    public void resetChangeManager() {
        this._$29661.reset();
    }

    private void _$31962() {
        this._$4260.setNumRows(0);
        this._$4260.setNumColumns(TITLES.length);
        for (int i = 0; i < TITLES.length; ++i) {
            this._$4260.setColumnLabel(i, TITLES[i]);
        }
        this._$4260.addRow(Integer.MAX_VALUE, new Integer(0), null);
    }

    private void _$31963(String[] stringArray) {
        this._$31954.removeAllElements();
        for (String string : stringArray) {
            this._$31954.addElement(string);
        }
        this._$31953.setModel(this._$31954);
    }

    private void _$4625(int n, int n2, JCCellStyle jCCellStyle) {
        this._$4160.setCellStyle(n, n2, jCCellStyle);
    }

    private void _$4634() {
        this._$29667 = new JCCellStyle(this._$4160.getDefaultCellStyle());
        this._$29667.setEditable(true);
        this._$29667.setBackground(Color.blue);
        this._$29667.setForeground(Color.white);
        this._$29909 = new JCCellStyle(this._$29667);
        this._$29909.setCellEditor(new JCComboBoxCellEditor(WIRE_SYNTAXES, WIRE_SYNTAX_IDS));
        for (int i = 0; i < this._$4160.getNumColumns(); ++i) {
            if (i != 1) {
                this._$4160.setCellStyle(-997, i, this._$29667);
            } else {
                this._$4625(-997, i, this._$29909);
            }
            this._$4160.setCharWidth(i, _$29654[i]);
        }
        this._$4160.setCellEditor(ObjectID.class, MultiVariablePanel.getCellEditor(new ValueConverter(2), this._$18643));
    }

    public void updateStyle() {
        this._$4160.setCellStyle(-997, 2, this._$29667);
    }

    public static JCCellEditor getCellEditor(ValueConverter valueConverter, MIBRepository mIBRepository) {
        BaseCellEditor baseCellEditor;
        switch (SMI.smiSyntax(valueConverter.getEffectiveSyntax().getSyntax())) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                JCLongCellEditor jCLongCellEditor = new JCLongCellEditor();
                jCLongCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCLongCellEditor;
                break;
            }
            case 6: {
                JCBigDecimalCellEditor jCBigDecimalCellEditor = new JCBigDecimalCellEditor();
                jCBigDecimalCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCBigDecimalCellEditor;
                break;
            }
            case 0: 
            case 8: {
                if (valueConverter.getEffectiveSyntax().hasEnums()) {
                    EnumCellEditor enumCellEditor = new EnumCellEditor(valueConverter.getEffectiveSyntax().getEnumsVector());
                    baseCellEditor = enumCellEditor;
                    break;
                }
                JCIntegerCellEditor jCIntegerCellEditor = new JCIntegerCellEditor();
                jCIntegerCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCIntegerCellEditor;
                break;
            }
            case 2: {
                ObjectIDCellEditor objectIDCellEditor = new ObjectIDCellEditor(mIBRepository);
                baseCellEditor = objectIDCellEditor;
                break;
            }
            case 9: {
                IpAddressCellEditor ipAddressCellEditor;
                baseCellEditor = ipAddressCellEditor = new IpAddressCellEditor();
                break;
            }
            default: {
                JCStringCellEditor jCStringCellEditor = new JCStringCellEditor();
                jCStringCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCStringCellEditor;
                break;
            }
        }
        return baseCellEditor;
    }

    void jbInit() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.jButtonRefresh.setToolTipText("Refresh data by sending GET request to current target");
        this.jButtonRefresh.setIcon(imageRefresh16);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonRefresh_actionPerformed(actionEvent);
            }
        });
        this.jButtonNewRow.setToolTipText("Add a row (variable) to the PDU table");
        this.jButtonNewRow.setIcon(imageNew16);
        this.jButtonNewRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonNewRow_actionPerformed(actionEvent);
            }
        });
        this.jButtonCopyRow.setToolTipText("Duplicate the selected row");
        this.jButtonCopyRow.setIcon(MIBExplorerFrame.imageCopy16);
        this.jButtonCopyRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonCopyRow_actionPerformed(actionEvent);
            }
        });
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.setLayout(this.borderLayout1);
        this.jPanelNorth.setLayout(this.flowLayout3);
        this.jPanelCenter.setLayout(this.borderLayout4);
        this.jButtonUndo.setToolTipText("Undo last change made to the table");
        this.jButtonUndo.setIcon(imageUndo16);
        this.jButtonUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonUndo_actionPerformed(actionEvent);
            }
        });
        this.jButtonRedo.setIcon(imageRedo16);
        this.jButtonRedo.setToolTipText("Redo last change");
        this.jButtonRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonRedo_actionPerformed(actionEvent);
            }
        });
        this._$29899.setBorder(this.border2);
        this._$29899.setToolTipText("Periodical refresh in seconds");
        this._$29899.setDataProperties(MIBTablePanel.getRefreshDataProperties());
        this._$31953.setBorder(this.border2);
        this._$31953.setToolTipText("PDU Type");
        this._$31953 = new JComboBox<String>(MultiPDUDialog.NON_TRAP_PDU_TYPES);
        this._$31953.setSelectedIndex(0);
        this.jButtonPause.setToolTipText("Suspends periodic refresh");
        this.jButtonPause.setIcon(imagePause16);
        this.jButtonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonPause_actionPerformed(actionEvent);
            }
        });
        this.jButtonPlay.setToolTipText("Start periodic refresh");
        this.jButtonPlay.setIcon(imagePlay16);
        this.jButtonPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonPlay_actionPerformed(actionEvent);
            }
        });
        this.jProgressBarTimer.setPreferredSize(new Dimension(50, 16));
        this.jProgressBarTimer.setToolTipText("Time to next periodic update in %");
        this.jLabelRefresh.setText("Refresh:");
        this.flowLayout3.setAlignment(0);
        this.jButtonApply.setIcon(imageEdit16);
        this.jButtonApply.setToolTipText("Send PDU as SET request to current target");
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonApply_actionPerformed(actionEvent);
            }
        });
        this.jButtonDeleteRow.setIcon(imageDeleteRow16);
        this.jButtonDeleteRow.setEnabled(false);
        this.jButtonDeleteRow.setToolTipText("Remove selected rows (variables) from PDU");
        this.jButtonDeleteRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonDeleteRow_actionPerformed(actionEvent);
            }
        });
        this.jButtonMultiSet.setIcon(imageSendMail16);
        this.jButtonMultiSet.setToolTipText("Send PDU as GET, GETNEXT, GETBULK, SET, TRAP, or INFORM request to a set of targets");
        this.jButtonMultiSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonMultiSet_actionPerformed(actionEvent);
            }
        });
        this.jToggleButtonExport.setIcon(imageExport16);
        this.jToggleButtonExport.setToolTipText("Export PDU contents to a text file (and append new values when periodically refreshed)");
        this.jToggleButtonExport.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MultiVariablePanel.this.jToggleButtonExport_itemStateChanged(itemEvent);
            }
        });
        this.jButtonMoveUp.setIcon(imageUp16);
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonMoveUp.setToolTipText("Move selected rows up by one");
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonMoveUp_actionPerformed(actionEvent);
            }
        });
        this.jButtonMoveDown.setIcon(imageDown16);
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonMoveDown.setToolTipText("Move selected rows down by one");
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonMoveDown_actionPerformed(actionEvent);
            }
        });
        this.jButtonZoomIn.setIcon(imageZoomIn16);
        this.jButtonZoomIn.setToolTipText("Detach PDU from PDUs tab and show it in its own frame");
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonZoomIn_actionPerformed(actionEvent);
            }
        });
        this.jButtonZoomOut.setIcon(imageZoomOut16);
        this.jButtonZoomOut.setToolTipText("Attach PDU frame to PDUs tab");
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonZoomOut_actionPerformed(actionEvent);
            }
        });
        this.jButtonZoomOut.setEnabled(false);
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jToolBar1, null);
        this.jPanelNorth.add((Component)this.jToolBarRefresh, null);
        this.jToolBar1.add((Component)this.jButtonNewRow, null);
        this.jToolBar1.add((Component)this.jButtonCopyRow, null);
        this.jToolBar1.add((Component)this.jButtonDeleteRow, null);
        this.jToolBar1.add((Component)this.jButtonMoveUp, null);
        this.jToolBar1.add((Component)this.jButtonMoveDown, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonApply, null);
        this.jToolBar1.add((Component)this.jButtonMultiSet, null);
        this.jToolBar1.add((Component)this._$31953, null);
        this.jToolBar1.add((Component)this.jButtonRefresh, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonRedo, null);
        this.jToolBar1.add((Component)this.jButtonUndo, null);
        this.jToolBar1.add((Component)this.jButtonZoomIn, null);
        this.jToolBar1.add((Component)this.jButtonZoomOut, null);
        this.jToolBar1.addSeparator();
        ToolBarUtils.setMinimumButtonSize(this.jToolBar1);
        this.jToolBarRefresh.add((Component)this.jLabelRefresh, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this._$29899, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jButtonPlay, null);
        this.jToolBarRefresh.add((Component)this.jButtonPause, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jProgressBarTimer, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jToggleButtonExport, null);
        this.jToolBarRefresh.addSeparator();
        ToolBarUtils.setMinimumButtonSize(this.jToolBarRefresh);
        this.jPanelCenter.add((Component)this._$4160, "Center");
        this.add((Component)this.observer, "South");
        this.add((Component)this.jPanelCenter, "Center");
    }

    void jButtonApply_actionPerformed(ActionEvent actionEvent) {
        this.updateStyle();
        this.commitChanges();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
    }

    public synchronized void stopTimer() {
        this.fireActionPerformed(new ActionEvent(this, 1001, "Stopped"));
        if (this._$4297 != null) {
            this._$4297.cancel();
        }
        this._$29905 = false;
        this.jProgressBarTimer.setValue(0);
        this._$25240();
    }

    public synchronized void onResponse(ResponseEvent responseEvent) {
        try {
            this._$4261.cancel(responseEvent.getRequest(), this);
            if (!this._$4326.logResponse(responseEvent, this.observer)) {
                if (responseEvent.getResponse() != null && responseEvent.getResponse().getType() != -88 && responseEvent.getResponse().getErrorStatus() != 0) {
                    int n;
                    this.observer.requestFinishedWithError("SNMP error " + responseEvent.getResponse().getErrorStatusText() + " at index " + responseEvent.getResponse().getErrorIndex());
                    PDU pDU = responseEvent.getResponse();
                    if (responseEvent.getRequest().getType() == -93 && (n = pDU.getErrorIndex()) > 0 && n < pDU.size()) {
                        for (int i = 2; i <= 2; ++i) {
                            JCCellStyle jCCellStyle = new JCCellStyle(this._$4160.getCellStyle(n, i));
                            jCCellStyle.setBackground(Color.red);
                            jCCellStyle.setForeground(Color.black);
                            this._$4160.setCellStyle(n, i, jCCellStyle);
                        }
                        this._$4160.traverse(n, 2, true, true);
                    }
                }
            } else {
                this.observer.requestFinished();
                VariableBinding[] variableBindingArray = responseEvent.getResponse().toArray();
                for (int i = 0; i < variableBindingArray.length; ++i) {
                    if (variableBindingArray[i].isException() || variableBindingArray[i].getVariable() == null) {
                        this._$4260.setTableDataItem(null, i + 1, 2);
                        for (int j = 2; j <= 2; ++j) {
                            JCCellStyle jCCellStyle = new JCCellStyle(this._$4160.getCellStyle(i + 1, j));
                            jCCellStyle.setBackground(Color.orange);
                            jCCellStyle.setForeground(Color.black);
                            this._$4160.setCellStyle(i + 1, j, jCCellStyle);
                        }
                        this._$4260.setTableDataItem(null, i + 1, 2);
                        this._$4260.setTableDataItem(new Integer(ValueConverter.getSmiSyntax(variableBindingArray[i].getSyntax())), i + 1, 1);
                        continue;
                    }
                    ValueConverter valueConverter = (ValueConverter)this._$4260.getTableDataItem(i + 1, 3);
                    if (!valueConverter.isSyntaxCompatible(variableBindingArray[i].getVariable().getSyntax())) {
                        valueConverter = new ValueConverter(variableBindingArray[i].getVariable().getClass());
                    }
                    this._$4260.setTableDataItem(new Integer(valueConverter.getSMISyntax()), i + 1, 1);
                    this._$4260.setTableDataItem(valueConverter.toNative(variableBindingArray[i].getVariable()), i + 1, 2);
                    this._$4260.setTableDataItem(valueConverter, i + 1, 3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$29959();
        this.notify();
    }

    private void _$29959() {
        if (this._$29896 != null) {
            try {
                this.saveTableToFile(this._$29896, this._$29897);
                if (!this._$29897 && this.isPeriodicRefreshEnabled()) {
                    this._$29897 = true;
                }
            }
            catch (IOException iOException) {
                final String[] stringArray = new String[]{"Could not write log file:", iOException.getMessage()};
                Runnable runnable = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(MultiVariablePanel.this._$18902, stringArray, "Export Failed", 0);
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(runnable);
                }
                runnable.run();
            }
        }
    }

    public synchronized void refresh() {
        this._$4160.commitEdit(true);
        this._$773 = this._$4262.getTarget();
        this.updateStyle();
        this._$29661.reset();
        this.updateButtons();
        this._$4276 = this._$4262.makePDU();
        int n = this._$31984();
        VariableBinding[] variableBindingArray = new VariableBinding[this._$4260.getNumRows() - 1];
        switch (n) {
            case -96: 
            case -95: 
            case -91: {
                for (int i = 0; i < variableBindingArray.length; ++i) {
                    Object object = this._$4260.getTableDataItem(i + 1, 0);
                    OID oID = object != null ? new OID(object.toString()) : new OID();
                    variableBindingArray[i] = new VariableBinding();
                    variableBindingArray[i].setOid(oID);
                }
                break;
            }
            default: {
                variableBindingArray = this._$31985();
            }
        }
        this._$4276.addAll(variableBindingArray);
        if (n == -91) {
            this._$4276.setMaxRepetitions(1);
        }
        this.observer.request(n, this._$4276, this._$4262, this._$773, null, this, null);
    }

    private int _$4419(int n, int n2) {
        return n;
    }

    private int _$29694(int n, int n2) {
        return n2;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        try {
            int n = this._$4419(jCCellDisplayEvent.getRow(), jCCellDisplayEvent.getColumn());
            int n2 = this._$29694(jCCellDisplayEvent.getRow(), jCCellDisplayEvent.getColumn());
            if (n == -1 || jCCellDisplayEvent.getDisplayData() == null) {
                return;
            }
            switch (n2) {
                case 0: {
                    ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                    String string = this._$18643.getObjectName(objectID);
                    if (string == null) {
                        string = this._$18643.getPathSuffix(objectID);
                    }
                    if (string == null) break;
                    jCCellDisplayEvent.setDisplayData(string);
                    break;
                }
                case 1: {
                    int n3 = (Integer)jCCellDisplayEvent.getDisplayData();
                    String string = ValueConverter.getExceptionString(n3);
                    if (string == null) {
                        string = SMI.SMI_SYNTAX[n3];
                    }
                    jCCellDisplayEvent.setDisplayData(string);
                    break;
                }
                case 2: {
                    ValueConverter valueConverter = (ValueConverter)this._$4260.getTableDataItem(n, 3);
                    if (valueConverter != null && valueConverter.getEffectiveSyntax() != null && valueConverter.getEffectiveSyntax().hasEnums()) {
                        if (!(jCCellDisplayEvent.getDisplayData() instanceof Integer)) break;
                        Integer n4 = (Integer)jCCellDisplayEvent.getDisplayData();
                        if (n4 == null) {
                            return;
                        }
                        MIBEnum mIBEnum = valueConverter.getEffectiveSyntax().getEnum(n4.intValue());
                        if (mIBEnum != null) {
                            jCCellDisplayEvent.setDisplayData(mIBEnum.toString());
                        }
                    } else {
                        if (valueConverter != null && valueConverter.getSMISyntax() == 11 && jCCellDisplayEvent.getCellData() instanceof Long) {
                            jCCellDisplayEvent.setDisplayData(new TimeTicks((Long)jCCellDisplayEvent.getCellData()).toString());
                            break;
                        }
                        if (jCCellDisplayEvent.getDisplayData() instanceof ComparableIpAddress || this._$29665 || !(jCCellDisplayEvent.getDisplayData() instanceof ObjectID) || valueConverter == null || valueConverter.getSMISyntax() != 2) break;
                        ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                        String string = this._$18643.getObjectName(objectID);
                        if (string == null) {
                            string = this._$18643.getPathSuffix(objectID);
                        }
                        if (string != null) {
                            jCCellDisplayEvent.setDisplayData(string);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JCTableCellInfo _$29697(int n, int n2) {
        JCTableCellInfo jCTableCellInfo = new JCTableCellInfo();
        jCTableCellInfo.initialize(this._$4160, this._$4260.getTableDataItem(n, n2), n, n2, this._$4160.getCellStyle(n2, n));
        return jCTableCellInfo;
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
        int n;
        int n2 = this._$4419(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n3 = this._$29694(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        if (n3 == 1 && (n = ((Integer)this._$4260.getTableDataItem(n2, n3)).intValue()) < 0) {
            this._$4260.setTableDataItem(new Integer(1), n2, n3);
        }
        this._$29663 = new CellEdit(this._$29697(n2, n3), this._$4260.getTableDataItem(n2, n3), null);
        if (this.isPeriodicRefreshEnabled()) {
            this.stopTimer();
        }
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        int n = this._$4419(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n2 = this._$29694(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        if (!jCEditCellEvent.isCancelled() && n2 == 1) {
            int n3 = (Integer)this._$4260.getTableDataItem(n, n2);
            ValueConverter valueConverter = new ValueConverter(n3);
            this._$4260.setTableDataItem(valueConverter, n, 3);
            this._$4260.setTableDataItem(valueConverter.getNativeExample(), n, 2);
            JCCellStyle jCCellStyle = new JCCellStyle(this._$29667);
            jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, this._$18643));
            this._$4625(n, 2, jCCellStyle);
        }
        this._$29663.setNewValue(this._$4260.getTableDataItem(n, n2));
        this._$29661.addEdit(this._$29663);
        this.updateButtons();
    }

    public static ValueConverter[] makeVCsFromModel(JCEditableVectorDataSource jCEditableVectorDataSource) {
        ValueConverter[] valueConverterArray = new ValueConverter[jCEditableVectorDataSource.getNumRows() - 1];
        for (int i = 0; i < valueConverterArray.length; ++i) {
            valueConverterArray[i] = (ValueConverter)jCEditableVectorDataSource.getTableDataItem(i + 1, 3);
        }
        return valueConverterArray;
    }

    public static VariableBinding[] makeVBsFromModel(JCEditableVectorDataSource jCEditableVectorDataSource) {
        VariableBinding[] variableBindingArray = new VariableBinding[jCEditableVectorDataSource.getNumRows() - 1];
        for (int i = 0; i < variableBindingArray.length; ++i) {
            variableBindingArray[i] = new VariableBinding();
            variableBindingArray[i].setOid(new OID(jCEditableVectorDataSource.getTableDataItem(i + 1, 0).toString()));
            ValueConverter valueConverter = (ValueConverter)jCEditableVectorDataSource.getTableDataItem(i + 1, 3);
            Variable variable = null;
            if (valueConverter != null) {
                variable = valueConverter.fromNative(jCEditableVectorDataSource.getTableDataItem(i + 1, 2));
            }
            if (variable == null) {
                variableBindingArray[i].setVariable(new Null());
                continue;
            }
            variableBindingArray[i].setVariable(variable);
        }
        return variableBindingArray;
    }

    private VariableBinding[] _$31985() {
        return MultiVariablePanel.makeVBsFromModel(this._$4260);
    }

    public void commitChanges() {
        this._$4160.commitEdit(true);
        this._$773 = this._$4262.getTarget();
        this._$4276 = this._$4262.makePDU();
        this._$4276.addAll(this._$31985());
        this.observer.request(-93, this._$4276, this._$4262, this._$773, null, this, null);
    }

    private Vector _$22591() {
        Vector<Object> vector = new Vector<Object>(TITLES.length);
        vector.addElement(new ObjectID());
        vector.addElement(new Integer(1));
        vector.addElement(new String());
        vector.addElement(new ValueConverter(1));
        return vector;
    }

    void jButtonNewRow_actionPerformed(ActionEvent actionEvent) {
        if (!this._$4160.commitEdit(true)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Vector vector = this._$22591();
        int n = TableUtils.getFirstSelectedRow(this._$4160);
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        this._$4260.addRow(n, new Integer(this._$4260.getNumRows()), vector);
        if (n == Integer.MAX_VALUE) {
            n = this._$4260.getNumRows() - 1;
        }
        this._$17830(n);
        this._$29661.addEdit(new RowAddEdit(n, true, vector));
        this.updateButtons();
    }

    void jButtonCopyRow_actionPerformed(ActionEvent actionEvent) {
        if (!this._$4160.commitEdit(true)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Vector vector = this._$22591();
        int n = TableUtils.getFirstSelectedRow(this._$4160);
        if (n == -1) {
            return;
        }
        ObjectID objectID = new ObjectID((ObjectID)this._$4260.getTableDataItem(n, 0));
        Integer n2 = new Integer((Integer)this._$4260.getTableDataItem(n, 1));
        ValueConverter valueConverter = new ValueConverter((ValueConverter)this._$4260.getTableDataItem(n, 3));
        Object object = valueConverter.toNative(valueConverter.fromNative(this._$4260.getTableDataItem(n, 2)));
        vector.set(0, objectID);
        vector.set(1, n2);
        vector.set(2, object);
        vector.set(3, valueConverter);
        if (++n >= this._$4260.getNumRows()) {
            n = Integer.MAX_VALUE;
        }
        this._$4260.addRow(n, new Integer(this._$4260.getNumRows()), vector);
        if (n == Integer.MAX_VALUE) {
            n = this._$4260.getNumRows() - 1;
        }
        this._$17830(n);
        this._$29661.addEdit(new RowAddEdit(n, true, vector));
        this.updateButtons();
        this._$4160.setRowSelection(n, n);
        this._$4160.setCurrentCell(n, 2);
    }

    private void _$17830(int n) {
        for (int i = n; i < this._$4260.getNumRows(); ++i) {
            this._$4260.setRowLabel(i, new Integer(i));
        }
    }

    public void traverse(int n, int n2, boolean bl, boolean bl2) {
        this._$4160.traverse(n, n2, bl, bl2);
    }

    void jButtonRefresh_actionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    public void resendRequest(ResponseEvent responseEvent, ResponseListener responseListener) {
        VariableBinding[] variableBindingArray = (VariableBinding[])responseEvent.getRequest().getVariableBindings().toArray();
        int n = variableBindingArray.length / 2;
        VariableBinding[][] variableBindingArrayArray = new VariableBinding[2][];
        Vector[] vectorArray = new Vector[2];
        if (responseEvent.getUserObject() instanceof Vector) {
            vectorArray[0] = new Vector(n + 1);
            vectorArray[1] = new Vector(n + 1);
            Vector vector = (Vector)responseEvent.getUserObject();
            for (int i = 0; i < vector.size(); ++i) {
                if (i < n) {
                    vectorArray[0].addElement(vector.elementAt(i));
                    continue;
                }
                vectorArray[1].addElement(vector.elementAt(i));
            }
        }
        variableBindingArrayArray[0] = new VariableBinding[n];
        variableBindingArrayArray[1] = new VariableBinding[variableBindingArray.length - n];
        System.arraycopy(variableBindingArray, 0, variableBindingArrayArray[0], 0, n);
        System.arraycopy(variableBindingArray, n, variableBindingArrayArray[1], 0, variableBindingArray.length - n);
        try {
            block7: for (int i = 0; i < variableBindingArrayArray.length; ++i) {
                responseEvent.getRequest().clear();
                responseEvent.getRequest().addAll(variableBindingArrayArray[i]);
                switch (responseEvent.getRequest().getType()) {
                    case -91: {
                        this._$4261.getBulk(responseEvent.getRequest(), this._$773, vectorArray[i], responseListener);
                        continue block7;
                    }
                    case -93: {
                        this._$4261.set(responseEvent.getRequest(), this._$773, responseEvent.getUserObject(), responseListener);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void undo() {
        this._$4160.cancelEdit(true);
        this._$29661.undo();
        this.updateButtons();
    }

    public void redo() {
        this._$4160.cancelEdit(true);
        this._$29661.redo();
        this.updateButtons();
    }

    void jButtonUndo_actionPerformed(ActionEvent actionEvent) {
        this.undo();
    }

    void jButtonRedo_actionPerformed(ActionEvent actionEvent) {
        this.redo();
    }

    public void updateButtons() {
        this.jButtonNewRow.setEnabled(true);
        this.jButtonCopyRow.setEnabled(TableUtils.getFirstSelectedRow(this._$4160) != -1);
        this.jButtonUndo.setEnabled(this._$29661.canUndo());
        this.jButtonRedo.setEnabled(this._$29661.canRedo());
        this.jButtonApply.setEnabled(this._$4260.getNumRows() > 1);
        Collection collection = this._$4160.getSelectedCells();
        if (collection == null || collection.size() == 0) {
            this.jButtonDeleteRow.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
            this.jButtonMoveUp.setEnabled(false);
        } else {
            this.jButtonDeleteRow.setEnabled(true);
            JCCellRange jCCellRange = (JCCellRange)collection.iterator().next();
            TableUtils.setRangeAfterCopy(jCCellRange);
            if (jCCellRange.start_row > 1) {
                this.jButtonMoveUp.setEnabled(true);
            } else {
                this.jButtonMoveUp.setEnabled(false);
            }
            if (jCCellRange.end_row < this._$4260.getNumRows() - 1) {
                this.jButtonMoveDown.setEnabled(true);
            } else {
                this.jButtonMoveDown.setEnabled(false);
            }
        }
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        if (jCValueEvent.getSource() == this._$29899) {
            if (this._$4297 != null) {
                this._$4297.cancel();
            }
            this.runTimer();
        }
    }

    public boolean isRunning() {
        return this.isPeriodicRefreshEnabled();
    }

    public synchronized void runTimer() {
        this.fireActionPerformed(new ActionEvent(this, 1001, "Running"));
        this._$4297 = new Timer();
        Long l = (Long)this._$29899.getValue();
        long l2 = l * 10L * (long)this._$29904;
        if (l2 > 0L) {
            this._$29905 = true;
            this._$4297.schedule((TimerTask)new PeriodicRefresh(this._$29904), l2, l2);
        }
        this._$25240();
    }

    private void _$25240() {
        this.jButtonPlay.setEnabled(!this._$29905);
        this.jButtonPause.setEnabled(this._$29905);
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    protected MultiVariablePanel getPanel() {
        return this;
    }

    void jButtonPause_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
    }

    void jButtonPlay_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
        this.runTimer();
    }

    public void setPeriodicRefreshStepping(int n) {
        this._$29904 = n;
    }

    public int getPeriodicRefreshStepping() {
        return this._$29904;
    }

    public boolean isPeriodicRefreshEnabled() {
        return this._$29905;
    }

    public void setDisplayOID(boolean bl) {
        this._$29665 = bl;
    }

    public boolean isDisplayOID() {
        return this._$29665;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Serializable serializable;
            Serializable serializable2;
            ObjectID objectID;
            MIBObject mIBObject;
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Point point = dropTargetDropEvent.getLocation();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object = transferable.getTransferData(DraggableTreeNode.supported[0]);
            if (object == null || !(object instanceof MIBObject) && !(object instanceof MIBInstance)) {
                this.observer.setMessage("Invalid drag source!");
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            this._$4160.cancelEdit(true);
            Object object2 = object;
            ValueConverter valueConverter = null;
            boolean bl = false;
            if (object instanceof MIBInstance) {
                mIBObject = ((MIBInstance)object2).getObjectClass();
                objectID = new ObjectID(((MIBInstance)object2).getOid().toString());
                valueConverter = ((MIBInstance)object2).getValueConverter();
                bl = true;
            } else {
                mIBObject = (MIBObject)object2;
                objectID = mIBObject.getOid();
                if (mIBObject instanceof MIBObjectType && (((MIBObjectType)(serializable2 = (MIBObjectType)mIBObject)).isColumnarObject() || ((MIBObjectType)serializable2).isScalar())) {
                    bl = !((MIBObjectType)serializable2).isColumnarObject();
                    serializable = this._$18643.getEffectiveSyntax(((MIBObjectType)serializable2).getSyntax());
                    valueConverter = new ValueConverter((MIBObjectType)serializable2, ((MIBTextualConvention)serializable).getSyntax(), ((MIBTextualConvention)serializable).getDisplayHint());
                }
            }
            serializable2 = this._$4160.getCellAreaHandler().findByType(0);
            serializable = this._$4160.XYToCell(point.x + ((CellArea)serializable2).getStandardOffsetX(), point.y + ((CellArea)serializable2).getStandardOffsetY());
            ValueConverter valueConverter2 = (ValueConverter)this._$4160.getDataView().getTableDataItem(((JCCellPosition)serializable).row, 3);
            if (((JCCellPosition)serializable).row > 0 && ((JCCellPosition)serializable).row < this._$4260.getNumRows() && (((JCCellPosition)serializable).column == 0 && valueConverter2.getObjectType() == null || ((JCCellPosition)serializable).column == 2 && this._$4160.getDataView().getTableDataItem(((JCCellPosition)serializable).row, 2) instanceof ObjectID)) {
                Object object3 = this._$4160.getDataView().getTableDataItem(((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column);
                CellEdit cellEdit = new CellEdit(this._$29697(((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column), object3, objectID);
                this._$29661.addEdit(cellEdit);
                this._$4160.getDataView().setTableDataItem(objectID, ((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column);
            } else {
                Vector<Object> vector = new Vector<Object>(TITLES.length);
                if (object instanceof MIBInstance) {
                    vector.addElement(new ObjectID(((MIBInstance)object2).getOid().toString()));
                    if (valueConverter == null) {
                        valueConverter = new ValueConverter(((MIBInstance)object).getValue().getClass());
                    }
                    vector.addElement(new Integer(valueConverter.getSMISyntax()));
                    vector.addElement(valueConverter.toNative(((MIBInstance)object2).getValue()));
                    vector.addElement(valueConverter);
                } else {
                    if (object instanceof MIBNotifyType) {
                        this._$4260.deleteRows(1, this._$4260.getNumRows() - 1);
                        this.addTrapObjects(System.currentTimeMillis() - PDUTabbedPanel.applicationStart);
                        MIBNotifyType mIBNotifyType = (MIBNotifyType)object;
                        this._$4260.setTableDataItem(new ObjectID(mIBNotifyType.getOid()), 2, 2);
                        if (mIBNotifyType.hasVariables()) {
                            Enumeration enumeration = mIBNotifyType.getVariablesVector().elements();
                            while (enumeration.hasMoreElements()) {
                                vector = new Vector(TITLES.length);
                                String string = (String)enumeration.nextElement();
                                String string2 = this._$18643.getModuleName(mIBNotifyType.getModuleID());
                                MIBObject mIBObject2 = this._$18643.getScopedObject(string2, string);
                                if (mIBObject2 == null || !(mIBObject2 instanceof MIBObjectType)) continue;
                                MIBObjectType mIBObjectType = (MIBObjectType)mIBObject2;
                                vector.add(new ObjectID(mIBObjectType.getOid()));
                                MIBTextualConvention mIBTextualConvention = this._$18643.getEffectiveSyntax(mIBObjectType.getSyntax());
                                valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
                                vector.add(new Integer(valueConverter.getSMISyntax()));
                                Variable variable = ValueConverter.getDefaultValue(this._$18643, valueConverter.getObjectType(), valueConverter.getEffectiveSyntax());
                                if (variable != null) {
                                    vector.addElement(valueConverter.toNative(variable));
                                } else {
                                    vector.addElement(valueConverter.getNativeExample());
                                }
                                vector.add(valueConverter);
                                this._$4260.addRow(Integer.MAX_VALUE, new Integer(this._$4260.getNumRows()), vector);
                                this.setReadOnly(this._$4260.getNumRows() - 1, true);
                                this._$31990(this._$4260.getNumRows() - 1, false);
                                this._$29661.addEdit(new RowAddEdit(this._$4260.getNumRows() - 1, true, vector));
                            }
                        }
                        dropTargetDropEvent.dropComplete(true);
                        this.updateButtons();
                        return;
                    }
                    if (bl) {
                        vector.addElement(new ObjectID(mIBObject.getPrintableOid() + ".0"));
                    } else {
                        vector.addElement(mIBObject.getOid());
                    }
                    if (valueConverter == null) {
                        vector.addElement(new Integer(1));
                        vector.addElement(new String());
                    } else {
                        vector.addElement(new Integer(valueConverter.getSMISyntax()));
                        Variable variable = ValueConverter.getDefaultValue(this._$18643, valueConverter.getObjectType(), valueConverter.getEffectiveSyntax());
                        if (variable != null) {
                            vector.addElement(valueConverter.toNative(variable));
                        } else {
                            vector.addElement(valueConverter.getNativeExample());
                        }
                        vector.addElement(valueConverter);
                    }
                }
                this._$4260.addRow(Integer.MAX_VALUE, new Integer(this._$4260.getNumRows()), vector);
                if (bl) {
                    this.setReadOnly(this._$4260.getNumRows() - 1, true);
                }
                this._$31990(this._$4260.getNumRows() - 1, false);
                this._$29661.addEdit(new RowAddEdit(this._$4260.getNumRows() - 1, true, vector));
            }
            dropTargetDropEvent.dropComplete(true);
            this.updateButtons();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public JCTable getTable() {
        return this._$4160;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = dropTargetDragEvent.isDataFlavorSupported(DraggableTreeNode.supported[0]);
        int n = dropTargetDragEvent.getDropAction();
        if (bl && (n & 3) > 0) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    void jButtonDeleteRow_actionPerformed(ActionEvent actionEvent) {
        int n;
        Collection collection = this._$4160.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (n = 0; n < jCCellRangeArray.length; ++n) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[n]);
        }
        for (n = 0; n < jCCellRangeArray.length; ++n) {
            Vector vector;
            if (jCCellRangeArray[n].start_row >= this._$4260.getNumRows()) continue;
            Vector<Vector> vector2 = new Vector<Vector>();
            for (int i = jCCellRangeArray[n].start_row; i <= jCCellRangeArray[n].end_row; ++i) {
                vector = new Vector();
                vector.addElement(new Integer(i));
                for (int j = 0; j <= this._$4260.getNumColumns(); ++j) {
                    vector.addElement(this._$4260.getTableDataItem(i, j));
                }
                vector2.addElement(vector);
            }
            this._$4260.deleteRows(jCCellRangeArray[n].start_row, jCCellRangeArray[n].end_row - jCCellRangeArray[n].start_row + 1);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                vector = (Vector)enumeration.nextElement();
                Object e = vector.firstElement();
                vector.removeElementAt(0);
                this._$29661.addEdit(new RowAddEdit((Integer)e, false, vector));
            }
        }
        this._$17830(1);
        this.updateButtons();
    }

    public Object getData() {
        return this._$4260;
    }

    public void setData(Object object) {
        this._$4260 = (JCEditableVectorDataSource)object;
        this._$4260.setColumnLabels(TITLES);
        this._$4160.setDataSource(this._$4260);
        for (int i = 1; i < this._$4260.getNumRows(); ++i) {
            this._$31990(i, true);
        }
        this.updateButtons();
        this._$31967();
    }

    public void setReadOnly(int n, boolean bl) {
        for (int i = 0; i < 2; ++i) {
            if (bl) {
                JCCellStyle jCCellStyle = new JCCellStyle(this._$4160.getCellStyle(n, i));
                jCCellStyle.setEditable(false);
                jCCellStyle.setBackground(Color.lightGray);
                jCCellStyle.setForeground(Color.black);
                this._$4160.setCellStyle(n, i, jCCellStyle);
                continue;
            }
            if (i != 1) {
                this._$4625(n, i, this._$29667);
                continue;
            }
            this._$4625(n, i, this._$29909);
        }
    }

    private void _$31990(int n, boolean bl) {
        ValueConverter valueConverter = (ValueConverter)this._$4260.getTableDataItem(n, 3);
        if (bl && valueConverter != null && valueConverter.getObjectType() != null) {
            this.setReadOnly(n, true);
        }
        if (valueConverter != null) {
            JCCellStyle jCCellStyle = new JCCellStyle(this._$29667);
            jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, this._$18643));
            this._$4625(n, 2, jCCellStyle);
        }
    }

    void jButtonMultiSet_actionPerformed(ActionEvent actionEvent) {
        VariableBinding[] variableBindingArray = this._$31985();
        if (variableBindingArray.length == 0) {
            return;
        }
        SelectTargetsPanel selectTargetsPanel = new SelectTargetsPanel(this._$4957);
        selectTargetsPanel.moveTargetL2R(this._$4262);
        StandardDialog standardDialog = new StandardDialog(this._$18902, "Send PDU To Multiple Targets", true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)selectTargetsPanel, "Center");
        PDUTypePanel pDUTypePanel = new PDUTypePanel(MultiPDUDialog.isValidTrapPDU(variableBindingArray));
        pDUTypePanel.setMaxVbs(variableBindingArray.length);
        pDUTypePanel.setSelectedItem(this._$31953.getSelectedItem());
        jPanel.add((Component)pDUTypePanel, "South");
        standardDialog.setCenterPanel(jPanel);
        standardDialog.setLocationRelativeTo(this._$18902);
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            List<GenTarget> list = selectTargetsPanel.getSelectedTargets();
            if (list.size() == 0) {
                JOptionPane.showMessageDialog(this._$18902, "No targets have been selected!", "Nothing To Do", 0);
                return;
            }
            String string = pDUTypePanel.getSelectedType();
            MultiPDUDialog multiPDUDialog = new MultiPDUDialog(this._$18902, string + " PDU Results", true, list, this._$4261, variableBindingArray, MultiPDUDialog.PDU_IDS[pDUTypePanel.getSelectedIndex()], this._$18643, pDUTypePanel.getNonRepeaters(), pDUTypePanel.getMaxRepetitions());
            multiPDUDialog.setSize(640, 400);
            multiPDUDialog.setLocationRelativeTo(this._$18902);
            multiPDUDialog.setVisible(true);
        }
    }

    void jToggleButtonExport_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            JFileChooser jFileChooser = new JFileChooser(new File(this._$4288.get("mibexplorer.LogPath", "")));
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.setDescription("Comma Separated Values");
            jFileChooser.setFileFilter(exampleFileFilter);
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showSaveDialog(this._$18902) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".CSV")) {
                    file = new File(file.getParentFile(), file.getName() + ".csv");
                }
                this._$4288.put("mibexplorer.LogPath", jFileChooser.getSelectedFile().getParent());
                if (file.exists()) {
                    Object[] objectArray = new Object[]{"Overwrite", "Append", "Cancel"};
                    int n = JOptionPane.showOptionDialog(this._$18902, "File already exists. Overwrite it?", "Log File", 1, 3, null, objectArray, objectArray[1]);
                    if (n == 2) {
                        this._$29896 = null;
                        this.jToggleButtonExport.setSelected(false);
                        return;
                    }
                    this._$29897 = n != 0;
                }
                this._$29896 = file;
                if (this.isPeriodicRefreshEnabled()) {
                    this.stopTimer();
                    this.runTimer();
                } else {
                    this.refresh();
                }
            } else {
                this._$29896 = null;
                this.jToggleButtonExport.setSelected(false);
            }
        } else {
            this._$29896 = null;
        }
    }

    private String _$32012() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"Time\"");
        for (int i = 1; i < this._$4260.getNumRows(); ++i) {
            stringBuffer.append(",\"");
            stringBuffer.append(this._$4260.getTableDataItem(i, 0));
            stringBuffer.append('\"');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public synchronized void saveTableToFile(File file, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file.getPath(), bl));
        if (!bl) {
            bufferedOutputStream.write(this._$32012().getBytes());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        String string = simpleDateFormat.format(new Date());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        for (int i = 1; i < this._$4260.getNumRows(); ++i) {
            stringBuffer.append(",\"");
            stringBuffer.append(this._$4260.getTableDataItem(i, 2));
            stringBuffer.append('\"');
        }
        stringBuffer.append('\n');
        bufferedOutputStream.write(stringBuffer.toString().getBytes());
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public void addTrapObjects(long l) {
        Vector<Object> vector = new Vector<Object>(3);
        ObjectID objectID = new ObjectID(SnmpConstants.sysUpTime.toString());
        vector.addElement(objectID);
        vector.addElement(new Integer(11));
        vector.addElement(new Long(l));
        ValueConverter valueConverter = new ValueConverter(new MIBObjectType(objectID, "sysUpTime", new Integer(-1)), new MIBSyntax(SMI.SMI_SYNTAX[11], 0), null);
        vector.addElement(valueConverter);
        this._$4260.addRow(1, new Integer(1), vector);
        this.setReadOnly(1, true);
        this._$17830(1);
        vector = new Vector(3);
        ObjectID objectID2 = new ObjectID(SnmpConstants.snmpTrapOID.toString());
        vector.addElement(objectID2);
        vector.addElement(new Integer(2));
        vector.addElement(new ObjectID());
        valueConverter = new ValueConverter(new MIBObjectType(objectID2, "snmpTrapOid", new Integer(-1)), new MIBSyntax(SMI.SMI_SYNTAX[2], 0), null);
        vector.addElement(valueConverter);
        this._$4260.addRow(2, new Integer(2), vector);
        this.setReadOnly(2, true);
        this._$17830(2);
        this._$31967();
        this._$31963(MultiPDUDialog.PDU_TYPES);
    }

    private int _$31984() {
        String string = (String)this._$31953.getSelectedItem();
        if ("TRAP".equals(string)) {
            return -89;
        }
        return PDU.getTypeFromString(string);
    }

    void jButtonMoveUp_actionPerformed(ActionEvent actionEvent) {
        int n;
        Collection collection = this._$4160.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (n = 0; n < jCCellRangeArray.length; ++n) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[n]);
        }
        for (n = 0; n < jCCellRangeArray.length; ++n) {
            if (jCCellRangeArray[n].start_row <= 1) continue;
            this._$29661.addEdit(new RowMoveMV(jCCellRangeArray[n].start_row, jCCellRangeArray[n].end_row - jCCellRangeArray[n].start_row + 1, -1));
        }
        this.updateButtons();
    }

    void jButtonMoveDown_actionPerformed(ActionEvent actionEvent) {
        int n;
        Collection collection = this._$4160.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (n = 0; n < jCCellRangeArray.length; ++n) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[n]);
        }
        for (n = 0; n < jCCellRangeArray.length; ++n) {
            if (jCCellRangeArray[n].end_row == this._$4260.getNumRows() - 1) continue;
            this._$29661.addEdit(new RowMoveMV(jCCellRangeArray[n].start_row, jCCellRangeArray[n].end_row - jCCellRangeArray[n].start_row + 1, 1));
        }
        this.updateButtons();
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getStartColumn() == -1) {
            this.traverse(jCSelectEvent.getStartRow(), 0, false, false);
        }
        if (jCSelectEvent.getStartRow() == -1) {
            this.traverse(0, jCSelectEvent.getStartColumn(), false, false);
        }
        this.updateButtons();
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void setMessage(String string) {
        this.observer.setMessage(string);
    }

    public boolean isChanged() {
        return this._$29661.canUndo();
    }

    public void setTitle(String string) {
        this._$4364 = string;
        this.jToolBar1.setName("PDU Main Tool Bar of " + this._$4364);
        this.jToolBarRefresh.setName("PDU Refresh Tool Bar of " + this._$4364);
    }

    public String getTitle() {
        return this._$4364;
    }

    void jButtonZoomOut_actionPerformed(ActionEvent actionEvent) {
        this.jButtonZoomIn.setEnabled(true);
        this.jButtonZoomOut.setEnabled(false);
        this.fireLinkComponent(new ComponentLinkEvent(this, this.getPanel(), this._$4364));
        this.getPanel().updateButtons();
        this.f.dispose();
        this.f = null;
    }

    void jButtonZoomIn_actionPerformed(ActionEvent actionEvent) {
        this.jButtonZoomIn.setEnabled(false);
        this.jButtonZoomOut.setEnabled(true);
        this.fireUnlinkComponent(new ComponentLinkEvent(this, this, this.getTitle()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MultiVariablePanel.this.f = new StandardFrame(false){

                    public boolean cancel() {
                        ComponentLinkEvent componentLinkEvent = new ComponentLinkEvent(this, MultiVariablePanel.this, MultiVariablePanel.this._$4364);
                        MultiVariablePanel.this.fireUnlinkComponent(componentLinkEvent);
                        return componentLinkEvent.isAccepted();
                    }
                };
                MultiVariablePanel.this.f.addWindowListener((WindowListener)((Object)MultiVariablePanel.this._$18902));
                MultiVariablePanel.this.f.setIconImage(MIBExplorerFrame.explorerIcon);
                MultiVariablePanel.this.f.setTitle(MultiVariablePanel.this.getTitle());
                MultiVariablePanel.this.setVisible(true);
                MultiVariablePanel.this.f.setPanel(MultiVariablePanel.this.getPanel());
                MultiVariablePanel.this.revalidate();
                MultiVariablePanel.this.repaint();
                MIBExplorerFrame.centerFrame(MultiVariablePanel.this.f);
                MultiVariablePanel.this.f.setVisible(true);
            }
        });
    }

    public synchronized void removeComponentLinkListener(ComponentLinkListener componentLinkListener) {
        if (this._$29914 != null && this._$29914.contains(componentLinkListener)) {
            Vector vector = (Vector)this._$29914.clone();
            vector.removeElement(componentLinkListener);
            this._$29914 = vector;
        }
    }

    public synchronized void addComponentLinkListener(ComponentLinkListener componentLinkListener) {
        Vector vector;
        Vector vector2 = vector = this._$29914 == null ? new Vector(2) : (Vector)this._$29914.clone();
        if (!vector.contains(componentLinkListener)) {
            vector.addElement(componentLinkListener);
            this._$29914 = vector;
        }
    }

    protected void fireUnlinkComponent(ComponentLinkEvent componentLinkEvent) {
        if (this._$29914 != null) {
            Vector vector = this._$29914;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ComponentLinkListener)vector.elementAt(i)).unlinkComponent(componentLinkEvent);
            }
        }
    }

    protected void fireLinkComponent(ComponentLinkEvent componentLinkEvent) {
        if (this._$29914 != null) {
            Vector vector = this._$29914;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ComponentLinkListener)vector.elementAt(i)).linkComponent(componentLinkEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 0) {
            JCCellPosition jCCellPosition = this._$4160.XYToCell(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (jCCellPosition == null || jCCellPosition.column != -1) {
                return;
            }
            ObjectID objectID = (ObjectID)this._$4260.getTableDataItem(jCCellPosition.row, 0);
            if (objectID == null) {
                objectID = new ObjectID();
            }
            try {
                Pair pair = this._$18643.getSplittedObjectID(objectID);
                if (pair.second == null) {
                    return;
                }
                MIBObject mIBObject = this._$18643.getObject((ObjectID)pair.first);
                if (mIBObject == null) {
                    return;
                }
                this.fireChangedMIBObject(new MIBObjectEvent(this, mIBObject, 0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized void removeMIBObjectListener(MIBObjectListener mIBObjectListener) {
        if (this._$29657 != null && this._$29657.contains(mIBObjectListener)) {
            Vector vector = (Vector)this._$29657.clone();
            vector.removeElement(mIBObjectListener);
            this._$29657 = vector;
        }
    }

    public synchronized void addMIBObjectListener(MIBObjectListener mIBObjectListener) {
        Vector vector;
        Vector vector2 = vector = this._$29657 == null ? new Vector(2) : (Vector)this._$29657.clone();
        if (!vector.contains(mIBObjectListener)) {
            vector.addElement(mIBObjectListener);
            this._$29657 = vector;
        }
    }

    protected void fireChangedMIBObject(MIBObjectEvent mIBObjectEvent) {
        if (this._$29657 != null) {
            Vector vector = this._$29657;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MIBObjectListener)vector.elementAt(i)).changedMIBObject(mIBObjectEvent);
            }
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this._$29933 != null && this._$29933.contains(actionListener)) {
            Vector vector = (Vector)this._$29933.clone();
            vector.removeElement(actionListener);
            this._$29933 = vector;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        Vector vector;
        Vector vector2 = vector = this._$29933 == null ? new Vector(2) : (Vector)this._$29933.clone();
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
            this._$29933 = vector;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this._$29933 != null) {
            Vector vector = this._$29933;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ActionListener)vector.elementAt(i)).actionPerformed(actionEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = TableUtils.getSelectedRows(this._$4160);
        if (actionEvent.getActionCommand().equals(ACTION_UNLOCK)) {
            for (int i = 0; i < nArray.length; ++i) {
                this.setReadOnly(nArray[i], false);
            }
        }
    }

    public void setFile(File file) {
        this._$18765 = file;
    }

    public File getFile() {
        return this._$18765;
    }

    class FormatAction
    extends AbstractAction {
        private String _$5168;

        public FormatAction(String string, String string2) {
            super(string);
            this._$5168 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = MultiVariablePanel.this._$4160.getPopupCellPosition();
            int n = MultiVariablePanel.this._$4419(jCCellPosition.row, jCCellPosition.column);
            ValueConverter valueConverter = (ValueConverter)MultiVariablePanel.this._$4260.getTableDataItem(n, 3);
            if (valueConverter != null) {
                MultiVariablePanel.this._$4160.commitEdit(true);
                Variable variable = valueConverter.fromNative(MultiVariablePanel.this._$4260.getTableDataItem(n, 2));
                if (this._$5168 == null) {
                    MIBObjectType mIBObjectType = valueConverter.getObjectType();
                    if (mIBObjectType != null) {
                        MIBTextualConvention mIBTextualConvention = MultiVariablePanel.this._$18643.getEffectiveSyntax(mIBObjectType.getSyntax());
                        if (mIBTextualConvention.getDisplayHint() != null) {
                            valueConverter.setDisplayHint(MIBObject.getUnquotedString(mIBTextualConvention.getDisplayHint()));
                        } else {
                            valueConverter.setDisplayHint(null);
                        }
                    } else {
                        valueConverter.setDisplayHint(null);
                    }
                } else {
                    valueConverter.setDisplayHint(this._$5168);
                }
                MultiVariablePanel.this._$4260.setTableDataItem(valueConverter.toNative(variable), n, 2);
            }
        }
    }

    class RequestListener
    implements ResponseListener {
        public ResponseEvent pduEvent = null;

        public void onResponse(ResponseEvent responseEvent) {
            this.pduEvent = responseEvent;
            responseEvent.getUserObject().notify();
        }
    }

    class RowMoveMV
    extends RowMove {
        private int _$4583;
        private int _$31992;
        private int _$22527;

        public RowMoveMV(int n, int n2, int n3) {
            super(MultiVariablePanel.this._$4160, MultiVariablePanel.this._$4260, n, n2, n3);
        }

        protected void renumberRows(int n) {
            MultiVariablePanel.this._$17830(n);
        }
    }

    class RowAddEdit
    extends AbstractUndoableEdit {
        private int _$4402;
        private boolean _$12164 = true;
        private Vector _$4418;

        public RowAddEdit(int n, boolean bl, Vector vector) {
            this._$4402 = n;
            this._$12164 = bl;
            this._$4418 = vector;
            if (bl) {
                MultiVariablePanel.this._$31967();
            }
        }

        public void undo() {
            super.undo();
            if (this._$12164) {
                if (!MultiVariablePanel.this._$4260.deleteRows(this._$4402, 1)) {
                    throw new CannotUndoException();
                }
                MultiVariablePanel.this._$17830(this._$4402);
            } else {
                if (!MultiVariablePanel.this._$4260.addRow(this._$4402, new Integer(this._$4402), this._$4418)) {
                    throw new CannotUndoException();
                }
                MultiVariablePanel.this._$31990(this._$4402, true);
                MultiVariablePanel.this._$17830(this._$4402);
            }
        }

        public void redo() {
            super.redo();
            if (this._$12164) {
                if (!MultiVariablePanel.this._$4260.addRow(this._$4402, new Integer(this._$4402), this._$4418)) {
                    throw new CannotRedoException();
                }
                MultiVariablePanel.this._$31990(this._$4402, true);
                MultiVariablePanel.this._$17830(this._$4402);
            } else {
                if (!MultiVariablePanel.this._$4260.deleteRows(this._$4402, 1)) {
                    throw new CannotRedoException();
                }
                MultiVariablePanel.this._$17830(this._$4402);
            }
        }
    }

    class CellEdit
    extends AbstractUndoableEdit {
        public JCTableCellInfo info;
        public Object oldValue;
        public Object newValue;
        public Object oldValueValue;

        public CellEdit(JCTableCellInfo jCTableCellInfo, Object object, Object object2) {
            this.info = jCTableCellInfo;
            this.oldValue = object;
            if (jCTableCellInfo.getColumn() == 1) {
                this.oldValueValue = MultiVariablePanel.this._$4260.getTableDataItem(jCTableCellInfo.getRow(), 2);
            }
            this.newValue = object2;
        }

        public void undo() {
            super.undo();
            if (!MultiVariablePanel.this._$4260.setTableDataItem(this.oldValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotUndoException();
            }
            if (this.info.getColumn() == 1) {
                int n = (Integer)MultiVariablePanel.this._$4260.getTableDataItem(this.info.getRow(), this.info.getColumn());
                ValueConverter valueConverter = new ValueConverter(n);
                MultiVariablePanel.this._$4260.setTableDataItem(valueConverter, this.info.getRow(), 3);
                MultiVariablePanel.this._$4260.setTableDataItem(this.oldValueValue, this.info.getRow(), 2);
                JCCellStyle jCCellStyle = new JCCellStyle(MultiVariablePanel.this._$29667);
                jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, MultiVariablePanel.this._$18643));
                MultiVariablePanel.this._$4625(this.info.getRow(), 2, jCCellStyle);
            }
            MultiVariablePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
        }

        public void redo() {
            super.redo();
            if (!MultiVariablePanel.this._$4260.setTableDataItem(this.newValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotRedoException();
            }
            if (this.info.getColumn() == 1) {
                int n = (Integer)MultiVariablePanel.this._$4260.getTableDataItem(this.info.getRow(), this.info.getColumn());
                ValueConverter valueConverter = new ValueConverter(n);
                MultiVariablePanel.this._$4260.setTableDataItem(valueConverter, this.info.getRow(), 3);
                MultiVariablePanel.this._$4260.setTableDataItem(valueConverter.getNativeExample(), this.info.getRow(), 2);
                JCCellStyle jCCellStyle = new JCCellStyle(MultiVariablePanel.this._$29667);
                jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, MultiVariablePanel.this._$18643));
                MultiVariablePanel.this._$4625(this.info.getRow(), 2, jCCellStyle);
            }
            MultiVariablePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
        }

        public void setNewValue(Object object) {
            this.newValue = object;
        }
    }

    class PeriodicRefresh
    extends TimerTask {
        private int _$29951 = 0;
        private int _$29952;

        public PeriodicRefresh(int n) {
            this._$29952 = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this._$29951 + this._$29952 < 100) {
                this._$29951 += this._$29952;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiVariablePanel.this.refresh();
                    }
                });
                MultiVariablePanel multiVariablePanel = MultiVariablePanel.this.getPanel();
                synchronized (multiVariablePanel) {
                    try {
                        MultiVariablePanel.this.getPanel().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._$29951 = 0;
            }
            MultiVariablePanel.this.jProgressBarTimer.setValue(this._$29951);
        }
    }
}

