/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ComponentLinkEvent;
import com.agentpp.common.ComponentLinkListener;
import com.agentpp.common.YesNoOption;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.ObserverTab;
import com.agentpp.explorer.TabbedControlledPanel;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.snmp4j.Snmp;

public abstract class MultiTabbedPanel
extends JPanel
implements ComponentLinkListener,
ObserverTab {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton jButtonOpen = new JButton();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton jButtonSave = new JButton();
    JButton jButtonSaveAs = new JButton();
    JTabbedPane jTabbedPane = new JTabbedPane();
    JButton jButtonClose = new JButton();
    protected UserConfigFile config;
    protected JFrame myFrame;
    protected Snmp session;
    protected GenTarget target;
    protected MIBRepository rep;
    protected RepositoryManager repMan;
    protected Hashtable targets;
    protected MIBObjectListener listener;
    JButton jButtonNew = new JButton();
    protected static long applicationStart = System.currentTimeMillis();
    protected Vector detached = new Vector();
    private String _$31017;
    private String[] _$31018;

    public MultiTabbedPanel(UserConfigFile userConfigFile, JFrame jFrame, MIBObjectListener mIBObjectListener, Snmp snmp, MIBRepository mIBRepository, RepositoryManager repositoryManager, Hashtable hashtable, String string, String[] stringArray) {
        this._$31018 = stringArray;
        this._$31017 = string;
        this.config = userConfigFile;
        this.myFrame = jFrame;
        this.listener = mIBObjectListener;
        this.session = snmp;
        this.rep = mIBRepository;
        this.repMan = repositoryManager;
        this.targets = hashtable;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateButtons();
    }

    public MultiTabbedPanel() {
        this(null, null, null, null, null, null, null, "", new String[]{""});
    }

    protected JPanel getPanel() {
        return this.jPanel1;
    }

    protected JTabbedPane getTabbedPane() {
        return this.jTabbedPane;
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.verticalFlowLayout1);
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Open16.gif");
        this.jButtonOpen.setIcon(new ImageIcon(uRL));
        this.jButtonOpen.setToolTipText("Load a " + this.getTypeString() + " from a previously saved " + this.getTypeString() + " file.");
        this.jButtonOpen.setHorizontalAlignment(2);
        this.jButtonOpen.setText("Open...");
        this.jButtonOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiTabbedPanel.this.openPanel();
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Save16.gif");
        this.jButtonSave.setIcon(new ImageIcon(uRL));
        this.jButtonSave.setToolTipText("Save current " + this.getTypeString());
        this.jButtonSave.setHorizontalAlignment(2);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiTabbedPanel.this.savePanel();
            }
        });
        this.jButtonSaveAs.setIcon(new ImageIcon(uRL));
        this.jButtonSaveAs.setToolTipText("Save current " + this.getTypeString() + " as a new file");
        this.jButtonSaveAs.setHorizontalAlignment(2);
        this.jButtonSaveAs.setText("Save As...");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiTabbedPanel.this.savePanelAs();
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Delete16.gif");
        this.jButtonClose.setIcon(new ImageIcon(uRL));
        this.jButtonClose.setToolTipText("Close current " + this.getTypeString());
        this.jButtonClose.setHorizontalAlignment(2);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiTabbedPanel.this.closePanel();
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/New16.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.jButtonNew.setIcon(imageIcon);
        this.jButtonNew.setToolTipText("Create a new " + this.getTypeString() + " panel");
        this.jButtonNew.setActionCommand("jButtonNew");
        this.jButtonNew.setHorizontalAlignment(2);
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiTabbedPanel.this.newPanel();
            }
        });
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.jButtonNew, null);
        this.jPanel1.add((Component)this.jButtonOpen, null);
        this.jPanel1.add((Component)this.jButtonSave, null);
        this.jPanel1.add((Component)this.jButtonSaveAs, null);
        this.jPanel1.add((Component)this.jButtonClose, null);
        this.add((Component)this.jTabbedPane, "Center");
    }

    public Object initDone(boolean bl) {
        return null;
    }

    protected abstract void loadData(TabbedControlledPanel var1, File var2) throws IOException, ClassNotFoundException;

    public void openPanel() {
        JFileChooser jFileChooser = new JFileChooser(this.config.get("mibexplorer.PDUPath", ""));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        String[] stringArray = this._$31027(exampleFileFilter);
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.config.put("mibexplorer.PDUPath", jFileChooser.getSelectedFile().getParent());
            try {
                String string = jFileChooser.getSelectedFile().getName();
                string = this.cutExtension(stringArray, string);
                this.openPanel(jFileChooser.getSelectedFile(), string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String[] stringArray2 = new String[]{"The selected file is not a " + this.getTypeString() + " file!"};
                JOptionPane.showMessageDialog(this.myFrame, stringArray2, "Invalid " + this.getTypeString() + " File", 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String[] stringArray3 = new String[]{"Could not load '" + jFileChooser.getSelectedFile() + "':", exception.getMessage()};
                JOptionPane.showMessageDialog(this.myFrame, stringArray3, "Open File Failed", 0);
            }
        }
    }

    protected TabbedControlledPanel openPanel(File file, String string) throws ClassNotFoundException, IOException {
        TabbedControlledPanel tabbedControlledPanel = this.createPanel();
        tabbedControlledPanel.setTarget(this.target);
        tabbedControlledPanel.addComponentLinkListener(this);
        tabbedControlledPanel.addActionListener(this);
        tabbedControlledPanel.addMIBObjectListener(this.listener);
        tabbedControlledPanel.setTitle(string);
        this.updateButtons();
        this.loadData(tabbedControlledPanel, file);
        this.jTabbedPane.addTab(string, tabbedControlledPanel);
        this.jTabbedPane.setSelectedComponent(tabbedControlledPanel);
        return tabbedControlledPanel;
    }

    protected String cutExtension(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = string.toUpperCase().indexOf(stringArray[i]);
            if (n <= 0) continue;
            string = string.substring(0, n);
            break;
        }
        return string;
    }

    private String[] _$31027(ExampleFileFilter exampleFileFilter) {
        String[] stringArray = this.getTypeExtensions();
        exampleFileFilter.setDescription("MIB Explorer " + this._$31017 + " Files");
        for (int i = 0; i < stringArray.length; ++i) {
            exampleFileFilter.addExtension(stringArray[i].toLowerCase().substring(1));
        }
        return stringArray;
    }

    public void savePanel() {
        if (this.jTabbedPane.getTabCount() == 0) {
            return;
        }
        this.save((TabbedControlledPanel)this.jTabbedPane.getSelectedComponent(), null);
    }

    public void savePanelAs() {
        if (this.jTabbedPane.getTabCount() == 0) {
            return;
        }
        this.saveAs((TabbedControlledPanel)this.jTabbedPane.getSelectedComponent(), null);
    }

    protected String extension() {
        return this.getTypeExtension().toLowerCase().substring(1);
    }

    public void setTrapProxy(TrapProxy trapProxy) {
    }

    public boolean saveAs(TabbedControlledPanel tabbedControlledPanel, YesNoOption[] yesNoOptionArray) {
        File file = new File(this.config.get("mibexplorer.PDUPath", ""), tabbedControlledPanel.getTitle() + this.getTypeExtension().toLowerCase());
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        String[] stringArray = this._$31027(exampleFileFilter);
        if (yesNoOptionArray == null || yesNoOptionArray[1].getOption() != 1) {
            JFileChooser jFileChooser = new JFileChooser(this.config.get("mibexplorer.PDUPath", ""));
            jFileChooser.setFileFilter(exampleFileFilter);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setSelectedFile(file);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                this.config.put("mibexplorer.PDUPath", jFileChooser.getSelectedFile().getParent());
                file = jFileChooser.getSelectedFile();
            } else {
                file = null;
            }
        }
        if (file != null) {
            try {
                file = this._$18811(file);
                if (Boolean.valueOf(this.config.get("mibexplorer.AskBeforeOverwritingFile", "true")).booleanValue() && file.exists() && (yesNoOptionArray == null || yesNoOptionArray[2].getOption() != 1)) {
                    int n = 3;
                    n = yesNoOptionArray == null ? YesNoOption.showYesNoOption(this, new String[]{"File '" + file.getPath() + "'", "already exists! Replace it?"}, "Confirm Replace", 3) : YesNoOption.showYesToAllCancelOption(this, new String[]{"File '" + file.getPath() + "'", "already exists! Replace it?"}, "Confirm Replace", 3, yesNoOptionArray[2]);
                    if (n == 2) {
                        return true;
                    }
                }
                this.saveData(tabbedControlledPanel, file);
                tabbedControlledPanel.setMessage("Saved " + this.getTypeString() + " to " + file.getPath());
                String string = file.getName();
                string = this.cutExtension(stringArray, string);
                if (this.jTabbedPane.getSelectedComponent() != null && this.jTabbedPane.getSelectedComponent().equals(tabbedControlledPanel)) {
                    this.jTabbedPane.setTitleAt(this.jTabbedPane.getSelectedIndex(), string);
                }
                tabbedControlledPanel.setTitle(string);
                tabbedControlledPanel.resetChangeManager();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String[] stringArray2 = new String[]{"Error while saving " + this.getTypeString() + " file:", exception.getMessage()};
                JOptionPane.showMessageDialog(this.myFrame, stringArray2, "IO Error", 0);
                return false;
            }
        }
        return false;
    }

    public boolean save(TabbedControlledPanel tabbedControlledPanel, YesNoOption[] yesNoOptionArray) {
        File file = tabbedControlledPanel.getFile();
        if (file == null) {
            return this.saveAs(tabbedControlledPanel, yesNoOptionArray);
        }
        try {
            if (Boolean.valueOf(this.config.get("mibexplorer.AskBeforeOverwritingFile", "true")).booleanValue() && file.exists() && (yesNoOptionArray == null || yesNoOptionArray[2].getOption() != 1)) {
                int n = 3;
                n = yesNoOptionArray == null ? YesNoOption.showYesNoOption(this, new String[]{"File '" + file.getPath() + "'", "already exists! Replace it?"}, "Confirm Replace", 3) : YesNoOption.showYesToAllCancelOption(this, new String[]{"File '" + file.getPath() + "'", "already exists! Replace it?"}, "Confirm Replace", 3, yesNoOptionArray[2]);
                if (n == 2) {
                    return true;
                }
            }
            this.saveData(tabbedControlledPanel, file);
            tabbedControlledPanel.setMessage("Saved " + this.getTypeString() + " to " + file.getPath());
            String string = file.getName();
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
            String[] stringArray = this._$31027(exampleFileFilter);
            string = this.cutExtension(stringArray, string);
            tabbedControlledPanel.resetChangeManager();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String[] stringArray = new String[]{"Error while saving " + this.getTypeString() + " file:", exception.getMessage()};
            JOptionPane.showMessageDialog(this.myFrame, stringArray, "IO Error", 0);
            return false;
        }
    }

    private File _$18811(File file) {
        String[] stringArray = this.getTypeExtensions();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!file.getName().toUpperCase().endsWith(stringArray[i])) continue;
            bl = false;
            break;
        }
        if (bl) {
            file = new File(file.getParentFile(), file.getName() + this.getTypeExtension().toLowerCase());
        }
        return file;
    }

    protected abstract void saveData(TabbedControlledPanel var1, File var2) throws IOException;

    public boolean close(TabbedControlledPanel tabbedControlledPanel, YesNoOption[] yesNoOptionArray) {
        if (tabbedControlledPanel.isRunning() && tabbedControlledPanel.isChanged() && (yesNoOptionArray == null || yesNoOptionArray[0].getOption() != 1)) {
            Object[] objectArray = new String[]{tabbedControlledPanel.getTitle() + " is currently busy! Closing it", "will stop its execution and collected data may", "get lost. Close " + tabbedControlledPanel.getTitle() + " anyway?"};
            int n = yesNoOptionArray == null ? YesNoOption.showYesNoCancelOption(this, objectArray, "Busy " + this.getTypeString(), 3) : YesNoOption.showYesToAllCancelOption(this, objectArray, "Busy " + this.getTypeString(), 3, yesNoOptionArray[0]);
            if (n == 3) {
                return false;
            }
        }
        tabbedControlledPanel.stopTimer();
        if (tabbedControlledPanel.isChanged()) {
            Object[] objectArray;
            int n = 1;
            if (yesNoOptionArray[1].getOption() != 1 && (n = YesNoOption.showYesToAllOption(this, objectArray = new String[]{"Do you want save changes made to " + tabbedControlledPanel.getTitle()}, "Unsaved " + this.getTypeString() + " Changes", 3, yesNoOptionArray[1])) == 3) {
                return false;
            }
            if (n != 2 && !this.save(tabbedControlledPanel, yesNoOptionArray)) {
                return false;
            }
        }
        this.jTabbedPane.remove(tabbedControlledPanel);
        tabbedControlledPanel.removeComponentLinkListener(this);
        tabbedControlledPanel.removeMIBObjectListener(this.listener);
        tabbedControlledPanel.removeActionListener(this);
        this.detached.remove(tabbedControlledPanel);
        this.updateButtons();
        return true;
    }

    public boolean closeAndSave(TabbedControlledPanel tabbedControlledPanel) {
        if (this.save(tabbedControlledPanel, null)) {
            this.jTabbedPane.remove(tabbedControlledPanel);
            tabbedControlledPanel.removeComponentLinkListener(this);
            tabbedControlledPanel.removeMIBObjectListener(this.listener);
            tabbedControlledPanel.removeActionListener(this);
            this.detached.remove(tabbedControlledPanel);
            this.updateButtons();
            return true;
        }
        return false;
    }

    public void closePanel() {
        if (this.jTabbedPane.getSelectedIndex() >= 0) {
            this.close((TabbedControlledPanel)this.jTabbedPane.getSelectedComponent(), this.createOptionSet());
        } else {
            this.updateButtons();
        }
    }

    public void setTargets(Hashtable hashtable) {
        this.targets = hashtable;
        for (int i = 0; i < this.jTabbedPane.getTabCount(); ++i) {
            TabbedControlledPanel tabbedControlledPanel = (TabbedControlledPanel)this.jTabbedPane.getComponentAt(i);
            tabbedControlledPanel.setTargets(hashtable);
        }
    }

    public void setTarget(GenTarget genTarget) {
        this.target = genTarget;
        for (int i = 0; i < this.jTabbedPane.getTabCount(); ++i) {
            TabbedControlledPanel tabbedControlledPanel = (TabbedControlledPanel)this.jTabbedPane.getComponentAt(i);
            tabbedControlledPanel.setTarget(genTarget);
        }
    }

    public void setConfig(UserConfigFile userConfigFile) {
        this.config = userConfigFile;
    }

    public UserConfigFile getConfig() {
        return this.config;
    }

    protected abstract TabbedControlledPanel createPanel();

    public void newPanel() {
        TabbedControlledPanel tabbedControlledPanel = this.createPanel();
        tabbedControlledPanel.setTarget(this.target);
        tabbedControlledPanel.addComponentLinkListener(this);
        tabbedControlledPanel.addActionListener(this);
        tabbedControlledPanel.addMIBObjectListener(this.listener);
        String string = this.getTypeString() + " " + (this.jTabbedPane.getComponentCount() + 1);
        this.jTabbedPane.addTab(string, tabbedControlledPanel);
        tabbedControlledPanel.setTitle(string);
        this.updateButtons();
        this.jTabbedPane.setSelectedComponent(tabbedControlledPanel);
    }

    protected void updateButtons() {
        if (this.jTabbedPane.getComponentCount() > 0) {
            this.jButtonClose.setEnabled(true);
            TabbedControlledPanel tabbedControlledPanel = (TabbedControlledPanel)this.jTabbedPane.getSelectedComponent();
            this.jButtonSave.setEnabled(tabbedControlledPanel.isChanged());
            this.jButtonSaveAs.setEnabled(true);
        } else {
            this.jButtonClose.setEnabled(false);
            this.jButtonSave.setEnabled(false);
            this.jButtonSaveAs.setEnabled(false);
        }
    }

    protected YesNoOption[] createOptionSet() {
        YesNoOption[] yesNoOptionArray = new YesNoOption[]{new YesNoOption(), new YesNoOption(), new YesNoOption()};
        return yesNoOptionArray;
    }

    public void unlinkComponent(ComponentLinkEvent componentLinkEvent) {
        boolean bl = false;
        for (int i = 0; i < this.jTabbedPane.getComponentCount(); ++i) {
            if (this.jTabbedPane.getComponentAt(i) != componentLinkEvent.getComponent()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.jTabbedPane.remove(componentLinkEvent.getComponent());
            this.detached.addElement(componentLinkEvent.getComponent());
        } else if (!this.close((TabbedControlledPanel)componentLinkEvent.getComponent(), null)) {
            componentLinkEvent.setAccepted(false);
        }
        this.updateButtons();
    }

    public void linkComponent(ComponentLinkEvent componentLinkEvent) {
        this.detached.removeElement(componentLinkEvent.getComponent());
        this.jTabbedPane.addTab(componentLinkEvent.getName(), componentLinkEvent.getComponent());
        this.jTabbedPane.setSelectedComponent(componentLinkEvent.getComponent());
        this.updateButtons();
    }

    public void updateButtons(ComponentLinkEvent componentLinkEvent) {
        this.updateButtons();
    }

    public void saveComponent(ComponentLinkEvent componentLinkEvent) {
        block3: {
            TabbedControlledPanel tabbedControlledPanel = (TabbedControlledPanel)componentLinkEvent.getComponent();
            File file = new File(this.config.get("mibexplorer.PDUPath", ""), tabbedControlledPanel.getTitle() + this.getTypeExtension().toLowerCase());
            if (componentLinkEvent.userObject != null && componentLinkEvent.userObject instanceof File) {
                file = (File)componentLinkEvent.userObject;
            }
            try {
                this.saveData(tabbedControlledPanel, file);
                componentLinkEvent.userObject = null;
            }
            catch (Exception exception) {
                componentLinkEvent.userObject = exception;
                if (componentLinkEvent.getLogger() == null) break block3;
                componentLinkEvent.getLogger().error("Could not save " + this.getTypeString() + " '" + tabbedControlledPanel.getTitle() + "' to '" + file.getPath() + "': " + exception.getMessage(), exception);
            }
        }
        this.updateButtons();
    }

    public boolean saveAll() {
        int n;
        YesNoOption[] yesNoOptionArray = this.createOptionSet();
        for (n = 0; n < this.jTabbedPane.getComponentCount(); ++n) {
            if (!this.close((TabbedControlledPanel)this.jTabbedPane.getComponentAt(n), yesNoOptionArray)) {
                return false;
            }
            --n;
        }
        for (n = 0; n < this.detached.size(); ++n) {
            if (!this.close((TabbedControlledPanel)this.detached.elementAt(n), yesNoOptionArray)) {
                return false;
            }
            --n;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getActionCommand().equals("Running")) {
            int n2 = this.jTabbedPane.indexOfComponent((Component)actionEvent.getSource());
            if (n2 >= 0) {
                this.jTabbedPane.setIconAt(this.jTabbedPane.indexOfComponent((Component)actionEvent.getSource()), MIBExplorerFrame.imagePlay16);
            }
        } else if (actionEvent.getActionCommand().equals("Stopped") && (n = this.jTabbedPane.indexOfComponent((Component)actionEvent.getSource())) >= 0) {
            this.jTabbedPane.setIconAt(n, null);
        }
    }

    public String getTypeString() {
        return this._$31017;
    }

    public void setTypeExtensions(String[] stringArray) {
        this._$31018 = stringArray;
    }

    public String getTypeExtension() {
        return this._$31018[0];
    }

    public String[] getTypeExtensions() {
        return this._$31018;
    }
}

