/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.StatusBar;
import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.snmp.GenTarget;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseListener;

public class MultiRequestObserver
implements RequestObserver,
StatusBar {
    private StatusBar _$29915;
    private Hashtable _$31364 = new Hashtable(20);
    private Snmp _$4261;

    public MultiRequestObserver(Snmp snmp) {
        this._$4261 = snmp;
    }

    public MultiRequestObserver(Snmp snmp, StatusBar statusBar) {
        this(snmp);
        this._$29915 = statusBar;
    }

    public void requestFinishedWithError(String string) {
        this.requestFinished();
        this.setMessage(string);
    }

    public synchronized void request(int n, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) throws IOException {
        if (target == null) {
            this.setMessage(genTarget.toString() + ": Timeout on engine ID discovery!");
            return;
        }
        try {
            this._$31364.put(pDU, responseListener);
            if (string == null) {
                String string2 = RequestObserverPanel.getRequestTypeString(n);
                if (string2 != null) {
                    this.setMessage("Sending " + string2 + " request to " + target.getAddress());
                }
            } else {
                this.setMessage(string);
            }
            switch (n) {
                case -91: {
                    this._$4261.getBulk(pDU, target, object, responseListener);
                    break;
                }
                case -96: {
                    this._$4261.get(pDU, target, object, responseListener);
                    break;
                }
                case -95: {
                    this._$4261.getNext(pDU, target, object, responseListener);
                    break;
                }
                case -93: {
                    this._$4261.set(pDU, target, object, responseListener);
                }
            }
            SnmpLogger.logRequest(pDU, genTarget);
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.fatal("Failed to send request: " + iOException.getMessage());
            this.setMessage("Failed to send request: " + iOException.getMessage());
            throw iOException;
        }
    }

    public void resendRequest(int n, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) throws IOException {
        this.request(n, pDU, genTarget, target, object, responseListener, string);
    }

    public String getMessage() {
        return this._$29915.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String string) {
        if (this._$29915 == null) {
            return;
        }
        StatusBar statusBar = this._$29915;
        synchronized (statusBar) {
            if (string != null && string.trim().length() > 0 && !string.endsWith(".") && !string.endsWith("!")) {
                string = string + ".";
            }
            this._$29915.setMessage(string);
        }
    }

    public synchronized void requestFinished() {
        this._$31364 = new Hashtable();
        this.setMessage("Finished.");
    }

    public void setCurrentRequest(PDU pDU, ResponseListener responseListener, String string) {
        this._$31364.remove(pDU);
    }

    public void cancelRequests() {
    }

    public boolean isRequestCanceled() {
        return false;
    }

    public boolean isFinished() {
        return this._$31364.size() == 0;
    }
}

