/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.BrowsePanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPDUDialog
extends StandardDialog
implements JCSelectListener {
    public static final String[] PDU_TYPES = new String[]{"GET", "GETNEXT", "GETBULK", "SET", "TRAP", "INFORM"};
    public static final String[] NON_TRAP_PDU_TYPES = new String[]{"GET", "GETNEXT", "GETBULK", "SET"};
    public static final int[] PDU_IDS = new int[]{-96, -95, -91, -93, -89, -90};
    private static long _$40567 = System.currentTimeMillis();
    private List<GenTarget> _$4957;
    private VariableBinding[] _$18781;
    private MIBRepository _$18643;
    private JCEditableVectorDataSource _$34456 = new JCEditableVectorDataSource();
    private BrowsePanel _$18939;
    private UserUpdate _$27626;
    private int _$31815;
    protected int nonrep;
    protected int maxrep;
    JPanel resultPanel = new JPanel();
    JButton resendButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JCListTable table = new FlexListTable();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    private Snmp _$4261;
    private SnmpLogger _$4326;

    public MultiPDUDialog(JFrame jFrame, String string, boolean bl, List<GenTarget> list, Snmp snmp, VariableBinding[] variableBindingArray, int n, MIBRepository mIBRepository, int n2, int n3) {
        super(jFrame, string, bl);
        int n4;
        this.setCancelButtonToolTip("Cancel any outstanding requests");
        this.setOKButtonToolTip("Close window");
        this._$4957 = list;
        this._$4261 = snmp;
        this._$18781 = variableBindingArray;
        this.nonrep = n2;
        this.maxrep = n3;
        this._$18643 = mIBRepository;
        this._$4326 = new SnmpLogger(mIBRepository);
        this._$31815 = n;
        this._$18939 = new BrowsePanel(mIBRepository);
        this._$34456.setNumColumns(3);
        this._$34456.setNumRows(0);
        this._$34456.setColumnLabel(0, "Target");
        this._$34456.setColumnLabel(1, "Address");
        this._$34456.setColumnLabel(2, "Status");
        this.table.setToolTipText("Select a row to view the corresponding response PDU (if available)");
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.setDataSource(this._$34456);
        this.table.setVisibleRows(20);
        this.table.setVariableEstimateCount(20);
        this.table.setRowLabelDisplay(false);
        this.table.getDefaultCellStyle().setEditable(false);
        for (n4 = 0; n4 < 2; ++n4) {
            this.table.setPixelWidth(n4, 33002);
        }
        this.table.addSelectListener(this);
        this.table.setCharWidth(2, 20);
        for (n4 = 0; n4 < list.size(); ++n4) {
            GenTarget genTarget = list.get(n4);
            if (!(genTarget instanceof GenTarget)) {
                System.err.println(genTarget.getClass() + "=" + genTarget);
            }
            GenTarget genTarget2 = genTarget;
            Vector<String> vector = new Vector<String>(3);
            vector.addElement(genTarget2.getName());
            vector.addElement(genTarget2.getAddress().toString());
            vector.addElement("Waiting...");
            this._$34456.addRow(Integer.MAX_VALUE, genTarget2, vector);
        }
        this._$27626 = new UserUpdate(this._$34456, variableBindingArray, n);
        this._$27626.setResultDialog(this);
        this.setOkButtonEnabled(false);
        this.resendButton.setEnabled(false);
        this._$18939.set(this._$18939.makeRow(null, variableBindingArray), 0, 0);
        try {
            this.jbInit2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MultiPDUDialog() {
        try {
            this.jbInit2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void jbInit2() throws Exception {
        this.resendButton.setText("Resend All");
        this.resendButton.setToolTipText("Cancel any outstanding requests and send PDU to all targets once again");
        this.buttons.add((Component)this.resendButton, 1);
        this.resendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiPDUDialog.this.resend_actionPerformed(actionEvent);
            }
        });
        this.resultPanel.setLayout(new BorderLayout());
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Results");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border3, "Response PDU ");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.resultPanel.setBorder(this.border2);
        this._$18939.setBorder(this.border4);
        this.resultPanel.add((Component)this.table, "North");
        this.resultPanel.add((Component)this._$18939, "Center");
        this.panelRoot.add((Component)this.resultPanel, "Center");
        this.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        this._$27626.start();
        this._$18939.clear();
        super.setVisible(bl);
    }

    public void resend_actionPerformed(ActionEvent actionEvent) {
        this.cancel();
        this._$18939.clear();
        this.resendButton.setEnabled(false);
        this.setCancelButtonEnabled(true);
        for (int i = 0; i < this._$4957.size(); ++i) {
            this._$34456.setTableDataItem("Waiting...", i, 2);
            this._$34456.setRowLabel(i, this._$4957.get(i));
        }
        this._$27626 = new UserUpdate(this._$34456, this._$18781, this._$31815);
        this._$27626.setResultDialog(this);
        this.setOkButtonEnabled(false);
        this._$27626.start();
    }

    @Override
    public boolean cancel() {
        this._$27626.cancel();
        super.setCancelButtonEnabled(false);
        return false;
    }

    public static String getPDUString(int n) {
        switch (n) {
            case -90: {
                return "INFORM";
            }
            case -93: {
                return "SET";
            }
            case -96: {
                return "GET";
            }
            case -91: {
                return "GETBULK";
            }
            case -89: {
                return "TRAP";
            }
            case -95: {
                return "GETNEXT";
            }
        }
        return "?";
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int n = jCSelectEvent.getStartRow();
        this._$43256(n);
    }

    private void _$43256(int n) {
        this._$18939.clear();
        if (this._$34456.getTableRowLabel(n) != null && this._$34456.getTableRowLabel(n) instanceof PDU) {
            PDU pDU = (PDU)this._$34456.getTableRowLabel(n);
            Vector vector = this._$18939.makeRow(null, pDU.toArray());
            this._$18939.set(vector, pDU.getErrorStatus(), pDU.getErrorIndex());
        }
    }

    public static IpAddress getAgentAddress(VariableBinding[] variableBindingArray) {
        for (int i = 0; i < variableBindingArray.length; ++i) {
            if (!variableBindingArray[i].getOid().equals(SnmpConstants.snmpTrapAddress) || variableBindingArray[i].getSyntax() != 64) continue;
            return (IpAddress)variableBindingArray[i].getVariable();
        }
        return new IpAddress("0.0.0.0");
    }

    public static OID getTrapOID(VariableBinding[] variableBindingArray) {
        for (int i = 0; i < variableBindingArray.length; ++i) {
            if (!variableBindingArray[i].getOid().equals(SnmpConstants.snmpTrapOID) || variableBindingArray[i].getSyntax() != 6) continue;
            return new OID(((OID)variableBindingArray[i].getVariable()).toString());
        }
        return new OID();
    }

    public static long getTimestamp(VariableBinding[] variableBindingArray) {
        for (int i = 0; i < variableBindingArray.length; ++i) {
            if (!variableBindingArray[i].getOid().equals(SnmpConstants.sysUpTime) || !(variableBindingArray[i].getVariable() instanceof TimeTicks)) continue;
            return ((TimeTicks)variableBindingArray[i].getVariable()).getValue();
        }
        return 0L;
    }

    public static boolean isValidTrapPDU(VariableBinding[] variableBindingArray) {
        return variableBindingArray.length >= 2 && variableBindingArray[1].getOid().equals(SnmpConstants.snmpTrapOID) && variableBindingArray[0].getOid().equals(SnmpConstants.sysUpTime) && variableBindingArray[0].getSyntax() == 67 && variableBindingArray[1].getSyntax() == 6;
    }

    public static VariableBinding[] getV1TrapVbs(VariableBinding[] variableBindingArray) {
        Vector<VariableBinding> vector = new Vector<VariableBinding>(variableBindingArray.length + 1);
        for (int i = 0; i < variableBindingArray.length; ++i) {
            if (variableBindingArray[i].getOid().equals(SnmpConstants.sysUpTime) || variableBindingArray[i].getOid().equals(SnmpConstants.snmpTrapOID) || variableBindingArray[i].getOid().equals(SnmpConstants.snmpTrapAddress)) continue;
            vector.addElement(variableBindingArray[i]);
        }
        Object[] objectArray = new VariableBinding[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    class UserUpdate
    extends Thread
    implements ResponseListener {
        private JCEditableVectorDataSource _$34456;
        private boolean _$4767 = false;
        private StandardDialog _$18907;
        private boolean _$34462 = true;
        private VariableBinding[] _$18781;
        private PDU[] _$4971;
        private int _$31815;

        public UserUpdate(JCEditableVectorDataSource jCEditableVectorDataSource, VariableBinding[] variableBindingArray, int n) {
            this._$34456 = jCEditableVectorDataSource;
            this._$18781 = variableBindingArray;
            this._$31815 = n;
            this._$4971 = new PDU[jCEditableVectorDataSource.getNumRows()];
        }

        public void setResultDialog(StandardDialog standardDialog) {
            this._$18907 = standardDialog;
        }

        public synchronized void cancel() {
            this._$4767 = true;
            for (int i = 0; i < this._$4971.length; ++i) {
                if (this._$4971[i] == null) continue;
                MultiPDUDialog.this._$4261.cancel(this._$4971[i], this);
                this._$34456.setTableDataItem("Canceled", i, 2);
            }
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            MultiPDUDialog.this._$4261.cancel(responseEvent.getRequest(), this);
            PDU pDU = responseEvent.getResponse();
            MultiPDUDialog.this._$4326.logResponse(responseEvent, null);
            Integer n = (Integer)responseEvent.getUserObject();
            int n2 = n;
            this._$4971[n2] = null;
            this._$34456.setRowLabel(n2, pDU);
            if (pDU == null) {
                this._$34456.setTableDataItem("Timeout", n2, 2);
            } else if (pDU.getErrorStatus() != 0) {
                this._$34456.setTableDataItem(pDU.getErrorStatusText() + " at index " + pDU.getErrorIndex(), n2, 2);
            } else {
                this._$34456.setTableDataItem("Success", n2, 2);
            }
            boolean bl = true;
            for (int i = 0; i < this._$4971.length; ++i) {
                if (this._$4971[i] == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                this._$18907.setCancelButtonEnabled(false);
                int[] nArray = TableUtils.getSelectedRows(MultiPDUDialog.this.table);
                if (nArray == null || nArray.length == 0) {
                    MultiPDUDialog.this.table.setSelection(0, 0, 0, MultiPDUDialog.this.table.getNumColumns() - 1);
                    MultiPDUDialog.this._$43256(0);
                } else {
                    MultiPDUDialog.this._$43256(TableUtils.getFirstSelectedRow(MultiPDUDialog.this.table));
                }
            }
        }

        public void run() {
            int n;
            block13: for (n = 0; !this._$4767 && n < this._$34456.getNumRows(); ++n) {
                this._$34456.setTableDataItem("Processing...", n, 2);
                GenTarget genTarget = (GenTarget)this._$34456.getTableRowLabel(n);
                try {
                    Target target = genTarget.getTarget();
                    PDU pDU = genTarget.makePDU();
                    VariableBinding[] variableBindingArray = new VariableBinding[this._$18781.length];
                    block14: for (int i = 0; i < this._$18781.length; ++i) {
                        switch (this._$31815) {
                            case -96: 
                            case -95: 
                            case -91: {
                                variableBindingArray[i] = new VariableBinding(this._$18781[i].getOid());
                                continue block14;
                            }
                            default: {
                                variableBindingArray[i] = (VariableBinding)this._$18781[i].clone();
                            }
                        }
                    }
                    pDU.addAll(variableBindingArray);
                    switch (this._$31815) {
                        case -96: {
                            MultiPDUDialog.this._$4261.get(pDU, target, new Integer(n), this);
                            break;
                        }
                        case -95: {
                            MultiPDUDialog.this._$4261.getNext(pDU, target, new Integer(n), this);
                            break;
                        }
                        case -91: {
                            pDU.setNonRepeaters(MultiPDUDialog.this.nonrep);
                            pDU.setMaxRepetitions(MultiPDUDialog.this.maxrep);
                            MultiPDUDialog.this._$4261.getBulk(pDU, target, new Integer(n), this);
                            break;
                        }
                        case -93: {
                            MultiPDUDialog.this._$4261.set(pDU, target, new Integer(n), this);
                            break;
                        }
                        case -90: {
                            MultiPDUDialog.this._$4261.inform(pDU, target, new Integer(n), this);
                            break;
                        }
                        case -89: {
                            if (target.getVersion() == 0) {
                                PDUv1 pDUv1 = new PDUv1();
                                pDUv1.setType(-92);
                                pDUv1.setAgentAddress(MultiPDUDialog.getAgentAddress(this._$18781));
                                OID oID = MultiPDUDialog.getTrapOID(this._$18781);
                                int n2 = SnmpConstants.getGenericTrapID(oID);
                                if (n2 == -1) {
                                    pDUv1.setGenericTrap(6);
                                    if (oID.size() < 3 || oID.get(oID.size() - 2) != 0) {
                                        this._$34456.setTableDataItem("Not send due to invalid SNMPv1 trap OID: " + oID, n, 2);
                                        continue block13;
                                    }
                                    int n3 = oID.get(oID.size() - 1);
                                    oID.trim(2);
                                    pDUv1.setEnterprise(oID);
                                    pDUv1.setSpecificTrap(n3);
                                } else {
                                    pDUv1.setGenericTrap(n2);
                                }
                                pDUv1.setTimestamp(MultiPDUDialog.getTimestamp(this._$18781));
                                VariableBinding[] variableBindingArray2 = MultiPDUDialog.getV1TrapVbs(this._$18781);
                                pDUv1.addAll(variableBindingArray2);
                                pDU = pDUv1;
                            } else {
                                pDU.setType(-89);
                            }
                            MultiPDUDialog.this._$4261.send(pDU, target);
                            this._$34456.setTableDataItem("Success", n, 2);
                            break;
                        }
                        default: {
                            this._$34456.setTableDataItem("Not send", n, 2);
                        }
                    }
                    SnmpLogger.logRequest(pDU, genTarget);
                    if (this._$31815 == -89) continue;
                    this._$4971[n] = pDU;
                    continue;
                }
                catch (Exception exception) {
                    this._$34456.setTableDataItem(exception.getMessage(), n, 2);
                    this._$34462 = false;
                    exception.printStackTrace();
                }
            }
            if (this._$4767) {
                while (n < this._$34456.getNumRows()) {
                    this._$34456.setTableDataItem("Canceled", n, 2);
                    this._$34462 = false;
                    ++n;
                }
            }
            this._$18907.setOkButtonEnabled(true);
            MultiPDUDialog.this.resendButton.setEnabled(true);
            if (this._$31815 == -89) {
                this._$18907.setCancelButtonEnabled(false);
            }
        }

        public boolean isOverallSuccess() {
            return this._$34462;
        }
    }
}

