/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ChangeManager;
import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.ShuffleDialog;
import com.agentpp.common.SortLabel;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.table.ColumnFilter;
import com.agentpp.common.table.JTableColumnResizeEmulator;
import com.agentpp.common.table.PopupTable;
import com.agentpp.common.table.TransposableDataSource;
import com.agentpp.common.table.filter.RegexColumnFilter;
import com.agentpp.common.table.filter.ValueColumnFilter;
import com.agentpp.common.table.print.JCTableView;
import com.agentpp.common.table.print.PrintActionPanel;
import com.agentpp.common.table.print.TableFlow;
import com.agentpp.common.xls.Table2XLS;
import com.agentpp.common.xml.Table2XML;
import com.agentpp.explorer.DraggableTreeNode;
import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBTableModel;
import com.agentpp.explorer.MIBTableModelRowKey;
import com.agentpp.explorer.MIBTablePreferences;
import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.SelectTargetsDialog;
import com.agentpp.explorer.cfg.ViewSettings;
import com.agentpp.explorer.editors.IndexDialog;
import com.agentpp.explorer.editors.cell.IpAddressCellEditor;
import com.agentpp.explorer.editors.cell.ObjectIDCellEditor;
import com.agentpp.explorer.filter.IndexFilterPanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.Regex;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.Vector2Matrix;
import com.agentpp.util.gui.ShowHtmlDialog;
import com.borland.jbcl.layout.BoxLayout2;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.editors.JCBigDecimalCellEditor;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCIntegerCellEditor;
import com.klg.jclass.cell.editors.JCLongCellEditor;
import com.klg.jclass.cell.editors.JCMultilineCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCLongValidator;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableCellInfo;
import com.klg.jclass.table.JCTraverseCellEvent;
import com.klg.jclass.table.JCTraverseCellListener;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.swing.JCListModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBTablePanel
extends JFrame
implements ResponseListener,
JCCellDisplayListener,
JCValueListener,
JCEditCellListener,
JCSelectListener,
JCTraverseCellListener,
DropTargetListener,
ActionListener,
RequestObserver {
    public static final int TOOLTIP_OBJECTTYPE = 0;
    public static final int TOOLTIP_VALUE = 1;
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_XLS = "yyyy-MM-dd HHmmss";
    public static final String SUFFIX_XLS = ".XLS";
    public static final String SUFFIX_CSV = ".CSV";
    public static final String SUFFIX_XML = ".XML";
    private static final String _$35123 = "Auto-Filter...";
    private static final String _$35124 = "Regex-Filter...";
    private static final String _$35125 = "Disable";
    private static final String _$35126 = "No Filters";
    private static final String _$35127 = "Description";
    private static final String _$35128 = "Syntax";
    private static final String _$35129 = "";
    private static final String _$35130 = "Copy...";
    private static final String _$35131 = "Save";
    private static final String _$35132 = "Restore";
    private static final String _$35133 = "Reset";
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    public static final Color INDEX_BACKGROUND = new Color(220, 220, 220);
    public static final DataFlavor data_flavour = new DataFlavor(String.class, "ExcelTokenizedString");
    private Clipboard _$29645;
    private int _$35135;
    private int _$35136;
    private int _$29646;
    private int _$29647;
    private StringSelection _$29648;
    private Collection _$27414;
    private boolean _$35137;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelNorth = new JPanel();
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelCenter = new JPanel();
    JToolBar jToolBar1 = new JToolBar();
    JButton jButtonNewRow = new JButton();
    JButton jButtonRefresh = new JButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    Border border1;
    JPanel jPanel2 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonApply = new JButton();
    JButton jButtonCancel = new JButton();
    JCheckBox commitByRow = new JCheckBox("By Row", false);
    private File _$29896;
    private JFrame _$18902;
    private MIBTableModel _$4260;
    private Snmp _$4261;
    private Target _$773 = null;
    private List<GenTarget> _$4262;
    private MIBRepository _$18643;
    private boolean _$35139;
    private IndexStruct[] _$20272;
    private PopupTable _$4160;
    private TableSorter _$18933;
    private TransposableDataSource _$35140;
    private int _$29680 = 50;
    private int _$35141 = 0;
    private int _$35142 = 0;
    private PDU _$4276;
    private boolean _$35143 = false;
    private int _$35144 = -1;
    private boolean _$29897 = true;
    private TreeMap<MIBTableModelRowKey, TreeMap<ObjectID, CellEdit>> _$35145 = new TreeMap();
    JButton jButtonUndo = new JButton();
    private int _$35146 = 1;
    private boolean _$35147;
    private boolean _$35148;
    private UserConfigFile _$4288;
    JButton jButtonTranspose = new JButton();
    private ChangeManager _$29661 = new ChangeManager();
    private CellEdit _$29663 = null;
    JButton jButtonRedo = new JButton();
    JCSpinField jCSpinFieldRefresh = new JCSpinField();
    private Timer _$4297;
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanelStatus = new JPanel();
    JProgressBar jProgressBarTimer = new JProgressBar();
    JButton jButtonPlay = new JButton();
    JButton jButtonDuplicateRow = new JButton();
    JButton jButtonPause = new JButton();
    private int _$29904 = 5;
    private boolean _$29905 = false;
    Border border2;
    JButton jButtonFilterRows = new JButton();
    private ObjectID _$35153;
    private ObjectID _$35154;
    JLabel filterStatus = new JLabel();
    private ValueConverter[] _$35156;
    FlowLayout flowLayout2 = new FlowLayout();
    private boolean _$29665 = false;
    JLabel jLabelRefresh = new JLabel();
    JButton jButtonPreferences = new JButton();
    private boolean _$35158 = true;
    private int _$35159;
    JToolBar jToolBarRefresh = new JToolBar();
    private DropTarget _$4322;
    JButton jButtonApplyRead = new JButton();
    JToggleButton jButtonExport = new JToggleButton();
    private SnmpLogger _$4326;
    boolean editing = false;
    BoxLayout2 boxLayout21 = new BoxLayout2();
    JMenu dhMenu = new JMenu("String Format");
    JMenu filterMenu = new JMenu("Filter");
    JMenu colWidthsMenu = new JMenu("Column Widths");
    ColWidthAction restoreAction = new ColWidthAction("Restore");
    private JPanel _$35167 = new JPanel();
    private RequestObserverPanel _$24536;
    private Object _$4339 = new Object();
    private JButton _$35168 = new JButton();
    private JButton _$35169 = new JButton();
    private JButton _$35170 = new JButton();
    private PatternMatcher _$35171 = new Perl5Matcher();
    private PatternCompiler _$35172 = new Perl5Compiler();
    private Pattern _$35173;
    private PatternMatcherInput _$29803;
    private JButton _$35174 = new JButton();
    private String _$35175;
    private JFrame _$35176;
    private boolean _$35177;
    private MIBObject _$4358;
    private boolean _$35178;
    private String _$4360;

    public MIBTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MIBTablePanel(JFrame jFrame, MIBObject mIBObject, String string, Image image, Snmp snmp, List<GenTarget> list, MIBTableModel mIBTableModel, MIBRepository mIBRepository, int n, int n2, boolean bl, boolean bl2, UserConfigFile userConfigFile) {
        this._$4358 = mIBObject;
        this.setTitle(string);
        this.setIconImage(image);
        this._$18902 = this;
        this._$35176 = jFrame;
        this._$4261 = snmp;
        this._$35175 = mIBObject.getName();
        this._$4262 = list;
        this._$18643 = mIBRepository;
        this._$4326 = new SnmpLogger(mIBRepository);
        this._$4288 = userConfigFile;
        this._$20272 = mIBTableModel.getIndexStruct();
        this._$4260 = mIBTableModel;
        this._$29680 = n;
        this._$35159 = n2;
        this._$35137 = bl2;
        this._$35158 = bl;
        this._$4360 = ViewSettings.getDisplayFormat(userConfigFile);
        this._$24536 = new RequestObserverPanel(snmp){

            public void stopped() {
                MIBTablePanel.this.refreshFinished();
            }
        };
        this._$35156 = new JCValueConverter[this._$20272.length];
        for (int i = 0; i < this._$20272.length; ++i) {
            this._$35156[i] = this._$4260.getValueConverter(i);
        }
        this._$35182(this._$4360);
        this._$4160 = new PopupTable(){

            public void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    MIBTablePanel.this.destroySelectedRows();
                } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 155) {
                    MIBTablePanel.this.createWaitSelectedRows();
                } else if (keyEvent.getKeyCode() == 155) {
                    MIBTablePanel.this.createSelectedRows();
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }

            public boolean isPopupAllowed(int n, int n2) {
                TablePopupMenu tablePopupMenu = super.getPopupMenu();
                JCCellPosition jCCellPosition = MIBTablePanel.this._$4160.XYToCell(n, n2);
                int n3 = MIBTablePanel.this._$29694(jCCellPosition.row, jCCellPosition.column);
                if (n3 < 0) {
                    return false;
                }
                JCValueConverter jCValueConverter = MIBTablePanel.this._$4260.getValueConverter(n3);
                if (jCValueConverter == null || !SMI.isString(jCValueConverter.getEffectiveSyntax().getSyntax())) {
                    MIBTablePanel.this.dhMenu.setEnabled(false);
                } else {
                    MIBTablePanel.this.dhMenu.setEnabled(true);
                }
                return true;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
                if (jCCellPosition.row == -1) {
                    Object object = MIBTablePanel.this._$4260.getTableColumnLabel(jCCellPosition.column);
                    if (object instanceof SortLabel && ((SortLabel)object).getFilter() != null) {
                        return "Filtered by: " + ((SortLabel)object).getFilter().toString();
                    }
                } else if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                    return null;
                }
                int n = MIBTablePanel.this._$4419(jCCellPosition.row, jCCellPosition.column);
                int n2 = MIBTablePanel.this._$29694(jCCellPosition.row, jCCellPosition.column);
                switch (MIBTablePanel.this.getToolTipType()) {
                    case 0: {
                        JCValueConverter jCValueConverter = MIBTablePanel.this._$4260.getValueConverter(n2);
                        if (jCValueConverter == null) {
                            return null;
                        }
                        return jCValueConverter.getEffectiveSyntax().getSyntax();
                    }
                    case 1: {
                        Object object = MIBTablePanel.this._$4260.getTableDataItem(n, n2);
                        if (object == null) {
                            return null;
                        }
                        JCValueConverter jCValueConverter = MIBTablePanel.this._$4260.getValueConverter(n2);
                        if (jCValueConverter != null) {
                            if (MIBTablePanel._$35188(jCValueConverter)) {
                                Variable variable = jCValueConverter.fromNative(object);
                                if (variable == null || !(variable instanceof OctetString)) {
                                    return object.toString();
                                }
                                return ValueConverter.getPrintableString((OctetString)variable);
                            }
                            if (jCValueConverter.getEffectiveSyntax().getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                                Variable variable = jCValueConverter.fromNative(object);
                                if (variable == null || !(variable instanceof OctetString)) {
                                    return object.toString();
                                }
                                String string = jCValueConverter.getEffectiveSyntax().getBitsEnum(((OctetString)variable).getValue());
                                if (string != null) {
                                    return string;
                                }
                            }
                        }
                        return object.toString();
                    }
                }
                return null;
            }
        };
        this._$35177 = userConfigFile.getBoolean("mibexplorer.SetReadonly", false);
        this._$4160.setPopupMenuEnabled(true);
        TablePopupMenu tablePopupMenu = this._$4160.getPopupMenu();
        tablePopupMenu.add(this.filterMenu);
        this.filterMenu.setMnemonic('F');
        tablePopupMenu.addItem(_$35127, this);
        tablePopupMenu.addItem(_$35128, this);
        tablePopupMenu.add(this.colWidthsMenu);
        this.colWidthsMenu.setMnemonic('C');
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(_$35130, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.dhMenu);
        this.dhMenu.setMnemonic('S');
        JMenuItem jMenuItem = this.filterMenu.add(new FilterAction(_$35123));
        jMenuItem.setToolTipText("Filter rows by a single value of this column");
        jMenuItem.setMnemonic('A');
        jMenuItem = this.filterMenu.add(new FilterAction(_$35124));
        jMenuItem.setToolTipText("Filter rows by a regular expression on this columns values");
        jMenuItem.setMnemonic('R');
        jMenuItem = this.filterMenu.add(new FilterAction(_$35125));
        jMenuItem.setToolTipText("Disable this column filter");
        jMenuItem.setMnemonic('D');
        this.filterMenu.add(new JSeparator());
        jMenuItem = this.filterMenu.add(new FilterAction(_$35126));
        jMenuItem.setToolTipText("Disable any column filters");
        jMenuItem.setMnemonic('N');
        jMenuItem = this.dhMenu.add(new FormatAction("ASCII", "255a"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '255a', e.g. 'aBc' renders 'aBc'");
        jMenuItem.setMnemonic('A');
        jMenuItem = this.dhMenu.add(new FormatAction("Decimal", "1d."));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1d.', e.g. 'aBc' renders '97.66.99'");
        jMenuItem.setMnemonic('D');
        jMenuItem = this.dhMenu.add(new FormatAction("Hexadecimal", "1x:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1x:', e.g. 'aBc' renders '61:42:63'");
        jMenuItem.setMnemonic('H');
        jMenuItem = this.dhMenu.add(new FormatAction("Octal", "1o:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1o:', e.g. 'aBc' renders '141:102:143'");
        jMenuItem.setMnemonic('O');
        jMenuItem = this.dhMenu.add(new FormatAction("Binary", "1b:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1b:', e.g. 'aBc' renders '01100001:01000010:01100011'");
        jMenuItem.setMnemonic('B');
        jMenuItem = this.dhMenu.add(new FormatAction("MIB", null));
        jMenuItem.setToolTipText("Sets the default display and input format for this string object as defined in the corresponding MIB module");
        jMenuItem.setMnemonic('M');
        this.dhMenu.add(new JSeparator());
        jMenuItem = this.dhMenu.add(new CellEditorAction("Multi-Line"));
        jMenuItem.setToolTipText("Toggles between the default single line cell editors and a multi-line cell editors");
        jMenuItem.setMnemonic('L');
        jMenuItem = this.colWidthsMenu.add(new ColWidthAction(_$35131));
        jMenuItem.setToolTipText("Save current column withs for this table MIB object");
        jMenuItem.setMnemonic('S');
        jMenuItem = this.colWidthsMenu.add(this.restoreAction);
        jMenuItem.setToolTipText("Restore last saved column withs for this table MIB object");
        jMenuItem.setMnemonic('R');
        this.filterMenu.add(new JSeparator());
        jMenuItem = this.colWidthsMenu.add(new ColWidthAction(_$35133));
        jMenuItem.setToolTipText("Reset stored column withs for this table MIB object to defaults");
        jMenuItem.setMnemonic('t');
        ToolTipManager.sharedInstance().registerComponent(this._$4160);
        this._$4160.setColumnLabelDisplay(true);
        this._$4160.setRowLabelDisplay(false);
        this._$4160.setResizeEven(false);
        this._$35140 = new TransposableDataSource(this._$4260);
        this._$4160.setDataSource(this._$35140);
        this._$4160.setFrozenColumns(mIBTableModel.getIndexColumnCount());
        this._$4160.setVisibleColumns(this._$4260.getNumColumns());
        this._$4160.setVisibleRows(20);
        this._$4160.setAllowCellResize(4);
        this._$4160.setVariableEstimateCount(15);
        this._$4160.setAutoScroll(3);
        for (int i = 0; i < mIBTableModel.getNumColumns(); ++i) {
            this._$4160.setPixelWidth(i, 33002);
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$4160.addCellDisplayListener(this);
        this._$4160.addSelectListener(this);
        this._$4160.addEditCellListener(this);
        this._$4160.addTraverseCellListener(this);
        this._$4160.addResizeCellMotionListener(new JTableColumnResizeEmulator(0));
        this.jCSpinFieldRefresh.addValueListener(this);
        if (!bl) {
            this.jButtonTranspose.setEnabled(false);
        }
        this.updateButtons();
        this.jButtonApply.setEnabled(false);
        this.jButtonApplyRead.setEnabled(false);
        this._$4260.setNumRows(11);
        this._$35191();
        this._$4260.setNumRows(0);
        this._$4260.addExpressionRow(Integer.MAX_VALUE, null);
        if (bl) {
            // empty if block
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(86, 2, false);
        this._$4160.registerKeyboardAction(this, "copy", keyStroke, 0);
        this._$4160.registerKeyboardAction(this, "paste", keyStroke2, 0);
        if (this._$35192()) {
            this._$4490();
        }
        this._$35193();
    }

    private static boolean _$35188(ValueConverter valueConverter) {
        String string;
        return valueConverter != null && valueConverter.getEffectiveSyntax() != null && SMI.SMI_SYNTAX[1].equals(string = valueConverter.getEffectiveSyntax().getSyntax()) && valueConverter.getDisplayHint() == null;
    }

    private void _$35182(String string) {
        for (int i = 0; i < this._$4260.getNumColumns(); ++i) {
            JCValueConverter jCValueConverter = this._$4260.getValueConverter(i);
            if (jCValueConverter == null || !MIBTablePanel._$35188(jCValueConverter)) continue;
            jCValueConverter.setDisplayHint(string);
        }
    }

    private void _$4490() {
        this._$4160.restoreColumnWidths(this._$4288, "mibexplorer.table.colWidth." + this._$4358.getName() + ".", 33002);
    }

    private boolean _$35192() {
        return this._$4288.getInteger("mibexplorer.table.colWidth." + this._$4358.getName() + ".0", 0) != 0;
    }

    public void createSelectedRows() {
        this._$35195("createAndGo", 4);
    }

    public void createWaitSelectedRows() {
        this._$35195("createAndWait", 5);
    }

    private void _$35195(String string, int n) {
        int n2 = -1;
        String string2 = "" + n;
        for (int i = 0; i < this._$4260.getNumColumns(); ++i) {
            JCValueConverter jCValueConverter = this._$4260.getValueConverter(i);
            if (!"RowStatus".equals(jCValueConverter.getObjectType().getSyntax().getSyntax()) || !jCValueConverter.getEffectiveSyntax().hasEnums() || jCValueConverter.getSMISyntax() != 0 || !string2.equals(jCValueConverter.getEffectiveSyntax().getEnum(string))) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        int[] nArray = com.agentpp.common.table.TableUtils.getSelectedRows(this._$4160);
        if (this.isPeriodicRefreshEnabled()) {
            this.stopTimer();
        }
        for (int i = 0; i < nArray.length; ++i) {
            OID oID = this._$4260.getOidOf(nArray[i], n2);
            Integer n3 = new Integer(n);
            this._$29663 = new CellEdit(this.getCellInfo(oID, this._$4260.getTarget(nArray[i])), this._$4260.getTableDataItem(nArray[i], n2), n3, oID);
            if (this._$29663.oldValue != null && this._$29663.oldValue.equals(this._$29663.newValue)) continue;
            this._$4260.setTableDataItem(n3, nArray[i], n2);
            this._$29661.addEdit(this._$29663);
        }
        this.updateButtons();
    }

    public void destroySelectedRows() {
        this._$35195("destroy", 6);
    }

    public static DataProperties getRefreshDataProperties() {
        return new DataProperties(new JCLongValidator(null, new Long("0"), new Long("31536000"), new JCListModel(new Long[]{new Long("0"), new Long("15"), new Long("30"), new Long("60"), new Long("900"), new Long("3600")}), false, new String[]{"disabled", "every 15s", "every 30s", "every min", "every 15min", "every hour"}, new Long("10"), "#,##0.###;-#,##0.###", false, false, false, null, new Long("0")), new MutableValueModel(Long.class, new Long("0")), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255)));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.copySelectionToClipBoard();
        } else if (string.equals("paste")) {
            this.pasteSelectionFromClipBoard();
        } else if (string.equals(_$35127)) {
            JCCellPosition jCCellPosition = this._$4160.getPopupCellPosition();
            int n = this._$29694(jCCellPosition.row, jCCellPosition.column);
            JCValueConverter jCValueConverter = this._$4260.getValueConverter(n);
            if (jCValueConverter == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String string2 = jCValueConverter.getObjectType().getDescription();
            JOptionPane.showMessageDialog(this, string2, "Description of " + jCValueConverter.getObjectType().getName(), 1);
        } else if (string.equals(_$35128)) {
            JCCellPosition jCCellPosition = this._$4160.getPopupCellPosition();
            int n = this._$29694(jCCellPosition.row, jCCellPosition.column);
            JCValueConverter jCValueConverter = this._$4260.getValueConverter(n);
            if (jCValueConverter == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String string3 = jCValueConverter.getEffectiveSyntax().toSMI(1, this._$18643, null, NEWLINE);
            string3 = ShowHtmlDialog.replaceTabs(string3);
            JTextArea jTextArea = new JTextArea(string3);
            jTextArea.setEditable(false);
            jTextArea.setCaretPosition(0);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jTextArea);
            JOptionPane.showMessageDialog(this, jScrollPane, "Syntax of " + jCValueConverter.getObjectType().getName(), 1);
        } else if (string.equals(_$35130)) {
            int n;
            int n2;
            JCCellPosition jCCellPosition = this._$4160.getPopupCellPosition();
            int n3 = this._$4419(jCCellPosition.row, jCCellPosition.column);
            MIBTableModelRowKey mIBTableModelRowKey = this._$4260.getIndexOf(n3);
            ShuffleDialog shuffleDialog = new ShuffleDialog(this._$18902, "Choose Target(s) for " + mIBTableModelRowKey, true);
            JCVectorDataSource jCVectorDataSource = new JCVectorDataSource();
            jCVectorDataSource.setNumColumns(this._$4260.getIndexColumnCount());
            jCVectorDataSource.setNumRows(0);
            for (n2 = 0; n2 < this._$4260.getIndexColumnCount(); ++n2) {
                jCVectorDataSource.setColumnLabel(n2, this._$4260.getColumnLabels().get(n2));
            }
            for (n2 = 0; n2 < this._$4260.getNumDataRows(); ++n2) {
                if (n3 == n2) continue;
                Vector<Object> vector = new Vector<Object>(this._$4260.getIndexColumnCount());
                for (n = 0; n < this._$4260.getIndexColumnCount(); ++n) {
                    vector.add(this._$4260.getTableDataItem(n2, n));
                }
                jCVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(n2), vector);
            }
            shuffleDialog.setLeftData(jCVectorDataSource);
            shuffleDialog.setLeftTitle("Available Targets");
            jCVectorDataSource = new JCVectorDataSource();
            jCVectorDataSource.setNumColumns(this._$4260.getIndexColumnCount());
            jCVectorDataSource.setNumRows(0);
            for (n2 = 0; n2 < this._$4260.getIndexColumnCount(); ++n2) {
                jCVectorDataSource.setColumnLabel(n2, this._$4260.getColumnLabels().get(n2));
            }
            shuffleDialog.setRightData(jCVectorDataSource);
            shuffleDialog.setRightTitle("Selected Targets");
            shuffleDialog.setLocationRelativeTo(this);
            shuffleDialog.setVisible(true);
            if (shuffleDialog.getResult() == 0) {
                jCVectorDataSource = shuffleDialog.getRightData();
                for (n2 = 0; n2 < jCVectorDataSource.getNumRows(); ++n2) {
                    int n4 = (Integer)jCVectorDataSource.getTableRowLabel(n2);
                    for (n = this._$4260.getIndexColumnCount(); n < this._$4260.getNumColumns(); ++n) {
                        if (!SMI.isWritable(this._$4260.getColumnObject(n).getAccess())) continue;
                        JCTableCellInfo jCTableCellInfo = this._$29697(n4, n);
                        OID oID = this._$4260.getOidOf(n4, n);
                        CellEdit cellEdit = new CellEdit(jCTableCellInfo, this._$4260.getTableDataItem(n4, n), this._$4260.getTableDataItem(n3, n), oID);
                        this._$4260.setTableDataItem(cellEdit.newValue, n4, n);
                        this._$29661.addEdit(cellEdit);
                    }
                }
                this.updateButtons();
            }
        }
    }

    private void _$4580(JCCellRange jCCellRange) {
        int n;
        if (jCCellRange.start_row == -1) {
            jCCellRange.start_row = 0;
        }
        if (jCCellRange.start_column == -1) {
            jCCellRange.start_column = 0;
        }
        if (jCCellRange.start_row > jCCellRange.end_row) {
            n = jCCellRange.start_row;
            jCCellRange.start_row = jCCellRange.end_row;
            jCCellRange.end_row = n;
        }
        if (jCCellRange.start_column > jCCellRange.end_column) {
            n = jCCellRange.start_column;
            jCCellRange.start_column = jCCellRange.end_column;
            jCCellRange.end_column = n;
        }
        this._$29646 = jCCellRange.end_row;
        this._$29647 = jCCellRange.end_column;
        if (this._$29646 > this._$4260.getNumRows()) {
            this._$29646 = this._$4260.getNumRows() - 1;
        }
        if (this._$29647 > this._$4260.getNumColumns()) {
            this._$29647 = this._$4260.getNumColumns() - 1;
        }
    }

    public void copySelectionToClipBoard() {
        JCCellRange jCCellRange2 = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this._$27414 = this._$4160.getSelectedCells();
            for (JCCellRange jCCellRange2 : this._$27414) {
                this._$4580(jCCellRange2);
                for (int i = jCCellRange2.start_row; i <= this._$29646; ++i) {
                    for (int j = jCCellRange2.start_column; j <= this._$29647; ++j) {
                        string = this._$4160.getDataView().getObject(i, j).toString();
                        if (string == null) {
                            string = "";
                        } else {
                            string = string.replace('\t', ' ');
                            string = string.replace('\n', ' ');
                        }
                        if (string == NULL) continue;
                        stringBuffer.append(string);
                        if (j < this._$29647) {
                            stringBuffer.append(TAB);
                        }
                        if (j != this._$29647) continue;
                        stringBuffer.append(NEWLINE);
                    }
                }
            }
            this._$29648 = new StringSelection(stringBuffer.toString());
            this._$29645 = Toolkit.getDefaultToolkit().getSystemClipboard();
            this._$29645.setContents(this._$29648, this._$29648);
        }
        catch (NullPointerException nullPointerException) {
            Toolkit.getDefaultToolkit().beep();
        }
        this._$29648 = null;
    }

    public void pasteSelectionFromClipBoard() {
        this._$29645 = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = null;
        StringSelection stringSelection = (StringSelection)this._$29645.getContents(this);
        if (stringSelection == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            string = (String)stringSelection.getTransferData(data_flavour);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._$35205(string);
        this._$4160.clearSelectedCells();
        this._$4160.repaint();
    }

    private Vector _$35206(String string, char c) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        while (n < string.length()) {
            string2 = string.substring(n, string.length());
            n2 = string2.indexOf(c);
            if (n2 == -1) {
                n2 = string2.length();
            }
            vector.addElement(string2.substring(0, n2));
            n = n + n2 + 1;
        }
        return vector;
    }

    private void _$35205(String string) {
        Vector vector = null;
        Vector vector2 = this._$35206(string, '\n');
        for (int i = 0; i < vector2.size(); ++i) {
            vector = this._$35206((String)vector2.elementAt(i) + TAB, '\t');
            for (int j = 0; j < vector.size(); ++j) {
                JCValueConverter jCValueConverter;
                Variable variable;
                if (this._$4419(this._$35135 + i, this._$35136 + j) > this._$4260.getNumDataRows() - 1 || this._$29694(this._$35135 + i, this._$35136 + j) > this._$4260.getNumColumns() - 1 || this._$35136 + j < this._$4260.getIndexColumnCount() || !this._$4160.getCellStyle(this._$35135 + i, this._$35136 + j).isEditable() || (variable = (jCValueConverter = this._$4260.getValueConverter(this._$29694(this._$35135 + i, this._$35136 + j))).fromString((String)vector.elementAt(j))) == null) continue;
                Object object = jCValueConverter.toNative(variable);
                int n = this._$4419(this._$35135 + i, this._$35136 + j);
                int n2 = this._$29694(this._$35135 + i, this._$35136 + j);
                OID oID = this._$4260.getOidOf(n, n2);
                JCTableCellInfo jCTableCellInfo = this._$29697(n, n2);
                CellEdit cellEdit = new CellEdit(jCTableCellInfo, this._$4260.getTableDataItem(n, n2), object, oID);
                this._$29661.addEdit(cellEdit);
                this._$4160.getDataView().setTableDataItem(object, this._$35135 + i, this._$35136 + j);
            }
        }
    }

    private void _$4625(int n, int n2, JCCellStyle jCCellStyle) {
        if (this._$35148) {
            this._$4160.setCellStyle(n2, n, jCCellStyle);
        } else {
            this._$4160.setCellStyle(n, n2, jCCellStyle);
        }
    }

    private boolean _$35210(int n) {
        if (this._$35177) {
            return false;
        }
        String string = this._$4260.getColumnObject(n).getAccess();
        return string.equals(SMI.ACCESS[1]);
    }

    private void _$4634() {
        int n;
        JCCellStyle jCCellStyle = new JCCellStyle(this._$4160.getDefaultCellStyle());
        jCCellStyle.setEditable(false);
        jCCellStyle.setBackground(INDEX_BACKGROUND);
        boolean bl = false;
        if (this._$35192()) {
            this._$4490();
            bl = true;
        } else {
            for (n = 0; n < this._$4160.getNumColumns(); ++n) {
                this._$4160.setPixelWidth(n, 33002);
            }
        }
        for (n = 0; n < this._$20272.length; ++n) {
            this._$4625(-997, n, jCCellStyle);
        }
        JCCellStyle jCCellStyle2 = new JCCellStyle(this._$4160.getDefaultCellStyle());
        jCCellStyle2.setEditable(false);
        JCCellStyle jCCellStyle3 = new JCCellStyle(this._$4160.getDefaultCellStyle());
        jCCellStyle3.setEditable(true);
        jCCellStyle3.setBackground(Color.blue);
        jCCellStyle3.setForeground(Color.white);
        Object[] objectArray = new GenTarget[this._$4262.size()];
        int n2 = 0;
        Object object = this._$4262.iterator();
        while (object.hasNext()) {
            objectArray[n2] = object.next();
            ++n2;
        }
        Arrays.sort(objectArray);
        object = new JCCellStyle(jCCellStyle);
        if (this._$4262.size() == 1) {
            if (this._$35148) {
                this._$4160.setRowHidden(this._$20272.length, true);
            } else {
                this._$4160.setColumnHidden(this._$20272.length, true);
            }
        }
        this._$4625(-997, this._$20272.length, (JCCellStyle)object);
        JCCellStyle jCCellStyle4 = new JCCellStyle(jCCellStyle2);
        jCCellStyle4.setHorizontalAlignment(4);
        for (int i = this._$20272.length + 1; i < this._$4260.getNumColumns(); ++i) {
            Object object2;
            JCValueConverter jCValueConverter = this._$4260.getValueConverter(i);
            boolean bl2 = jCValueConverter.getEffectiveSyntax().hasEnums();
            if (this._$35210(i)) {
                if (jCValueConverter.isNumber() && !bl2) {
                    this._$4625(-997, i, jCCellStyle4);
                } else {
                    this._$4625(-997, i, jCCellStyle2);
                }
            } else {
                if (this._$35144 < 0) {
                    this._$35144 = i;
                }
                if (bl2 && !jCValueConverter.getEffectiveSyntax().getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    Object[] objectArray2 = new String[jCValueConverter.getEffectiveSyntax().getEnumsVector().size()];
                    object2 = new int[objectArray2.length];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        MIBEnum mIBEnum = (MIBEnum)jCValueConverter.getEffectiveSyntax().getEnumsVector().elementAt(j);
                        objectArray2[j] = mIBEnum.toString();
                        object2[j] = (int)mIBEnum.getLongValue();
                    }
                    JCCellStyle jCCellStyle5 = new JCCellStyle(jCCellStyle3);
                    jCCellStyle5.setCellEditor(new JCComboBoxCellEditor(objectArray2, (int[])object2));
                    this._$4625(-997, i, jCCellStyle5);
                } else {
                    JCCellEditor jCCellEditor = this._$4665(jCValueConverter);
                    object2 = new JCCellStyle(jCCellStyle3);
                    ((JCCellStyle)object2).setCellEditor(jCCellEditor);
                    if (jCValueConverter.isNumber()) {
                        ((JCCellStyle)object2).setHorizontalAlignment(4);
                    }
                    this._$4625(-997, i, (JCCellStyle)object2);
                }
            }
            if (!bl2 || this._$35148 || bl) continue;
            this._$4160.setPixelWidth(i, -999);
            int n3 = this._$4260.getColumnLabels().get(i).toString().length();
            object2 = jCValueConverter.getEffectiveSyntax().getEnumsVector();
            this._$4160.setCharWidth(i, Math.max(n3, this._$35221((Vector)object2) - 4));
        }
    }

    private int _$35221(Vector vector) {
        int n = -1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = enumeration.nextElement().toString().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private JCCellEditor _$4665(ValueConverter valueConverter) {
        JComponent jComponent;
        switch (SMI.smiSyntax(valueConverter.getEffectiveSyntax().getSyntax())) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                JCLongCellEditor jCLongCellEditor = new JCLongCellEditor();
                jCLongCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                jComponent = jCLongCellEditor;
                break;
            }
            case 6: {
                JCBigDecimalCellEditor jCBigDecimalCellEditor = new JCBigDecimalCellEditor();
                jCBigDecimalCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                jComponent = jCBigDecimalCellEditor;
                break;
            }
            case 0: 
            case 8: {
                JCIntegerCellEditor jCIntegerCellEditor = new JCIntegerCellEditor();
                jCIntegerCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                jComponent = jCIntegerCellEditor;
                break;
            }
            case 2: {
                ObjectIDCellEditor objectIDCellEditor;
                jComponent = objectIDCellEditor = new ObjectIDCellEditor(this._$18643);
                break;
            }
            case 9: {
                IpAddressCellEditor ipAddressCellEditor = new IpAddressCellEditor();
                ipAddressCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                jComponent = ipAddressCellEditor;
                break;
            }
            default: {
                if (this.isMultiLineStrings()) {
                    JCMultilineCellEditor jCMultilineCellEditor = new JCMultilineCellEditor();
                    jCMultilineCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                    jComponent = jCMultilineCellEditor;
                    break;
                }
                JCStringCellEditor jCStringCellEditor = new JCStringCellEditor();
                jCStringCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                jComponent = jCStringCellEditor;
            }
        }
        return jComponent;
    }

    void jbInit() throws Exception {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Refresh16.gif");
        this.border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.jButtonRefresh.setToolTipText("Refresh table data");
        this.jButtonRefresh.setIcon(new ImageIcon(uRL));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonRefresh_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/New16.gif");
        this.jButtonNewRow.setToolTipText("Add a row to the table");
        this.jButtonNewRow.setIcon(new ImageIcon(uRL));
        this.jButtonNewRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonNewRow_actionPerformed(actionEvent);
            }
        });
        this.jButtonDuplicateRow.setToolTipText("Create a copy of this row");
        this.jButtonDuplicateRow.setIcon(MIBExplorerFrame.imageCopy16);
        this.jButtonDuplicateRow.setEnabled(false);
        this.jButtonDuplicateRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonDuplicateRow_actionPerformed(actionEvent);
            }
        });
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanelNorth.setLayout(this.boxLayout21);
        this.jPanelSouth.setLayout(this.borderLayout3);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setPreferredSize(new Dimension(14, 2));
        this.jPanel2.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(10);
        this.flowLayout1.setVgap(10);
        this.commitByRow.setToolTipText("Commit all writable columns of a changed row (even if column is unchanged)");
        this.jButtonApply.setToolTipText("Commit changes made (send changes to agent)");
        this.jButtonApply.setText("Commit");
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonApply_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setToolTipText("Close Table window and discard any changes");
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jPanelCenter.setLayout(this.borderLayout4);
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Undo16.gif");
        this.jButtonUndo.setToolTipText("Undo last change made to the table");
        this.jButtonUndo.setIcon(new ImageIcon(uRL));
        this.jButtonUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonUndo_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("com/agentpp/common/table/TransposeTable16.gif");
        this.jButtonTranspose.setToolTipText("Transpose the table");
        this.jButtonTranspose.setIcon(new ImageIcon(uRL));
        this.jButtonTranspose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonTranspose_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Redo16.gif");
        this.jButtonRedo.setIcon(new ImageIcon(uRL));
        this.jButtonRedo.setToolTipText("Redo last change");
        this.jButtonRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonRedo_actionPerformed(actionEvent);
            }
        });
        this.jCSpinFieldRefresh.setBorder(this.border2);
        this.jCSpinFieldRefresh.setToolTipText("Periodical refresh in seconds");
        this.jCSpinFieldRefresh.setDataProperties(MIBTablePanel.getRefreshDataProperties());
        this.jPanelStatus.setLayout(this.flowLayout2);
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Pause16.gif");
        this.jButtonPause.setToolTipText("Suspends periodic refresh");
        this.jButtonPause.setIcon(new ImageIcon(uRL));
        this.jButtonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonPause_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Play16.gif");
        this.jButtonPlay.setToolTipText("Starts periodic refresh");
        this.jButtonPlay.setIcon(new ImageIcon(uRL));
        this.jButtonPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonPlay_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/table/RowDelete16.gif");
        this.jButtonFilterRows.setIcon(new ImageIcon(uRL));
        this.jButtonFilterRows.setToolTipText("Filter rows to view");
        this.jButtonFilterRows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonFilterRows_actionPerformed(actionEvent);
            }
        });
        this.jProgressBarTimer.setPreferredSize(new Dimension(50, 16));
        this.jProgressBarTimer.setToolTipText("Time to next periodic update in %");
        this.filterStatus.setToolTipText("The row index filter currently active");
        this.filterStatus.setText(" ");
        this.flowLayout2.setAlignment(0);
        this.flowLayout2.setHgap(10);
        this.flowLayout2.setVgap(10);
        this.jLabelRefresh.setText("Refresh:");
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Preferences16.gif");
        this.jButtonPreferences.setIcon(new ImageIcon(uRL));
        this.jButtonPreferences.setToolTipText("Edit table preferences");
        this.jButtonPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonPreferences_actionPerformed(actionEvent);
            }
        });
        this.jButtonApplyRead.setToolTipText("Commit changes made and verify set values afterwards");
        this.jButtonApplyRead.setText("Commit & Verify");
        this.jButtonApplyRead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonApplyRead_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Export16.gif");
        this.jButtonExport.setIcon(new ImageIcon(uRL));
        this.jButtonExport.setToolTipText("Export table contents to a text file (and append new values when periodically refreshed)");
        this.jButtonExport.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MIBTablePanel.this.jButtonExport_itemStateChanged(itemEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Find16.gif");
        this._$35168.setIcon(new ImageIcon(uRL));
        this._$35168.setToolTipText("Find a cell in the table that matches a given search expression");
        this._$35168.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonSearch_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/FindAgain16.gif");
        this._$35169.setIcon(new ImageIcon(uRL));
        this._$35169.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonSearchAgain_actionPerformed(actionEvent);
            }
        });
        this._$35169.setToolTipText("Find last search expression again");
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Replace16.gif");
        this._$35170.setIcon(new ImageIcon(uRL));
        this._$35170.setToolTipText("Replace occurrances of a search expression by a given value");
        this._$35170.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonReplace_actionPerformed(actionEvent);
            }
        });
        this._$35174.setToolTipText("Print table as PDF, PS or PCL");
        this._$35174.setIcon(MIBExplorerFrame.imagePrint24);
        this._$35174.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBTablePanel.this.jButtonPrint_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.jPanelNorth, "North");
        this.jToolBar1.setName("Table Tool Bar: " + this.getTitle());
        this.jToolBarRefresh.setName("Refresh Tool Bar: " + this.getTitle());
        this.jPanelNorth.add((Component)this.jToolBar1, null);
        this.jPanelNorth.add((Component)this.jToolBarRefresh, null);
        this.jToolBar1.add((Component)this.jButtonNewRow, null);
        this.jToolBar1.add((Component)this.jButtonDuplicateRow, null);
        this.jToolBar1.add((Component)this.jButtonFilterRows, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonRefresh, null);
        this.jToolBar1.add((Component)this.jButtonRedo, null);
        this.jToolBar1.add((Component)this.jButtonUndo, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonTranspose, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this._$35168, null);
        this.jToolBar1.add((Component)this._$35169, null);
        this.jToolBar1.add((Component)this._$35170, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonPreferences, null);
        this.jToolBar1.add((Component)this._$35174, null);
        this.jToolBar1.addSeparator();
        ToolBarUtils.setMinimumButtonSize(this.jToolBar1);
        this.jToolBarRefresh.add((Component)this.jLabelRefresh, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jCSpinFieldRefresh, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jButtonPlay, null);
        this.jToolBarRefresh.add((Component)this.jButtonPause, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jProgressBarTimer, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jButtonExport, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add(Box.createHorizontalStrut(100));
        ToolBarUtils.setMinimumButtonSize(this.jToolBarRefresh);
        this.getContentPane().add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanel1, "North");
        this.jPanelSouth.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jButtonApply, null);
        this.jPanel2.add((Component)this.jButtonApplyRead, null);
        if (this._$35137) {
            this.jPanel2.add((Component)this.commitByRow, null);
        }
        this.jPanel2.add((Component)this.jButtonCancel, null);
        this._$35167.setLayout(new BorderLayout(10, 10));
        this.jPanelSouth.add((Component)this._$35167, "West");
        this.jPanelCenter.add((Component)this._$4160, "Center");
        this.jPanelCenter.add((Component)this.jPanelStatus, "South");
        this.jPanelStatus.add((Component)this.filterStatus, null);
        this.getContentPane().add((Component)this.jPanelCenter, "Center");
        this._$35167.add((Component)this._$24536, "West");
    }

    void jButtonApply_actionPerformed(ActionEvent actionEvent) {
        this.commitChanges(false);
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        if (this._$29661.canUndo()) {
            this._$35232();
            if (this._$35145.size() > 0 && JOptionPane.showConfirmDialog(this, "There are uncommitted changes! Close window anyway?", "Confirm Close", 0, 3) == 1) {
                return;
            }
        }
        this.stopTimer();
        if (this._$4288.getBoolean("mibexplorer.table.colWidth.autosave", true)) {
            this._$4160.saveColumnWidths(this._$4288, "mibexplorer.table.colWidth." + this._$4358.getName() + ".");
        }
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void stopTimer() {
        if (this._$4297 != null) {
            this._$4297.cancel();
        }
        this._$29905 = false;
        this.jProgressBarTimer.setValue(0);
        this._$25240();
    }

    public void setModel(MIBTableModel mIBTableModel) {
        this._$4260 = mIBTableModel;
    }

    public MIBTableModel getModel() {
        return this._$4260;
    }

    private String _$35234() {
        return "Received " + this._$35142 + " instances...";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(ResponseEvent responseEvent) {
        Object object = this._$4339;
        synchronized (object) {
            try {
                Object object2;
                Object object3;
                Serializable serializable;
                Cloneable cloneable;
                Object object4;
                Object object5;
                this._$4261.cancel(responseEvent.getRequest(), this);
                this._$4339.notifyAll();
                boolean bl = true;
                this._$35235();
                if (this._$24536.isRequestCanceled()) {
                    this.refreshFinished();
                    return;
                }
                boolean bl2 = this._$4326.logResponse(responseEvent, this._$24536);
                if (!bl2) {
                    if (responseEvent.getResponse() != null && responseEvent.getResponse().getType() != -88 && responseEvent.getResponse().getErrorStatus() != 0) {
                        Object object6;
                        if (responseEvent.getUserObject() == null && responseEvent.getResponse().getErrorStatus() == 2) {
                            return;
                        }
                        if (responseEvent.getResponse().getErrorStatus() == 1) {
                            this.resendRequest(responseEvent, this);
                            return;
                        }
                        object5 = responseEvent.getResponse();
                        object4 = null;
                        if (responseEvent.getRequest().getType() == -93) {
                            int n = ((PDU)object5).getErrorIndex() - 1;
                            if (n >= 0 && n < ((PDU)object5).size()) {
                                cloneable = ((PDU)object5).get(n);
                                object4 = ((VariableBinding)cloneable).getOid();
                                serializable = this.getCellInfo((OID)object4, ((Setter)responseEvent.getUserObject()).getTarget());
                                if (serializable != null) {
                                    object6 = new JCCellStyle(((JCTableCellInfo)serializable).getCellStyle());
                                    ((JCCellStyle)object6).setBackground(Color.red);
                                    this._$4625(((JCTableCellInfo)serializable).getRow(), ((JCTableCellInfo)serializable).getColumn(), (JCCellStyle)object6);
                                    this.traverse(((JCTableCellInfo)serializable).getRow(), ((JCTableCellInfo)serializable).getColumn(), true, true);
                                }
                            } else if (((PDU)object5).size() > 0) {
                                for (int i = 0; i < ((PDU)object5).size(); ++i) {
                                    serializable = ((PDU)object5).get(i);
                                    object4 = ((VariableBinding)serializable).getOid();
                                    object6 = this.getCellInfo((OID)object4, ((Setter)responseEvent.getUserObject()).getTarget());
                                    if (object6 == null) continue;
                                    object3 = new JCCellStyle(((JCTableCellInfo)object6).getCellStyle());
                                    ((JCCellStyle)object3).setBackground(Color.red);
                                    this._$4625(((JCTableCellInfo)object6).getRow(), ((JCTableCellInfo)object6).getColumn(), (JCCellStyle)object3);
                                    if (i != 0) continue;
                                    this.traverse(((JCTableCellInfo)object6).getRow(), ((JCTableCellInfo)object6).getColumn(), true, true);
                                }
                            }
                        }
                        this.updateButtons();
                        object2 = this._$4260.getIndexString(this._$4260.getIndex((OID)object4));
                        cloneable = new String[]{"SNMP Error: " + responseEvent.getResponse().getErrorStatusText()};
                        serializable = new String[]{"SNMP Error: " + responseEvent.getResponse().getErrorStatusText(), "Continue committing other rows?"};
                        if (this._$35145.size() > 0) {
                            object6 = this._$35145.values().iterator().next();
                            object3 = (CellEdit)((TreeMap)object6).values().iterator().next();
                            ((CellEdit)object3).committed = false;
                        }
                        if (responseEvent.getRequest().getType() == -93) {
                            object6 = (Setter)responseEvent.getUserObject();
                            if (this._$35145.size() > 1) {
                                object3 = new SetContinue((String[])serializable, (String)object2, (Setter)object6);
                                SwingUtilities.invokeLater((Runnable)object3);
                                bl = false;
                            } else {
                                this._$35245(this._$35145);
                                SwingUtilities.invokeLater(new Runnable((String[])cloneable, (String)object2){
                                    final /* synthetic */ String[] val$errText;
                                    final /* synthetic */ String val$rowIndex;
                                    {
                                        this.val$errText = stringArray;
                                        this.val$rowIndex = string;
                                    }

                                    public void run() {
                                        JOptionPane.showMessageDialog(MIBTablePanel.this.getPanel(), this.val$errText, "Row Commit Failed: " + this.val$rowIndex, 0);
                                    }
                                });
                                if (((Setter)object6).verify) {
                                    object3 = new Getter(((Setter)object6).getVerificationList(), ((Setter)object6)._$35249, ((Setter)object6).getTarget(), ((Setter)object6).getTarget().getTarget());
                                    ((Getter)object3).next();
                                    bl = false;
                                } else {
                                    this._$24536.requestFinishedWithError((String)((Object)cloneable[0]));
                                }
                            }
                        }
                    } else if (responseEvent.getUserObject() instanceof Setter) {
                        object5 = (Setter)responseEvent.getUserObject();
                        this._$35245(((Setter)object5)._$35145);
                    }
                }
                if (bl2) {
                    object5 = responseEvent.getResponse().toArray();
                    this._$35142 += ((VariableBinding[])object5).length;
                    if (responseEvent.getUserObject() instanceof Walker) {
                        object4 = (Walker)responseEvent.getUserObject();
                        object2 = ((Walker)object4).getLastSend();
                        cloneable = (Vector)((Vector)object2).clone();
                        serializable = Vector2Matrix.getMatrix((Object[])object5, ((Vector)object2).size());
                        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                            Serializable serializable2;
                            object3 = (Vector)((Vector)serializable).elementAt(i);
                            Vector vector = new Vector(((Vector)object3).size() + 1);
                            for (int j = 0; j < ((Vector)object3).size(); ++j) {
                                OID oID = (OID)((Vector)object2).get(j);
                                serializable2 = (VariableBinding)((Vector)object3).get(j);
                                if (((VariableBinding)serializable2).isException()) continue;
                                if (((VariableBinding)serializable2).getOid().leftMostCompare(oID.size(), oID) == 0) {
                                    vector.add(((Vector)object3).get(j));
                                    continue;
                                }
                                ((Vector)cloneable).set(j, null);
                            }
                            Object[] objectArray = new VariableBinding[vector.size()];
                            vector.copyInto(objectArray);
                            if (objectArray.length <= 0) continue;
                            boolean bl3 = true;
                            if (this._$35153 != null || this._$35154 != null) {
                                serializable2 = this._$4260.getIndex(((VariableBinding)objectArray[0]).getOid());
                                if (serializable2 != null) {
                                    if (this._$35153 != null && ((ObjectID)serializable2).compareTo(this._$35153) < 0) {
                                        bl3 = false;
                                    }
                                    if (this._$35154 != null && ((ObjectID)serializable2).compareTo(this._$35154) > 0) {
                                        bl3 = false;
                                    }
                                } else {
                                    bl3 = false;
                                }
                            }
                            if (bl3) {
                                this._$4260.refreshRow((VariableBinding[])objectArray, ((Walker)object4)._$4262);
                            }
                            if (responseEvent.getRequest().getNonRepeaters() != 0 || i + 1 < ((Vector)serializable).size() && objectArray.length <= ((Vector)((Vector)serializable).get(i + 1)).size()) continue;
                            try {
                                boolean bl4 = true;
                                if (this._$35154 != null) {
                                    List<OID> list = this._$4260.getColumnIDs();
                                    OID oID = new OID(list.get(0).getValue());
                                    oID.append(this._$35154.toString());
                                    if (oID.leftMostCompare(oID.size(), ((VariableBinding)objectArray[0]).getOid()) <= 0) {
                                        bl4 = false;
                                    }
                                }
                                if (bl4) {
                                    this._$4276 = ((Walker)object4)._$4262.makePDU();
                                    this._$4276.addAllOIDs((VariableBinding[])objectArray);
                                    this._$4276.setMaxRepetitions(this._$29680);
                                    for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                                        if (((Vector)cloneable).get(j) != null) continue;
                                        ((Vector)cloneable).remove(j--);
                                    }
                                    ((Walker)object4).setLastSend((Vector)cloneable);
                                    this._$24536.resendRequest(-91, this._$4276, ((Walker)object4)._$4262, ((Walker)object4)._$773, object4, this, this._$35234());
                                    bl = false;
                                    break;
                                }
                                if (!((Walker)object4).next()) break;
                                bl = false;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        if (bl) {
                            bl = !((Walker)object4).next();
                        }
                    } else if (responseEvent.getUserObject() instanceof Setter) {
                        ++this._$35141;
                        object4 = (Setter)responseEvent.getUserObject();
                        SwingUtilities.invokeLater(new Runnable((VariableBinding[])object5, (Setter)object4){
                            final /* synthetic */ Setter val$setter;
                            final /* synthetic */ VariableBinding[] val$vbs;
                            {
                                this.val$vbs = variableBindingArray;
                                this.val$setter = setter;
                            }

                            public void run() {
                                MIBTablePanel.this._$4260.setSparseRow(this.val$vbs, false, this.val$setter.getTarget());
                            }
                        });
                        bl = false;
                        if (!((Setter)object4).next(false, true)) {
                            if (((Setter)responseEvent.getUserObject()).verify) {
                                object2 = new Getter(((Setter)object4).getVerificationList(), ((Setter)object4)._$35249, ((Setter)object4).getTarget(), ((Setter)object4).getTarget().getTarget());
                                ((Getter)object2).next();
                            } else {
                                bl = true;
                                this.updateButtons();
                            }
                        }
                    } else if (responseEvent.getUserObject() instanceof Getter) {
                        object4 = (Getter)responseEvent.getUserObject();
                        boolean bl5 = bl = !((Getter)object4).next();
                        if (((Object)object5).length > 0) {
                            boolean bl6 = true;
                            for (int i = 0; i < ((Object)object5).length; ++i) {
                                if (((VariableBinding)object5[i]).isException()) continue;
                                bl6 = false;
                                break;
                            }
                            if (bl6) {
                                SwingUtilities.invokeLater(new Runnable((VariableBinding[])object5, (Getter)object4){
                                    final /* synthetic */ Getter val$getter;
                                    final /* synthetic */ VariableBinding[] val$vbs;
                                    {
                                        this.val$vbs = variableBindingArray;
                                        this.val$getter = getter;
                                    }

                                    public void run() {
                                        MIBTablePanel.this._$4260.removeRow(this.val$vbs[0].getOid(), this.val$getter._$4262);
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable((VariableBinding[])object5, (Getter)object4){
                                    final /* synthetic */ Getter val$getter;
                                    final /* synthetic */ VariableBinding[] val$vbs;
                                    {
                                        this.val$vbs = variableBindingArray;
                                        this.val$getter = getter;
                                    }

                                    public void run() {
                                        MIBTablePanel.this._$4260.setSparseRow(this.val$vbs, false, this.val$getter._$4262);
                                    }
                                });
                            }
                        }
                        if (bl) {
                            this.updateButtons();
                        }
                    }
                }
                if (bl) {
                    if (bl2) {
                        this._$24536.requestFinished();
                    }
                    this._$4160.setCursor(Cursor.getDefaultCursor());
                    this._$4339.notify();
                    if (this._$18933 != null) {
                        this._$18933.sort();
                    }
                    if (responseEvent.getUserObject() instanceof Walker) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MIBTablePanel.this._$4260.refreshEnd();
                                MIBTablePanel.this._$35191();
                                MIBTablePanel.this.refreshFinished();
                                MIBTablePanel.this._$4160.repaint();
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MIBTablePanel.this._$35191();
                                MIBTablePanel.this.refreshFinished();
                                MIBTablePanel.this._$4160.repaint();
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._$4160.setCursor(Cursor.getDefaultCursor());
                this.refreshFinished();
            }
        }
    }

    private void _$35191() {
        if (!this._$35143) {
            this._$35143 = true;
            this._$4160.setSelectionPolicy(2);
            if (this._$35158) {
                this._$18933 = new TableSorter((JCTable)this._$4160, (JCVectorDataSource)this._$4260, this._$4260.getValueConverter(0));
                this._$4634();
            } else {
                this.setTransposed(true);
            }
            this.pack();
            MIBExplorerFrame.centerFrame(this);
            this.runTimer();
            this.setVisible(true);
            this._$4322 = new DropTarget(this._$4160.getCellAreaHandler().getCellArea(), 3, this);
        }
    }

    private void _$35259() {
        this._$24536.stop();
    }

    protected void refreshFinished() {
        if (this._$29896 != null) {
            try {
                this.saveTableToFile(this._$29896, this._$29897);
                if (!this._$29897 && this.isPeriodicRefreshEnabled()) {
                    this._$29897 = true;
                }
            }
            catch (IOException iOException) {
                final String[] stringArray = new String[]{"Could not write log file:", iOException.getMessage()};
                Runnable runnable = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(MIBTablePanel.this._$18902, stringArray, "Export Failed", 0);
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(runnable);
                }
                runnable.run();
            }
        }
        this._$4160.setRepaintEnabled(true);
        if (this._$18933 != null) {
            this._$18933.sort();
        }
    }

    public static ObjectID predecessor(ObjectID objectID) {
        if (objectID.size() == 0) {
            return objectID;
        }
        try {
            if (objectID.getSubIDAsLong(objectID.size() - 1) == 0L) {
                objectID = ObjectID.trim(objectID);
                return objectID;
            }
            objectID.setSubID(objectID.size() - 1, objectID.getSubIDAsLong(objectID.size() - 1) - 1L);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        return objectID;
    }

    public void clear() {
        this._$4260.clear();
    }

    public void refresh() {
        this._$4160.cancelEdit(true);
        this._$4634();
        this._$29661.reset();
        this.updateButtons();
        this._$4160.setRepaintEnabled(false);
        this._$4260.refreshStart();
        this._$35142 = 0;
        this._$4160.setCursor(Cursor.getPredefinedCursor(3));
        List<OID> list = this._$4260.getColumnIDs();
        if (list.size() + this._$4260.getIndexColumnCount() > this._$4260.getNumColumns()) {
            System.out.println("Error: wrong column count " + this._$4260.getNumColumns() + "!=" + list.size() + "+" + this._$4260.getIndexColumnCount());
        }
        for (GenTarget genTarget : this._$4262) {
            Target target = genTarget.getTarget();
            TableWalker tableWalker = new TableWalker(this._$4261, genTarget);
            tableWalker.setMaxNumColumnsPerPDU(this._$4288.getInteger("mibexplorer.MaxVBS", list.size()));
            tableWalker.setMaxNumRowsPerPDU(this._$4288.getInteger("mibexplorer.MaxRepetitions", 10));
            try {
                tableWalker.getTable(target, list.toArray(new OID[list.size()]), new InnerTableListener(genTarget), list, this._$35153 != null ? new OID(this._$35153.asIntArray()) : null, this._$35154 != null ? new OID(this._$35154.asIntArray()) : null);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                objectIDFormatException.printStackTrace();
            }
        }
    }

    private int _$4419(int n, int n2) {
        if (this._$35148) {
            return n2;
        }
        return n;
    }

    private int _$29694(int n, int n2) {
        if (this._$35148) {
            return n;
        }
        return n2;
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        int n = this._$4419(jCCellDisplayEvent.getRow(), jCCellDisplayEvent.getColumn());
        int n2 = this._$29694(jCCellDisplayEvent.getRow(), jCCellDisplayEvent.getColumn());
        if (n == -1 || n2 == -1 || jCCellDisplayEvent.getDisplayData() == null) {
            return;
        }
        JCValueConverter jCValueConverter = this._$4260.getValueConverter(n2);
        if (jCValueConverter != null && jCValueConverter.getEffectiveSyntax().hasEnums()) {
            if (jCCellDisplayEvent.getDisplayData() instanceof Integer) {
                Integer n3 = (Integer)jCCellDisplayEvent.getDisplayData();
                if (n3 == null) {
                    return;
                }
                MIBEnum mIBEnum = jCValueConverter.getEffectiveSyntax().getEnum(n3.intValue());
                if (mIBEnum != null) {
                    jCCellDisplayEvent.setDisplayData(mIBEnum.toString());
                }
            }
        } else if (jCValueConverter != null && jCValueConverter.getSMISyntax() == 11 && jCCellDisplayEvent.getCellData() instanceof Long) {
            jCCellDisplayEvent.setDisplayData(new TimeTicks((Long)jCCellDisplayEvent.getCellData()).toString());
        } else if (!(jCCellDisplayEvent.getDisplayData() instanceof ComparableIpAddress) && !this._$29665 && jCCellDisplayEvent.getDisplayData() instanceof ObjectID) {
            ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
            String string = this._$18643.getObjectName(objectID);
            if (string == null) {
                string = this._$18643.getPathSuffix(objectID);
            }
            if (string != null) {
                jCCellDisplayEvent.setDisplayData(string);
            }
        }
    }

    @Override
    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
        int n = this._$4419(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n2 = this._$29694(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        OID oID = this._$4260.getOidOf(n, n2);
        this._$29663 = new CellEdit(this._$29697(n, n2), this._$4260.getTableDataItem(n, n2), null, oID);
        if (this.isPeriodicRefreshEnabled()) {
            this.stopTimer();
        }
    }

    @Override
    public void editCell(JCEditCellEvent jCEditCellEvent) {
        this.editing = true;
    }

    private void _$35263(GenTarget genTarget, GenTarget genTarget2, int n) {
        for (int i = 0; i < this._$4260.getNumRows(); ++i) {
            if (i == n || !this._$4260.getTarget(i).equals(genTarget)) continue;
            this._$4260.setTarget(i, genTarget2);
            break;
        }
    }

    @Override
    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        this.editing = false;
        int n = this._$4419(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n2 = this._$29694(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        this._$29663.setNewValue(this._$4260.getTableDataItem(n, n2));
        if (!(jCEditCellEvent.isCancelled() || this._$29663.oldValue != null && this._$29663.oldValue.equals(this._$29663.newValue))) {
            this._$29661.addEdit(this._$29663);
        }
        this.updateButtons();
    }

    private void _$35232() {
        this._$35145 = new TreeMap();
        Vector vector = this._$29661.getChanges();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TreeMap<ObjectID, CellEdit> treeMap;
            UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
            if (!(undoableEdit instanceof CellEdit)) continue;
            CellEdit cellEdit = (CellEdit)undoableEdit;
            if (cellEdit.committed) continue;
            VariableBinding variableBinding = cellEdit.getVariableBinding(true);
            ObjectID objectID = null;
            if (variableBinding == null && cellEdit.newValue instanceof GenTarget) {
                objectID = new ObjectID();
            } else if (variableBinding == null || variableBinding.getVariable() == null) continue;
            cellEdit.committed = true;
            MIBTableModelRowKey mIBTableModelRowKey = this._$4260.getIndexOf(cellEdit.info.getRow());
            GenTarget genTarget = this._$4260.getTarget(cellEdit.info.getRow());
            MIBTableModelRowKey mIBTableModelRowKey2 = new MIBTableModelRowKey(mIBTableModelRowKey.getIndex(), genTarget);
            if (objectID == null) {
                objectID = new ObjectID(cellEdit.oid.toString());
            }
            if ((treeMap = this._$35145.get(mIBTableModelRowKey)) == null) {
                treeMap = new TreeMap();
                this._$35145.put(mIBTableModelRowKey2, treeMap);
            }
            treeMap.put(objectID, cellEdit);
        }
    }

    private VariableBinding[] _$35268(TreeMap treeMap, boolean bl) {
        if (treeMap.size() == 0) {
            return null;
        }
        boolean bl2 = this.commitByRow.isSelected();
        MIBTableModelRowKey mIBTableModelRowKey = (MIBTableModelRowKey)treeMap.firstKey();
        TreeMap treeMap2 = (TreeMap)treeMap.get(mIBTableModelRowKey);
        LinkedList<VariableBinding> linkedList = new LinkedList<VariableBinding>();
        if (treeMap2 != null) {
            int n = -1;
            for (Serializable serializable : treeMap2.values()) {
                if (((CellEdit)serializable).newValue instanceof GenTarget) {
                    bl2 = true;
                    n = ((CellEdit)serializable).info.getRow();
                    continue;
                }
                linkedList.addLast(((CellEdit)serializable).getVariableBinding(bl));
            }
            if (bl2) {
                if (n == -1) {
                    n = this._$4260.getRow(mIBTableModelRowKey.getIndex(), mIBTableModelRowKey.getTarget());
                }
                for (int i = this._$4260.getIndexColumnCount(); i < this._$4260.getNumColumns(); ++i) {
                    Serializable serializable;
                    if (!SMI.isWritable(this._$4260.getColumnObject(i).getAccess()) || treeMap2.get(new ObjectID(((OID)(serializable = this._$4260.getOidOf(n, i))).toString())) != null) continue;
                    JCValueConverter jCValueConverter = this._$4260.getValueConverter(i);
                    VariableBinding variableBinding = new VariableBinding();
                    variableBinding.setOid((OID)serializable);
                    if (bl) {
                        Variable variable = jCValueConverter.fromNative(this._$4260.getTableDataItem(n, i));
                        variableBinding.setVariable(variable);
                    }
                    linkedList.add(variableBinding);
                }
            }
        }
        return linkedList.toArray(new VariableBinding[0]);
    }

    private void _$35245(TreeMap treeMap) {
        if (treeMap.size() == 0) {
            return;
        }
        Object k = treeMap.firstKey();
        TreeMap treeMap2 = (TreeMap)treeMap.get(k);
        CellEdit[] cellEditArray = null;
        if (treeMap2 != null) {
            cellEditArray = new CellEdit[treeMap2.values().size()];
            treeMap2.values().toArray(cellEditArray);
            for (int i = 0; i < cellEditArray.length; ++i) {
                cellEditArray[i].committed = false;
            }
        }
    }

    public JCTableCellInfo getCellInfo(OID oID, GenTarget genTarget) {
        int n = this._$4260.getRow(oID, genTarget);
        if (n < 0) {
            return null;
        }
        int n2 = this._$4260.getColumn(oID);
        if (n2 < 0) {
            return null;
        }
        JCTableCellInfo jCTableCellInfo = new JCTableCellInfo();
        jCTableCellInfo.initialize(this._$4160, this._$4260.getTableDataItem(n, n2), n, n2, this._$4160.getCellStyle(n, n2));
        return jCTableCellInfo;
    }

    private JCTableCellInfo _$29697(int n, int n2) {
        JCTableCellInfo jCTableCellInfo = new JCTableCellInfo();
        jCTableCellInfo.initialize(this._$4160, this._$4260.getTableDataItem(n, n2), n, n2, this._$4160.getCellStyle(n, n2));
        return jCTableCellInfo;
    }

    public void commitChanges(boolean bl) {
        this._$4160.commitEdit(true);
        this.jButtonApply.setEnabled(false);
        this.jButtonApplyRead.setEnabled(false);
        this._$4160.setCursor(Cursor.getPredefinedCursor(3));
        this._$4634();
        this._$35232();
        if (this._$35145.size() == 0) {
            String[] stringArray = new String[]{"There are no recent modifications left to commit!", "Operation aborted."};
            JOptionPane.showMessageDialog(this, stringArray, "No Recent Modifications", 1);
            return;
        }
        this._$35141 = 0;
        Setter setter = new Setter(this._$35145, this._$35159, bl);
        setter.next(false, false);
    }

    public void undoChanges() {
    }

    void jButtonNewRow_actionPerformed(ActionEvent actionEvent) {
        if (!this._$4160.commitEdit(true)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        IndexDialog indexDialog = new IndexDialog(this._$18643, this._$35156, this._$20272, this, "Index of New Row", true, this._$4288.get("mibexplorer.vb.display.mode", null));
        indexDialog.setLocationRelativeTo(this);
        indexDialog.setVisible(true);
        if (indexDialog.getResult() == 0) {
            int n;
            List list = this._$4262;
            ObjectID objectID = indexDialog.getObjectID();
            if (this._$4262.size() > 1) {
                SelectTargetsDialog selectTargetsDialog = new SelectTargetsDialog(this._$18902, "Target Selection for New Row", true, this._$4262);
                selectTargetsDialog.setLocationRelativeTo(this);
                selectTargetsDialog.showIt();
                if (selectTargetsDialog.getResult() == 0) {
                    list = selectTargetsDialog.getSelectedTargets();
                } else {
                    return;
                }
            }
            for (GenTarget genTarget : list) {
                n = this._$4260.getRow(objectID, genTarget);
                if (n < 0) continue;
                String[] stringArray = new String[]{"The row with index " + objectID.toString() + " already exists on target '" + genTarget + "'."};
                JOptionPane.showMessageDialog(this, stringArray, "Invalid Index", 0);
                this.traverse(n, this.getFirstEditableColumn(), true, true);
                return;
            }
            for (GenTarget genTarget : list) {
                n = this._$4260.addNewRow(indexDialog.getObjectID(), genTarget);
                this._$29661.addEdit(new RowAddEdit(n, indexDialog.getObjectID(), genTarget));
                this.updateButtons();
                this.traverse(n, this.getFirstEditableColumn(), true, true);
            }
        }
    }

    void jButtonDuplicateRow_actionPerformed(ActionEvent actionEvent) {
        if (!this._$4160.commitEdit(true)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int n = com.agentpp.common.table.TableUtils.getFirstSelectedRow(this._$4160);
        if (n < 0) {
            return;
        }
        MIBTableModelRowKey mIBTableModelRowKey = this._$4260.getIndexOf(n);
        IndexDialog indexDialog = new IndexDialog(this._$18643, this._$35156, this._$20272, this, "Index for New Row", true, mIBTableModelRowKey.getIndex(), this._$4288.get("mibexplorer.vb.display.mode", null));
        indexDialog.setLocationRelativeTo(this);
        indexDialog.setVisible(true);
        if (indexDialog.getResult() == 0) {
            GenTarget genTarget;
            ObjectID objectID = indexDialog.getObjectID();
            int n2 = this._$4260.getRow(objectID, genTarget = this._$4260.getTarget(n));
            if (n2 >= 0) {
                String[] stringArray = new String[]{"The row with index " + objectID.toString() + " already exists."};
                JOptionPane.showMessageDialog(this, stringArray, "Invalid Index", 0);
                this.traverse(n2, this.getFirstEditableColumn(), true, true);
                return;
            }
            int n3 = this._$4260.duplicateRow(indexDialog.getObjectID(), n);
            this._$29661.addEdit(new RowAddEdit(n3, indexDialog.getObjectID(), genTarget));
            for (int i = this.getFirstEditableColumn(); i < this._$4260.getNumColumns(); ++i) {
                OID oID = this._$4260.getOidOf(n3, i);
                JCTableCellInfo jCTableCellInfo = this._$29697(n3, i);
                CellEdit cellEdit = new CellEdit(jCTableCellInfo, this._$4260.getTableDataItem(n, i), this._$4260.getTableDataItem(n3, i), oID);
                this._$29661.addEdit(cellEdit);
            }
            this.updateButtons();
            this.traverse(n3, this.getFirstEditableColumn(), true, true);
        }
    }

    public void traverse(int n, int n2, boolean bl, boolean bl2) {
        if (this._$35148) {
            this._$4160.traverse(n2, n, bl, bl2);
        } else {
            this._$4160.traverse(n, n2, bl, bl2);
            this._$4160.makeRowVisible(n);
        }
    }

    public int getFirstEditableColumn() {
        return this._$35144;
    }

    void jButtonRefresh_actionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    public void resendRequest(ResponseEvent responseEvent, ResponseListener responseListener) {
        if (responseEvent.getUserObject() instanceof Walker) {
            Walker walker = (Walker)responseEvent.getUserObject();
            walker._$4971 -= walker.getLastSend().size();
            if (walker._$35249 == 2) {
                walker._$35249 = 1;
            } else {
                walker._$35249 = Math.max(walker._$35249 / 2, 1);
            }
            walker.next();
        } else {
            this._$24536.requestFinishedWithError("SNMP Error: " + responseEvent.getResponse().getErrorStatusText());
        }
    }

    public void undo() {
        this._$4160.cancelEdit(true);
        this._$29661.undo();
        this.updateButtons();
    }

    public void redo() {
        this._$4160.cancelEdit(true);
        this._$29661.redo();
        this.updateButtons();
    }

    void jButtonUndo_actionPerformed(ActionEvent actionEvent) {
        this.undo();
    }

    void jButtonRedo_actionPerformed(ActionEvent actionEvent) {
        this.redo();
    }

    public void updateButtons() {
        boolean bl = this._$29661.canUndo();
        if (bl) {
            bl = false;
            for (UndoableEdit undoableEdit : this._$29661.getCurrentChanges()) {
                if (!(undoableEdit instanceof CellEdit) || ((CellEdit)undoableEdit).committed) continue;
                bl = true;
                break;
            }
        }
        this.jButtonFilterRows.setEnabled(this._$20272.length > 0);
        this.jButtonNewRow.setEnabled(this._$20272.length > 0 && this._$35279());
        this.jButtonUndo.setEnabled(this._$29661.canUndo());
        this.jButtonRedo.setEnabled(this._$29661.canRedo());
        this.jButtonApply.setEnabled(bl);
        this.jButtonApplyRead.setEnabled(bl);
    }

    private boolean _$35279() {
        if (this._$35177) {
            return true;
        }
        for (int i = this._$4260.getIndexColumnCount(); i < this._$4260.getNumColumns(); ++i) {
            if (SMI.accessType(this._$4260.getColumnObject(i).getAccess()) != 3) continue;
            return true;
        }
        return false;
    }

    public void setToolTipType(int n) {
        this._$35146 = n;
    }

    public int getToolTipType() {
        return this._$35146;
    }

    public void setShowRowLabels(boolean bl) {
        this._$35147 = bl;
        this._$4160.setRowLabelDisplay(this._$35147);
    }

    public boolean isShowRowLabels() {
        return this._$35147;
    }

    private void _$4451() {
        if (this._$35148) {
            this._$4160.setRowLabelDisplay(true);
            this._$4160.setColumnLabelDisplay(this._$35147);
        } else {
            this._$4160.setColumnLabelDisplay(true);
            this._$4160.setRowLabelDisplay(this._$35147);
        }
    }

    public void setTransposed(boolean bl) {
        this._$4160.commitEdit(true);
        this._$4160.removeCellDisplayListener(this);
        if (!this._$35148 && bl) {
            if (this._$18933 != null) {
                this._$18933.unsort();
            }
            this._$35140.setTransposed(bl);
            this._$35148 = bl;
            this._$4634();
            if (this._$4262.size() == 1) {
                this._$4160.setRowHidden(this._$4260.getIndexColumnCount(), false);
                this._$4160.setColumnHidden(this._$4260.getIndexColumnCount(), true);
            }
            int n = this._$4160.getFrozenColumns();
            this._$4160.setFrozenColumns(0);
            this._$4160.setFrozenRows(n);
        } else if (this._$35148 && !bl) {
            this._$35148 = bl;
            this._$35140.setTransposed(bl);
            this._$4634();
            if (this._$4262.size() == 1) {
                this._$4160.setRowHidden(this._$4260.getIndexColumnCount(), true);
                this._$4160.setColumnHidden(this._$4260.getIndexColumnCount(), false);
            }
            int n = this._$4160.getFrozenRows();
            this._$4160.setFrozenRows(0);
            this._$4160.setFrozenColumns(n);
        }
        this._$4451();
        this._$4160.addCellDisplayListener(this);
    }

    public boolean isTransposed() {
        return this._$35148;
    }

    void jButtonTranspose_actionPerformed(ActionEvent actionEvent) {
        this.setTransposed(!this.isTransposed());
    }

    @Override
    public void valueChanged(JCValueEvent jCValueEvent) {
        if (jCValueEvent.getSource().equals(this.jCSpinFieldRefresh)) {
            if (this._$4297 != null) {
                this._$4297.cancel();
            }
            this.runTimer();
        }
    }

    public synchronized void runTimer() {
        this._$4297 = new Timer();
        Long l = (Long)this.jCSpinFieldRefresh.getValue();
        long l2 = l * 10L * (long)this._$29904;
        if (l2 > 0L) {
            this._$29905 = true;
            this._$4297.schedule((TimerTask)new PeriodicRefresh(this._$29904), l2, l2);
        }
        this._$25240();
    }

    private void _$25240() {
        this.jButtonPlay.setEnabled(!this._$29905);
        this.jButtonPause.setEnabled(this._$29905);
    }

    @Override
    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    protected MIBTablePanel getPanel() {
        return this;
    }

    void jButtonPause_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
    }

    void jButtonPlay_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
        this.runTimer();
    }

    public void setPeriodicRefreshStepping(int n) {
        this._$29904 = n;
    }

    public int getPeriodicRefreshStepping() {
        return this._$29904;
    }

    public boolean isPeriodicRefreshEnabled() {
        return this._$29905;
    }

    private boolean _$35288(IndexStruct[] indexStructArray) {
        for (int i = 0; i < indexStructArray.length; ++i) {
            IndexStruct indexStruct = indexStructArray[i];
            if (indexStruct.minLength == indexStruct.maxLength || indexStruct.impliedLength) continue;
            return true;
        }
        return false;
    }

    void jButtonFilterRows_actionPerformed(ActionEvent actionEvent) {
        StandardDialog standardDialog = new StandardDialog(this, "Set Filter", true);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        boolean bl = this._$35288(this._$20272);
        IndexFilterPanel indexFilterPanel = new IndexFilterPanel(this._$4288.get("mibexplorer.vb.display.mode", null));
        ObjectID[] objectIDArray = null;
        if (this._$35153 != null) {
            objectIDArray = this._$18643.getIndexObjectIDs(this._$35153, this._$20272);
        }
        indexFilterPanel.getIndexPanelFrom().setIndexStruct(this._$18643, this._$35156, this._$20272, objectIDArray);
        ObjectID[] objectIDArray2 = null;
        if (this._$35154 != null) {
            objectIDArray2 = this._$18643.getIndexObjectIDs(this._$35154, this._$20272);
        }
        indexFilterPanel.getIndexPanelTo().setIndexStruct(this._$18643, this._$35156, this._$20272, objectIDArray2);
        if (this._$35153 == null && this._$35154 == null) {
            indexFilterPanel.setLowerBound(true);
            indexFilterPanel.setUpperBound(true);
        } else {
            indexFilterPanel.setLowerBound(this._$35153 != null);
            indexFilterPanel.setUpperBound(this._$35154 != null);
        }
        if (bl) {
            jPanel.add((Component)indexFilterPanel, "Center");
            JTextArea jTextArea = new JTextArea("Due to explicit length sub-IDs in this index, only filtering for exactly specified values for these sub-index(es) will return the expected results. For prefix filtering, use the column filter from the column context menu instead.", 3, 40);
            jTextArea.setForeground(Color.red);
            jTextArea.setEditable(false);
            jTextArea.setBackground(new JLabel().getBackground());
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            jPanel.add((Component)jTextArea, "South");
            standardDialog.setCenterPanel(jPanel);
        } else {
            standardDialog.setCenterPanel(indexFilterPanel);
        }
        standardDialog.setLocationRelativeTo(this);
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            this._$35153 = indexFilterPanel.getIndexPanelFrom().getObjectID();
            if (!indexFilterPanel.isLowerBound() || this._$35153 != null && !this._$35153.isValid()) {
                this._$35153 = null;
            }
            this._$35154 = indexFilterPanel.getIndexPanelTo().getObjectID();
            if (!indexFilterPanel.isUpperBound() || this._$35154 != null && !this._$35154.isValid()) {
                this._$35154 = null;
            }
            this.clear();
            this.refresh();
        }
        this._$35293();
    }

    public void setIndexFrom(ObjectID objectID) {
        this._$35153 = objectID;
    }

    public ObjectID getIndexFrom() {
        return this._$35153;
    }

    public void setIndexTo(ObjectID objectID) {
        this._$35154 = objectID;
    }

    public ObjectID getIndexTo() {
        return this._$35154;
    }

    private void _$35193() {
        this.restoreAction.setEnabled(this._$35192());
    }

    private void _$35293() {
        if (this._$35153 == null && this._$35154 == null) {
            this.filterStatus.setText("");
        } else {
            ObjectID[] objectIDArray;
            String string = "Filter: ";
            if (this._$35153 != null) {
                string = string + "From ";
                objectIDArray = this._$18643.getIndexObjectIDs(this._$35153, this._$20272);
                string = string + "[" + IndexConverter.getIndexString(this._$35156, this._$20272, objectIDArray) + "]";
            }
            if (this._$35154 != null) {
                string = string + " To ";
                objectIDArray = this._$18643.getIndexObjectIDs(this._$35154, this._$20272);
                string = string + "[" + IndexConverter.getIndexString(this._$35156, this._$20272, objectIDArray) + "]";
            }
            this.filterStatus.setText(string);
        }
    }

    public void setDisplayOID(boolean bl) {
        this._$29665 = bl;
    }

    public boolean isDisplayOID() {
        return this._$29665;
    }

    void jButtonPreferences_actionPerformed(ActionEvent actionEvent) {
        MIBTablePreferences mIBTablePreferences = new MIBTablePreferences();
        mIBTablePreferences.setTooltipDisplay(this._$35146);
        mIBTablePreferences.setDisplayOID(this._$29665);
        StandardDialog standardDialog = new StandardDialog(this, "Preferences", true);
        standardDialog.setCenterPanel(mIBTablePreferences);
        standardDialog.setLocationRelativeTo(this);
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            this._$29665 = mIBTablePreferences.isDisplayOID();
            this._$35146 = mIBTablePreferences.getTooltipDisplay();
        }
    }

    public boolean isSortable() {
        return this._$35158;
    }

    public void setMaxRepetitions(int n) {
        this._$29680 = n;
    }

    public void setMaxVBS(int n) {
        this._$35159 = n;
    }

    public int getMaxVBS() {
        return this._$35159;
    }

    private void _$35235() {
        this.jButtonApply.setEnabled(this._$29661.canUndo());
        this.jButtonApplyRead.setEnabled(this._$29661.canUndo());
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            String string;
            Object object;
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Point point = dropTargetDropEvent.getLocation();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object2 = transferable.getTransferData(DraggableTreeNode.supported[1]);
            if (object2 instanceof ByteArrayInputStream) {
                object = new byte[((ByteArrayInputStream)object2).available()];
                ((ByteArrayInputStream)object2).read((byte[])object);
                string = new String((byte[])object);
            } else {
                string = (String)object2;
            }
            object = new ObjectID(string);
            if (!((ObjectID)object).isValid()) {
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            this._$4160.cancelEdit(true);
            CellArea cellArea = this._$4160.getCellAreaHandler().getCellArea();
            JCCellPosition jCCellPosition = this._$4160.XYToCell(point.x + cellArea.getStandardOffsetX(), point.y + cellArea.getStandardOffsetY());
            Object object3 = this._$4160.getDataView().getTableDataItem(jCCellPosition.row, jCCellPosition.column);
            int n = this._$4419(jCCellPosition.row, jCCellPosition.column);
            int n2 = this._$29694(jCCellPosition.row, jCCellPosition.column);
            OID oID = this._$4260.getOidOf(n, n2);
            if (object3 instanceof ObjectID && this._$4160.getCellStyle(jCCellPosition.row, jCCellPosition.column).isEditable()) {
                this._$29663 = new CellEdit(this._$29697(n, n2), object3, object, oID);
                this._$29661.addEdit(this._$29663);
                this._$4160.getDataView().setTableDataItem(object, jCCellPosition.row, jCCellPosition.column);
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.dropComplete(false);
            exception.printStackTrace();
        }
        this.updateButtons();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        try {
            if (DraggableTreeNode.supported.length < 1) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            boolean bl = dropTargetDragEvent.isDataFlavorSupported(DraggableTreeNode.supported[1]);
            int n = dropTargetDragEvent.getDropAction();
            if (bl && (n & 3) > 0) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    void jButtonApplyRead_actionPerformed(ActionEvent actionEvent) {
        this.commitChanges(true);
    }

    private void _$35306(int n, ColumnFilter columnFilter) {
        Object object = this._$4260.getTableColumnLabel(n);
        if (object instanceof SortLabel) {
            ((SortLabel)object).setFilter(columnFilter);
        }
        this._$35139 = this._$35307();
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int n;
        if (jCSelectEvent.getStartColumn() == -1) {
            this.traverse(jCSelectEvent.getStartRow(), 0, false, false);
        }
        if (jCSelectEvent.getStartRow() == -1) {
            this.traverse(0, jCSelectEvent.getStartColumn(), false, false);
        }
        this.jButtonDuplicateRow.setEnabled((n = com.agentpp.common.table.TableUtils.getFirstSelectedRow(this._$4160)) >= 0);
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
        this.setMessage(null);
    }

    @Override
    public void afterTraverseCell(JCTraverseCellEvent jCTraverseCellEvent) {
        this._$35135 = jCTraverseCellEvent.getNextRow();
        this._$35136 = jCTraverseCellEvent.getNextColumn();
        if (jCTraverseCellEvent.getTraverseType() == 0) {
            this.repaint();
        }
    }

    @Override
    public void traverseCell(JCTraverseCellEvent jCTraverseCellEvent) {
    }

    void jButtonExport_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            JFileChooser jFileChooser = new JFileChooser(new File(this._$4288.get("mibexplorer.LogPath", "")));
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.addExtension("xls");
            exampleFileFilter.addExtension("xml");
            jFileChooser.setFileFilter(exampleFileFilter);
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showSaveDialog(this._$18902) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!(file.getName().toUpperCase().endsWith(SUFFIX_CSV) || file.getName().toUpperCase().endsWith(SUFFIX_XLS) || file.getName().toUpperCase().endsWith(SUFFIX_XML))) {
                    file = new File(file.getParentFile(), file.getName() + SUFFIX_CSV.toLowerCase());
                }
                this._$4288.put("mibexplorer.LogPath", jFileChooser.getSelectedFile().getParent());
                if (file.exists()) {
                    Object[] objectArray;
                    int n = 1;
                    if (file.getPath().toUpperCase().endsWith(SUFFIX_XML)) {
                        objectArray = new String[]{"Overwrite", "Cancel"};
                        n = 0;
                    } else {
                        objectArray = new String[]{"Overwrite", "Append", "Cancel"};
                    }
                    int n2 = JOptionPane.showOptionDialog(this._$18902, "File already exists. Overwrite it?", "Log File", n, 3, null, objectArray, objectArray[1]);
                    if (n2 == 2) {
                        this._$29896 = null;
                        this.jButtonExport.setSelected(false);
                        return;
                    }
                    this._$29897 = n2 != 0;
                }
                this._$29896 = file;
                if (this.isPeriodicRefreshEnabled()) {
                    this.stopTimer();
                    this.runTimer();
                } else {
                    this.refreshFinished();
                }
            } else {
                this._$29896 = null;
                this.jButtonExport.setSelected(false);
            }
        } else {
            this._$29896 = null;
        }
    }

    private String _$32012() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"Time\"");
        for (int i = 0; i < this._$4260.getNumColumns(); ++i) {
            stringBuffer.append(",\"");
            stringBuffer.append(this._$4260.getTableColumnLabel(i));
            stringBuffer.append('\"');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTableToFile(File file, boolean bl) throws IOException {
        Object object = this._$4339;
        synchronized (object) {
            boolean bl2 = true;
            if (file.exists()) {
                bl2 = false;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_XLS);
            String string = simpleDateFormat.format(new Date());
            if (file.getPath().toUpperCase().endsWith(SUFFIX_XLS)) {
                Table2XLS table2XLS = new Table2XLS();
                table2XLS.setSheedTitle(string);
                table2XLS.setTable(this._$4160);
                if (!bl2 && bl) {
                    table2XLS.appendXLSFile(file);
                } else {
                    table2XLS.writeXLSFile(file);
                }
            } else if (file.getPath().toUpperCase().endsWith(SUFFIX_XML)) {
                Table2XML table2XML = new Table2XML(this._$4262.get(0), this._$4260, this._$4260.getIndexColumnCount(), this._$18643, this._$4260.getValueConverters(), this._$4358);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                table2XML.write(fileOutputStream);
                fileOutputStream.close();
            } else {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(DATE_FORMAT);
                String string2 = simpleDateFormat2.format(new Date());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file.getPath(), bl));
                if (bl2 || !bl) {
                    bufferedOutputStream.write(this._$32012().getBytes());
                }
                for (int i = 0; i < this._$4260.getNumDataRows(); ++i) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('\"');
                    stringBuffer.append(string2);
                    stringBuffer.append('\"');
                    for (int j = 0; j < this._$4260.getNumColumns(); ++j) {
                        stringBuffer.append(",\"");
                        stringBuffer.append(this._$4260.getTableDataItem(i, j));
                        stringBuffer.append('\"');
                    }
                    stringBuffer.append('\n');
                    bufferedOutputStream.write(stringBuffer.toString().getBytes());
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
    }

    @Override
    public void setCurrentRequest(PDU pDU, ResponseListener responseListener, String string) {
    }

    @Override
    public void requestFinishedWithError(String string) {
        this._$24536.requestFinishedWithError(string);
    }

    @Override
    public void requestFinished() {
        this._$24536.requestFinished();
    }

    @Override
    public void request(int n, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) {
    }

    @Override
    public void resendRequest(int n, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) {
    }

    @Override
    public boolean isRequestCanceled() {
        return false;
    }

    @Override
    public void setMessage(String string) {
        this._$24536.setMessage(string);
    }

    @Override
    public String getMessage() {
        return this._$24536.getMessage();
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this._$35259();
        }
    }

    private Pattern _$35328(String string, boolean bl) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this._$35172.compile(string);
            }
            catch (MalformedPatternException malformedPatternException) {
                if (bl) break block2;
                JOptionPane.showMessageDialog(this, malformedPatternException.getMessage(), "Malformed Search Expression", 0);
            }
        }
        return pattern;
    }

    private boolean _$35330(Pattern pattern, boolean bl) {
        this.setMessage("");
        JCCellPosition jCCellPosition = this._$4160.getCurrentCell();
        int n = this._$4419(jCCellPosition.row, jCCellPosition.column);
        jCCellPosition.column = this._$29694(jCCellPosition.row, jCCellPosition.column);
        jCCellPosition.row = n;
        this._$35173 = pattern;
        if (jCCellPosition == null) {
            jCCellPosition = new JCCellPosition(0, 0);
        }
        if (jCCellPosition.row <= 0) {
            jCCellPosition.row = 0;
        }
        if (jCCellPosition.column < 0) {
            jCCellPosition.column = 0;
        }
        for (int i = jCCellPosition.row; i < this._$4260.getNumDataRows(); ++i) {
            int n2;
            for (int j = n2 = i == jCCellPosition.row ? jCCellPosition.column + 1 : 0; j < this._$4260.getNumColumns(); ++j) {
                Object object = this._$4260.getTableDataItem(i, j);
                if (object == null) continue;
                if (bl) {
                    JCCellDisplayEvent jCCellDisplayEvent = new JCCellDisplayEvent(this, i, j, object);
                    this.cellDisplay(jCCellDisplayEvent);
                    if (jCCellDisplayEvent.getDisplayData() != null) {
                        object = jCCellDisplayEvent.getDisplayData();
                    }
                }
                this._$29803 = new PatternMatcherInput(object.toString());
                if (!this._$35171.contains(this._$29803, pattern)) continue;
                this._$4160.traverse(i, j, false, false);
                return true;
            }
        }
        this.setMessage("Search complete!");
        return false;
    }

    public boolean replace(Pattern pattern, String string) {
        Perl5Substitution perl5Substitution = new Perl5Substitution(string);
        int n = -1;
        block5: while (this._$35330(pattern, false)) {
            Object object;
            Object object2;
            JCCellPosition jCCellPosition = this._$4160.getCurrentCell();
            int n2 = this._$29694(jCCellPosition.row, jCCellPosition.column);
            int n3 = this._$4419(jCCellPosition.row, jCCellPosition.column);
            if (n2 >= this._$4260.getIndexColumnCount() && !this._$4260.isCellEditable(n3, n2)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            if (n != 1) {
                object2 = new String[]{"Replace?"};
                object = new String[]{"Yes", "Yes to All", "No", "Cancel"};
                n = JOptionPane.showOptionDialog(this, object2, "Confirm Substitution", 1, 3, null, (Object[])object, object[0]);
            }
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    continue block5;
                }
                case 3: {
                    this.updateButtons();
                    return false;
                }
            }
            object2 = this._$4260.getTableDataItem(this._$4419(jCCellPosition.row, jCCellPosition.column), this._$29694(jCCellPosition.row, jCCellPosition.column));
            if (object2 == null) continue;
            this._$29803 = new PatternMatcherInput(object2.toString());
            Util.substitute(stringBuffer, this._$35171, pattern, (Substitution)perl5Substitution, this._$29803, 1);
            object = this._$4260.getValueConverter(this._$29694(jCCellPosition.row, jCCellPosition.column));
            object2 = ((ValueConverter)object).fromString(stringBuffer.toString());
            if (object2 == null) {
                if (JOptionPane.showConfirmDialog(this, "Cell value '" + stringBuffer.toString() + "' cannot be converted! Continue replace?", "Conversion Failed: " + jCCellPosition.row + "," + jCCellPosition.column, 0) == 1) {
                    this.updateButtons();
                }
                return false;
            }
            int n4 = this._$4419(jCCellPosition.row, jCCellPosition.column);
            int n5 = this._$29694(jCCellPosition.row, jCCellPosition.column);
            Object object3 = ((ValueConverter)object).toNative((Variable)object2);
            OID oID = this._$4260.getOidOf(n4, n5);
            JCTableCellInfo jCTableCellInfo = this._$29697(n4, n5);
            CellEdit cellEdit = new CellEdit(jCTableCellInfo, this._$4260.getTableDataItem(n4, n5), object3, oID);
            this._$29661.addEdit(cellEdit);
            this._$4260.setTableDataItem(object3, n4, n5);
        }
        this.updateButtons();
        return true;
    }

    void jButtonSearch_actionPerformed(ActionEvent actionEvent) {
        SearchReplacePanel searchReplacePanel = new SearchReplacePanel();
        searchReplacePanel.setReplaceEnabled(false);
        searchReplacePanel.setSearchExpressions(this._$4288.getArray("mibexplorer.SearchExpression"));
        StandardDialog standardDialog = new StandardDialog((Frame)this._$18902, "Find", true, true);
        standardDialog.setCenterPanel(searchReplacePanel);
        standardDialog.setLocationRelativeTo(this);
        do {
            Pattern pattern;
            standardDialog.setVisible(true);
            if (standardDialog.getResult() != 0 || (pattern = this._$35328(searchReplacePanel.getSearchExpression(), false)) == null) continue;
            this._$4288.putArray("mibexplorer.SearchExpression", searchReplacePanel.getSearchExpressions());
            this._$35330(pattern, true);
            break;
        } while (standardDialog.getResult() == 0);
    }

    void jButtonSearchAgain_actionPerformed(ActionEvent actionEvent) {
        this._$35330(this._$35173, true);
    }

    void jButtonReplace_actionPerformed(ActionEvent actionEvent) {
        SearchReplacePanel searchReplacePanel = new SearchReplacePanel();
        searchReplacePanel.setReplaceEnabled(true);
        searchReplacePanel.setSearchExpressions(this._$4288.getArray("mibexplorer.SearchExpression"));
        searchReplacePanel.setSubstitutionStrings(this._$4288.getArray("mibexplorer.SearchReplace"));
        StandardDialog standardDialog = new StandardDialog((Frame)this._$18902, "Replace", true, true);
        standardDialog.setCenterPanel(searchReplacePanel);
        standardDialog.setLocationRelativeTo(this._$18902);
        do {
            Pattern pattern;
            standardDialog.setVisible(true);
            if (standardDialog.getResult() != 0 || (pattern = this._$35328(searchReplacePanel.getSearchExpression(), false)) == null) continue;
            this._$4288.putArray("mibexplorer.SearchExpression", searchReplacePanel.getSearchExpressions());
            this._$4288.putArray("mibexplorer.SearchReplace", searchReplacePanel.getSubstitutionStrings());
            this.replace(pattern, searchReplacePanel.getSubstitutionString());
            break;
        } while (standardDialog.getResult() == 0);
    }

    void jButtonPrint_actionPerformed(ActionEvent actionEvent) {
        TableFlow tableFlow = new TableFlow();
        JCTableView jCTableView = new JCTableView();
        jCTableView.setTable(this._$4160);
        tableFlow.setCurrentTable(jCTableView);
        PrintActionPanel printActionPanel = new PrintActionPanel(this.getParentFrame(), "TableView_" + this.getShortTitle());
        printActionPanel.setDocumentFlow(tableFlow);
        if (JOptionPane.showConfirmDialog(this, printActionPanel, "Print " + this.getTitle(), 2, -1) == 0) {
            printActionPanel.getActionPanel().actionPerformed(new ActionEvent(this, 0, "Print"));
        }
    }

    public void setShortTitle(String string) {
        this._$35175 = string;
    }

    public String getShortTitle() {
        return this._$35175;
    }

    public JFrame getParentFrame() {
        return this._$35176;
    }

    public boolean isDisableReadOnly() {
        return this._$35177;
    }

    public boolean isMultiLineStrings() {
        return this._$35178;
    }

    public void setMultiLineStrings(boolean bl) {
        this._$35178 = bl;
    }

    private boolean _$35307() {
        for (int i = 0; i < this._$4260.getNumColumns(); ++i) {
            Object object = this._$4260.getTableColumnLabel(i);
            if (!(object instanceof SortLabel) || ((SortLabel)object).getFilter() == null) continue;
            return true;
        }
        return false;
    }

    private boolean _$35349(TableEvent tableEvent) {
        if (this._$35139) {
            int n;
            Vector vector = this._$4260.getIndexObjects(new ObjectID(tableEvent.getIndex().getValue()));
            VariableBinding[] variableBindingArray = tableEvent.getColumns();
            for (n = 0; n < this._$4260.getIndexColumnCount(); ++n) {
                Object object = this._$4260.getTableColumnLabel(n);
                if (!(object instanceof SortLabel) || ((SortLabel)object).getFilter() == null || ((SortLabel)object).getFilter().passesFilter(vector.get(n))) continue;
                return false;
            }
            for (n = 0; n < variableBindingArray.length; ++n) {
                int n2 = n + this._$4260.getIndexColumnCount();
                Object object = this._$4260.getTableColumnLabel(n2);
                if (variableBindingArray[n] == null) {
                    if (!(object instanceof SortLabel) || ((SortLabel)object).getFilter() == null || ((SortLabel)object).getFilter().passesFilter(null)) continue;
                    return false;
                }
                if (!(object instanceof SortLabel) || ((SortLabel)object).getFilter() == null) continue;
                JCValueConverter jCValueConverter = this._$4260.getValueConverter(n2);
                Object object2 = jCValueConverter.toNative(variableBindingArray[n].getVariable());
                if (((SortLabel)object).getFilter().passesFilter(object2)) continue;
                return false;
            }
        }
        return true;
    }

    class TableWalker
    extends TableUtils {
        private boolean _$35354;
        private GenTarget _$4897;

        public TableWalker(Session session, GenTarget genTarget) {
            super(session, new DefaultPDUFactory());
            this._$35354 = false;
            this._$4897 = genTarget;
        }

        protected TableUtils.TableRequest createTableRequest(Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
            return new ExtTableRequest(this._$4897, target, oIDArray, tableListener, object, oID, oID2);
        }

        public class ExtTableRequest
        extends TableUtils.TableRequest {
            private GenTarget _$4897;

            public ExtTableRequest(GenTarget genTarget, Target target, OID[] oIDArray, TableListener tableListener, Object object, OID oID, OID oID2) {
                super(TableWalker.this, target, oIDArray, tableListener, object, oID, oID2);
                this._$4897 = genTarget;
            }

            protected void sendRequest(PDU pDU, Target target, Integer n) throws IOException {
                if (!TableWalker.this._$35354) {
                    MIBTablePanel.this._$24536.resendRequest(-91, pDU, this._$4897, target, n, this, MIBTablePanel.this._$35234());
                } else {
                    TableWalker.this._$35354 = true;
                    MIBTablePanel.this._$24536.request(-91, pDU, this._$4897, target, n, this, MIBTablePanel.this._$35234());
                }
            }
        }
    }

    class InnerTableListener
    implements TableListener {
        private GenTarget _$4262;
        private boolean _$29975 = false;

        public InnerTableListener(GenTarget genTarget) {
            this._$4262 = genTarget;
        }

        public boolean isFinished() {
            return this._$29975;
        }

        public boolean next(TableEvent tableEvent) {
            if (tableEvent.getStatus() == 0 && tableEvent.getColumns() != null && tableEvent.getColumns().length > 0 && MIBTablePanel.this._$35349(tableEvent)) {
                MIBTablePanel.this._$4260.addOrUpdateRow(this._$4262, new ObjectID(tableEvent.getIndex().getValue()), tableEvent.getColumns());
            }
            return MIBTablePanel.this._$24536.isRequestCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent tableEvent) {
            this._$29975 = true;
            Object object = MIBTablePanel.this._$4339;
            synchronized (object) {
                if (tableEvent.getStatus() != 0) {
                    MIBTablePanel.this.requestFinishedWithError(tableEvent.getErrorMessage());
                } else {
                    MIBTablePanel.this.requestFinished();
                    if (tableEvent.getColumns() != null && tableEvent.getColumns().length > 0 && MIBTablePanel.this._$35349(tableEvent)) {
                        MIBTablePanel.this._$4260.addOrUpdateRow(this._$4262, new ObjectID(tableEvent.getIndex().getValue()), tableEvent.getColumns());
                    }
                    MIBTablePanel.this._$4160.setCursor(Cursor.getDefaultCursor());
                    MIBTablePanel.this._$4339.notify();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MIBTablePanel.this._$4260.refreshEnd();
                            MIBTablePanel.this._$35191();
                            MIBTablePanel.this.refreshFinished();
                            MIBTablePanel.this._$4160.repaint();
                        }
                    });
                }
            }
        }
    }

    class Walker {
        private int _$4971 = 0;
        private Vector _$34997;
        private Vector _$35325;
        private int _$35249;
        private boolean _$34760 = false;
        private GenTarget _$4262;
        private Target _$773;

        public Walker(Vector vector, int n, GenTarget genTarget, Target target) {
            this._$34997 = vector;
            this._$35249 = n;
            this._$4262 = genTarget;
            this._$773 = target;
        }

        public Vector getLastSend() {
            return this._$35325;
        }

        public void setMaxColumns(int n) {
            this._$35249 = n;
        }

        public void setLastSend(Vector vector) {
            this._$35325 = vector;
        }

        public boolean next() {
            if (this._$4971 >= this._$34997.size()) {
                return false;
            }
            MIBTablePanel.this._$4276 = this._$4262.makePDU();
            int n = Math.min(this._$35249, this._$34997.size() - this._$4971);
            if (MIBTablePanel.this._$29680 > 0) {
                MIBTablePanel.this._$4276.setMaxRepetitions(MIBTablePanel.this._$29680);
                MIBTablePanel.this._$4276.setNonRepeaters(0);
            } else {
                MIBTablePanel.this._$4276.setNonRepeaters(n);
                MIBTablePanel.this._$4276.setMaxRepetitions(0);
            }
            this._$35325 = new Vector(n + 1);
            for (int i = this._$4971; i < this._$4971 + n; ++i) {
                Serializable serializable;
                OID oID = (OID)this._$34997.get(i);
                if (MIBTablePanel.this._$35153 != null) {
                    serializable = new ObjectID(oID.toString());
                    ((ObjectID)serializable).append(MIBTablePanel.this._$35153);
                    serializable = MIBTablePanel.predecessor((ObjectID)serializable);
                    oID = new OID(((ObjectID)serializable).toString());
                }
                serializable = new VariableBinding();
                ((VariableBinding)serializable).setOid(oID);
                MIBTablePanel.this._$4276.add((VariableBinding)serializable);
                this._$35325.add(this._$34997.elementAt(i));
            }
            try {
                Target target = this._$4262.getTarget();
                if (this._$4971 == 0) {
                    MIBTablePanel.this._$24536.request(-91, MIBTablePanel.this._$4276, this._$4262, target, this, MIBTablePanel.this, MIBTablePanel.this._$35234());
                } else {
                    MIBTablePanel.this._$24536.resendRequest(-91, MIBTablePanel.this._$4276, this._$4262, target, this, MIBTablePanel.this, MIBTablePanel.this._$35234());
                }
                this._$4971 += MIBTablePanel.this._$4276.size();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Getter {
        private int _$4971 = 0;
        private int _$35249;
        private TreeMap<MIBTableModelRowKey, TreeMap<ObjectID, CellEdit>> _$35145;
        private int _$4618 = 0;
        private GenTarget _$4262;
        private Target _$773;

        public Getter(TreeMap<MIBTableModelRowKey, TreeMap<ObjectID, CellEdit>> treeMap, int n, GenTarget genTarget, Target target) {
            this._$35145 = treeMap;
            this._$35249 = n;
            this._$4618 = treeMap.size();
            this._$4262 = genTarget;
            this._$773 = target;
        }

        private void _$35322() {
            if (this._$35145.size() == 0) {
                return;
            }
            MIBTableModelRowKey mIBTableModelRowKey = this._$35145.firstKey();
            this._$35145.remove(mIBTableModelRowKey);
        }

        private String _$35323() {
            double d = this._$4971;
            int n = (int)(d / (double)this._$4618 * 100.0);
            return "" + n + "% verified";
        }

        public synchronized boolean next() {
            if (this._$4971 > 0) {
                this._$35322();
            }
            if (this._$35145.size() == 0) {
                return false;
            }
            String string = this._$35145.firstKey().toString();
            GenTarget genTarget = this._$35145.firstKey().getTarget();
            PDU pDU = genTarget.makePDU();
            VariableBinding[] variableBindingArray = MIBTablePanel.this._$35268(this._$35145, false);
            if (variableBindingArray == null || variableBindingArray.length == 0) {
                return false;
            }
            pDU.addAll(variableBindingArray);
            MIBTablePanel.this._$24536.resendRequest(-96, pDU, genTarget, this._$773, this, MIBTablePanel.this, this._$35323() + ", verifying row " + string);
            ++this._$4971;
            return true;
        }
    }

    class Setter {
        private int _$4971 = 0;
        private int _$35249;
        private TreeMap _$35145;
        boolean verify = false;
        private int _$4618 = 0;
        private TreeMap _$35320;
        private GenTarget _$4262;

        public Setter(TreeMap treeMap, int n, boolean bl) {
            this._$35145 = treeMap;
            this._$35320 = (TreeMap)treeMap.clone();
            this._$35249 = n;
            this.verify = bl;
            this._$4618 = treeMap.size();
        }

        private void _$35322() {
            if (this._$35145.size() == 0) {
                return;
            }
            Object k = this._$35145.firstKey();
            this._$35145.remove(k);
        }

        public TreeMap getVerificationList() {
            return this._$35320;
        }

        private String _$35323() {
            double d = this._$4971;
            int n = (int)(d / (double)this._$4618 * 100.0);
            return "" + n + "% committed";
        }

        public synchronized boolean next(boolean bl, boolean bl2) {
            if (this._$4971 > 0) {
                if (!bl2 && !this._$35145.isEmpty()) {
                    MIBTablePanel.this._$35245(this._$35145);
                }
                this._$35322();
            }
            if (this._$35145.size() == 0) {
                return false;
            }
            String string = this._$35145.firstKey().toString();
            this._$4262 = ((MIBTableModelRowKey)this._$35145.firstKey()).getTarget();
            Target target = this._$4262.getTarget();
            PDU pDU = this._$4262.makePDU();
            VariableBinding[] variableBindingArray = MIBTablePanel.this._$35268(this._$35145, true);
            if (variableBindingArray == null || variableBindingArray.length == 0) {
                return false;
            }
            pDU.addAll(variableBindingArray);
            if (!bl && this._$4971 > 0) {
                MIBTablePanel.this._$24536.resendRequest(-93, pDU, this._$4262, target, this, MIBTablePanel.this, this._$35323() + ", writing row " + string);
            } else {
                MIBTablePanel.this._$24536.request(-93, pDU, this._$4262, target, this, MIBTablePanel.this, this._$35323() + ", writing row " + string);
            }
            ++this._$4971;
            return true;
        }

        public GenTarget getTarget() {
            return this._$4262;
        }
    }

    class SetContinue
    implements Runnable {
        private String[] _$18911;
        private String _$35239;
        private Setter _$35242;

        public SetContinue(String[] stringArray, String string, Setter setter) {
            this._$18911 = stringArray;
            this._$35239 = string;
            this._$35242 = setter;
        }

        public void run() {
            Object[] objectArray = new String[]{"Commit", "Cancel"};
            if (JOptionPane.showOptionDialog(MIBTablePanel.this.getPanel(), this._$18911, "Row Commit Failed: " + this._$35239, 0, 0, null, objectArray, objectArray[0]) == 0) {
                this._$35242.next(true, false);
            } else if (this._$35242.verify) {
                Getter getter = new Getter(this._$35242.getVerificationList(), this._$35242._$35249, this._$35242.getTarget(), this._$35242.getTarget().getTarget());
                getter.next();
            }
        }
    }

    class CellEditorAction
    extends AbstractAction {
        public CellEditorAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MIBTablePanel.this.setMultiLineStrings(!MIBTablePanel.this.isMultiLineStrings());
            MIBTablePanel.this._$4634();
        }
    }

    class ColWidthAction
    extends AbstractAction {
        public ColWidthAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "mibexplorer.table.colWidth." + MIBTablePanel.this._$4358.getName() + ".";
            if (MIBTablePanel._$35131.equals(actionEvent.getActionCommand())) {
                MIBTablePanel.this._$4160.saveColumnWidths(MIBTablePanel.this._$4288, string);
            } else if (MIBTablePanel._$35132.equals(actionEvent.getActionCommand())) {
                MIBTablePanel.this._$4160.restoreColumnWidths(MIBTablePanel.this._$4288, string);
            } else if (MIBTablePanel._$35133.equals(actionEvent.getActionCommand())) {
                MIBTablePanel.this._$4160.resetColumnWidths(MIBTablePanel.this._$4288, string);
            }
            MIBTablePanel.this._$35193();
        }
    }

    class FormatAction
    extends AbstractAction {
        private String _$5168;

        public FormatAction(String string, String string2) {
            super(string);
            this._$5168 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = MIBTablePanel.this._$4160.getPopupCellPosition();
            int n = MIBTablePanel.this._$29694(jCCellPosition.row, jCCellPosition.column);
            JCValueConverter jCValueConverter = MIBTablePanel.this._$4260.getValueConverter(n);
            if (jCValueConverter != null) {
                MIBTablePanel.this._$4160.commitEdit(true);
                Variable[] variableArray = new Variable[MIBTablePanel.this._$4260.getNumDataRows()];
                for (int i = 0; i < MIBTablePanel.this._$4260.getNumDataRows(); ++i) {
                    variableArray[i] = jCValueConverter.fromNative(MIBTablePanel.this._$4260.getTableDataItem(i, n));
                }
                if (this._$5168 == null) {
                    MIBTextualConvention mIBTextualConvention = MIBTablePanel.this._$18643.getEffectiveSyntax(jCValueConverter.getObjectType().getSyntax());
                    if (mIBTextualConvention.getDisplayHint() != null) {
                        jCValueConverter.setDisplayHint(MIBObject.getUnquotedString(mIBTextualConvention.getDisplayHint()));
                    } else {
                        jCValueConverter.setDisplayHint(MIBTablePanel.this._$4360);
                    }
                } else {
                    jCValueConverter.setDisplayHint(this._$5168);
                }
                for (int i = 0; i < MIBTablePanel.this._$4260.getNumDataRows(); ++i) {
                    MIBTablePanel.this._$4260.setTableDataItem(jCValueConverter.toNative(variableArray[i]), i, n);
                }
            }
        }
    }

    class FilterAction
    extends AbstractAction {
        public FilterAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = MIBTablePanel.this._$4160.getPopupCellPosition();
            int n = MIBTablePanel.this._$29694(jCCellPosition.row, jCCellPosition.column);
            if (MIBTablePanel._$35123.equals(actionEvent.getActionCommand())) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < MIBTablePanel.this._$4260.getNumDataRows(); ++i) {
                    hashSet.add(MIBTablePanel.this._$4260.getTableDataItem(i, n));
                }
                if (hashSet.size() > 0) {
                    Object[] objectArray = hashSet.toArray(new Object[hashSet.size()]);
                    Arrays.sort(objectArray);
                    Object object = JOptionPane.showInputDialog(MIBTablePanel.this, "Filter by: ", "Filter", -1, null, objectArray, objectArray[0]);
                    if (object == null) {
                        return;
                    }
                    ValueColumnFilter valueColumnFilter = new ValueColumnFilter(object);
                    MIBTablePanel.this._$35306(n, valueColumnFilter);
                }
            } else if (MIBTablePanel._$35124.equals(actionEvent.getActionCommand())) {
                SortLabel sortLabel;
                String string = null;
                Object object = MIBTablePanel.this._$4260.getTableColumnLabel(n);
                if (object instanceof SortLabel && (sortLabel = (SortLabel)object).getFilter() != null) {
                    string = sortLabel.getFilter().toString();
                }
                boolean bl = true;
                do {
                    if (bl) continue;
                    JOptionPane.showMessageDialog(MIBTablePanel.this, "Expression is not a valid regular expression!", "Invalid Filter Expression", 0);
                } while ((string = (String)JOptionPane.showInputDialog(MIBTablePanel.this, "Regular expression: ", "Filter", -1, null, null, string)) != null && !(bl = Regex.isRegex(string)));
                if (string != null && Regex.isRegex(string)) {
                    MIBTablePanel.this._$35306(n, new RegexColumnFilter(string));
                }
            } else if (MIBTablePanel._$35126.equals(actionEvent.getActionCommand())) {
                for (int i = 0; i < MIBTablePanel.this._$4260.getNumColumns(); ++i) {
                    Object object = MIBTablePanel.this._$4260.getTableColumnLabel(i);
                    if (!(object instanceof SortLabel)) continue;
                    ((SortLabel)object).setFilter(null);
                }
            } else {
                MIBTablePanel.this._$35306(n, null);
            }
            MIBTablePanel.this.clear();
            MIBTablePanel.this.refresh();
        }
    }

    class RowAddEdit
    extends AbstractUndoableEdit {
        private int _$4402;
        private ObjectID _$20272;
        private GenTarget _$4262;

        public RowAddEdit(int n, ObjectID objectID, GenTarget genTarget) {
            this._$4402 = n;
            this._$20272 = objectID;
            this._$4262 = genTarget;
        }

        public void undo() {
            super.undo();
            if (!MIBTablePanel.this._$4260.removeRow(this._$4402, this._$4262)) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            int n = MIBTablePanel.this._$4260.addNewRow(this._$20272, this._$4262);
            if (n < 0) {
                throw new CannotRedoException();
            }
            this._$4402 = n;
        }
    }

    class CellEdit
    extends AbstractUndoableEdit {
        public JCTableCellInfo info;
        public Object oldValue;
        public Object newValue;
        public OID oid;
        public boolean committed = false;

        public CellEdit(JCTableCellInfo jCTableCellInfo, Object object, Object object2, OID oID) {
            this.info = jCTableCellInfo;
            this.oldValue = object;
            this.newValue = object2;
            this.oid = oID;
        }

        public void undo() {
            super.undo();
            if (!MIBTablePanel.this._$4260.setTableDataItem(this.oldValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotUndoException();
            }
            MIBTablePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
        }

        public void redo() {
            super.redo();
            if (!MIBTablePanel.this._$4260.setTableDataItem(this.newValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotRedoException();
            }
            this.committed = false;
            MIBTablePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
        }

        public void setNewValue(Object object) {
            this.newValue = object;
        }

        public VariableBinding getVariableBinding(boolean bl) {
            Object object = MIBTablePanel.this._$4260.getTableDataItem(this.info.getRow(), this.info.getColumn());
            if (object instanceof GenTarget) {
                return null;
            }
            JCValueConverter jCValueConverter = MIBTablePanel.this._$4260.getValueConverter(this.info.getColumn());
            VariableBinding variableBinding = new VariableBinding();
            variableBinding.setOid(this.oid);
            if (bl) {
                Variable variable = jCValueConverter.fromNative(object);
                variableBinding.setVariable(variable);
            }
            return variableBinding;
        }

        public GenTarget getTarget() {
            return MIBTablePanel.this._$4260.getTarget(this.info.getRow());
        }
    }

    class PeriodicRefresh
    extends TimerTask {
        private int _$29951 = 0;
        private int _$29952;

        public PeriodicRefresh(int n) {
            this._$29952 = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this._$29951 + this._$29952 < 100) {
                this._$29951 += this._$29952;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MIBTablePanel.this.refresh();
                    }
                });
                Object object = MIBTablePanel.this._$4339;
                synchronized (object) {
                    try {
                        MIBTablePanel.this._$4339.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._$29951 = 0;
            }
            MIBTablePanel.this.jProgressBarTimer.setValue(this._$29951);
        }
    }
}

