/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBTableModelRowKey;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBTableModel
extends JCEditableVectorDataSource {
    protected ArrayList<OID> colids;
    protected IndexStruct[] index = null;
    protected MIBRepository rep;
    protected ArrayList<MIBObject> columns = new ArrayList();
    protected ArrayList<JCValueConverter> valueConverter = new ArrayList();
    protected ArrayList<MIBTableModelRowKey> indexes = new ArrayList();
    protected TreeMap<MIBTableModelRowKey, MIBTableModelRowKey> index2row = new TreeMap();
    protected HashMap<GenTarget, Integer> lastRowSet = new HashMap();

    public MIBTableModel(MIBRepository mIBRepository, Vector<MIBObject> vector, Vector<String> vector2, IndexStruct[] indexStructArray) {
        this.rep = mIBRepository;
        this.columns.addAll(vector);
        this.colids = new ArrayList(vector.size() + 1);
        int n = 0;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            MIBObjectType mIBObjectType = (MIBObjectType)object.nextElement();
            if (n >= indexStructArray.length && !mIBObjectType.getAccess().equals(SMI.ACCESS[0])) {
                this.colids.add(new OID(mIBObjectType.getOid().toString()));
            }
            MIBTextualConvention mIBTextualConvention = mIBRepository.getEffectiveSyntax(mIBObjectType.getSyntax());
            JCValueConverter jCValueConverter = new JCValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
            this.valueConverter.add(jCValueConverter);
            ++n;
        }
        object = new Vector(vector2.size());
        if (vector2.size() < vector.size() + 1) {
            int n2;
            for (n2 = 0; n2 < indexStructArray.length; ++n2) {
                ((Vector)object).add(vector2.get(n2));
            }
            ((Vector)object).add("Target");
            while (n2 < vector2.size()) {
                ((Vector)object).add(vector2.get(n2));
                ++n2;
            }
        }
        this.setColumnLabels((Vector)object);
        this.setNumRows(0);
        this.setNumColumns(((Vector)object).size());
        this.index = indexStructArray;
    }

    public List<OID> getColumnIDs() {
        return this.colids;
    }

    public List<MIBObject> getColumns() {
        return this.columns;
    }

    public int getValueColumnCount() {
        return super.getNumColumns() - 1;
    }

    public int getColumn(OID oID) {
        for (int i = 0; i < this.colids.size(); ++i) {
            OID oID2 = this.colids.get(i);
            if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
            return this.index.length + 1 + i;
        }
        return -1;
    }

    public int getColumn(OID oID, int n) {
        for (int i = n; i < this.colids.size(); ++i) {
            OID oID2 = this.colids.get(i);
            if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
            return this.index.length + 1 + i;
        }
        return -1;
    }

    private static String _$35006(String string) {
        String string2 = string;
        while (string2.length() > 2 && Character.isLowerCase(string2.charAt(string2.length() - 1))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.length() < 2) {
            return "";
        }
        return string2.substring(0, string2.length() - 1);
    }

    public static Vector getTitlesFromNames(String string, Vector vector) {
        String string2;
        int n;
        Vector vector2 = new Vector(vector.size() + 1);
        String string3 = MIBTableModel._$35006(string);
        boolean bl = false;
        block0: while (!bl && string3.length() > 0) {
            bl = true;
            for (n = 0; n < vector.size(); ++n) {
                string2 = vector.elementAt(n).toString();
                if (string2.startsWith(string3)) continue;
                string3 = MIBTableModel._$35006(string3);
                bl = false;
                continue block0;
            }
        }
        if (bl) {
            for (n = 0; n < vector.size(); ++n) {
                string2 = vector.elementAt(n).toString();
                vector2.addElement(string2.substring(string3.length()));
            }
        } else {
            vector2 = (Vector)vector.clone();
        }
        return vector2;
    }

    public OID getOidOf(int n, int n2) {
        int n3 = n2;
        if (n3 > this.index.length) {
            --n3;
        } else if (n3 == this.index.length) {
            return null;
        }
        MIBObject mIBObject = this.columns.get(n3);
        OID oID = new OID(mIBObject.getPrintableOid());
        oID.append(new OID(this.getIndexOf(n).getIndex().toString()));
        return oID;
    }

    public MIBObjectType getColumnObject(int n) {
        int n2 = n;
        if (n2 == this.index.length) {
            return null;
        }
        if (n2 > this.index.length) {
            --n2;
        }
        return (MIBObjectType)this.columns.get(n2);
    }

    public boolean isCellEditable(int n, int n2) {
        int n3 = n2;
        if (n2 == this.index.length) {
            return true;
        }
        if (n2 > this.index.length) {
            --n3;
        }
        return SMI.isWritable(this.getColumnObject(n3).getAccess());
    }

    private int _$4801(MIBTableModelRowKey mIBTableModelRowKey) {
        return this.index2row.containsKey(mIBTableModelRowKey) ? this.index2row.headMap(mIBTableModelRowKey).size() : -1;
    }

    public int getRow(ObjectID objectID, GenTarget genTarget) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        return this._$4801(mIBTableModelRowKey);
    }

    public int getRow(OID oID, GenTarget genTarget) {
        ObjectID objectID = new ObjectID(oID.toString());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            return this.getRow(objectID, genTarget);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            objectIDFormatException.printStackTrace();
            return -1;
        }
    }

    public ObjectID getIndex(OID oID) {
        if (oID == null) {
            return null;
        }
        ObjectID objectID = new ObjectID(oID.toString());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            return objectID;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            objectIDFormatException.printStackTrace();
            return null;
        }
    }

    public MIBTableModelRowKey getIndexOf(int n) {
        return this.indexes.get(n);
    }

    public int getIndexColumnCount() {
        return this.index.length + 1;
    }

    public void refreshStart() {
        for (Map.Entry<GenTarget, Integer> entry : this.lastRowSet.entrySet()) {
            entry.setValue(-1);
        }
    }

    public void refreshEnd() {
        try {
            for (Map.Entry<GenTarget, Integer> entry : this.lastRowSet.entrySet()) {
                Integer n = entry.getValue();
                if (n == null) {
                    n = -1;
                }
                int n2 = 1;
                while (this.getNumDataRows() - 1 >= n + n2) {
                    if (this.removeRow(n + n2, entry.getKey())) continue;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addOrUpdateRow(GenTarget genTarget, ObjectID objectID, VariableBinding[] variableBindingArray) {
        int n;
        boolean bl = false;
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        int n2 = this.getRowIndex(mIBTableModelRowKey);
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.addEmptyRow(objectID, genTarget);
            bl = true;
        } else {
            this._$35021(genTarget, n2);
        }
        int n3 = this._$4801(mIBTableModelRowKey);
        if (n3 < 0) {
            this.addEmptyRow(objectID, genTarget);
            n2 = this._$4801(mIBTableModelRowKey);
            bl = true;
        } else {
            n2 = n3;
        }
        for (n = 0; n < variableBindingArray.length; ++n) {
            int n4 = n + this.getIndexColumnCount();
            if (variableBindingArray[n] == null) {
                this.setTableDataItem(null, n2, n4);
                continue;
            }
            JCValueConverter jCValueConverter = this.getValueConverter(n4);
            Object object = jCValueConverter.toNative(variableBindingArray[n].getVariable());
            this.setTableDataItem(object, n2, n4);
        }
        if (!bl && n2 > (n = this._$35023(genTarget))) {
            this._$35024(genTarget, n2, false);
        }
    }

    private void _$35021(GenTarget genTarget, int n) {
        int n2 = this._$35023(genTarget);
        if (n - n2 > 1) {
            int n3 = 0;
            for (int i = 0; i < n - n2 - 1; ++i) {
                if (this.removeRow(n2 + 1 + n3, genTarget)) continue;
                ++n3;
            }
        }
    }

    private int _$35023(GenTarget genTarget) {
        int n = -1;
        Integer n2 = this.lastRowSet.get(genTarget);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    private void _$35026(ObjectID objectID, VariableBinding[] variableBindingArray, GenTarget genTarget) {
        int n = this.getRowIndex(new MIBTableModelRowKey(objectID, genTarget));
        if (n == Integer.MAX_VALUE) {
            n = this.getNumDataRows();
        }
        int n2 = this._$35023(genTarget);
        this._$35021(genTarget, n);
        int n3 = this.setRow(variableBindingArray, true, genTarget);
        if (n3 > n2) {
            this._$35024(genTarget, n3, false);
        }
    }

    private void _$35024(GenTarget genTarget, int n, boolean bl) {
        Integer n2 = this.lastRowSet.get(genTarget);
        if (n2 == null || n2 < n) {
            this.lastRowSet.put(genTarget, n);
        }
        if (bl) {
            for (Map.Entry<GenTarget, Integer> entry : this.lastRowSet.entrySet()) {
                if (entry.getKey() == genTarget || n > entry.getValue()) continue;
                entry.setValue(entry.getValue() + 1);
            }
        }
    }

    public void refreshRow(VariableBinding[] variableBindingArray, GenTarget genTarget) {
        if (variableBindingArray.length <= 0) {
            return;
        }
        ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().getValue());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            if (objectID != null) {
                OID oID = new OID(objectID.asIntArray());
                VariableBinding[] variableBindingArray2 = variableBindingArray;
                for (int i = 0; i < variableBindingArray2.length; ++i) {
                    if (variableBindingArray2[i].getOid().rightMostCompare(oID.size(), oID) == 0) continue;
                    VariableBinding[] variableBindingArray3 = new VariableBinding[i];
                    if (variableBindingArray3.length > 0) {
                        System.arraycopy(variableBindingArray2, 0, variableBindingArray3, 0, i);
                        this._$35026(objectID, variableBindingArray3, genTarget);
                    }
                    variableBindingArray3 = new VariableBinding[variableBindingArray2.length - i];
                    objectID = new ObjectID(variableBindingArray2[i].getOid().getValue());
                    System.arraycopy(variableBindingArray2, i, variableBindingArray3, 0, variableBindingArray2.length - i);
                    variableBindingArray2 = variableBindingArray3;
                    objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
                    if (objectID != null) {
                        oID = new OID(objectID.asIntArray());
                    }
                    i = 0;
                }
                if (variableBindingArray2.length > 0) {
                    this._$35026(objectID, variableBindingArray2, genTarget);
                }
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
            objectIDFormatException.printStackTrace();
        }
    }

    public int getNumDataRows() {
        return this.indexes.size();
    }

    public int setRow(VariableBinding[] variableBindingArray, boolean bl, GenTarget genTarget) {
        if (variableBindingArray.length <= 0) {
            return -1;
        }
        return this.setSparseRow(variableBindingArray, bl, genTarget);
    }

    public int setSparseRow(VariableBinding[] variableBindingArray, boolean bl, GenTarget genTarget) {
        if (variableBindingArray.length <= 0) {
            return -1;
        }
        ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().toString());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            int n = -1;
            if (objectID != null) {
                n = this.getRow(objectID, genTarget);
                if (n < 0) {
                    n = bl ? this.addEmptyRow(objectID, genTarget) : this.addNewRow(objectID, genTarget);
                }
                for (int i = 0; i < variableBindingArray.length; ++i) {
                    int n2 = this.getColumn(variableBindingArray[i].getOid(), i);
                    if (n2 < 0) continue;
                    JCValueConverter jCValueConverter = this.getValueConverter(n2);
                    Object object = jCValueConverter.toNative(variableBindingArray[i].getVariable());
                    this.setTableDataItem(object, n, n2);
                }
            }
            return n;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
            objectIDFormatException.printStackTrace();
            return -1;
        }
    }

    protected int getRowIndex(MIBTableModelRowKey mIBTableModelRowKey) {
        try {
            if (this.index2row.lastKey().compareTo(mIBTableModelRowKey) < 0) {
                return Integer.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            return Integer.MAX_VALUE;
        }
        int n = this.index2row.headMap(mIBTableModelRowKey).size();
        return n;
    }

    protected int addRowAt(ObjectID objectID, GenTarget genTarget, Vector vector) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        int n = this.getRowIndex(mIBTableModelRowKey);
        if (n >= 0) {
            if (n == Integer.MAX_VALUE) {
                n = this.getNumDataRows() + (this.getNumRows() - this.getNumDataRows());
                if (!this.addRow(Integer.MAX_VALUE, objectID, vector)) {
                    return -1;
                }
                this.indexes.add(mIBTableModelRowKey);
            } else {
                if (!this.addRow(n, objectID, vector)) {
                    return -1;
                }
                this.indexes.add(n, mIBTableModelRowKey);
                Integer n2 = this.lastRowSet.get(genTarget);
                if (n2 != null && n <= n2) {
                    n2 = n2 + 1;
                    this.lastRowSet.put(genTarget, n2);
                }
            }
            this.index2row.put(mIBTableModelRowKey, mIBTableModelRowKey);
            this._$35024(genTarget, n, true);
        }
        return n;
    }

    public int duplicateRow(ObjectID objectID, int n) {
        int n2;
        ObjectID[] objectIDArray;
        Vector vector = this.createDefaultInstances();
        for (int i = this.index.length + 1; i - (this.index.length + 1) < vector.size() && i < this.valueConverter.size(); ++i) {
            if (this.getTableDataItem(n, i) != null) {
                vector.set(i - (this.index.length + 1), this.getTableDataItem(n, i));
                continue;
            }
            objectIDArray = this.getValueConverter(i);
            vector.setElementAt(objectIDArray.toNative((Variable)vector.get(i - (this.index.length + 1))), i - (this.index.length + 1));
        }
        GenTarget genTarget = this.getTarget(n);
        vector.insertElementAt(genTarget, 0);
        objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        for (n2 = this.index.length - 1; n2 >= 0; --n2) {
            JCValueConverter jCValueConverter = this.getValueConverter(n2);
            Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index[n2], objectIDArray[n2]));
            vector.insertElementAt(object, 0);
        }
        n2 = this.addRowAt(objectID, genTarget, vector);
        return n2;
    }

    public int addNewRow(ObjectID objectID, GenTarget genTarget) {
        int n;
        Vector vector = this.createDefaultInstances();
        for (int i = this.index.length + 1; i - this.index.length < vector.size() && i < this.valueConverter.size(); ++i) {
            JCValueConverter jCValueConverter = this.getValueConverter(i);
            vector.setElementAt(jCValueConverter.toNative((Variable)vector.get(i - (this.index.length + 1))), i - (this.index.length + 1));
        }
        vector.insertElementAt(genTarget, 0);
        ObjectID[] objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        for (n = this.index.length - 1; n >= 0; --n) {
            JCValueConverter jCValueConverter = this.getValueConverter(n);
            Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index[n], objectIDArray[n]));
            vector.insertElementAt(object, 0);
        }
        n = this.addRowAt(objectID, genTarget, vector);
        return n;
    }

    public String getIndexString(ObjectID objectID) {
        if (objectID == null) {
            return "<null>";
        }
        ObjectID[] objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        ValueConverter[] valueConverterArray = new ValueConverter[this.index.length];
        for (int i = 0; i < this.index.length; ++i) {
            valueConverterArray[i] = this.getValueConverter(i);
        }
        return IndexConverter.getIndexString(valueConverterArray, this.index, objectIDArray);
    }

    public Vector getIndexObjects(ObjectID objectID) {
        IndexStruct[] indexStructArray;
        ObjectID[] objectIDArray = null;
        IndexStruct[] indexStructArray2 = this.index;
        int n = 0;
        while (n < this.index.length && objectIDArray == null) {
            objectIDArray = this.rep.getIndexObjectIDs(objectID, indexStructArray2);
            if (objectIDArray != null) continue;
            indexStructArray = new IndexStruct[indexStructArray2.length - ++n];
            System.arraycopy(indexStructArray2, 0, indexStructArray, 0, indexStructArray.length);
            indexStructArray2 = indexStructArray;
        }
        indexStructArray = new Vector(this.index.length + 1);
        for (int i = 0; i < this.index.length; ++i) {
            JCValueConverter jCValueConverter = this.getValueConverter(i);
            if (i < indexStructArray2.length && objectIDArray != null && i < objectIDArray.length) {
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index[i], objectIDArray[i]));
                indexStructArray.addElement(object);
                continue;
            }
            indexStructArray.add(null);
        }
        return indexStructArray;
    }

    public int addEmptyRow(ObjectID objectID, GenTarget genTarget) {
        Vector vector = this.getIndexObjects(objectID);
        vector.add(genTarget);
        return this.addRowAt(objectID, genTarget, vector);
    }

    public boolean removeRow(OID oID, GenTarget genTarget) {
        try {
            ObjectID objectID = this.getIndex(oID);
            MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
            int n = this.getRowIndex(mIBTableModelRowKey);
            this.index2row.remove(mIBTableModelRowKey);
            this.indexes.remove(n);
            return super.deleteRows(n, 1);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean removeRow(int n, GenTarget genTarget) {
        try {
            MIBTableModelRowKey mIBTableModelRowKey = this.indexes.get(n);
            if (genTarget.equals(mIBTableModelRowKey.getTarget())) {
                this.index2row.remove(mIBTableModelRowKey);
                this.indexes.remove(n);
                return this.deleteRows(n, 1);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Variable getInitialValue(MIBSyntax mIBSyntax) {
        if (mIBSyntax.getType() == 3 && (mIBSyntax = this.rep.resolveTC(mIBSyntax.getSyntax())) == null) {
            return null;
        }
        if (mIBSyntax.hasEnums()) {
            return new Integer32((int)((MIBEnum)mIBSyntax.getEnumsVector().firstElement()).getLongValue());
        }
        if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32")) {
            return new Integer32();
        }
        if (mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32")) {
            return new Counter32();
        }
        if (mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32")) {
            return new Gauge32();
        }
        if (mIBSyntax.getSyntax().equals("Counter64")) {
            return new Counter64();
        }
        if (mIBSyntax.getSyntax().equals("TimeTicks")) {
            return new TimeTicks();
        }
        if (mIBSyntax.getSyntax().equals("IpAddress") || mIBSyntax.getSyntax().equals("NetworkAddress")) {
            return new IpAddress("0.0.0.0");
        }
        if (mIBSyntax.getSyntax().equals("Opaque")) {
            return new Opaque();
        }
        if (mIBSyntax.getSyntax().startsWith("OCTET STRING")) {
            return new OctetString();
        }
        if (mIBSyntax.getSyntax().equals("OBJECT-IDENTITY") || mIBSyntax.getSyntax().equals("OBJECT IDENTIFIER")) {
            return new OID();
        }
        return null;
    }

    public static OctetString parseOctetStringConstant(String string) throws NumberFormatException {
        int n = 10;
        int n2 = 3;
        if (string.startsWith("\"")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            if (!stringTokenizer.hasMoreTokens()) {
                return new OctetString();
            }
            return new OctetString(stringTokenizer.nextToken());
        }
        if (string.startsWith("'")) {
            StringTokenizer stringTokenizer;
            if (string.endsWith("h") || string.endsWith("H")) {
                n = 16;
                n2 = 2;
            }
            if (string.endsWith("o") || string.endsWith("O")) {
                n = 8;
                n2 = 4;
            }
            if (string.endsWith("b") || string.endsWith("B")) {
                n = 2;
                n2 = 8;
            }
            if (!(stringTokenizer = new StringTokenizer(string, "'")).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) {
                return new OctetString();
            }
            try {
                byte[] byArray = new byte[string2.length() / n2];
                int n3 = 0;
                int n4 = 0;
                while (n3 < string2.length()) {
                    char c = (char)Integer.parseInt(string2.substring(n3, n3 + n2), n);
                    byArray[n4] = (byte)c;
                    n3 += n2;
                    ++n4;
                }
                return new OctetString(byArray);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return new OctetString();
            }
        }
        return new OctetString();
    }

    public Vector createDefaultInstances() {
        Vector<Variable> vector = new Vector<Variable>(this.getNumColumns());
        for (int i = this.index.length + 1; i < this.getNumColumns(); ++i) {
            MIBObjectType mIBObjectType = this.getColumnObject(i);
            JCValueConverter jCValueConverter = this.getValueConverter(i);
            Variable variable = ValueConverter.getDefaultValue(this.rep, mIBObjectType, jCValueConverter.getEffectiveSyntax());
            if (variable != null) {
                vector.addElement(variable);
                continue;
            }
            vector.addElement(this.getInitialValue(jCValueConverter.getEffectiveSyntax()));
        }
        return vector;
    }

    protected void setIndexObjects(int n, ObjectID objectID) {
        ObjectID[] objectIDArray = null;
        objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        for (int i = 0; i < this.index.length; ++i) {
            if (objectIDArray == null) continue;
            JCValueConverter jCValueConverter = this.getValueConverter(i);
            Variable variable = IndexConverter.getIndexVariable(this.index[i], objectIDArray[i]);
            if (variable == null) continue;
            this.setTableDataItem(jCValueConverter.toNative(variable), n, i);
        }
    }

    public IndexStruct[] getIndexStruct() {
        return this.index;
    }

    public JCValueConverter getValueConverter(int n) {
        int n2 = 0;
        if (n == this.index.length) {
            return null;
        }
        if (n > this.index.length) {
            n2 = -1;
        }
        return this.valueConverter.get(n + n2);
    }

    public List<JCValueConverter> getValueConverters() {
        return this.valueConverter;
    }

    public int addExpressionRow(int n, Vector vector) {
        return n;
    }

    @Override
    public boolean setTableDataItem(Object object, int n, int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            return super.setTableDataItem(object, n, n2);
        }
        RowUpdate rowUpdate = new RowUpdate(1, n, n2, object);
        try {
            SwingUtilities.invokeAndWait(rowUpdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return rowUpdate.isSuccess();
    }

    @Override
    public boolean deleteRows(int n, int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            return super.deleteRows(n, n2);
        }
        RowUpdate rowUpdate = new RowUpdate(4, n, n2);
        try {
            SwingUtilities.invokeAndWait(rowUpdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return rowUpdate.isSuccess();
    }

    @Override
    public boolean addRow(int n, Object object, Vector vector) {
        if (SwingUtilities.isEventDispatchThread()) {
            return super.addRow(n, object, vector);
        }
        RowUpdate rowUpdate = new RowUpdate(3, n, object, vector);
        try {
            SwingUtilities.invokeAndWait(rowUpdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return rowUpdate.isSuccess();
    }

    public void clear() {
        super.deleteRows(0, this.getNumDataRows());
        this.indexes.clear();
        this.index2row.clear();
    }

    public GenTarget getTarget(int n) {
        return (GenTarget)super.getTableDataItem(n, this.index.length);
    }

    public void setTarget(int n, GenTarget genTarget) {
        super.setTableDataItem(genTarget, n, this.index.length);
        this._$35054(n);
    }

    private void _$35054(int n) {
    }

    class RowUpdate
    implements Runnable {
        private boolean _$35055 = false;
        private int _$35056;
        private Object _$4414;
        private Vector _$84;
        private int _$4402;
        private int _$18803 = 0;

        public RowUpdate(int n, int n2, Object object, Vector vector) {
            this._$35056 = n;
            this._$4402 = n2;
            this._$84 = vector;
            this._$4414 = object;
        }

        public RowUpdate(int n, int n2, int n3) {
            this._$35056 = n;
            this._$4402 = n2;
            this._$18803 = n3;
        }

        public RowUpdate(int n, int n2, int n3, Object object) {
            this._$35056 = n;
            this._$4402 = n2;
            this._$18803 = n3;
            this._$4414 = object;
        }

        public void run() {
            switch (this._$35056) {
                case 3: {
                    this._$35055 = MIBTableModel.this.addRow(this._$4402, this._$4414, this._$84);
                    break;
                }
                case 4: {
                    this._$35055 = MIBTableModel.this.deleteRows(this._$4402, this._$18803);
                    break;
                }
                case 1: {
                    this._$35055 = MIBTableModel.this.setTableDataItem(this._$4414, this._$4402, this._$18803);
                    break;
                }
            }
        }

        public boolean isSuccess() {
            return this._$35055;
        }

        public int getRowIndex() {
            return this._$4402;
        }
    }
}

