/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ExportPanel;
import com.agentpp.common.ExportThread;
import com.agentpp.common.ModulesSelectionDialog;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StringInputPanel;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.mib.event.MIBModuleEvent;
import com.agentpp.mib.event.MIBModuleListener;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.util.UserConfigFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MIBSetPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane = new JScrollPane();
    JTree tree = new JTree();
    JPopupMenu jPopupMenuNode = new JPopupMenu();
    TreePath popupPath = null;
    private UserConfigFile _$4288;
    private TreeMap _$28743 = new TreeMap();
    private DefaultTreeModel _$27087;
    private DefaultMutableTreeNode _$18769;
    private MIBExplorerFrame _$18902;
    private RepositoryManager _$18642;
    JMenuItem jMenuItemCreateMIBSet = new JMenuItem();
    JMenuItem jMenuItemEdit = new JMenuItem();
    JMenuItem jMenuItemDeleteMIBSet = new JMenuItem();
    JMenuItem jMenuItemLoad = new JMenuItem();
    private transient Vector _$28748;
    JMenuItem jMenuItemAdd = new JMenuItem();
    private JMenuItem _$27171 = new JMenuItem();

    public MIBSetPanel() {
        this((MIBExplorerFrame)null);
    }

    public MIBSetPanel(MIBExplorerFrame mIBExplorerFrame) {
        this._$18902 = mIBExplorerFrame;
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MIBSetPanel.this.showPopupMenuNode(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MIBSetPanel.this.showPopupMenuNode(mouseEvent);
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$26550();
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this._$18642 = repositoryManager;
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jMenuItemCreateMIBSet.setToolTipText("Create a new MIB set");
        this.jMenuItemCreateMIBSet.setText("New...");
        this.jMenuItemCreateMIBSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSetPanel.this.jMenuItemCreateMIBSet_actionPerformed(actionEvent);
            }
        });
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSetPanel.this.jMenuItemEdit_actionPerformed(actionEvent);
            }
        });
        this.jMenuItemDeleteMIBSet.setText("Delete");
        this.jMenuItemDeleteMIBSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSetPanel.this.jMenuItemDeleteMIBSet_actionPerformed(actionEvent);
            }
        });
        this.jMenuItemLoad.setToolTipText("Load selected MIB set into MIB tree");
        this.jMenuItemLoad.setText("Load");
        this.jMenuItemLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSetPanel.this.jMenuItemLoad_actionPerformed(actionEvent);
            }
        });
        this.jMenuItemAdd.setToolTipText("Add MIBs of selected MIB set to MIB tree");
        this.jMenuItemAdd.setText("Add");
        this.jMenuItemAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSetPanel.this.jMenuItemAdd_actionPerformed(actionEvent);
            }
        });
        this._$27171.setText("Export...");
        this._$27171.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSetPanel.this.jMenuItemExport_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.jScrollPane, "North");
        this.jScrollPane.getViewport().add((Component)this.tree, null);
        this.jPopupMenuNode.add(this.jMenuItemCreateMIBSet);
        this.jPopupMenuNode.add(this.jMenuItemEdit);
        this.jPopupMenuNode.add(this.jMenuItemDeleteMIBSet);
        this.jPopupMenuNode.addSeparator();
        this.jPopupMenuNode.add(this._$27171);
        this.jPopupMenuNode.addSeparator();
        this.jPopupMenuNode.add(this.jMenuItemLoad);
        this.jPopupMenuNode.add(this.jMenuItemAdd);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
    }

    public void setConfig(UserConfigFile userConfigFile) {
        this._$4288 = userConfigFile;
        this.loadMIBSets();
    }

    public void saveMIBSets() {
        Vector vector = this._$4288.getArray("mibexplorer.MIBSets");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this._$4288.put("mibexplorer.MIBSet_" + string, null);
        }
        vector = new Vector(this._$28743.keySet());
        this._$4288.putArray("mibexplorer.MIBSets", vector);
        for (String string : this._$28743.keySet()) {
            Vector vector2 = (Vector)this._$28743.get(string);
            this._$4288.putArray("mibexplorer.MIBSet_" + string, vector2);
        }
    }

    public static TreeMap loadMIBSets(UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("mibexplorer.MIBSets");
        TreeMap<String, Vector> treeMap = new TreeMap<String, Vector>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector2 = userConfigFile.getArray("mibexplorer.MIBSet_" + string);
            Collections.sort(vector2);
            treeMap.put(string, vector2);
        }
        return treeMap;
    }

    public void loadMIBSets() {
        this._$28743 = MIBSetPanel.loadMIBSets(this._$4288);
        this._$26550();
    }

    private void _$27462() {
        if (this._$18769 != null) {
            this._$18769.removeAllChildren();
        }
        this._$18769 = new DefaultMutableTreeNode("root");
        this._$27087 = new DefaultTreeModel(this._$18769, false);
        this.tree.setModel(this._$27087);
        this.tree.treeDidChange();
    }

    private void _$26550() {
        this._$27462();
        for (String string : this._$28743.keySet()) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this._$27087.insertNodeInto(defaultMutableTreeNode, this._$18769, this._$18769.getChildCount());
            Vector vector = (Vector)this._$28743.get(string);
            if (vector == null) {
                vector = new Vector(1);
                this._$28743.put(string, vector);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(enumeration.nextElement());
                this._$27087.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
        }
        this.tree.expandPath(new TreePath(this._$18769.getPath()));
    }

    public UserConfigFile getConfig() {
        return this._$4288;
    }

    public void showPopupMenuNode(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
            this.popupPath = treePath;
            this._$27319();
            this.jPopupMenuNode.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void _$27319() {
        if (this.popupPath != null) {
            TreeNode treeNode = ((DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent();
            if (treeNode == null) {
                this.jMenuItemEdit.setEnabled(false);
                this.jMenuItemDeleteMIBSet.setEnabled(false);
                this.jMenuItemLoad.setEnabled(false);
            } else {
                this.jMenuItemEdit.setEnabled(treeNode.equals(this._$18769));
                this.jMenuItemDeleteMIBSet.setEnabled(treeNode.equals(this._$18769));
                this.jMenuItemLoad.setEnabled(treeNode.equals(this._$18769));
            }
        }
    }

    void jMenuItemCreateMIBSet_actionPerformed(ActionEvent actionEvent) {
        String string = "";
        boolean bl = false;
        while (!bl) {
            Object object;
            StandardDialog standardDialog = new StandardDialog(this._$18902, "New MIB Set", true);
            StringInputPanel stringInputPanel = new StringInputPanel("MIB Set Name:", string);
            standardDialog.setCenterPanel(stringInputPanel);
            standardDialog.setLocationRelativeTo(this._$18902);
            standardDialog.setVisible(true);
            if (standardDialog.getResult() != 0) {
                return;
            }
            string = stringInputPanel.getTextValue();
            if (string.length() == 0) {
                object = new String[]{"The MIB set name entered is invalid.", "Please enter different name or press <Cancel>!"};
                bl = JOptionPane.showConfirmDialog(this._$18902, object, "Invalid MIB Set Name", 2, 0) == 2;
                continue;
            }
            if (this._$28743.get(string) != null) {
                object = new String[]{"The entered MIB set already exists.", "Please enter different name or press <Cancel>!"};
                bl = JOptionPane.showConfirmDialog(this._$18902, object, "Duplicate MIB Set", 2, 0) == 2;
                continue;
            }
            this._$28743.put(string, new Vector(5));
            object = this._$27411();
            this._$26550();
            this.expandUserObject(object);
            this.selectMIBSet(string);
            break;
        }
    }

    public void selectMIBSet(String string) {
        Enumeration<TreeNode> enumeration = this._$18769.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.getUserObject().equals(string)) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
            return;
        }
    }

    public void selectMIB(String string, String string2) {
        Enumeration<TreeNode> enumeration = this._$18769.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.getUserObject().equals(string)) continue;
            Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode.children();
            while (enumeration2.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration2.nextElement();
                if (!defaultMutableTreeNode2.getUserObject().equals(string2)) continue;
                TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
                return;
            }
        }
    }

    private Vector _$27411() {
        Vector<Object> vector = new Vector<Object>(10, 10);
        Enumeration<TreeNode> enumeration = this._$18769.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) continue;
            vector.addElement(defaultMutableTreeNode.getUserObject());
        }
        return vector;
    }

    public void expandUserObjects(Enumeration enumeration) {
        Enumeration enumeration2 = enumeration;
        while (enumeration2.hasMoreElements()) {
            this.expandUserObject(enumeration2.nextElement());
        }
    }

    public void expandUserObject(Object object) {
        Enumeration<TreeNode> enumeration = this._$18769.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (!object2.equals(object)) continue;
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    void jMenuItemRemoveMIBFromMIBSet_actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.popupPath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent().equals(this._$18769)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            this._$28743.remove(string);
            this._$28766();
        }
    }

    void jMenuItemEdit_actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.popupPath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent().equals(this._$18769)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            Vector vector = (Vector)this._$28743.get(string);
            if (vector == null) {
                return;
            }
            try {
                Object object;
                ModuleInfo[] moduleInfoArray = this._$18642.getModuleInfos();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Object object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    hashtable.put((String)object, (String)object);
                }
                object2 = new ModulesSelectionDialog(moduleInfoArray, hashtable, this._$18902, "Select MIBs", true);
                ((ModulesSelectionDialog)object2).setModuleTitle("MIB Set");
                ((Window)object2).setLocationRelativeTo(this._$18902);
                ((Dialog)object2).setVisible(true);
                object = ((ModulesSelectionDialog)object2).getModules();
                if (object == null) {
                    return;
                }
                Collections.sort(object);
                this._$28743.put(string, object);
                this._$28766();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void _$28766() {
        Vector vector = this._$27411();
        this._$26550();
        this.expandUserObjects(vector.elements());
    }

    void jMenuItemDeleteMIBSet_actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.popupPath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent().equals(this._$18769)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            this._$28743.remove(string);
            this._$28766();
        }
    }

    void jMenuItemLoad_actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.popupPath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent().equals(this._$18769)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            Vector vector = (Vector)this._$28743.get(string);
            this.fireModuleEvent(new MIBModuleEvent(this, vector, 3));
        }
    }

    public void setMIBSet(String string) {
        Vector vector = (Vector)this._$28743.get(string);
        if (vector != null) {
            this.fireModuleEvent(new MIBModuleEvent(this, vector, 3));
        }
    }

    public Vector getMIBSet(String string) {
        return (Vector)this._$28743.get(string);
    }

    public Vector getMIBSetNames() {
        return new Vector(this._$28743.keySet());
    }

    public void putMIBSet(String string, Vector vector) {
        Collections.sort(vector);
        this._$28743.put(string, vector);
        this._$28766();
    }

    public int getNumSets() {
        return this._$28743.size();
    }

    public synchronized void removeMIBModuleListener(MIBModuleListener mIBModuleListener) {
        if (this._$28748 != null && this._$28748.contains(mIBModuleListener)) {
            Vector vector = (Vector)this._$28748.clone();
            vector.removeElement(mIBModuleListener);
            this._$28748 = vector;
        }
    }

    public synchronized void addMIBModuleListener(MIBModuleListener mIBModuleListener) {
        Vector vector;
        Vector vector2 = vector = this._$28748 == null ? new Vector(2) : (Vector)this._$28748.clone();
        if (!vector.contains(mIBModuleListener)) {
            vector.addElement(mIBModuleListener);
            this._$28748 = vector;
        }
    }

    protected void fireModuleEvent(MIBModuleEvent mIBModuleEvent) {
        if (this._$28748 != null) {
            Vector vector = this._$28748;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MIBModuleListener)vector.elementAt(i)).moduleEvent(mIBModuleEvent);
            }
        }
    }

    void jMenuItemAdd_actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.popupPath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent().equals(this._$18769)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            Vector vector = (Vector)this._$28743.get(string);
            this.fireModuleEvent(new MIBModuleEvent(this, vector, 1));
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.jScrollPane.getViewport().setPreferredSize(new Dimension(n3, n4));
        super.setBounds(n, n2, n3, n4);
    }

    void jMenuItemExport_actionPerformed(ActionEvent actionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.popupPath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.popupPath.getLastPathComponent()).getParent().equals(this._$18769)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            Vector vector = (Vector)this._$28743.get(string);
            final ExportPanel exportPanel = new ExportPanel(vector, 7);
            StandardDialog standardDialog = new StandardDialog(this._$18902, "Export From MIB Set", true, true, true){

                public void apply() {
                    if (this.ok()) {
                        ExportThread exportThread = new ExportThread((JFrame)MIBSetPanel.this._$18902, MIBSetPanel.this._$18902.getStatusBar(), MIBSetPanel.this._$4288, MIBSetPanel.this._$18642, exportPanel, MIBSetPanel.this._$18902.getLicenseText(), "http://www.mibexplorer.com/DTD/SMI.DTD");
                        exportThread.start();
                    }
                }

                public boolean ok() {
                    File file = new File(exportPanel.getExportPath());
                    if (!file.isDirectory()) {
                        String[] stringArray = new String[]{"The specified path '" + exportPanel.getExportPath() + "'", "is not a directory!"};
                        JOptionPane.showMessageDialog(MIBSetPanel.this._$18902, stringArray, "Invalid Export Directory", 0);
                        return false;
                    }
                    return true;
                }
            };
            exportPanel.setDialog(standardDialog);
            exportPanel.setExportPath(this._$4288.get("mibexplorer.ExportPath", ""));
            standardDialog.setCenterPanel(exportPanel);
            standardDialog.setLocationRelativeTo(this);
            standardDialog.setVisible(true);
            if (standardDialog.getResult() == 0) {
                this._$4288.put("mibexplorer.ExportPath", exportPanel.getExportPath());
                ExportThread exportThread = new ExportThread((JFrame)this._$18902, this._$18902.getStatusBar(), this._$4288, this._$18642, exportPanel, this._$18902.getLicenseText(), "http://www.mibexplorer.com/DTD/SMI.DTD");
                exportThread.start();
            }
        }
    }
}

