/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ComponentLinkListener;
import com.agentpp.common.PropertiesEditor;
import com.agentpp.common.velocity.Log4JProxy;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBExplorerRemoteServerAuthImpl;
import com.agentpp.explorer.MIBSetPanel;
import com.agentpp.explorer.MonitorManager;
import com.agentpp.explorer.TabbedControlledPanel;
import com.agentpp.explorer.TargetConfiguration;
import com.agentpp.explorer.cfg.JdbcDriverRegistration;
import com.agentpp.explorer.cfg.Preferences;
import com.agentpp.explorer.cfg.SNMPv3Settings;
import com.agentpp.explorer.http.ExplorerHttpServer;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.monitor.Monitor;
import com.agentpp.explorer.monitor.MonitorConfigPanel;
import com.agentpp.explorer.monitor.MonitorEvent;
import com.agentpp.explorer.monitor.MonitorListener;
import com.agentpp.explorer.monitor.MonitorPanel;
import com.agentpp.explorer.monitor.MonitorProperty;
import com.agentpp.explorer.monitor.MonitorServerImpl;
import com.agentpp.explorer.monitor.ServerMonitor;
import com.agentpp.explorer.monitor.db.Monitor2DB;
import com.agentpp.explorer.script.MIBContext;
import com.agentpp.explorer.script.Script;
import com.agentpp.explorer.script.ScriptContext;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.slimdao.jdbc.DriverLoader;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.license.Validate;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;

public class MIBExplorerServer
implements MonitorManager {
    private UserConfigFile _$6226 = new UserConfigFile(true);
    private Snmp _$6313;
    private Vector _$23995 = new Vector();
    private String _$23996;
    private String _$23997;
    private Vector _$23998 = new Vector();
    private Vector _$23999 = new Vector();
    private DefaultRepositoryManager _$6227 = new DefaultRepositoryManager();
    private MIBRepository _$6228 = new MIBRepository(true);
    private Hashtable _$7204;
    private GenTarget _$6321;
    private TrapProxy _$6314;
    private boolean _$24000 = true;
    private MonitorPanel _$6339;
    private Logger _$6448;
    private Vector _$24001 = new Vector();
    private int _$6590 = 800;
    private int _$6588 = 600;
    private int _$24002 = 4976;
    private static final byte _$6240 = 48;
    private static byte _$6271;
    private static GregorianCalendar _$6272;
    private Vector _$24003 = new Vector();
    private ExplorerHttpServer _$6317;
    private LinkedList _$24004 = new LinkedList();
    private boolean _$24005 = false;
    private DriverLoader _$6319 = new DriverLoader();

    public MIBExplorerServer(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Log4JProxy.logger = Logger.getLogger("Velocity");
        System.out.println();
        System.out.println("MIB Explorer Server v3.2.0 - SNMPv1/v2c/v3 Monitor.");
        System.out.println("Copyright \u00a9 2001-2011, Frank Fock. All rights reserved.");
        System.out.println();
        Logger.getRootLogger().setLevel(Level.DEBUG);
        this._$6448 = Logger.getLogger("MIBExplorer.Server");
        if (System.getProperty("java.version").compareTo("1.6") < 0) {
            System.err.println("MIB Explorer Server needs Java Runtime Environment 1.6 or later installed!");
            System.err.println("Current version is: " + System.getProperty("java.version"));
            System.exit(1);
        }
        String string2 = "MIBExplorer3.cf";
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-configFile")) continue;
            if (stringArray.length < i + 1) {
                System.out.println("There is no config file name given for the -config option, aborting.");
                System.exit(1);
                continue;
            }
            string3 = stringArray[i + 1];
        }
        if (string3 != null) {
            this._$6226.setConfigFile(string3);
        } else {
            this._$6226.setConfigName(string2);
        }
        this._$6226.read(true);
        System.out.println();
        this._$6590 = this._$6226.getInteger("mibexplorer.monitor.image.sizeX", 640);
        this._$6588 = this._$6226.getInteger("mibexplorer.monitor.image.sizeY", 480);
        byte[] byArray = Validate.fromHexString(this._$6226.get("mibexplorer.License", null));
        byte[] byArray2 = this._$6226.get("mibexplorer.LicenseKey", "").getBytes();
        if (byArray == null || byArray2 == null) {
            try {
                System.err.println("Invalid license, aborting!");
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
        int n = 0;
        n = this._$6480(byArray, byArray2);
        if (n == 0) {
            try {
                System.err.println("Invalid license, aborting!");
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
        this._$24003.add(this._$6226.get("mibexplorer.server.secret", ""));
        try {
            object3 = new MessageDispatcherImpl();
            this._$6313 = new Snmp((MessageDispatcher)object3);
            ((MessageDispatcherImpl)object3).addMessageProcessingModel(new MPv1());
            ((MessageDispatcherImpl)object3).addMessageProcessingModel(new MPv2c());
            ((MessageDispatcherImpl)object3).addMessageProcessingModel(new MPv3(SNMPv3Settings.getEngineID(this._$6226).getValue()));
            SecurityProtocols.getInstance().addDefaultProtocols();
            SecurityModels.getInstance().addSecurityModel(new USM(SecurityProtocols.getInstance(), SNMPv3Settings.getEngineID(this._$6226), SNMPv3Settings.getEngineBoots(this._$6226)));
            JdbcDriverRegistration.loadDrivers(this._$6226, this._$6319);
            object2 = new Preferences(this._$6226, this._$6313, this._$6314, this._$6228, this._$6227, true, this._$6319);
            ((Preferences)object2).initTransportMappings(null);
            this._$6313.listen();
        }
        catch (IOException iOException) {
            this._$6448.fatal("Cannot bind any UDP port, aborting... (Reason: " + iOException.getMessage() + ")");
            System.exit(2);
        }
        object3 = new TargetConfiguration(this._$6226, this._$6313);
        ((TargetConfiguration)object3).load();
        this._$6548(((TargetConfiguration)object3).getUsers());
        object2 = PropertiesEditor.filterProperties(this._$6226.properties);
        PropertyConfigurator.configure(this._$6226.properties);
        this._$6226.properties.putAll((Map<?, ?>)object2);
        if (System.getProperty("log4j.configuration") == null) {
            BasicConfigurator.configure();
        }
        try {
            this._$6227.open(new File(this._$6226.get("mibexplorer.RepositoryPath", "mibrepository")));
        }
        catch (IOException iOException) {
            object = new String[]{"The current repository path '" + this._$6226.get("mibexplorer.RepositoryPath", "mibrepository") + "'", "is not valid. Please choose a new one with the MIB Explorer GUI."};
            this._$6448.fatal(object);
            System.exit(2);
        }
        Vector vector = MIBExplorerFrame.getConfiguredModules(this._$6226);
        this.loadMIBs(vector);
        if (!this._$24005) {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase("-securitymanager")) continue;
                    System.setSecurityManager(new SecurityManager());
                    break;
                }
                this._$24002 = Integer.parseInt(System.getProperty("mibexplorer.server.port", "4976"));
                LocateRegistry.createRegistry(this._$24002);
                this._$6448.info("RMI registry created at port " + this._$24002);
            }
            catch (Exception exception) {
                this._$6448.warn(exception);
            }
        }
        object = this._$6226.get("mibexplorer.ActiveTarget", null);
        this._$6321 = TargetConfiguration.loadTarget(this._$6226, (String)object);
        this._$7204 = TargetConfiguration.loadAllTargets(this._$6226);
        this._$6314 = new TrapProxy(this._$6226, this._$6321, new Hashtable(5), this._$6227, this._$6313);
        this._$6314.loadConfig();
        this._$6339 = new MonitorPanel(this._$6226, null, this._$6313, this._$6228, (RepositoryManager)this._$6227, this._$7204);
        this._$6339.setTrapProxy(this._$6314);
        this._$24014(stringArray);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this._$6317 = new ExplorerHttpServer(this._$6226, this._$6313, this._$7204, this._$6321, new SnmpLogger(this._$6228), this._$6228, (RepositoryManager)this._$6227);
        try {
            this._$6317.run();
            if (this._$6317.isStarted()) {
                this._$6339.addMonitorListener((MonitorListener)this._$6317);
                this._$6448.info("HTTP server started on " + this._$6317.getPort());
            } else {
                this._$6448.warn("HTTP server NOT started on port " + this._$6317.getPort());
            }
        }
        catch (Exception exception) {
            this._$6448.error("HTTP server not started: " + exception.getMessage());
        }
        for (Object object4 : this._$23999) {
            Thread thread = new Thread((Runnable)object4);
            this._$6448.info("Running script " + ((ScriptRunnable)((Object)object4))._$46);
            thread.start();
        }
        this._$6339.setTarget(this._$6321);
        this._$6339.setMonitorManager((MonitorManager)this);
        if (this._$23996 == null) {
            this._$23995.addAll((List)this._$6339.initDone(true));
        } else {
            Object object4;
            Iterator iterator = this._$6226.getArray("mibexplorer.monitor.restart.monitors");
            object4 = new LinkedList();
            if (iterator != null && ((Vector)((Object)iterator)).size() > 0) {
                for (int i = 0; i < ((Vector)((Object)iterator)).size(); ++i) {
                    string = (String)((Vector)((Object)iterator)).get(i);
                    File file = new File(string);
                    String string4 = file.getName();
                    string4 = this._$6339.cutExtension(this._$6339.getTypeExtensions(), string4);
                    try {
                        MonitorConfigPanel monitorConfigPanel = this.createMonitor(file, string4);
                        monitorConfigPanel.addComponentLinkListener((ComponentLinkListener)this._$6339);
                        this._$6339.loadData((TabbedControlledPanel)monitorConfigPanel, file);
                        if (monitorConfigPanel.getDBMonitor() == null && !this._$24024(monitorConfigPanel, new File(file.getParent(), string4 + ".dbm"), this._$23997)) {
                            this._$6448.info("Monitor migration to DB failed: " + monitorConfigPanel.getTitle());
                            monitorConfigPanel.stopTimer();
                            ((Vector)((Object)iterator)).remove(monitorConfigPanel);
                            monitorConfigPanel.removeComponentLinkListener((ComponentLinkListener)this._$6339);
                            continue;
                        }
                        monitorConfigPanel.getMonitorProperties().getExportConfig().setAutoSave(true);
                        monitorConfigPanel.setExportEnabled(true);
                        monitorConfigPanel.run();
                        ((LinkedList)object4).add(monitorConfigPanel);
                        continue;
                    }
                    catch (IOException iOException) {
                        this._$6448.warn("Could not start monitor '" + string + "': " + iOException.getMessage());
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this._$6448.error("Monitor file '" + string + "' has unrecognizable format");
                    }
                }
            }
        }
        for (Object object4 : this._$24001) {
            MonitorConfigPanel monitorConfigPanel = this._$24022(this._$6321, new File((String)object4));
            if (monitorConfigPanel == null) continue;
            monitorConfigPanel.addComponentLinkListener((ComponentLinkListener)this._$6339);
            this._$23995.add(monitorConfigPanel);
            if (this._$23996 != null) {
                string = new File((String)object4).getName();
                if (string.toLowerCase().endsWith(".mon") || string.toLowerCase().endsWith(".xml")) {
                    string = string.substring(0, string.length() - 4);
                }
                if (!this._$24024(monitorConfigPanel, new File(this.getMonitorPath(), string + ".dbm"), this._$23997)) {
                    this._$6448.info("Monitor migration to DB failed: " + monitorConfigPanel.getTitle());
                    monitorConfigPanel.stopTimer();
                    this._$23995.remove(monitorConfigPanel);
                    monitorConfigPanel.removeComponentLinkListener((ComponentLinkListener)this._$6339);
                    continue;
                }
            }
            this._$6317.monitorChanged(new MonitorEvent((Object)this, 1, (Monitor)monitorConfigPanel));
            this._$6448.info("Started monitor: " + monitorConfigPanel.getTitle());
        }
        if (this._$24004 == null) {
            for (Object object4 : this._$23995) {
                this._$6448.info("Truncating data of monitor " + object4.getTitle());
                object4.resetValues();
            }
        } else {
            for (Object object4 : this._$23995) {
                if (!this._$24004.contains(object4.getTitle())) continue;
                this._$24004.remove(object4.getTitle());
                this._$6448.info("Truncating data of monitor " + object4.getTitle());
                object4.resetValues();
            }
        }
        try {
            Naming.rebind("//:" + this._$24002 + "/MIBExplorerServer", new MIBExplorerRemoteServerAuthImpl(this._$23998, this._$23995, this, this._$24003));
            this._$6448.info("Bound RMI server //:" + this._$24002 + "/MIBExplorerServer");
        }
        catch (Exception exception) {
            this._$6448.warn(exception);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean _$24024(MonitorConfigPanel monitorConfigPanel, File file, String string) {
        Vector vector = (Vector)monitorConfigPanel.getData();
        MonitorProperty monitorProperty = (MonitorProperty)vector.get(1);
        Monitor2DB monitor2DB = monitorConfigPanel.getDBMonitor();
        try {
            String string2;
            Long l;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (monitor2DB == null) {
                monitor2DB = new Monitor2DB(string, this._$6226.get("mibexplorer.db.schema", "MXP"), this._$6226.get("mibexplorer.db.config.xml", ""));
                monitor2DB.connect(this._$23996, string, new Properties());
                int n = monitor2DB.getSchemaVersion();
                if (n < 0) {
                    monitor2DB.createSchema();
                } else if (n < monitor2DB.getRequiredSchemaVersion()) {
                    // empty if block
                }
                monitorConfigPanel.setDBMonitor(monitor2DB);
            }
            if ((l = monitor2DB.getMonitorID(string2 = file.getName())) != null) {
                monitor2DB.saveMonitorToDB(string2, l, monitorProperty, (JCEditableVectorDataSource)vector.get(0), fileOutputStream);
            } else {
                monitor2DB.saveMonitorToDB(string2, null, monitorProperty, (JCEditableVectorDataSource)vector.get(0), fileOutputStream);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._$6448.error("JDBC Driver '" + string + "' not found!", classNotFoundException);
        }
        catch (SQLException sQLException) {
            this._$6448.error("SQL exception: " + sQLException.getMessage(), sQLException);
        }
        catch (IOException iOException) {
            this._$6448.error("IO exception while migrating monitor '" + file + "' to DB: " + iOException.getMessage(), iOException);
        }
        return false;
    }

    public void loadMIBs(Vector vector) {
        if (vector.size() == 0) {
            this._$6448.warn("No MIB modules loaded");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            try {
                int n;
                MIBObject[] mIBObjectArray = this._$6227.getObjects(string);
                MIBObject[] mIBObjectArray2 = this._$6227.getImportedObjects(string);
                for (n = 0; n < mIBObjectArray.length; ++n) {
                    this._$6228.addObject(mIBObjectArray[n]);
                }
                for (n = 0; n < mIBObjectArray2.length; ++n) {
                    this._$6228.addObject(mIBObjectArray2[n]);
                }
            }
            catch (IOException iOException) {
                this._$6448.fatal("Error while accessing MIB repository: " + iOException.getMessage());
                System.exit(1);
            }
        }
        if (vector.size() > 1) {
            this._$6448.info("Loaded " + vector.size() + " MIB modules");
        } else {
            this._$6448.info("Loaded " + vector.size() + " MIB module");
        }
        this._$6228.structureChanged();
    }

    private void _$21856() {
        System.out.println();
        System.out.println("MIB Explorer Headless Server can be run using Java 6 or later.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("java -Djava.awt.headless=true [-Djava.rmi.server.hostname=<host>] \\");
        System.out.println("  mxp-pro.jar [options]");
        System.out.println("where [options] is any combination of the following parameters:");
        System.out.println();
        System.out.println(" -?                          prints this usage information");
        System.out.println(" -a[ccept] secrect           accept client connections from MIB Explorers");
        System.out.println("                             using the specified server 'secret' (which");
        System.out.println("                             is by default the client's license)");
        System.out.println(" -acceptall                  accept any MIB Explorer clients");
        System.out.println(" -d[isableMonitorScripting]  disables scripting for monitor alarms");
        System.out.println(" -m2db <jdbc-url> <driver>   migrates .mon and .xml monitor files given by");
        System.out.println("                             the -m option to the database identified by");
        System.out.println("                             jdbc:<driver>://<server>:<port>/<database>");
        System.out.println("                             :user=<username>;password={<password>};");
        System.out.println("                             If the DB has not yet an appropriate MIB Explorer");
        System.out.println("                             schema, it will be created. <driver> is the used");
        System.out.println("                             driver class name (e.g. 'com.ibm.db2.jcc.DB2Driver')");
        System.out.println(" -h[eight]                   sets the height of monitor charts in pixels");
        System.out.println(" -http-servlets off|all|monitorcharts|monitordata|script}");
        System.out.println("                             enables none, all, or the specified subset");
        System.out.println("                             of HTTP servlets. Setting httpservlets to 'off'");
        System.out.println("                             disables the HTTP server.");
        System.out.println(" -http-port port             specifies the HTTP server port.");
        System.out.println(" -w[idth]                    sets the width of monitor charts in pixels");
        System.out.println(" -monitor-truncate [ALL|<monitor-name>]");
        System.out.println("                             clears all monitor data of either all monitors");
        System.out.println("                             or only the specified monitor on server start.");
        System.out.println(" -m[onitor] filename ..      runs the specified monitor configuration files");
        System.out.println(" -mibs[et] name              loads the specified MIB set in addition to already");
        System.out.println("                             loaded modules (i.e. those module that were loaded");
        System.out.println("                             when the MIB Explorer GUI has been exited last)");
        System.out.println(" -p[ath]                     path to load and store monitor files");
        System.out.println(" -s[cript] script output     runs the script file 'script' and writes the");
        System.out.println("                             output to the file denoted by 'output'");
        System.out.println(" -l[oglevel] category=level  overrides the configured log level for 'category'");
        System.out.println("                             with 'level'. Use for example 'Script=OFF' to");
        System.out.println("                             switch off logging for scripting");
        System.out.println(" -rmihost                    specifies the DNS hostname (including domain)");
        System.out.println("                             of the host running the server. This option sets");
        System.out.println("                             the 'java.rmi.server.hostname' system property.");
        System.out.println(" -rmiport                    specifies the port to bind the RMI server.");
        System.out.println("                             Default is 4976.");
        System.out.println(" -rmioff                     disables the RMI server.");
        System.out.println(" -securitymanager            runs the server with a security manager");
        System.out.println("                             This options requires specifying a policy file");
        System.out.println("                             with-Djava.security.policy=server.security at the");
        System.out.println("                             command line");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _$24014(String[] stringArray) {
        int n = 0;
        try {
            block8: while (n < stringArray.length) {
                Object object;
                if (stringArray[n].equals("-?") || stringArray[n].equals("-help")) {
                    this._$21856();
                    System.exit(0);
                }
                if (stringArray[n].equals("-m") || stringArray[n].equals("-monitor")) {
                    ++n;
                    while (true) {
                        if (n >= stringArray.length || stringArray[n].startsWith("-")) continue block8;
                        this._$24001.add(stringArray[n++]);
                    }
                }
                if (stringArray[n].equals("-m2db")) {
                    if (++n >= stringArray.length) {
                        this._$6448.warn("JDBC URL for monitor to DB migration must be specified");
                        return;
                    }
                    this._$23996 = stringArray[n++];
                    if (n >= stringArray.length) {
                        this._$6448.warn("JDBC driver class name must be specified with option -m2db");
                        this._$23996 = null;
                        return;
                    }
                    this._$23997 = stringArray[n++];
                    continue;
                }
                if (stringArray[n].equals("-securitymanager")) {
                    this._$6448.info("Running MIB Explorer Server with security manager");
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-acceptall")) {
                    this._$6448.warn("MIB Explorer will accept any client connection (provided that security policy allowes it)");
                    ++n;
                    this._$24003.removeAllElements();
                    continue;
                }
                if (stringArray[n].equals("-a") || stringArray[n].equals("-accept")) {
                    int n2 = ++n;
                    ++n;
                    this._$24003.add(stringArray[n2]);
                    continue;
                }
                if (stringArray[n].equals("-d") || stringArray[n].equals("-disableMonitorScripting")) {
                    ++n;
                    this._$24000 = false;
                    continue;
                }
                if (stringArray[n].equals("-p") || stringArray[n].equals("-path")) {
                    int n3 = ++n;
                    ++n;
                    String string = stringArray[n3];
                    File file = new File(string);
                    if (!file.exists() || !file.isDirectory()) {
                        this._$6448.warn("Invalid monitor path '" + string + "' given, option will be ignored!");
                    }
                    this._$6226.put("mibexplorer.PDUPath", string);
                    continue;
                }
                if (stringArray[n].equals("-mibs") || stringArray[n].equals("-mibset")) {
                    TreeMap treeMap = MIBSetPanel.loadMIBSets(this._$6226);
                    Vector vector = (Vector)treeMap.get(stringArray[++n]);
                    if (vector == null) {
                        throw new IllegalArgumentException("MIB set " + stringArray[n] + " not found!");
                    }
                    this.loadMIBs(vector);
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-monitor-truncate")) {
                    int n4 = ++n;
                    ++n;
                    String string = stringArray[n4];
                    if (string.equals("ALL")) {
                        this._$24004 = null;
                        continue;
                    }
                    if (this._$24004 == null) continue;
                    this._$24004.add(string);
                    continue;
                }
                if (stringArray[n].equals("-h") || stringArray[n].equals("-height")) {
                    int n5 = ++n;
                    ++n;
                    this._$6588 = Integer.parseInt(stringArray[n5]);
                    continue;
                }
                if (stringArray[n].equals("-rmiport")) {
                    ++n;
                    try {
                        this._$24002 = Integer.parseInt(stringArray[n++]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Specified RMI port is not a number");
                    }
                }
                if (stringArray[n].equals("-rmihost")) {
                    int n6 = ++n;
                    ++n;
                    System.setProperty("java.rmi.server.hostname", stringArray[n6]);
                    continue;
                }
                if (stringArray[n].equals("-w") || stringArray[n].equals("-width")) {
                    int n7 = ++n;
                    ++n;
                    this._$6590 = Integer.parseInt(stringArray[n7]);
                    continue;
                }
                if (stringArray[n].equals("-s") || stringArray[n].equals("-script")) {
                    if (stringArray.length < ++n + 2) {
                        throw new IllegalArgumentException("Missing script file name or script output filename");
                    }
                    String string = stringArray[n++];
                    String string2 = this._$24047(string);
                    object = new ScriptRunnable(string2, string, new File(stringArray[n++]));
                    this._$23999.add(object);
                    continue;
                }
                if (stringArray[n].equals("-l") || stringArray[n].equals("-loglevel")) {
                    int n8 = ++n;
                    ++n;
                    String string = stringArray[n8];
                    int n9 = string.indexOf(61);
                    if (n9 < 0 || n9 == string.length() - 1) {
                        System.err.println("Invalid log level assignment: " + string);
                        System.err.println("Aborting.");
                        System.exit(1);
                    }
                    object = string.substring(0, n9);
                    String string3 = string.substring(n9 + 1);
                    if (((String)object).length() == 0) {
                        Logger.getRootLogger().setLevel(Level.toLevel(string3));
                        continue;
                    }
                    Logger.getLogger((String)object).setLevel(Level.toLevel(string3));
                    continue;
                }
                if (stringArray[n].equals("-server")) {
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-rmioff")) {
                    this._$24005 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-http-servlets")) {
                    String string = this._$24050(stringArray, n);
                    n += 2;
                    if (string.equalsIgnoreCase("off")) {
                        this._$6226.putBoolean("mibexplorer.http.server.enabled", false);
                        continue;
                    }
                    if (string.equalsIgnoreCase("all")) {
                        this._$6226.putBoolean("mibexplorer.http.server.enabled", true);
                        this._$6226.putBoolean("mibexplorer.http.server.chart.enabled", true);
                        this._$6226.putBoolean("mibexplorer.http.server.data.enabled", true);
                        this._$6226.putBoolean("mibexplorer.http.server.script.enabled", true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("monitorcharts")) {
                        this._$6226.putBoolean("mibexplorer.http.server.chart.enabled", true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("monitordata")) {
                        this._$6226.putBoolean("mibexplorer.http.server.data.enabled", true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("scripts")) {
                        this._$6226.putBoolean("mibexplorer.http.server.script.enabled", true);
                        continue;
                    }
                    System.err.println("Unrecognized parameter '" + string + "' for option 'http-servlets', aborting.");
                    System.exit(1);
                    continue;
                }
                if (stringArray[n].equals("-http-port")) {
                    ++n;
                    try {
                        int n10 = Integer.parseInt(stringArray[n++]);
                        this._$6226.putInteger("mibexplorer.http.server.port", n10);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Specified HTTP port is not a number");
                    }
                }
                System.err.println("Unrecognized command line argument: " + stringArray[n]);
                System.err.println("Aborting.");
                System.exit(1);
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Missing parameter at " + stringArray[stringArray.length - 1]);
            System.exit(1);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.err.println("Aborting.");
            System.exit(1);
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.err.println("Aborting.");
            System.exit(1);
        }
    }

    private String _$24050(String[] stringArray, int n) {
        if (stringArray.length < n + 1) {
            System.err.println("Missing parameter for option '" + stringArray[n] + "', aborting.");
            System.exit(1);
        }
        return stringArray[n + 1];
    }

    private void _$6548(Hashtable hashtable) {
        Collection collection = hashtable.values();
        UsmUser[] usmUserArray = new UsmUser[collection.size()];
        Vector<UserProfile> vector = new Vector<UserProfile>();
        int n = 0;
        for (UserProfile userProfile : collection) {
            usmUserArray[n] = userProfile.getUser();
            if (userProfile.isPrincipal()) {
                vector.add(userProfile);
            }
            ++n;
        }
        this._$6313.getUSM().getUserTable().clear();
        this._$6313.getUSM().setUsers(usmUserArray);
    }

    private String _$24047(String string) throws IOException {
        byte[] byArray;
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        StringBuffer stringBuffer = new StringBuffer(Math.max(fileInputStream.available(), 1000));
        while (fileInputStream.available() > 0 && (n = fileInputStream.read(byArray = new byte[fileInputStream.available()])) > 0) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        return stringBuffer.toString();
    }

    private MonitorConfigPanel _$24022(GenTarget genTarget, File file) {
        ServerMonitor serverMonitor = new ServerMonitor(this._$6313, this._$6228, (RepositoryManager)this._$6227, this._$7204, this._$6226, this._$6590, this._$6588, this._$24000);
        this._$23995.add(serverMonitor);
        serverMonitor.setTarget(genTarget);
        try {
            this._$6339.loadData((TabbedControlledPanel)serverMonitor, file);
            int n = file.getName().lastIndexOf(46);
            if (n < 0) {
                n = file.getName().length();
            }
            serverMonitor.setTitle(file.getName().substring(0, n));
        }
        catch (Exception exception) {
            this._$6448.fatal("Failed to create monitor '" + file + "+':" + exception.getMessage(), exception);
            return null;
        }
        serverMonitor.getChart().setSize(this._$6590, this._$6588);
        serverMonitor.getMonitorProperties().getExportConfig().setAutoSave(serverMonitor.getDBMonitor() == null);
        serverMonitor.setExportEnabled(true);
        try {
            MonitorServerImpl monitorServerImpl = new MonitorServerImpl((MonitorConfigPanel)serverMonitor);
            Naming.rebind("//:" + this._$24002 + "/" + serverMonitor.getTitle(), (Remote)monitorServerImpl);
            this._$23998.add(monitorServerImpl);
        }
        catch (Exception exception) {
            this._$6448.warn(exception);
        }
        if (!serverMonitor.isRunning()) {
            serverMonitor.run();
        }
        return serverMonitor;
    }

    public void initMonitor(ServerMonitor serverMonitor) {
        serverMonitor.removeComponentLinkListener((ComponentLinkListener)this._$6339);
        serverMonitor.addComponentLinkListener((ComponentLinkListener)this._$6339);
        serverMonitor.getChart().setSize(this._$6590, this._$6588);
        if (!serverMonitor.isRunning()) {
            serverMonitor.run();
        }
    }

    public MonitorConfigPanel runMonitor(String string) {
        return this._$24022(this._$6321, new File(this.getMonitorPath(), string));
    }

    public MonitorConfigPanel createMonitor(String string) {
        ServerMonitor serverMonitor = new ServerMonitor(this._$6313, this._$6228, (RepositoryManager)this._$6227, this._$7204, this._$6226, this._$6590, this._$6588, this._$24000);
        this._$23995.add(serverMonitor);
        serverMonitor.setTarget(this._$6321);
        File file = this.getMonitorPath();
        serverMonitor.setExportEnabled(file.exists() && file.isDirectory());
        serverMonitor.setConfigFile(new File(this.getMonitorPath(), string + ".mon"));
        serverMonitor.setTitle(string);
        if (!this._$24005) {
            try {
                MonitorServerImpl monitorServerImpl = new MonitorServerImpl((MonitorConfigPanel)serverMonitor);
                Naming.rebind("//:" + this._$24002 + "/" + serverMonitor.getTitle(), (Remote)monitorServerImpl);
                this._$23998.add(monitorServerImpl);
            }
            catch (Exception exception) {
                this._$6448.warn(exception);
            }
        }
        return serverMonitor;
    }

    public MonitorConfigPanel createMonitor(File file, String string) {
        ServerMonitor serverMonitor = new ServerMonitor(this._$6313, this._$6228, (RepositoryManager)this._$6227, this._$7204, this._$6226, this._$6590, this._$6588, this._$24000);
        this._$23995.add(serverMonitor);
        serverMonitor.setTarget(this._$6321);
        serverMonitor.setExportEnabled(file.exists() && file.canWrite());
        serverMonitor.setConfigFile(file);
        serverMonitor.setTitle(string);
        if (!this._$24005) {
            try {
                MonitorServerImpl monitorServerImpl = new MonitorServerImpl((MonitorConfigPanel)serverMonitor);
                Naming.rebind("//:" + this._$24002 + "/" + serverMonitor.getTitle(), (Remote)monitorServerImpl);
                this._$23998.add(monitorServerImpl);
            }
            catch (Exception exception) {
                this._$6448.warn(exception);
            }
        }
        return serverMonitor;
    }

    private int _$6480(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Validate.decrypt(byArray, new String(byArray2).toCharArray());
        if (byArray3 == null || byArray3.length < 7 || byArray3[0] != 48 || byArray3[1] != 3) {
            return 0;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000 + byArray3[4], byArray3[5] - 1, byArray3[6]);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000 + byArray3[4] - (byArray3[5] > 2 ? 0 : 1), byArray3[5] > 2 ? byArray3[5] - 3 : 11 - (2 - byArray3[5]), byArray3[6]);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        if ((byArray3[4] != 0 || byArray3[5] != 0 || byArray3[6] != 0) && (gregorianCalendar3.getTime().before(gregorianCalendar2.getTime()) || gregorianCalendar.getTime().before(gregorianCalendar3.getTime()))) {
            return 0;
        }
        _$6272 = byArray3[4] == 0 && byArray3[5] == 0 && byArray3[6] == 0 ? null : gregorianCalendar;
        _$6271 = byArray3[3];
        this._$6226.put("mibexplorer.License", Validate.asHexString(byArray));
        this._$6226.put("mibexplorer.LicenseKey", new String(byArray2));
        return byArray3[0];
    }

    public File getMonitorPath() {
        String string = this._$6226.get("mibexplorer.PDUPath", ".");
        return new File(string);
    }

    static {
        LogFactory.setLogFactory(new Log4jLogFactory());
        _$6271 = 0;
    }

    class ScriptRunnable
    extends Script {
        private File _$24053;
        private String _$46;

        public ScriptRunnable(String string, String string2, File file) {
            super(string, new StringWriter(), new ScriptContext(MIBExplorerServer.this._$6313, MIBExplorerServer.this._$6226, MIBExplorerServer.this._$6321, MIBExplorerServer.this._$7204, new SnmpLogger(MIBExplorerServer.this._$6228), MIBExplorerServer.this._$6228, string2), new MIBContext((RepositoryManager)MIBExplorerServer.this._$6227, MIBExplorerServer.this._$6228), "Script");
            this._$46 = string2;
            this._$24053 = file;
        }

        public void output() {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this._$24053);
                fileOutputStream.write(this.output.toString().getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                l.error("Script output from " + this._$46 + " could not be written: " + iOException.getMessage());
            }
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        public void run() {
            for (MonitorServerImpl monitorServerImpl : MIBExplorerServer.this._$23998) {
                monitorServerImpl.get().fireRemoteDisconnect();
                MIBExplorerServer.this._$6448.info("Stopped monitor: " + monitorServerImpl.get().getTitle());
            }
            for (MonitorServerImpl monitorServerImpl : MIBExplorerServer.this._$23995) {
                monitorServerImpl.stopTimer();
                MIBExplorerServer.this._$6448.info("Stopped monitor: " + monitorServerImpl.getTitle());
            }
        }
    }
}

