/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.lf.MetalTheme;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBExplorerServer;
import com.agentpp.util.UserConfigFile;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;

public class MIBExplorer {
    boolean packFrame = false;

    public MIBExplorer(Vector vector) {
        String[] stringArray;
        Frame frame = new Frame();
        boolean bl = false;
        try {
            stringArray = Class.forName("com.agentpp.explorer.monitor.MonitorConfigPanel");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (System.getProperty("java.version").compareTo("1.6") < 0) {
            stringArray = new String[]{"MIB Explorer 3.x needs Java Runtime Environment 1.6 or later installed!", "Current version is: " + System.getProperty("java.version")};
            JOptionPane.showMessageDialog(frame, stringArray, "Unsupported JRE", 0);
            System.exit(1);
        }
        if (vector.contains("-help") || vector.contains("-?") || vector.contains("-h")) {
            this._$22694();
            System.exit(0);
        }
        stringArray = "MIBExplorer3.cf";
        String string = null;
        int n = vector.indexOf("-configFile");
        if (n >= 0) {
            if (vector.size() < n + 1) {
                System.out.println("There is no config file name given for the -config option, aborting.");
                System.exit(1);
            } else {
                string = (String)vector.get(n + 1);
            }
        }
        UserConfigFile userConfigFile = new UserConfigFile();
        if (string == null) {
            userConfigFile.setConfigName((String)stringArray);
        } else {
            userConfigFile.setConfigFile(string);
        }
        userConfigFile.read(true);
        MetalTheme metalTheme = new MetalTheme(userConfigFile);
        metalTheme.propertiesChanged();
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        String string2 = userConfigFile.get("LookAndFeel", null);
        if (string2 != null && string2.length() > 0) {
            try {
                UIManager.setLookAndFeel(string2);
            }
            catch (Exception exception) {
                System.out.println("Unable to load look&feel: " + string2);
            }
        } else {
            try {
                if (vector.contains("-native")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } else if (vector.contains("-kunststoff")) {
                    UIManager.setLookAndFeel("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
                } else if (System.getProperty("os.name", "").startsWith("Windows")) {
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                } else {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MIBExplorerFrame mIBExplorerFrame = new MIBExplorerFrame(userConfigFile, bl);
        if (this.packFrame) {
            mIBExplorerFrame.pack();
        } else {
            mIBExplorerFrame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = mIBExplorerFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        mIBExplorerFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        mIBExplorerFrame.setVisible(true);
        mIBExplorerFrame.initDone();
    }

    private void _$22694() {
        String[] stringArray = new String[]{"MIBExplorer [-help|h] [-?] [-configFile <configFile>] [[...server options...]]", " where ", "    -configFile    Specifies the config file to be used by MIB Explorer", "                   and <configFile> is the complete path to the file.", "    -help,-h       Prints out this usage information and then exits.", "    -?             Prints out the usage information for the Server."};
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
            if (System.getProperty("java.awt.headless", "false").equalsIgnoreCase("true") || vector.contains("-?") || vector.contains("-m") || vector.contains("-monitor") || vector.contains("-s") || vector.contains("-script") || vector.contains("-server")) {
                MIBExplorerServer mIBExplorerServer = new MIBExplorerServer(stringArray);
            } else {
                new MIBExplorer(vector);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        LogFactory.setLogFactory(new Log4jLogFactory());
    }
}

