/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.ResponseListener;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.GenTarget;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class HideResponseListener
extends ResponseListener {
    public HideResponseListener(RequestObserver requestObserver, Session session, Target target, GenTarget genTarget, MIBRepository mIBRepository, JTree jTree, DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        super(requestObserver, session, target, genTarget, mIBRepository, jTree, defaultTreeModel, defaultMutableTreeNode, string);
    }

    private DefaultMutableTreeNode _$5429(final DefaultMutableTreeNode defaultMutableTreeNode, ObjectID objectID) {
        MIBObject mIBObject = (MIBObject)defaultMutableTreeNode.getUserObject();
        if (!mIBObject.getObjectID().isRootOf(objectID)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getNextSibling();
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
            while (defaultMutableTreeNode2 == null && (defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent()) != null && !defaultMutableTreeNode3.equals(this.node)) {
                defaultMutableTreeNode2 = defaultMutableTreeNode3.getNextSibling();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HideResponseListener.this.model.removeNodeFromParent(defaultMutableTreeNode);
                }
            });
            if (defaultMutableTreeNode.equals(this.root)) {
                return null;
            }
            if (defaultMutableTreeNode2 != null) {
                return this._$5429(defaultMutableTreeNode2, objectID);
            }
            return null;
        }
        if (defaultMutableTreeNode.isLeaf()) {
            return defaultMutableTreeNode.getNextNode();
        }
        return this._$5429((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(), objectID);
    }

    public void onResponse(ResponseEvent responseEvent) {
        this.session.cancel(responseEvent.getRequest(), this);
        if (this.observer.isRequestCanceled()) {
            return;
        }
        if (this.logger.logResponse(responseEvent, this.observer)) {
            VariableBinding[] variableBindingArray = responseEvent.getResponse().toArray();
            if (variableBindingArray.length > 0 && !variableBindingArray[variableBindingArray.length - 1].isException()) {
                ObjectID objectID;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)responseEvent.getUserObject();
                DefaultMutableTreeNode defaultMutableTreeNode2 = this._$5429(defaultMutableTreeNode, objectID = new ObjectID(variableBindingArray[0].getOid().toString()));
                if (defaultMutableTreeNode2 != null) {
                    OID oID = new OID(((MIBObject)defaultMutableTreeNode2.getUserObject()).getOid().toString());
                    if (oID.leftMostCompare(this.root.size(), this.root) != 0) {
                        this.observer.requestFinished();
                        return;
                    }
                    objectID = ((MIBObject)defaultMutableTreeNode2.getUserObject()).getOid();
                    PDU pDU = responseEvent.getRequest();
                    int n = pDU.getMaxRepetitions();
                    pDU.clear();
                    pDU.setMaxRepetitions(n);
                    VariableBinding[] variableBindingArray2 = new VariableBinding[]{new VariableBinding()};
                    variableBindingArray2[0].setOid(new OID(objectID.toString()));
                    pDU.addAll(variableBindingArray2);
                    try {
                        String string = "Scanning subtree " + objectID.toString();
                        this.observer.resendRequest(-91, pDU, this.gtarget, this.target, defaultMutableTreeNode2, this, string);
                    }
                    catch (Exception exception) {
                        this.observer.requestFinishedWithError("I/O error: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                } else {
                    this.observer.requestFinished();
                }
            } else {
                this.observer.requestFinished();
            }
        }
    }
}

