/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ModulesSelectionDialog;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBSetPanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class DiscoverMIBSet
extends Thread {
    private GenTarget _$4262;
    private Snmp _$4261;
    private RepositoryManager _$18642;
    private MIBExplorerFrame _$18902;
    private Vector _$23633 = new Vector(20, 10);
    private MIBSetPanel _$5448;
    private GenTargetListener _$21254;
    private SnmpLogger _$4326;
    private JMenuItem _$23634;

    public DiscoverMIBSet(MIBExplorerFrame mIBExplorerFrame, Snmp snmp, GenTarget genTarget, RepositoryManager repositoryManager, MIBRepository mIBRepository, MIBSetPanel mIBSetPanel, GenTargetListener genTargetListener, JMenuItem jMenuItem) {
        this._$4261 = snmp;
        this._$4262 = genTarget;
        this._$18642 = repositoryManager;
        this._$18902 = mIBExplorerFrame;
        this._$5448 = mIBSetPanel;
        this._$21254 = genTargetListener;
        this._$23634 = jMenuItem;
        this._$4326 = new SnmpLogger(mIBRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        try {
            this._$18902.setMessage("Contacting target...please wait");
            String[] stringArray = this._$18642.getModuleNames();
            object = new ProgressMonitor(this._$18902, "Scanning target for implemented MIBs...", "", 0, stringArray.length);
            ((ProgressMonitor)object).setMillisToDecideToPopup(0);
            ((ProgressMonitor)object).setMillisToPopup(0);
            Target target = this._$4262.getTarget();
            if (target == null) {
                ((ProgressMonitor)object).close();
                JOptionPane.showMessageDialog(this._$18902, "Could not discover target's engine ID!", "Invalid Target", 0);
                this._$23634.setEnabled(true);
                this._$18902.setMessage(null);
                return;
            }
            for (int i = 0; i < stringArray.length && !((ProgressMonitor)object).isCanceled(); ++i) {
                ((ProgressMonitor)object).setNote(stringArray[i]);
                ((ProgressMonitor)object).setProgress(i);
                MIBModule mIBModule = this._$18642.getModule(stringArray[i], true);
                if (mIBModule == null) continue;
                boolean bl = false;
                Enumeration enumeration = mIBModule.objects();
                while (enumeration.hasMoreElements() && !((ProgressMonitor)object).isCanceled()) {
                    PDU pDU;
                    ResponseEvent responseEvent;
                    VariableBinding variableBinding;
                    PDU pDU2;
                    MIBObject mIBObject = (MIBObject)enumeration.nextElement();
                    if (!(mIBObject instanceof MIBObjectType)) continue;
                    MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                    if (mIBObjectType.isTable()) {
                        pDU2 = this._$4262.makePDU();
                        variableBinding = new VariableBinding();
                        variableBinding.setOid(new OID(mIBObjectType.getPrintableOid()));
                        pDU2.add(variableBinding);
                        SnmpLogger.logRequest(pDU2, this._$4262, false);
                        responseEvent = this._$4261.getNext(pDU2, target);
                        pDU = responseEvent.getResponse();
                        this._$4326.logResponse(responseEvent.getPeerAddress(), pDU2, pDU, false);
                        if (pDU == null) {
                            ((ProgressMonitor)object).close();
                            this._$5471();
                            return;
                        }
                        String string = "Target contacted";
                        if (this._$18902.getMessage() != null && !this._$18902.getMessage().equals(string)) {
                            this._$18902.setMessage(string);
                        } else if (this._$18902.getMessage() != null) {
                            this._$18902.setMessage(null);
                        }
                        if (pDU.getErrorStatus() != 0 || pDU.size() != 1 || pDU.get(0).isException()) continue;
                        OID oID = pDU.get(0).getOid();
                        if (!mIBObjectType.getObjectID().isRootOf(new ObjectID(oID.toString()))) continue;
                        bl = true;
                        break;
                    }
                    if (mIBObjectType.isColumnarObject() || !SMI.isAccessible(mIBObjectType.getAccess())) continue;
                    pDU2 = this._$4262.makePDU();
                    variableBinding = new VariableBinding();
                    variableBinding.setOid(new OID(mIBObjectType.getPrintableOid() + ".0"));
                    pDU2.add(variableBinding);
                    SnmpLogger.logRequest(pDU2, this._$4262, false);
                    responseEvent = this._$4261.get(pDU2, target);
                    pDU = responseEvent.getResponse();
                    this._$4326.logResponse(responseEvent.getPeerAddress(), pDU2, pDU, false);
                    if (pDU == null) {
                        ((ProgressMonitor)object).close();
                        this._$5471();
                        return;
                    }
                    if (pDU.getErrorStatus() != 0 || pDU.size() != 1 || pDU.get(0).isException()) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                this._$23633.addElement(stringArray[i]);
            }
            this._$18902.setMessage(null);
            ((ProgressMonitor)object).close();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Object object;
                        ModuleInfo[] moduleInfoArray = DiscoverMIBSet.this._$18642.getModuleInfos();
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        Object object2 = DiscoverMIBSet.this._$23633.elements();
                        while (object2.hasMoreElements()) {
                            object = object2.nextElement().toString();
                            hashtable.put((String)object, (String)object);
                        }
                        object2 = new ModulesSelectionDialog(moduleInfoArray, hashtable, DiscoverMIBSet.this._$18902, "Implemented MIBs: " + DiscoverMIBSet.this._$4262.toString(), true);
                        ((ModulesSelectionDialog)object2).setModuleTitle("MIB Set");
                        ((Window)object2).setLocationRelativeTo(DiscoverMIBSet.this._$18902);
                        ((Dialog)object2).setVisible(true);
                        object = ((ModulesSelectionDialog)object2).getModules();
                        if (object == null) {
                            return;
                        }
                        DiscoverMIBSet.this._$5448.putMIBSet(DiscoverMIBSet.this._$4262.getName(), (Vector)object);
                        DiscoverMIBSet.this._$5448.selectMIBSet(DiscoverMIBSet.this._$4262.getName());
                        String[] stringArray = new String[]{"Replace currently loaded MIBs with this MIB set", "and associate it with current target?"};
                        int n = JOptionPane.showConfirmDialog(DiscoverMIBSet.this._$18902, stringArray, "MIB Set Confirmation", 0, 3);
                        if (n == 0) {
                            DiscoverMIBSet.this._$4262.setMIBSet(DiscoverMIBSet.this._$4262.getName());
                            DiscoverMIBSet.this._$21254.targetChanged(new GenTargetEvent(this, DiscoverMIBSet.this._$4262, 0));
                            DiscoverMIBSet.this._$5448.setMIBSet(DiscoverMIBSet.this._$4262.getName());
                        }
                    }
                    catch (Exception exception) {
                        SnmpLogger.cTrapRcv.getRootLogger().fatal(exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exception) {
            object = exception.getMessage();
            SwingUtilities.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$s;
                {
                    this.val$s = string;
                }

                public void run() {
                    String[] stringArray = new String[]{"An unexpected error occured during scan:", this.val$s};
                    JOptionPane.showMessageDialog(DiscoverMIBSet.this._$18902, stringArray, "Internal Error", 0);
                }
            });
            exception.printStackTrace();
        }
        finally {
            this._$18902.setMessage(null);
            this._$23634.setEnabled(true);
        }
    }

    public Vector getResultSet() {
        return this._$23633;
    }

    private void _$5471() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String[] stringArray = new String[]{"Timeout occured during scan.", "Please check the target's security settings!", "If settings are correct, increase timeout value", "or retries for the target."};
                JOptionPane.showMessageDialog(DiscoverMIBSet.this._$18902, stringArray, "Timeout", 0);
                DiscoverMIBSet.this._$23634.setEnabled(true);
                DiscoverMIBSet.this._$18902.setMessage(null);
            }
        });
    }
}

