/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.ObjectID;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class CheckMIBSupport
extends Thread {
    private Vector _$20506;
    private Vector _$4957;
    private Vector _$53704 = new Vector();
    private Snmp _$4261;
    private JFrame _$18902;
    private transient Vector _$33542;

    public CheckMIBSupport(JFrame jFrame, Snmp snmp, Vector vector, Vector vector2) {
        this._$4261 = snmp;
        this._$20506 = vector;
        this._$4957 = vector2;
        this._$18902 = jFrame;
    }

    public void run() {
        try {
            ProgressMonitor progressMonitor = new ProgressMonitor(this._$18902, "Scanning targets for implemented MIBs...", "", 0, this._$20506.size() * this._$4957.size());
            for (int i = 0; i < this._$4957.size() && !progressMonitor.isCanceled(); ++i) {
                GenTarget genTarget = (GenTarget)this._$4957.elementAt(i);
                Target target = genTarget.getTarget();
                if (target == null) {
                    this.fireTargetChanged(new GenTargetEvent(this, genTarget, 2));
                    continue;
                }
                boolean bl = true;
                for (int j = 0; j < this._$20506.size() && !progressMonitor.isCanceled(); ++j) {
                    progressMonitor.setNote(target.toString() + ", " + this._$20506.elementAt(j));
                    progressMonitor.setProgress(i * this._$20506.size() + j);
                    MIBModule mIBModule = (MIBModule)this._$20506.elementAt(j);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (mIBModule == null) continue;
                    Enumeration enumeration = mIBModule.objects();
                    while (enumeration.hasMoreElements() && !progressMonitor.isCanceled()) {
                        PDU pDU;
                        ResponseEvent responseEvent;
                        VariableBinding variableBinding;
                        PDU pDU2;
                        MIBObject mIBObject = (MIBObject)enumeration.nextElement();
                        if (!(mIBObject instanceof MIBObjectType)) continue;
                        MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                        if (mIBObjectType.isTable()) {
                            pDU2 = genTarget.makePDU();
                            variableBinding = new VariableBinding();
                            variableBinding.setOid(new OID(mIBObjectType.getPrintableOid()));
                            pDU2.add(variableBinding);
                            responseEvent = this._$4261.getNext(pDU2, target);
                            pDU = responseEvent.getResponse();
                            bl3 = true;
                            if (pDU == null) {
                                progressMonitor.close();
                                this._$5471();
                                return;
                            }
                            if (pDU.getErrorStatus() != 0 || pDU.size() != 1 || pDU.get(0).isException()) continue;
                            OID oID = pDU.get(0).getOid();
                            if (!mIBObjectType.getObjectID().isRootOf(new ObjectID(oID.toString()))) continue;
                            bl2 = true;
                            break;
                        }
                        if (mIBObjectType.isColumnarObject() || !SMI.isAccessible(mIBObjectType.getAccess())) continue;
                        pDU2 = genTarget.makePDU();
                        variableBinding = new VariableBinding();
                        variableBinding.setOid(new OID(mIBObjectType.getPrintableOid() + ".0"));
                        pDU2.add(variableBinding);
                        responseEvent = this._$4261.get(pDU2, target);
                        pDU = responseEvent.getResponse();
                        bl3 = true;
                        if (pDU == null) {
                            progressMonitor.close();
                            this._$5471();
                            return;
                        }
                        if (pDU.getErrorStatus() != 0 || pDU.size() != 1 || pDU.get(0).isException()) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl3 || bl2) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                this.fireTargetChanged(new GenTargetEvent(this, genTarget, 2));
            }
            progressMonitor.close();
            this.fireTargetChanged(new GenTargetEvent(this, null, 0));
        }
        catch (Exception exception) {
            final String string = exception.getMessage();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{"An unexpected error occured during scan:", string};
                    JOptionPane.showMessageDialog(CheckMIBSupport.this._$18902, stringArray, "Internal Error", 0);
                }
            });
            exception.printStackTrace();
        }
    }

    private void _$5471() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String[] stringArray = new String[]{"Timeout occured during scan.", "Please check the target's security settings!", "If settings are correct, increase timeout value", "or retries for the target."};
                JOptionPane.showMessageDialog(CheckMIBSupport.this._$18902, stringArray, "Timeout", 0);
            }
        });
    }

    public synchronized void removeGenTargetListener(GenTargetListener genTargetListener) {
        if (this._$33542 != null && this._$33542.contains(genTargetListener)) {
            Vector vector = (Vector)this._$33542.clone();
            vector.removeElement(genTargetListener);
            this._$33542 = vector;
        }
    }

    public synchronized void addGenTargetListener(GenTargetListener genTargetListener) {
        Vector vector;
        Vector vector2 = vector = this._$33542 == null ? new Vector(2) : (Vector)this._$33542.clone();
        if (!vector.contains(genTargetListener)) {
            vector.addElement(genTargetListener);
            this._$33542 = vector;
        }
    }

    protected void fireTargetChanged(GenTargetEvent genTargetEvent) {
        if (this._$33542 != null) {
            Vector vector = this._$33542;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GenTargetListener)vector.elementAt(i)).targetChanged(genTargetEvent);
            }
        }
    }
}

