/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.tree;

import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MIBTreeModel
implements JCTreeTableModel,
TableModel {
    private static final String[] _$22066 = new String[]{"MIB Tree", "Object ID", "Object Type", "Status"};
    static final int COL_OID = 1;
    static final int COL_TYPE = 2;
    static final int COL_STATUS = 3;
    private MIBRepository _$7313;
    private TreeMap _$14149 = new TreeMap();
    private DefaultMutableTreeNode _$14834;
    private MIBTreeNode[] _$84;
    private transient Vector _$33505;
    private transient Vector _$33506;
    private boolean _$33476 = false;

    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
        MIBTreeNode values = (MIBTreeNode)dmtn.getUserObject();
        if (column == -1) {
            return values;
        }
        if (values != null) {
            return values.getColumn(column);
        }
        return null;
    }

    public boolean isCellEditable(Object parm1, int parm2) {
        return false;
    }

    public void setValueAt(Object parm1, Object parm2, int parm3) {
        throw new UnsupportedOperationException("Methode setValueAt() noch nicht implementiert.");
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    public int getColumnCount() {
        return _$22066.length;
    }

    public String getColumnName(int column) {
        return _$22066[column];
    }

    public Object getRoot() {
        return this._$14834;
    }

    public Object getChild(Object parent, int index) {
        return ((DefaultMutableTreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((DefaultMutableTreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)parent;
        DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)child;
        if (pNode == null || cNode == null) {
            return -1;
        }
        return pNode.getIndex(cNode);
    }

    public MIBRepository getRepository() {
        return this._$7313;
    }

    public boolean isRegisteredOnly() {
        return this._$33476;
    }

    public void setRepository(MIBRepository repository) {
        this._$7313 = repository;
    }

    public void setRegisteredOnly(boolean registeredOnly) {
        this._$33476 = registeredOnly;
    }

    public int getRowCount() {
        return this._$14149.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._$84[rowIndex].getColumn(columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void _$33518(DefaultMutableTreeNode node, MIBTreeNode child) {
        boolean added = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.compareTo((MIBTreeNode)n.getUserObject()) > 0) continue;
            node.insert(child.getNode(), i);
            added = true;
            break;
        }
        if (!added) {
            node.add(child.getNode());
        }
    }

    public void buildTree(MIBModule module) {
        this._$14149.clear();
        this._$14834 = new DefaultMutableTreeNode();
        this._$33520(this._$14834, module);
        this._$84 = new MIBTreeNode[this._$14149.size()];
        int i = 0;
        Iterator it = this._$14149.values().iterator();
        while (it.hasNext()) {
            this._$84[i] = (MIBTreeNode)it.next();
            ++i;
        }
    }

    private void _$33520(DefaultMutableTreeNode root, MIBModule module) {
        MIBObject current;
        LinkedList<MIBObject> base = new LinkedList<MIBObject>();
        if (module.hasImports()) {
            MIBImport[] imports = (MIBImport[])module.getImports();
            for (int i = 0; i < imports.length; ++i) {
                Enumeration en = imports[i].getImportsVector().elements();
                while (en.hasMoreElements()) {
                    String is = en.nextElement().toString();
                    current = this._$7313.getObject(imports[i].getSource(), is);
                    if (current == null || current.getOid().size() < 1) continue;
                    base.add(current);
                    MIBTreeNode childNode = new MIBTreeNode(current);
                    this._$14149.put(current.getObjectID(), childNode);
                    this._$33518(root, childNode);
                    this.buildSubTree(module, childNode.getNode(), this._$7313.getChildren(current.getOid(), false));
                }
            }
        }
        current = null;
        Enumeration en = module.objectsByOid().elements();
        while (en.hasMoreElements()) {
            MIBObject parent;
            MIBObject o = (MIBObject)en.nextElement();
            if (current != null && current.getOid().isRootOf(o.getOid()) || (parent = this._$7313.getParent(current = o)) != null) continue;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(current);
            MIBTreeNode childNode = new MIBTreeNode(current);
            this._$33518(root, childNode);
            this.buildSubTree(module, child, this._$7313.getChildren(current));
        }
    }

    public int buildSubTree(MIBModule module, DefaultMutableTreeNode node, Vector children) {
        int i = 0;
        int n = 0;
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            MIBObject current = (MIBObject)e.nextElement();
            if (!current.getModuleID().equals(module.getModuleID())) continue;
            MIBTreeNode childNode = new MIBTreeNode(current);
            this._$14149.put(current.getObjectID(), childNode);
            this._$33518(node, childNode);
            ++i;
            ++n;
            n += this.buildSubTree(module, childNode.getNode(), this._$7313.getChildren(current));
        }
        return n;
    }

    public synchronized void removeTreeModelListener(TreeModelListener l) {
        if (this._$33505 != null && this._$33505.contains(l)) {
            Vector v = (Vector)this._$33505.clone();
            v.removeElement(l);
            this._$33505 = v;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener l) {
        Vector v;
        Vector vector = v = this._$33505 == null ? new Vector(2) : (Vector)this._$33505.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this._$33505 = v;
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        if (this._$33505 != null) {
            Vector listeners = this._$33505;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TreeModelListener)listeners.elementAt(i)).treeNodesChanged(e);
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        if (this._$33505 != null) {
            Vector listeners = this._$33505;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TreeModelListener)listeners.elementAt(i)).treeNodesInserted(e);
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        if (this._$33505 != null) {
            Vector listeners = this._$33505;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TreeModelListener)listeners.elementAt(i)).treeNodesRemoved(e);
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        if (this._$33505 != null) {
            Vector listeners = this._$33505;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TreeModelListener)listeners.elementAt(i)).treeStructureChanged(e);
            }
        }
    }

    public synchronized void removeTableModelListener(TableModelListener l) {
        if (this._$33506 != null && this._$33506.contains(l)) {
            Vector v = (Vector)this._$33506.clone();
            v.removeElement(l);
            this._$33506 = v;
        }
    }

    public synchronized void addTableModelListener(TableModelListener l) {
        Vector v;
        Vector vector = v = this._$33506 == null ? new Vector(2) : (Vector)this._$33506.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this._$33506 = v;
        }
    }

    protected void fireTableChanged(TableModelEvent e) {
        if (this._$33506 != null) {
            Vector listeners = this._$33506;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TableModelListener)listeners.elementAt(i)).tableChanged(e);
            }
        }
    }

    public static MIBTreeModel createModel(MIBRepository rep, MIBModule module, boolean registeredOnly) {
        MIBTreeModel mibTreeModel = new MIBTreeModel();
        mibTreeModel.setRegisteredOnly(registeredOnly);
        mibTreeModel.setRepository(rep);
        mibTreeModel.buildTree(module);
        return mibTreeModel;
    }

    class MIBTreeNode
    implements Comparable {
        private MIBObject _$25538;
        private DefaultMutableTreeNode _$14227;

        public MIBTreeNode(MIBObject ot) {
            this._$25538 = ot;
        }

        public MIBObject getMIBObject() {
            return this._$25538;
        }

        public int compareTo(Object o) {
            return this._$25538.getOid().compareTo(((MIBTreeNode)o).getOID());
        }

        public ObjectID getOID() {
            return this._$25538.getOid();
        }

        public DefaultMutableTreeNode getNode() {
            if (this._$14227 == null) {
                this._$14227 = new DefaultMutableTreeNode(this);
            }
            return this._$14227;
        }

        public void setNode(DefaultMutableTreeNode node) {
            this._$14227 = node;
        }

        public Object getColumn(int column) {
            switch (column) {
                case 0: {
                    String name = MIBTreeModel.this._$7313.getPathSuffix(this.getOID());
                    return name;
                }
                case 1: {
                    return this._$25538.getOid();
                }
                case 2: {
                    return this._$25538.getTypeString();
                }
                case 3: {
                    return this._$25538.getStatus();
                }
            }
            return null;
        }
    }
}

