/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataView;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.util.Collection;
import java.util.Vector;

public class TableUtils {
    public static void setRangeAfterCopy(JCCellRange range) {
        if (range.start_row == -1) {
            range.start_row = 0;
        }
        if (range.start_column == -1) {
            range.start_column = 0;
        }
        if (range.start_row > range.end_row) {
            int temp_row = range.start_row;
            range.start_row = range.end_row;
            range.end_row = temp_row;
        }
        if (range.start_column > range.end_column) {
            int temp_col = range.start_column;
            range.start_column = range.end_column;
            range.end_column = temp_col;
        }
    }

    public static int getFirstMarkedRow(JCTable table) {
        int row = TableUtils.getFirstSelectedRow(table);
        if (row < 0) {
            row = table.getCurrentRow();
        }
        return row;
    }

    public static int getFirstSelectedRow(JCTable table) {
        Collection c = table.getSelectedCells();
        if (c == null) {
            return -1;
        }
        JCCellRange[] r = new JCCellRange[c.size()];
        c.toArray(r);
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < r.length; ++i) {
            TableUtils.setRangeAfterCopy(r[i]);
            if (r[i].start_row < min) {
                min = r[i].start_row;
            }
            if (r[i].end_row >= min) continue;
            min = r[i].end_row;
        }
        if (table.getDataView() instanceof SortableDataViewModel) {
            return ((SortableDataViewModel)table.getDataView()).getDataRow(min);
        }
        return min;
    }

    public static int getLastSelectedRow(JCTable table) {
        Collection c = table.getSelectedCells();
        if (c == null) {
            return -1;
        }
        JCCellRange[] r = new JCCellRange[c.size()];
        c.toArray(r);
        int max = -1;
        for (int i = 0; i < r.length; ++i) {
            TableUtils.setRangeAfterCopy(r[i]);
            if (r[i].start_row > max) {
                max = r[i].start_row;
            }
            if (r[i].end_row <= max) continue;
            max = r[i].end_row;
        }
        if (table.getDataView() instanceof SortableDataViewModel) {
            return ((SortableDataViewModel)table.getDataView()).getDataRow(max);
        }
        return max;
    }

    public static int[] getSelectedRows(Collection c) {
        if (c == null) {
            return new int[0];
        }
        Vector<Integer> v = new Vector<Integer>(10, 100);
        JCCellRange[] r = new JCCellRange[c.size()];
        c.toArray(r);
        for (int i = 0; i < r.length; ++i) {
            TableUtils.setRangeAfterCopy(r[i]);
            for (int j = r[i].start_row; j <= r[i].end_row; ++j) {
                v.add(new Integer(j));
            }
        }
        int[] s = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            s[i] = (Integer)v.elementAt(i);
        }
        return s;
    }

    public static int[] getSelectedRows(int numrows, Collection c) {
        if (c == null) {
            return new int[0];
        }
        Vector<Integer> v = new Vector<Integer>(10, 100);
        JCCellRange[] r = new JCCellRange[c.size()];
        c.toArray(r);
        for (int i = 0; i < r.length; ++i) {
            TableUtils.setRangeAfterCopy(r[i]);
            if (r[i].end_row >= numrows) {
                r[i].end_row = numrows - 1;
            }
            for (int j = r[i].start_row; j <= r[i].end_row; ++j) {
                v.add(new Integer(j));
            }
        }
        int[] s = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            s[i] = (Integer)v.elementAt(i);
        }
        return s;
    }

    public static int[] getSelectedRows(JCTable table) {
        return TableUtils.getDataRows(table, TableUtils.getSelectedRows(table.getNumRows(), table.getSelectedCells()));
    }

    public static int[] getMarkedRows(JCTable table) {
        int[] rows = TableUtils.getDataRows(table, TableUtils.getSelectedRows(table.getNumRows(), table.getSelectedCells()));
        if (rows == null || rows.length == 0) {
            int[] markedRow = new int[]{TableUtils.getFirstMarkedRow(table)};
            if (markedRow[0] < 0) {
                return rows;
            }
            return markedRow;
        }
        return rows;
    }

    public static int[] getDataRows(JCTable table, int[] rows) {
        if (table.getDataView() instanceof SortableDataViewModel) {
            int[] map = new int[rows.length];
            SortableDataViewModel sv = (SortableDataViewModel)table.getDataView();
            for (int i = 0; i < rows.length; ++i) {
                map[i] = sv.getDataRow(rows[i]);
            }
            return map;
        }
        return rows;
    }

    public static void removeRows(JCVectorDataSource data, int[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            data.deleteRows(rows[i], 1);
            int j = i + 1;
            while (j < rows.length) {
                int n = j++;
                rows[n] = rows[n] - 1;
            }
        }
    }

    public static boolean moveRow(JCVectorDataSource data, int row, int delta) {
        return data.moveRows(row, 1, row + (delta > 0 ? 1 : 0) + delta);
    }

    public static boolean moveSelectedRow(JCTable table, JCVectorDataSource data, int delta) {
        int row = TableUtils.getFirstSelectedRow(table);
        boolean ok = TableUtils.moveRow(data, row, delta);
        if (ok) {
            table.clearSelection();
            table.setCurrentCell(table.getCurrentRow() + delta, table.getCurrentColumn());
            if (table instanceof JCListTable) {
                table.setRowSelection(row + delta, row + delta);
            } else {
                table.setSelection(row + delta, 0, row + delta, table.getDataSource().getNumColumns() - 1);
            }
        }
        return ok;
    }

    public static void removeSelectedRows(JCTable table, JCVectorDataSource data) {
        int[] rows = TableUtils.getSelectedRows(table.getSelectedCells());
        rows = TableUtils.getDataRows(table, rows);
        TableUtils.removeRows(data, rows);
    }

    public static Vector sortVectorByView(JCTable table, Vector inputVector) {
        if (table.getDataView().getNumRows() != inputVector.size()) {
            return inputVector;
        }
        Vector v = new Vector(inputVector.size() + 1);
        TableDataView tdv = (TableDataView)table.getDataView();
        for (int i = 0; i < tdv.getNumRows(); ++i) {
            v.addElement(inputVector.elementAt(tdv.getDataRow(i)));
        }
        return v;
    }
}

