/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.agentpp.common.table.ConsolidationFunction;
import com.agentpp.common.table.RoundRobinEvent;
import com.agentpp.common.table.RoundRobinListener;
import com.klg.jclass.table.EditableTableDataModel;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class RoundRobinDataSource
implements EditableTableDataModel,
JCTableDataListener,
RoundRobinListener,
Serializable,
ConsolidationFunction {
    public static final long serialVersionUID = 2776133236688388574L;
    protected int position = 0;
    protected int samples = 288;
    protected JCVectorDataSource data = new JCVectorDataSource();
    private transient Vector tableDataListeners;
    private transient Vector roundRobinListeners;
    private int sampleRate = 300;
    private int consolidationFunction;
    private String name;
    private Vector lastSamples = new Vector(1);
    private transient boolean changed = true;
    private transient boolean dataChanged = false;
    private transient Long id;

    public RoundRobinDataSource() {
        this.activate();
    }

    public RoundRobinDataSource(int samples) {
        this();
        this.samples = samples;
    }

    public RoundRobinDataSource(int cf, int samples, int rate) {
        this();
        this.consolidationFunction = cf;
        this.samples = samples;
        this.sampleRate = rate;
    }

    public synchronized void setNumSamples(int samples) {
        this.samples = samples;
        if (this.data.getNumRows() > samples) {
            this.data.setNumRows(samples);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public Vector getColumnLabels() {
        return this.data.getColumnLabels();
    }

    public void activate() {
        this.data.addTableDataListener(this);
        if (this.lastSamples == null) {
            this.resetSamples();
        }
    }

    public void deactivate() {
        this.data.removeTableDataListener(this);
    }

    public int getNumSamples() {
        return this.samples;
    }

    private int getTranslatedRow(int row) {
        int t = this.position + row;
        int size = Math.min(this.samples, this.getNumRows());
        if (t >= size) {
            t -= size;
        }
        return t;
    }

    private int getBackTranslatedRow(int row) {
        int r = row - this.position;
        if (r < 0) {
            r = this.getNumRows() + r;
        }
        return r;
    }

    public List getCells() {
        Vector v = new Vector(this.getNumRows() + 1);
        for (int i = 0; i < this.data.getNumRows(); ++i) {
            int row = this.getTranslatedRow(i);
            Vector<Object> vr = new Vector<Object>(this.getNumColumns() + 1);
            vr.add(this.data.getTableRowLabel(row));
            for (int j = 0; j < this.getNumColumns(); ++j) {
                vr.add(this.data.getTableDataItem(row, j));
            }
            v.add(vr);
        }
        return v;
    }

    public Object getTableDataItem(int row, int column) {
        return this.data.getTableDataItem(this.getTranslatedRow(row), column);
    }

    public void setCell(int row, int col, Object o) {
        this.data.setCell(this.getTranslatedRow(row), col, o);
    }

    public Object getTableColumnLabel(int col) {
        return this.data.getTableColumnLabel(col);
    }

    public Object getTableRowLabel(int row) {
        return this.data.getTableRowLabel(this.getTranslatedRow(row));
    }

    public void setRowLabel(int row, Object label) {
        this.data.setRowLabel(this.getTranslatedRow(row), label);
    }

    private int decPosition() {
        int cp;
        block0: {
            if ((cp = this.position--) != 0) break block0;
            this.position = this.getNumRows() - 1;
        }
        return cp;
    }

    private int incPosition() {
        int cp = this.position;
        this.position = this.position + 1 == this.samples ? 0 : ++this.position;
        return cp;
    }

    public boolean deleteColumns(int col, int num) {
        boolean r = this.data.deleteColumns(col, num);
        return r;
    }

    public boolean addColumn(int col, Object label) {
        Vector<Double> v = new Vector<Double>(this.data.getNumRows() + 1);
        for (int i = 0; i < this.data.getNumRows(); ++i) {
            v.add(new Double(0.0));
        }
        return this.data.addColumn(col, label, v);
    }

    public boolean moveColumn(int src, int num, int dest) {
        boolean r = this.data.moveColumns(src, num, dest);
        return r;
    }

    public boolean addRow(int row, Object label, Vector v) {
        this.dataChanged = true;
        if (this.getNumRows() < this.samples) {
            if (row == Integer.MAX_VALUE) {
                if (this.position == 0) {
                    return this.data.addRow(Integer.MAX_VALUE, label, v);
                }
                return this.data.addRow(this.incPosition(), label, v);
            }
            return this.data.addRow(this.getTranslatedRow(row), label, v);
        }
        row = row == Integer.MAX_VALUE ? this.incPosition() : this.getTranslatedRow(row);
        this.data.setRowLabel(row, label);
        for (int i = 0; i < v.size(); ++i) {
            this.data.setCell(row, i, v.elementAt(i));
        }
        this.fireDataChanged(new JCTableDataEvent(this, 0, 0, 0, 0, 14));
        return true;
    }

    public boolean deleteRows(int row, int n) {
        this.data.removeTableDataListener(this);
        int r = this.getTranslatedRow(row);
        int sz = this.getNumRows();
        if (this.position >= r) {
            this.position -= Math.min(this.position - r, n);
            if (this.position < 0) {
                this.position = sz - n + this.position;
            }
        }
        boolean ok = r + n <= sz ? this.data.deleteRows(r, n) : this.data.deleteRows(r, sz - r) && this.data.deleteRows(0, r + n - sz);
        this.data.addTableDataListener(this);
        if (ok) {
            this.fireDataChanged(new JCTableDataEvent(this, 0, 0, 0, 0, 14));
        }
        return ok;
    }

    public int getNumRows() {
        return this.data.getNumRows();
    }

    public int getNumColumns() {
        return this.data.getNumColumns();
    }

    public boolean setTableDataItem(Object o, int row, int col) {
        this.data.setCell(this.getTranslatedRow(row), col, o);
        return true;
    }

    public void setNumRows(int rows) {
        if (this.position > rows) {
            this.position = rows;
        }
        this.data.setNumRows(rows);
    }

    public void setNumColumns(int cols) {
        this.data.setNumColumns(cols);
    }

    public void setColumnLabel(int col, Object label) {
        this.data.setColumnLabel(col, label);
    }

    public synchronized void removeTableDataListener(JCTableDataListener l) {
        if (this.tableDataListeners != null && this.tableDataListeners.contains(l)) {
            Vector v = (Vector)this.tableDataListeners.clone();
            v.removeElement(l);
            this.tableDataListeners = v;
        }
    }

    public synchronized void addTableDataListener(JCTableDataListener l) {
        Vector v;
        Vector vector = v = this.tableDataListeners == null ? new Vector(2) : (Vector)this.tableDataListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.tableDataListeners = v;
        }
    }

    public void fireAddDataPoint(RoundRobinEvent e) {
        if (this.roundRobinListeners != null) {
            Vector listeners = this.roundRobinListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RoundRobinListener)listeners.get(i)).addDataPoint(e);
            }
        }
    }

    public void fireRemoveDataPoint(RoundRobinEvent e) {
        if (this.roundRobinListeners != null) {
            Vector listeners = this.roundRobinListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RoundRobinListener)listeners.get(i)).removeDataPoint(e);
            }
        }
    }

    public void fireResetSamples(RoundRobinEvent e) {
        if (this.roundRobinListeners != null) {
            Vector listeners = this.roundRobinListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RoundRobinListener)listeners.get(i)).addDataPoint(e);
            }
        }
    }

    protected void fireDataChanged(JCTableDataEvent e) {
        if (this.tableDataListeners != null) {
            Vector listeners = this.tableDataListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((JCTableDataListener)listeners.elementAt(i)).dataChanged(e);
            }
        }
    }

    public void dataChanged(JCTableDataEvent e) {
        JCTableDataEvent event = new JCTableDataEvent(e.getSource(), this.getBackTranslatedRow(e.getRow()), e.getColumn(), e.getNumAffected(), e.getDestination(), e.getCommand());
        this.fireDataChanged(event);
    }

    private boolean checkNewData(RoundRobinEvent e) {
        boolean ok = true;
        Enumeration en = e.getRow().elements();
        while (en.hasMoreElements()) {
            Object value = en.nextElement();
            if (value != null && value instanceof Number) continue;
            ok = false;
            break;
        }
        return ok;
    }

    public synchronized void addDataPoint(RoundRobinEvent e) {
        block18: {
            try {
                this.changed = false;
                if (this.sampleRate <= 0) break block18;
                if (!this.checkNewData(e)) {
                    return;
                }
                this.addSample(e);
                if (this.lastSamples.size() < this.sampleRate) break block18;
                double[] v = new double[((RoundRobinEvent)this.lastSamples.firstElement()).getRow().size()];
                if (this.consolidationFunction == 3) {
                    Vector r = ((RoundRobinEvent)this.lastSamples.lastElement()).getRow();
                    for (int j = 0; j < r.size(); ++j) {
                        v[j] = ((Number)r.elementAt(j)).doubleValue();
                    }
                } else {
                    int i;
                    for (i = 0; i < this.lastSamples.size(); ++i) {
                        Vector r = ((RoundRobinEvent)this.lastSamples.elementAt(i)).getRow();
                        block9: for (int j = 0; j < r.size(); ++j) {
                            if (i == 0) {
                                v[j] = ((Number)r.elementAt(j)).doubleValue();
                                continue;
                            }
                            switch (this.consolidationFunction) {
                                case 1: {
                                    if (!(((Number)r.elementAt(j)).doubleValue() < v[j])) continue block9;
                                    v[j] = ((Number)r.elementAt(j)).doubleValue();
                                    continue block9;
                                }
                                case 2: {
                                    if (!(((Number)r.elementAt(j)).doubleValue() > v[j])) continue block9;
                                    v[j] = ((Number)r.elementAt(j)).doubleValue();
                                    continue block9;
                                }
                                case 0: 
                                case 4: {
                                    int n = j;
                                    v[n] = v[n] + ((Number)r.elementAt(j)).doubleValue();
                                }
                            }
                        }
                    }
                    if (this.consolidationFunction == 0) {
                        for (i = 0; i < v.length; ++i) {
                            v[i] = v[i] / (double)this.lastSamples.size();
                        }
                    }
                }
                Vector<Double> newRow = new Vector<Double>(v.length);
                for (int i = 0; i < v.length; ++i) {
                    newRow.add(new Double(v[i]));
                }
                if (this.addRow(Integer.MAX_VALUE, ((RoundRobinEvent)this.lastSamples.lastElement()).getLabel(), newRow)) {
                    this.changed = true;
                    this.fireAddDataPoint(new RoundRobinEvent(this, ((RoundRobinEvent)this.lastSamples.lastElement()).getLabel(), newRow, false));
                }
                this.resetSamples();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addSample(RoundRobinEvent e) {
        this.lastSamples.addElement(e);
        this.fireAddDataPoint(new RoundRobinEvent(this, e.getLabel(), e.getRow(), true));
    }

    public synchronized void removeRoundRobinListener(RoundRobinListener l) {
        if (this.roundRobinListeners != null && this.roundRobinListeners.contains(l)) {
            Vector v = (Vector)this.roundRobinListeners.clone();
            v.removeElement(l);
            this.roundRobinListeners = v;
        }
    }

    public synchronized void addRoundRobinListener(RoundRobinListener l) {
        Vector v;
        Vector vector = v = this.roundRobinListeners == null ? new Vector(2) : (Vector)this.roundRobinListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.roundRobinListeners = v;
        }
    }

    public synchronized void setSampleRate(int newSampleRate) {
        this.sampleRate = newSampleRate;
        this.resetSamples();
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setConsolidationFunction(int newConsolidationFunction) {
        this.consolidationFunction = newConsolidationFunction;
    }

    public int getConsolidationFunction() {
        return this.consolidationFunction;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public Long getId() {
        return this.id;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setData(int position, int rowCount, int colCount, Vector rowLabels, Vector colLabels, Vector cells) {
        this.position = position;
        this.data = new JCVectorDataSource(rowCount, colCount, rowLabels, colLabels, cells);
    }

    public RoundRobinDataSource createDataClone() {
        RoundRobinDataSource copy = new RoundRobinDataSource(this.consolidationFunction, this.samples, this.sampleRate);
        copy.setName(this.getName());
        copy.data = new JCVectorDataSource(this.data.getNumRows(), this.data.getNumColumns(), (Vector)this.data.getRowLabels().clone(), (Vector)this.data.getColumnLabels().clone(), (Vector)this.data.getCells().clone());
        return copy;
    }

    public List getLastSamples() {
        if (this.lastSamples == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.lastSamples);
    }

    public void setLastSamples(List samples) {
        this.lastSamples = new Vector(samples);
        this.fireResetSamples(new RoundRobinEvent(this, null, this.lastSamples, true));
    }

    public void resetSamples(RoundRobinEvent e) {
        this.resetSamples();
    }

    private void resetSamples() {
        this.lastSamples = new Vector(this.sampleRate + 1);
        this.fireResetSamples(new RoundRobinEvent(this, null, this.lastSamples, true));
    }

    public void removeDataPoint(RoundRobinEvent e) {
    }
}

