/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.Token;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.smiparser.SMIParserTokenManager;
import com.agentpp.smiparser.SimpleCharStream;
import com.agentpp.smiparser.TokenMgrError;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class SmiDocument
extends PlainDocument {
    private boolean _$16775;

    public SmiDocument() {
        super(new GapContent(1024));
    }

    public Scanner createScanner() {
        Scanner s;
        try {
            s = new Scanner();
        }
        catch (IOException e) {
            s = null;
        }
        return s;
    }

    public int getLineOfOffset(int offset) {
        return super.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineLength(int line) {
        Element l = super.getDefaultRootElement().getElement(line);
        return l.getEndOffset() - l.getStartOffset();
    }

    public int getLineCount() {
        return super.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getStartOffset();
    }

    public int getLineEndOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getEndOffset();
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (chng.getOffset() + chng.getLength() + 1 < chng.getDocument().getEndPosition().getOffset()) {
            this._$16775 = true;
        }
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        this._$16775 = true;
    }

    public void setUpdated(boolean updated) {
        this._$16775 = updated;
    }

    public boolean isUpdated() {
        return this._$16775;
    }

    class DocumentInputStream
    extends InputStream {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentInputStream(int p0, int p1) {
            this.p0 = p0;
            this.p1 = Math.min(SmiDocument.this.getLength(), p1);
            this.pos = p0;
            try {
                this.loadSegment();
            }
            catch (IOException ioe) {
                throw new Error("unexpected: " + ioe);
            }
        }

        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        void loadSegment() throws IOException {
            try {
                int n = Math.min(1024, this.p1 - this.pos);
                SmiDocument.this.getText(this.pos, n, this.segment);
                this.pos += n;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e) {
                throw new IOException("Bad location");
            }
        }
    }

    public class Scanner {
        private SMIParserTokenManager _$16789;
        private SimpleCharStream _$16790;
        private Token[] _$16562;
        private com.agentpp.smiparser.Token _$16791;
        private com.agentpp.smiparser.Token _$16792;
        private OrderedMap _$16793 = new OrderedMap();
        int p0;

        Scanner() throws IOException {
            this._$16794();
            this._$16790 = new SimpleCharStream(new DocumentInputStream(0, SmiDocument.this.getLength()));
            this._$16789 = new SMIParserTokenManager(this._$16790);
        }

        private void _$16794() {
            this._$16562 = new Token[SMIParserConstants.tokenImage.length];
            block0: for (int i = 0; i < this._$16562.length; ++i) {
                for (int j = 0; j < Token.all.length; ++j) {
                    if (Token.all[j].getScanValue() != i) continue;
                    this._$16562[i] = Token.all[j];
                    continue block0;
                }
            }
        }

        public void setRange(int p0, int p1) throws IOException {
            this._$16790 = new SimpleCharStream(new DocumentInputStream(p0, p1), 0, 0, 4096, p0);
            this._$16789.ReInit(this._$16790);
            this._$16791 = null;
            this._$16792 = null;
            this.p0 = p0;
            Integer i0 = new Integer(p0);
            this._$16793.remove(this._$16793.lowerBound(i0), this._$16793.end());
        }

        public final int getEndOffset() {
            if (this._$16791 == null) {
                this.getNextToken();
                if (this._$16791 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$16792 != null) {
                return this._$16792.endPos;
            }
            return this._$16791.endPos;
        }

        public int getTokenLength() {
            return this.getEndOffset() - this.getBeginOffset();
        }

        public final int getBeginOffset() {
            if (this._$16791 == null) {
                this.getNextToken();
                if (this._$16791 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$16792 != null) {
                return this._$16792.endPos - this._$16792.image.length();
            }
            return this._$16791.endPos - this._$16791.image.length();
        }

        public final Token getToken() {
            if (this._$16791 == null) {
                return this.getNextToken();
            }
            Token t = this._$16792 != null ? this._$16562[this._$16792.kind] : this._$16562[this._$16791.kind];
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }

        private void _$16804(int pos) {
            Integer p = new Integer(pos);
            this._$16793.put(p, p);
        }

        public int getScannerStart(int p) {
            Integer i = new Integer(p);
            OrderedMapIterator it = this._$16793.lowerBound(i);
            if (!it.atBegin()) {
                it.retreat();
            }
            if (it.atBegin() || it.atEnd()) {
                return 0;
            }
            int v = (Integer)((Pair)it.get()).first;
            return v;
        }

        public final Token getNextToken() {
            Token t = null;
            if (this._$16792 != null) {
                t = this._$16562[this._$16792.kind];
                this._$16792 = this._$16792.next;
                return t;
            }
            try {
                this._$16791 = this._$16789.getNextToken();
                this._$16792 = this._$16791.specialToken;
                if (this._$16792 != null) {
                    while (this._$16792.specialToken != null) {
                        this._$16792 = this._$16792.specialToken;
                    }
                    t = this._$16562[this._$16792.kind];
                } else {
                    t = this._$16562[this._$16791.kind];
                }
                this._$16804(this._$16791.endPos - this._$16791.image.length());
            }
            catch (TokenMgrError error) {
                this._$16791 = null;
                return Token.ERROR;
            }
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }
    }
}

