/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.lf;

import com.agentpp.util.UserConfigFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class LookAndFeelConfigPanel
extends JPanel {
    private static final String[][] _$30380 = new String[][]{{"tree.icon.AGENT-CAPABILITIES", "agentcaps16.gif"}, {"tree.icon.IMPORT.Module", "importmodule16.gif"}, {"tree.icon.MODULE-COMPLIANCE", "compliance16.gif"}, {"tree.icon.MODULE-IDENTITY", "module16.gif"}, {"tree.icon.NOTIFICATION-TYPE", "notification16.gif"}, {"tree.icon.NOTIFICATION-GROUP", "notifygroup16.gif"}, {"tree.icon.OBJECT-GROUP", "group16.gif"}, {"tree.icon.OBJECT-TYPE.Column", "column16.gif"}, {"tree.icon.OBJECT-TYPE.Scalar", "scalar16.gif"}, {"tree.icon.OBJECT-TYPE.Table", "table16.gif"}, {"tree.icon.OBJECT-TYPE.TableEntry", "tablerow16.gif"}, {"tree.icon.TEXTUAL-CONVENTION", "textualconvention16.gif"}, {"tree.icon.TRAP-TYPE", "notification16.gif"}, {"tree.icon.IMPORT.Object", "importobject16.gif"}, {"tree.icon.OBJECT-IDENTITY", "identity16.gif"}, {"tree.icon.INSTANCE", "instance16.gif"}, {"tree.icon.INSTANCE_MUTABLE", "instance_mutable16.gif"}};
    public static final String PROP_TREE_ICONS = "tree.icons";
    public static final String CFG_LOOK_AND_FEEL = "LookAndFeel";
    private static final String[][] _$30383 = new String[][]{{"Metal - Cross Platform", UIManager.getCrossPlatformLookAndFeelClassName()}, {"Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel"}, {"Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel"}, {"Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"}, {"Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel"}, {"System (Windows, Motif, etc.) [Default]", UIManager.getSystemLookAndFeelClassName()}};
    private Border _$25930;
    private TitledBorder _$26415;
    private JComboBox _$30384 = new JComboBox();
    private GridBagLayout _$6184 = new GridBagLayout();
    private UserConfigFile _$6388;
    private DefaultComboBoxModel _$6203 = new DefaultComboBoxModel();
    private JLabel _$9949 = new JLabel();
    JCheckBox useLookAndFeelTreeIcons = new JCheckBox();
    public boolean activateCustomTreeIcons;
    private int _$6126 = 0;

    public LookAndFeelConfigPanel(boolean activateCustomTreeIcons) {
        this.activateCustomTreeIcons = activateCustomTreeIcons;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LookAndFeelConfigPanel() {
        this(false);
    }

    public LookAndFeelConfigPanel(UserConfigFile config) {
        this(false);
        this.setConfig(config);
    }

    public LookAndFeelConfigPanel(UserConfigFile config, boolean activateCustomTreeIcons) {
        this(activateCustomTreeIcons);
        this.setConfig(config);
    }

    void jbInit() throws Exception {
        this._$30384.setEditable(true);
        this._$25930 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$26415 = new TitledBorder(this._$25930, "Look & Feel");
        this.setBorder(this._$26415);
        this.setLayout(this._$6184);
        this._$9949.setText("*Changes will take effect after application restart.");
        this.useLookAndFeelTreeIcons.setToolTipText("If not checked node icons in the MIB tree reflect the object's type");
        this.useLookAndFeelTreeIcons.setText("Use SMI object type specific tree icons");
        this.useLookAndFeelTreeIcons.setSelected(true);
        this.add((Component)this._$30384, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._$9949, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        if (this.activateCustomTreeIcons) {
            this.add((Component)this.useLookAndFeelTreeIcons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        }
    }

    public void setConfig(UserConfigFile config) {
        this._$6388 = config;
        this._$6203.removeAllElements();
        for (int i = this._$6126; i < _$30383.length; ++i) {
            this._$6203.addElement(_$30383[i][0]);
        }
        this._$30384.setModel(this._$6203);
        String lf = config.get(CFG_LOOK_AND_FEEL, _$30383[0][1]);
        boolean found = false;
        for (int i = this._$6126; i < _$30383.length; ++i) {
            if (!lf.equals(_$30383[i][1])) continue;
            this._$30384.setSelectedIndex(i - this._$6126);
            found = true;
            break;
        }
        if (!found) {
            this._$30384.getEditor().setItem(lf);
        }
        this.useLookAndFeelTreeIcons.setSelected(config.getBoolean(PROP_TREE_ICONS, this.activateCustomTreeIcons));
    }

    public static final void setTreeIconConfig(UserConfigFile config) {
        for (int i = 0; i < _$30380.length; ++i) {
            config.put(_$30380[i][0], _$30380[i][1]);
        }
    }

    public void save() {
        this._$6388.putBoolean(PROP_TREE_ICONS, this.useLookAndFeelTreeIcons.isSelected());
        if (this.useLookAndFeelTreeIcons.isSelected()) {
            LookAndFeelConfigPanel.setTreeIconConfig(this._$6388);
        } else {
            for (int i = 0; i < _$30380.length; ++i) {
                this._$6388.remove(_$30380[i][0]);
            }
        }
        String lf = this._$30384.getSelectedItem().toString();
        for (int i = this._$6126; i < _$30383.length; ++i) {
            if (!lf.equals(_$30383[i][0])) continue;
            this._$6388.put(CFG_LOOK_AND_FEEL, _$30383[i][1]);
            return;
        }
        this._$6388.put(CFG_LOOK_AND_FEEL, lf);
    }
}

