/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.formula;

import com.agentpp.common.formula.ArithmeticExpressionList;
import com.agentpp.common.formula.BooleanExpression;
import com.agentpp.common.formula.Concatenation;
import com.agentpp.common.formula.ConditionalExpression;
import com.agentpp.common.formula.Delta;
import com.agentpp.common.formula.ExtTableReference;
import com.agentpp.common.formula.FormulaParserConstants;
import com.agentpp.common.formula.FormulaParserTokenManager;
import com.agentpp.common.formula.IFormulaParser;
import com.agentpp.common.formula.NumberFormatExpression;
import com.agentpp.common.formula.OidConstant;
import com.agentpp.common.formula.ParseException;
import com.agentpp.common.formula.SimpleCharStream;
import com.agentpp.common.formula.StringConstant;
import com.agentpp.common.formula.SumWhen;
import com.agentpp.common.formula.Token;
import com.agentpp.common.formula.ValueOf;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.TargetInformation;
import com.agentpp.util.Regex;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.Abs;
import com.klg.jclass.util.formulae.Add;
import com.klg.jclass.util.formulae.Average;
import com.klg.jclass.util.formulae.Ceiling;
import com.klg.jclass.util.formulae.Count;
import com.klg.jclass.util.formulae.Divide;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.Floor;
import com.klg.jclass.util.formulae.GeometricMean;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.Max;
import com.klg.jclass.util.formulae.Median;
import com.klg.jclass.util.formulae.Min;
import com.klg.jclass.util.formulae.Multiply;
import com.klg.jclass.util.formulae.Power;
import com.klg.jclass.util.formulae.Product;
import com.klg.jclass.util.formulae.Remainder;
import com.klg.jclass.util.formulae.Root;
import com.klg.jclass.util.formulae.Round;
import com.klg.jclass.util.formulae.Sort;
import com.klg.jclass.util.formulae.StdDeviation;
import com.klg.jclass.util.formulae.Subtract;
import com.klg.jclass.util.formulae.Sum;
import com.klg.jclass.util.formulae.Trunc;
import java.awt.Point;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

public class FormulaParser
implements IFormulaParser,
FormulaParserConstants {
    public static final String ABS = "ABS";
    public static final String MULTIPLY = "MULTIPLY";
    public static final String AVERAGE = "AVERAGE";
    public static final String CEILING = "CEILING";
    public static final String DELTA = "DELTA";
    public static final String DELTA32 = "DELTA32";
    public static final String DELTA64 = "DELTA64";
    public static final String INTERVAL = "INTERVAL";
    public static final String POWER = "POWER";
    public static final String COUNT = "COUNT";
    public static final String PRODUCT = "PRODUCT";
    public static final String REMAINDER = "REMAINDER";
    public static final String ROOT = "ROOT";
    public static final String FLOOR = "FLOOR";
    public static final String ROUND = "ROUND";
    public static final String GEOMETRICMEAN = "GEOMETRICMEAN";
    public static final String SORT = "SORT";
    public static final String STDDEVIATION = "STDDEVIATION";
    public static final String SUBTRACT = "SUBTRACT";
    public static final String SUM = "SUM";
    public static final String MAX = "MAX";
    public static final String MEDIAN = "MEDIAN";
    public static final String TRUNC = "TRUNC";
    public static final String MIN = "MIN";
    public static final int MODE_ARITHMETIC_EXPRESSION = 0;
    public static final int MODE_OID_EXPRESSION = 1;
    public static final int MODE_FORMATTED_ARITHMETIC_EXPRESSION = 2;
    public static final int MODE_BOOLEAN_EXPRESSION = 3;
    public TableDataModel tableModel = null;
    public int currentRow = 0;
    public int currentCol = 0;
    public TargetInformation targetInformation;
    public MIBRepository rep;
    public int interval = 1;
    public FormulaParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int _$20094;
    private Token _$20193;
    private Token _$20192;
    private int _$20191;
    public boolean lookingAhead = false;
    private boolean _$20257;
    private int _$20107;
    private final int[] _$20106 = new int[37];
    private final int[] _$20258 = new int[]{-1006520299, -1006503915, -1004423147, 1729, 0x180000, 0x180000, -1004423148, 0xC00000, 0xC00000, 0x3000000, 0x3000000, 0x30000000, 0x30000000, -1006520300, 0x40000000, -1073741824, -1073741824, 0, 0, 0, -1006520300, 0, 0, 0, 0, 0, 0x8000000, -872302572, 67221524, 65536, 20, 448, 192, 0, 0, 0, 1728};
    private final int[] _$20259 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 0, 8, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 0};
    private final JJCalls[] _$20261 = new JJCalls[2];
    private boolean _$20262 = false;
    private int _$20263 = 0;
    private Vector _$20273 = new Vector();
    private int[] _$20274;
    private int _$20267 = -1;
    private int[] _$20275 = new int[100];
    private int _$20276;

    public FormulaParser() {
        this(new StringReader(""));
    }

    public Expression parseStream(Reader reader, int n) throws ParseException {
        this.ReInit(reader);
        switch (n) {
            case 1: {
                return this.parseOIDStringExpression();
            }
            case 2: {
                return this.parseFormattedArithmeticExpression();
            }
            case 3: {
                return this.parseBooleanExpression();
            }
        }
        return this.parseArithmeticExpression();
    }

    public Point getLocation(int n, String string) {
        char c = string.toUpperCase().charAt(0);
        int n2 = c - 65;
        int n3 = 0;
        if (c == 'Z') {
            n2 = this.currentCol;
            if (string.length() < 2) {
                return new Point(n2, n);
            }
        } else if (c == 'T') {
            n2 = -1;
            if (string.length() < 2) {
                return new Point(n2, n);
            }
        } else if (string.length() < 2) {
            return new Point(n2, n);
        }
        if (string.charAt(1) == '?') {
            return new Point(n2, 0);
        }
        try {
            n3 = Integer.valueOf(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Bad location " + string);
        }
        return new Point(n2, n - n3);
    }

    public final Expression parseArithmeticExpression() throws ParseException {
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                Expression expression = this.arithmeticExpression();
                this._$20104(0);
                return expression;
            }
            case 0: {
                this._$20104(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20106[0] = this._$20107;
        this._$20104(-1);
        throw new ParseException();
    }

    public final Expression parseFormattedArithmeticExpression() throws ParseException {
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 14: {
                Expression expression = this.formatExpression();
                return expression;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                Expression expression = this.arithmeticExpression();
                this._$20104(0);
                return expression;
            }
            case 0: {
                this._$20104(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20106[1] = this._$20107;
        this._$20104(-1);
        throw new ParseException();
    }

    public final Expression parseBooleanExpression() throws ParseException {
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                Expression expression = this.booleanExpression();
                this._$20104(0);
                return expression;
            }
            case 0: {
                this._$20104(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20106[2] = this._$20107;
        this._$20104(-1);
        throw new ParseException();
    }

    public final Expression parseOIDStringExpression() throws ParseException {
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Expression expression = this.oidStringConcatExpression();
                this._$20104(0);
                return expression;
            }
            case 0: {
                this._$20104(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20106[3] = this._$20107;
        this._$20104(-1);
        throw new ParseException();
    }

    public final Expression arithmeticExpression() throws ParseException {
        Expression expression = this.additiveExpression();
        return expression;
    }

    public final Expression booleanExpression() throws ParseException {
        Expression expression;
        block8: {
            expression = this.notExpression();
            block7: while (true) {
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 19: 
                    case 20: {
                        break;
                    }
                    default: {
                        this._$20106[4] = this._$20107;
                        break block8;
                    }
                }
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 19: {
                        this._$20104(19);
                        Expression expression2 = this.notExpression();
                        expression = new BooleanExpression(2, expression, expression2);
                        continue block7;
                    }
                    case 20: {
                        this._$20104(20);
                        Expression expression2 = this.notExpression();
                        expression = new BooleanExpression(1, expression, expression2);
                        continue block7;
                    }
                }
                break;
            }
            this._$20106[5] = this._$20107;
            this._$20104(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression notExpression() throws ParseException {
        Expression expression;
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                expression = this.relationalExpression();
                break;
            }
            case 21: {
                this._$20104(21);
                expression = this.relationalExpression();
                expression = new BooleanExpression(0, expression);
                break;
            }
            default: {
                this._$20106[6] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression relationalExpression() throws ParseException {
        Expression expression = this.OrEqualExpression();
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 22: 
            case 23: {
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 22: {
                        this._$20104(22);
                        Expression expression2 = this.OrEqualExpression();
                        return new BooleanExpression(4, expression, expression2);
                    }
                    case 23: {
                        this._$20104(23);
                        Expression expression3 = this.OrEqualExpression();
                        return new BooleanExpression(3, expression, expression3);
                    }
                }
                this._$20106[7] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        this._$20106[8] = this._$20107;
        return expression;
    }

    public final Expression OrEqualExpression() throws ParseException {
        Expression expression = this.EqualExpression();
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 24: 
            case 25: {
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 24: {
                        this._$20104(24);
                        Expression expression2 = this.additiveExpression();
                        BooleanExpression booleanExpression = new BooleanExpression(4, expression, expression2);
                        BooleanExpression booleanExpression2 = new BooleanExpression(5, expression, expression2);
                        return new BooleanExpression(1, booleanExpression, booleanExpression2);
                    }
                    case 25: {
                        this._$20104(25);
                        Expression expression3 = this.additiveExpression();
                        BooleanExpression booleanExpression = new BooleanExpression(3, expression, expression3);
                        BooleanExpression booleanExpression3 = new BooleanExpression(5, expression, expression3);
                        return new BooleanExpression(1, booleanExpression, booleanExpression3);
                    }
                }
                this._$20106[9] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        this._$20106[10] = this._$20107;
        return expression;
    }

    public final Expression EqualExpression() throws ParseException {
        Expression expression;
        if (this._$20125(3)) {
            this._$20104(26);
            Expression expression2 = this.booleanExpression();
            this._$20104(27);
            return expression2;
        }
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                expression = this.additiveExpression();
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 28: 
                    case 29: {
                        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                            case 28: {
                                this._$20104(28);
                                Expression expression3 = this.additiveExpression();
                                BooleanExpression booleanExpression = new BooleanExpression(5, expression, expression3);
                                return new BooleanExpression(0, booleanExpression);
                            }
                            case 29: {
                                this._$20104(29);
                                Expression expression4 = this.additiveExpression();
                                BooleanExpression booleanExpression = new BooleanExpression(5, expression, expression4);
                                return booleanExpression;
                            }
                        }
                        this._$20106[11] = this._$20107;
                        this._$20104(-1);
                        throw new ParseException();
                    }
                }
                this._$20106[12] = this._$20107;
                break;
            }
            default: {
                this._$20106[13] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression oidStringConcatExpression() throws ParseException {
        Expression expression = this.oidStringExpression();
        block3: while (true) {
            switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                case 30: {
                    break;
                }
                default: {
                    this._$20106[14] = this._$20107;
                    break block3;
                }
            }
            this._$20104(30);
            Expression expression2 = this.oidStringExpression();
            expression = new Concatenation(expression, new Concatenation(new StringConstant("."), expression2));
        }
        return expression;
    }

    public final Expression additiveExpression() throws ParseException {
        Expression expression;
        block8: {
            expression = this.multiplicativeExpression();
            block7: while (true) {
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 30: 
                    case 31: {
                        break;
                    }
                    default: {
                        this._$20106[15] = this._$20107;
                        break block8;
                    }
                }
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 30: {
                        this._$20104(30);
                        Expression expression2 = this.multiplicativeExpression();
                        expression = new Add(expression, expression2);
                        continue block7;
                    }
                    case 31: {
                        this._$20104(31);
                        Expression expression2 = this.multiplicativeExpression();
                        expression = new Subtract(expression, expression2);
                        continue block7;
                    }
                }
                break;
            }
            this._$20106[16] = this._$20107;
            this._$20104(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression multiplicativeExpression() throws ParseException {
        Expression expression = this.divisionExpression();
        block3: while (true) {
            switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                case 32: {
                    break;
                }
                default: {
                    this._$20106[17] = this._$20107;
                    break block3;
                }
            }
            this._$20104(32);
            Expression expression2 = this.divisionExpression();
            expression = new Multiply(expression, expression2);
        }
        return expression;
    }

    public final Expression divisionExpression() throws ParseException {
        Expression expression = this.modulusExpression();
        block3: while (true) {
            switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                case 33: {
                    break;
                }
                default: {
                    this._$20106[18] = this._$20107;
                    break block3;
                }
            }
            this._$20104(33);
            Expression expression2 = this.modulusExpression();
            expression = new Divide(expression, expression2);
        }
        return expression;
    }

    public final Expression modulusExpression() throws ParseException {
        Expression expression = this.unaryExpression();
        block3: while (true) {
            switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                case 34: {
                    break;
                }
                default: {
                    this._$20106[19] = this._$20107;
                    break block3;
                }
            }
            this._$20104(34);
            Expression expression2 = this.unaryExpression();
            expression = new Remainder(expression, expression2);
        }
        return expression;
    }

    public final Expression unaryExpression() throws ParseException {
        Expression expression;
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 30: {
                this._$20104(30);
                expression = this.unaryExpression();
                break;
            }
            case 31: {
                this._$20104(31);
                expression = this.unaryExpression();
                expression = new Multiply((Number)new Integer(-1), expression);
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: {
                expression = this.powerExpression();
                break;
            }
            default: {
                this._$20106[20] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression powerExpression() throws ParseException {
        Expression expression = this.unaryExpressionNotPlusMinus();
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 35: {
                this._$20104(35);
                Expression expression2 = this.unaryExpression();
                return new Power(expression, expression2);
            }
        }
        this._$20106[21] = this._$20107;
        return expression;
    }

    public final Expression unaryExpressionNotPlusMinus() throws ParseException {
        Expression expression;
        String string = null;
        String string2 = null;
        String string3 = null;
        block2 : switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 2: 
            case 4: {
                expression = this.anyConstant();
                break;
            }
            case 16: {
                expression = this.anyReference();
                break;
            }
            case 26: {
                this._$20104(26);
                expression = this.arithmeticExpression();
                this._$20104(27);
                break;
            }
            case 12: {
                this._$20104(12);
                this._$20104(26);
                String string4 = this.oidConstant();
                block11 : switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 36: {
                        this._$20104(36);
                        string = this.oidConstant();
                        this._$20104(36);
                        string2 = this.stringConstant();
                        if (!Regex.isRegex(string2)) {
                            throw new ParseException(this.token, "Illegal regular expression: " + string2);
                        }
                        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                            case 36: {
                                this._$20104(36);
                                string3 = this.stringConstant();
                                break block11;
                            }
                        }
                        this._$20106[22] = this._$20107;
                        break;
                    }
                    default: {
                        this._$20106[23] = this._$20107;
                    }
                }
                this._$20104(27);
                try {
                    return new SumWhen(this.rep, this.targetInformation, string4, false, string, string2, string3);
                }
                catch (Exception exception) {
                    throw new ParseException(this.token, "Illegal regular expression: " + string2);
                }
            }
            case 13: {
                this._$20104(13);
                this._$20104(26);
                String string5 = this.oidConstant();
                block17 : switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 36: {
                        this._$20104(36);
                        string = this.oidConstant();
                        this._$20104(36);
                        string2 = this.stringConstant();
                        if (!Regex.isRegex(string2)) {
                            throw new ParseException(this.token, "Illegal regular expression: " + string2);
                        }
                        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                            case 36: {
                                this._$20104(36);
                                string3 = this.stringConstant();
                                break block17;
                            }
                        }
                        this._$20106[24] = this._$20107;
                        break;
                    }
                    default: {
                        this._$20106[25] = this._$20107;
                    }
                }
                this._$20104(27);
                try {
                    return new SumWhen(this.rep, this.targetInformation, string5, true, string, string2, string3);
                }
                catch (Exception exception) {
                    throw new ParseException(this.token, "Illegal regular expression: " + string2);
                }
            }
            case 11: {
                this._$20104(11);
                this._$20104(26);
                Expression expression2 = this.booleanExpression();
                this._$20104(36);
                Expression expression3 = this.arithmeticExpression();
                this._$20104(36);
                Expression expression4 = this.arithmeticExpression();
                this._$20104(27);
                return new ConditionalExpression((BooleanExpression)expression2, expression3, expression4);
            }
            case 15: {
                String string6 = this.functionID();
                this._$20104(26);
                switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 27: {
                        this._$20104(27);
                        if (string6.equalsIgnoreCase(INTERVAL)) {
                            expression = new MathScalar(this.interval);
                            break block2;
                        }
                        throw new ParseException(this.token, "Unknown function: " + string6);
                    }
                    case 2: 
                    case 4: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 26: 
                    case 30: 
                    case 31: {
                        Expression expression5 = this.arithmeticExpression();
                        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                            case 36: {
                                this._$20104(36);
                                Expression expression6 = this.arithmeticExpression();
                                this._$20104(27);
                                if (string6.equalsIgnoreCase(SUM)) {
                                    expression = new Sum(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(AVERAGE)) {
                                    expression = new Average(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(COUNT)) {
                                    expression = new Count(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(GEOMETRICMEAN)) {
                                    expression = new GeometricMean(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MEDIAN)) {
                                    expression = new Median(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MAX)) {
                                    expression = new Max(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MIN)) {
                                    expression = new Min(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(POWER)) {
                                    expression = new Power(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(PRODUCT)) {
                                    expression = new Product(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(REMAINDER)) {
                                    expression = new Remainder(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SORT)) {
                                    expression = new Sort(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(STDDEVIATION)) {
                                    expression = new StdDeviation(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SUM)) {
                                    expression = new Sum(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA)) {
                                    expression = new Delta(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA32)) {
                                    expression = new Delta(expression5, expression6, new MathScalar(4.294967295E9));
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA64)) {
                                    expression = new Delta(expression5, expression6, new MathScalar(1.8446744073709552E19));
                                    break block2;
                                }
                                throw new ParseException(this.token, "Unknown function: " + string6);
                            }
                            case 27: {
                                this._$20104(27);
                                if (string6.equalsIgnoreCase(ABS)) {
                                    expression = new Abs(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(AVERAGE)) {
                                    expression = new Average(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(CEILING)) {
                                    expression = new Ceiling(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(COUNT)) {
                                    expression = new Count(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(FLOOR)) {
                                    expression = new Floor(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MAX)) {
                                    expression = new Max(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MEDIAN)) {
                                    expression = new Median(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MIN)) {
                                    expression = new Min(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(PRODUCT)) {
                                    expression = new Product(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(ROOT)) {
                                    expression = new Root(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SORT)) {
                                    expression = new Sort(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SUM)) {
                                    expression = new Sum(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(ROUND)) {
                                    expression = new Round(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(STDDEVIATION)) {
                                    expression = new StdDeviation(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(GEOMETRICMEAN)) {
                                    expression = new GeometricMean(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(TRUNC)) {
                                    expression = new Trunc(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA32)) {
                                    expression = new Delta(expression5, (Expression)new MathScalar(4.294967295E9));
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA64)) {
                                    expression = new Delta(expression5, (Expression)new MathScalar(1.8446744073709552E19));
                                    break block2;
                                }
                                throw new ParseException(this.token, "Unknown function: " + string6);
                            }
                        }
                        this._$20106[26] = this._$20107;
                        this._$20104(-1);
                        throw new ParseException();
                    }
                }
                this._$20106[27] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
            default: {
                this._$20106[28] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final String functionID() throws ParseException {
        Token token = this._$20104(15);
        return token.image;
    }

    public final String reference() throws ParseException {
        Token token = this._$20104(16);
        return token.image;
    }

    public final Expression anyReference() throws ParseException {
        Expression expression;
        if (this._$20179(2)) {
            String string = this.reference();
            this._$20104(37);
            String string2 = this.reference();
            Point point = this.getLocation(this.currentRow, string);
            Point point2 = this.getLocation(this.currentRow, string2);
            expression = this.tableModel == null || this.tableModel.getNumRows() == 0 ? new MathScalar(Double.valueOf("0.0")) : new ArithmeticExpressionList(this.tableModel, new MathScalar(point.y), new MathScalar(point2.y), new MathScalar(point.x), new MathScalar(point2.x));
        } else {
            switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                case 16: {
                    String string = this.reference();
                    Point point = this.getLocation(this.currentRow, string);
                    if (this.tableModel == null || this.tableModel.getNumRows() == 0) {
                        expression = new MathScalar(Double.valueOf("0.0"));
                        break;
                    }
                    expression = new ExtTableReference(this.tableModel, point);
                    break;
                }
                default: {
                    this._$20106[29] = this._$20107;
                    this._$20104(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final Expression anyConstant() throws ParseException {
        Double d = this.realConstant();
        return new MathScalar(d);
    }

    public final Double realConstant() throws ParseException {
        Token token;
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 2: {
                token = this._$20104(2);
                break;
            }
            case 4: {
                token = this._$20104(4);
                break;
            }
            default: {
                this._$20106[30] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        try {
            return new Double(token.image);
        }
        catch (Exception exception) {
            throw new ParseException(this.token, "Can't parse \"" + token.image + "\"");
        }
    }

    public final Long integerConstant() throws ParseException {
        Token token = this._$20104(2);
        try {
            return new Long(token.image);
        }
        catch (Exception exception) {
            throw new ParseException(this.token, "\"" + token.image + "\" is not an integer");
        }
    }

    public final String stringConstant() throws ParseException {
        Token token;
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 8: {
                token = this._$20104(8);
                break;
            }
            case 6: {
                token = this._$20104(6);
                break;
            }
            case 7: {
                token = this._$20104(7);
                break;
            }
            default: {
                this._$20106[31] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        return token.image.substring(1, token.image.length() - 1);
    }

    public final String oidConstant() throws ParseException {
        Token token;
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 6: {
                token = this._$20104(6);
                break;
            }
            case 7: {
                token = this._$20104(7);
                break;
            }
            default: {
                this._$20106[32] = this._$20107;
                this._$20104(-1);
                throw new ParseException();
            }
        }
        return token.image.substring(1, token.image.length() - 1);
    }

    public final Expression formatExpression() throws ParseException {
        Long l = null;
        this._$20104(14);
        this._$20104(26);
        Expression expression = this.arithmeticExpression();
        this._$20104(36);
        String string = this.stringConstant();
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 36: {
                this._$20104(36);
                l = this.integerConstant();
                break;
            }
            default: {
                this._$20106[33] = this._$20107;
            }
        }
        this._$20104(27);
        if (l != null) {
            return new NumberFormatExpression(expression, string, l.intValue());
        }
        return new NumberFormatExpression(expression, string);
    }

    public final Expression valueExpression() throws ParseException {
        this._$20104(9);
        this._$20104(26);
        String string = this.oidConstant();
        this._$20104(27);
        return new ValueOf(this.rep, this.targetInformation, string, false);
    }

    public final Expression oidStringExpression() throws ParseException {
        Token token = null;
        String string = null;
        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
            case 6: 
            case 7: {
                String string2 = this.oidConstant();
                return new OidConstant(this.rep, string2);
            }
            case 9: {
                this._$20104(9);
                this._$20104(26);
                String string3 = this.oidConstant();
                this._$20104(27);
                return new ValueOf(this.rep, this.targetInformation, string3);
            }
            case 10: {
                this._$20104(10);
                this._$20104(26);
                String string4 = this.oidConstant();
                this._$20104(36);
                String string5 = this.stringConstant();
                block6 : switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                    case 36: {
                        this._$20104(36);
                        token = this._$20104(2);
                        if (!Regex.isRegex(string5)) {
                            throw new ParseException(this.token, "Illegal regular expression: " + string5);
                        }
                        switch (this._$20094 == -1 ? this._$20094() : this._$20094) {
                            case 36: {
                                this._$20104(36);
                                string = this.stringConstant();
                                break block6;
                            }
                        }
                        this._$20106[34] = this._$20107;
                        break;
                    }
                    default: {
                        this._$20106[35] = this._$20107;
                    }
                }
                this._$20104(27);
                try {
                    if (token == null) {
                        return new ValueOf(this.rep, this.targetInformation, string4, string5);
                    }
                    int n = Integer.parseInt(token.image);
                    if (n < 1) {
                        throw new ParseException(this.token, "Occurance parameter must be > 0!");
                    }
                    return new ValueOf(this.rep, this.targetInformation, string4, string5, true, n, string);
                }
                catch (Exception exception) {
                    throw new ParseException(this.token, "Illegal regular expression: " + string5);
                }
            }
        }
        this._$20106[36] = this._$20107;
        this._$20104(-1);
        throw new ParseException();
    }

    private final boolean _$20125(int n) {
        this._$20191 = n;
        this._$20192 = this._$20193 = this.token;
        boolean bl = !this._$20195();
        this._$20196(0, n);
        return bl;
    }

    private final boolean _$20179(int n) {
        this._$20191 = n;
        this._$20192 = this._$20193 = this.token;
        boolean bl = !this._$20197();
        this._$20196(1, n);
        return bl;
    }

    private final boolean _$20198() {
        if (this._$20199()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        Token token = this._$20193;
        if (this._$20201()) {
            this._$20193 = token;
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20202() {
        Token token = this._$20193;
        if (this._$20203()) {
            this._$20193 = token;
            if (this._$20204()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20203() {
        if (this._$20205(30)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20206() {
        Token token;
        block3: {
            if (this._$20207()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
            do {
                token = this._$20193;
                if (this._$20202()) break block3;
            } while (this._$20191 != 0 || this._$20193 != this._$20192);
            return false;
        }
        this._$20193 = token;
        return false;
    }

    private final boolean _$20208() {
        if (this._$20209()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20210() {
        if (this._$20211()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20212() {
        if (this._$20205(31)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20213()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20214() {
        if (this._$20205(23)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20215() {
        if (this._$20205(30)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20213()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20213() {
        Token token = this._$20193;
        if (this._$20215()) {
            this._$20193 = token;
            if (this._$20212()) {
                this._$20193 = token;
                if (this._$20210()) {
                    return true;
                }
                if (this._$20191 == 0 && this._$20193 == this._$20192) {
                    return false;
                }
            } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20216() {
        if (this._$20217()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20205(26)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20218() {
        if (this._$20205(22)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20219() {
        Token token = this._$20193;
        if (this._$20218()) {
            this._$20193 = token;
            if (this._$20214()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20220() {
        if (this._$20205(11)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20205(26)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20221() {
        if (this._$20198()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        Token token = this._$20193;
        if (this._$20219()) {
            this._$20193 = token;
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20222() {
        if (this._$20223()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20224() {
        if (this._$20205(34)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20225() {
        Token token;
        block3: {
            if (this._$20213()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
            do {
                token = this._$20193;
                if (this._$20224()) break block3;
            } while (this._$20191 != 0 || this._$20193 != this._$20192);
            return false;
        }
        this._$20193 = token;
        return false;
    }

    private final boolean _$20226() {
        if (this._$20205(13)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20205(26)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20227() {
        if (this._$20205(29)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20228() {
        if (this._$20205(21)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20221()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20229() {
        if (this._$20221()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20230() {
        Token token = this._$20193;
        if (this._$20229()) {
            this._$20193 = token;
            if (this._$20228()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20231() {
        Token token = this._$20193;
        if (this._$20232()) {
            this._$20193 = token;
            if (this._$20227()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20232() {
        if (this._$20205(28)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20197() {
        if (this._$20223()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20205(37)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20233() {
        Token token = this._$20193;
        if (this._$20197()) {
            this._$20193 = token;
            if (this._$20222()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20234() {
        if (this._$20205(33)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20235() {
        if (this._$20206()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        Token token = this._$20193;
        if (this._$20231()) {
            this._$20193 = token;
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20195() {
        if (this._$20205(26)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20236()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20205(27)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20237() {
        Token token;
        block3: {
            if (this._$20225()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
            do {
                token = this._$20193;
                if (this._$20234()) break block3;
            } while (this._$20191 != 0 || this._$20193 != this._$20192);
            return false;
        }
        this._$20193 = token;
        return false;
    }

    private final boolean _$20238() {
        if (this._$20205(12)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20205(26)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20239() {
        if (this._$20205(20)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20199() {
        Token token = this._$20193;
        if (this._$20195()) {
            this._$20193 = token;
            if (this._$20235()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20240() {
        if (this._$20205(26)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        if (this._$20241()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20223() {
        if (this._$20205(16)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20242() {
        if (this._$20233()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20243() {
        if (this._$20205(19)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20244() {
        Token token = this._$20193;
        if (this._$20243()) {
            this._$20193 = token;
            if (this._$20239()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20245() {
        if (this._$20208()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20246() {
        Token token = this._$20193;
        if (this._$20245()) {
            this._$20193 = token;
            if (this._$20242()) {
                this._$20193 = token;
                if (this._$20240()) {
                    this._$20193 = token;
                    if (this._$20238()) {
                        this._$20193 = token;
                        if (this._$20226()) {
                            this._$20193 = token;
                            if (this._$20220()) {
                                this._$20193 = token;
                                if (this._$20216()) {
                                    return true;
                                }
                                if (this._$20191 == 0 && this._$20193 == this._$20192) {
                                    return false;
                                }
                            } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
                                return false;
                            }
                        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
                            return false;
                        }
                    } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
                        return false;
                    }
                } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
                    return false;
                }
            } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20236() {
        Token token;
        block3: {
            if (this._$20230()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
            do {
                token = this._$20193;
                if (this._$20244()) break block3;
            } while (this._$20191 != 0 || this._$20193 != this._$20192);
            return false;
        }
        this._$20193 = token;
        return false;
    }

    private final boolean _$20247() {
        if (this._$20205(32)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20217() {
        if (this._$20205(15)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20207() {
        Token token;
        block3: {
            if (this._$20237()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
            do {
                token = this._$20193;
                if (this._$20247()) break block3;
            } while (this._$20191 != 0 || this._$20193 != this._$20192);
            return false;
        }
        this._$20193 = token;
        return false;
    }

    private final boolean _$20248() {
        if (this._$20205(25)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20241() {
        if (this._$20206()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20201() {
        Token token = this._$20193;
        if (this._$20249()) {
            this._$20193 = token;
            if (this._$20248()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20249() {
        if (this._$20205(24)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20250() {
        if (this._$20205(35)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20204() {
        if (this._$20205(31)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20251() {
        if (this._$20205(4)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20211() {
        if (this._$20246()) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        Token token = this._$20193;
        if (this._$20250()) {
            this._$20193 = token;
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20252() {
        if (this._$20205(2)) {
            return true;
        }
        if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    private final boolean _$20209() {
        Token token = this._$20193;
        if (this._$20252()) {
            this._$20193 = token;
            if (this._$20251()) {
                return true;
            }
            if (this._$20191 == 0 && this._$20193 == this._$20192) {
                return false;
            }
        } else if (this._$20191 == 0 && this._$20193 == this._$20192) {
            return false;
        }
        return false;
    }

    public FormulaParser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new SimpleCharStream(inputStream, 1, 1);
        this.token_source = new FormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this._$20094 = -1;
        this._$20107 = 0;
        for (n = 0; n < 37; ++n) {
            this._$20106[n] = -1;
        }
        for (n = 0; n < this._$20261.length; ++n) {
            this._$20261[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this._$20094 = -1;
        this._$20107 = 0;
        for (n = 0; n < 37; ++n) {
            this._$20106[n] = -1;
        }
        for (n = 0; n < this._$20261.length; ++n) {
            this._$20261[n] = new JJCalls();
        }
    }

    public FormulaParser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new FormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this._$20094 = -1;
        this._$20107 = 0;
        for (n = 0; n < 37; ++n) {
            this._$20106[n] = -1;
        }
        for (n = 0; n < this._$20261.length; ++n) {
            this._$20261[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this._$20094 = -1;
        this._$20107 = 0;
        for (n = 0; n < 37; ++n) {
            this._$20106[n] = -1;
        }
        for (n = 0; n < this._$20261.length; ++n) {
            this._$20261[n] = new JJCalls();
        }
    }

    public FormulaParser(FormulaParserTokenManager formulaParserTokenManager) {
        int n;
        this.token_source = formulaParserTokenManager;
        this.token = new Token();
        this._$20094 = -1;
        this._$20107 = 0;
        for (n = 0; n < 37; ++n) {
            this._$20106[n] = -1;
        }
        for (n = 0; n < this._$20261.length; ++n) {
            this._$20261[n] = new JJCalls();
        }
    }

    public void ReInit(FormulaParserTokenManager formulaParserTokenManager) {
        int n;
        this.token_source = formulaParserTokenManager;
        this.token = new Token();
        this._$20094 = -1;
        this._$20107 = 0;
        for (n = 0; n < 37; ++n) {
            this._$20106[n] = -1;
        }
        for (n = 0; n < this._$20261.length; ++n) {
            this._$20261[n] = new JJCalls();
        }
    }

    private final Token _$20104(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this._$20094 = -1;
        if (this.token.kind == n) {
            ++this._$20107;
            if (++this._$20263 > 100) {
                this._$20263 = 0;
                for (int i = 0; i < this._$20261.length; ++i) {
                    JJCalls jJCalls = this._$20261[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this._$20107) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this._$20267 = n;
        throw this.generateParseException();
    }

    private final boolean _$20205(int n) {
        if (this._$20193 == this._$20192) {
            --this._$20191;
            if (this._$20193.next == null) {
                this._$20193 = this._$20193.next = this.token_source.getNextToken();
                this._$20192 = this._$20193.next;
            } else {
                this._$20192 = this._$20193 = this._$20193.next;
            }
        } else {
            this._$20193 = this._$20193.next;
        }
        if (this._$20262) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this._$20193) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this._$20270(n, n2);
            }
        }
        return this._$20193.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this._$20094 = -1;
        ++this._$20107;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this._$20193 : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int _$20094() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this._$20094 = this.token.next.kind;
            return this._$20094;
        }
        this._$20094 = this.jj_nt.kind;
        return this._$20094;
    }

    private void _$20270(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this._$20276 + 1) {
            this._$20275[this._$20276++] = n;
        } else if (this._$20276 != 0) {
            int n3;
            this._$20274 = new int[this._$20276];
            for (n3 = 0; n3 < this._$20276; ++n3) {
                this._$20274[n3] = this._$20275[n3];
            }
            n3 = 0;
            Enumeration enumeration = this._$20273.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this._$20274.length) continue;
                n3 = 1;
                for (int i = 0; i < this._$20274.length; ++i) {
                    if (nArray[i] == this._$20274[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this._$20273.addElement(this._$20274);
            }
            if (n2 != 0) {
                this._$20276 = n2;
                this._$20275[this._$20276 - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this._$20273.removeAllElements();
        boolean[] blArray = new boolean[38];
        for (n2 = 0; n2 < 38; ++n2) {
            blArray[n2] = false;
        }
        if (this._$20267 >= 0) {
            blArray[this._$20267] = true;
            this._$20267 = -1;
        }
        for (n2 = 0; n2 < 37; ++n2) {
            if (this._$20106[n2] != this._$20107) continue;
            for (n = 0; n < 32; ++n) {
                if ((this._$20258[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((this._$20259[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 38; ++n2) {
            if (!blArray[n2]) continue;
            this._$20274 = new int[1];
            this._$20274[0] = n2;
            this._$20273.addElement(this._$20274);
        }
        this._$20276 = 0;
        this._$20279();
        this._$20270(0, 0);
        int[][] nArrayArray = new int[this._$20273.size()][];
        for (n = 0; n < this._$20273.size(); ++n) {
            nArrayArray[n] = (int[])this._$20273.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void _$20279() {
        this._$20262 = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls jJCalls = this._$20261[i];
            do {
                if (jJCalls.gen <= this._$20107) continue;
                this._$20191 = jJCalls.arg;
                this._$20192 = this._$20193 = jJCalls.first;
                switch (i) {
                    case 0: {
                        this._$20195();
                        break;
                    }
                    case 1: {
                        this._$20197();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this._$20262 = false;
    }

    private final void _$20196(int n, int n2) {
        JJCalls jJCalls = this._$20261[n];
        while (jJCalls.gen > this._$20107) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this._$20107 + n2 - this._$20191;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

