/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.Regex;
import com.agentpp.util.ThreadPool;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SearchMIBRepository
extends JPanel
implements Runnable,
JCCellDisplayListener {
    private static final String[] _$22066 = new String[]{"MIB Module", "Object Name", "OID", "Type"};
    private static final int _$23090 = 2;
    private static final int _$22067 = 1;
    private static final int _$23091 = 0;
    private SearchConfig _$23092;
    private Regex _$16960;
    private String _$23093 = null;
    private JFrame _$11194;
    private RepositoryManager _$23094;
    private BorderLayout _$6329 = new BorderLayout();
    private JPanel _$23095 = new JPanel();
    private JPanel _$23096 = new JPanel();
    private JProgressBar _$23097 = new JProgressBar();
    private JLabel _$23098 = new JLabel();
    private GridBagLayout _$6184 = new GridBagLayout();
    private ExtendedListTable _$6180 = new ExtendedListTable();
    private BorderLayout _$7676 = new BorderLayout();
    private JCVectorDataSource _$6203 = new JCVectorDataSource();
    public volatile boolean cancel = false;
    private JLabel _$17384 = new JLabel();
    private JLabel _$10979 = new JLabel();
    private int _$6152 = 0;
    private JLabel _$23099 = new JLabel();
    private JLabel _$21140 = new JLabel();
    private Runnable _$23100;

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel) {
        this(frame, repMan, searchExpression, searchPanel, null);
    }

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel, String moduleScope) {
        this._$11194 = frame;
        this._$23094 = repMan;
        this._$23092 = searchPanel;
        this._$16960 = searchExpression;
        this._$23093 = moduleScope;
        this._$6203.setNumColumns(_$22066.length);
        this._$6203.setColumnLabels(_$22066);
        this._$6203.setNumRows(10);
        this._$6180.setDataSource(this._$6203);
        this._$6180.setPopupMenuEnabled(false);
        this._$6180.setCharWidth(-1, 5);
        this._$6180.setTraverseCycle(false);
        this._$6180.addCellDisplayListener(this);
        try {
            this._$6186();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFinishCallback(Runnable finishCallback) {
        this._$23100 = finishCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadPool threadPool = ThreadPool.create("SearchMIBRepository", Runtime.getRuntime().availableProcessors());
        this._$6152 = 0;
        this._$6203.setNumRows(0);
        Object[] modules = null;
        try {
            modules = this._$23094.getModuleNames();
        }
        catch (IOException ex) {
            this._$10979.setText("Failed to access MIB repository: " + ex.getMessage());
            return;
        }
        this._$23097.setMaximum(0);
        this._$23097.setMaximum(modules.length - 1);
        this._$23097.setStringPainted(true);
        Arrays.sort(modules);
        for (int i = 0; i < modules.length && !this.cancel; ++i) {
            this._$10979.setText((String)modules[i]);
            this._$23097.setValue(i);
            Object moduleName = modules[i];
            threadPool.execute(new Runnable((String)moduleName){
                final /* synthetic */ String val$moduleName;
                {
                    this.val$moduleName = string;
                }

                public void run() {
                    try {
                        MIBObject[] objects = SearchMIBRepository.this._$23094.getObjects(this.val$moduleName);
                        MIBRepository rep = new MIBRepository(objects);
                        objects = SearchMIBRepository.this._$23094.getImportedObjects(this.val$moduleName);
                        rep.addAllObjects(objects);
                        SearchMIBRepository.this._$23103(this.val$moduleName, rep);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            });
        }
        while (!threadPool.isIdle()) {
            try {
                ThreadPool i = threadPool;
                synchronized (i) {
                    threadPool.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        threadPool.stop();
        this._$10979.setText("Search complete!");
        if (this._$23100 != null) {
            SwingUtilities.invokeLater(this._$23100);
        }
    }

    public TreeMap getSelectedObjects() {
        int[] rows = TableUtils.getSelectedRows(this._$6180);
        TreeMap<Object, Object> h = new TreeMap<Object, Object>();
        for (int i = 0; i < rows.length; ++i) {
            h.put(this._$6203.getTableDataItem(rows[i], 1), this._$6203.getTableDataItem(rows[i], 0));
        }
        return h;
    }

    private synchronized boolean _$23104(MIBRepository rep, Regex expression, MIBObject o, boolean[] flags) {
        MIBModule module;
        if (flags[0] && (module = rep.getModule(o.getModuleID())) != null && expression.match(o.toSMI(1, module.getSMIVersion(), rep, "\n"))) {
            return true;
        }
        if ((flags[0] || flags[2]) && o.getName() != null && expression.match(o.getName())) {
            return true;
        }
        if ((flags[0] || flags[1]) && o.getOid() != null && expression.match(o.getOid().toString())) {
            return true;
        }
        if ((flags[0] || flags[3]) && o.getDescription() != null && expression.match(o.getDescription())) {
            return true;
        }
        if (flags[0] || flags.length > 4 && flags[4]) {
            List refs = this._$23108(rep, o);
            for (String ref : refs) {
                if (!expression.match(ref)) continue;
                return true;
            }
        }
        return false;
    }

    private List _$23108(MIBRepository rep, MIBObject o) {
        LinkedList<String> refs;
        block10: {
            MIBAgentCaps ac;
            block11: {
                block9: {
                    refs = new LinkedList<String>();
                    if (!(o instanceof MIBModule)) break block9;
                    MIBModule m = (MIBModule)o;
                    if (!m.hasImports()) break block10;
                    for (int i = 0; i < m.getImportsVector().size(); ++i) {
                        MIBImport imp = (MIBImport)m.getImportsVector().get(i);
                        if (this._$23093 != null && !imp.getSource().equals(this._$23093)) continue;
                        refs.addAll(imp.getImportsVector());
                    }
                    break block10;
                }
                if (!(o instanceof MIBCompliance)) break block11;
                MIBCompliance c = (MIBCompliance)o;
                if (c.getModules() == null) break block10;
                for (MIBComplianceModule cm : c.getModules()) {
                    String moduleName = cm.getModuleName();
                    if (!cm.hasModuleName()) {
                        moduleName = rep.getModuleName(o.getModuleID());
                    }
                    if (this._$23093 != null && !moduleName.equals(this._$23093)) continue;
                    if (cm.hasMandatory()) {
                        refs.addAll(cm.getMandatoryVector());
                    }
                    if (!cm.hasVariations()) continue;
                    for (MIBVariation var : cm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
                break block10;
            }
            if (o instanceof MIBAgentCaps && (ac = (MIBAgentCaps)o).getModules() != null) {
                for (MIBSupportedModule sm : ac.getModules()) {
                    String moduleName = sm.getSupports();
                    if (sm.getSupports() == null) {
                        moduleName = rep.getModuleName(o.getModuleID());
                    }
                    if (this._$23093 != null && !moduleName.equals(this._$23093) || !sm.hasVariations()) continue;
                    for (MIBVariation var : sm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
            }
        }
        return refs;
    }

    private void _$23103(String moduleName, MIBRepository rep) {
        Integer moduleID = null;
        if (rep.getModule(moduleName) != null) {
            moduleID = rep.getModule(moduleName).getModuleID();
        }
        Enumeration en = rep.objectsByName();
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (!o.getModuleID().equals(moduleID) || !this._$23104(rep, this._$16960, o, this._$23092.getSearchOptions())) continue;
            ++this._$6152;
            if (this._$6152 == 1) {
                this._$21140.setText("" + this._$6152 + " match.");
            } else {
                this._$21140.setText("" + this._$6152 + " matches.");
            }
            final Vector<Object> row = new Vector<Object>();
            row.add(moduleName);
            row.add(o);
            row.add(o.getOid());
            row.add(o.getTypeString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchMIBRepository.this._$6203.addRow(Integer.MAX_VALUE, new Integer(SearchMIBRepository.this._$6203.getNumRows() + 1), row);
                }
            });
        }
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this._$23094 = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this._$23094;
    }

    public SearchMIBRepository() {
        try {
            this._$6186();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _$6186() throws Exception {
        this.setLayout(this._$6329);
        this._$23098.setText("Progress:");
        this._$23096.setLayout(this._$6184);
        this._$23097.setStringPainted(true);
        this._$23095.setLayout(this._$7676);
        this._$17384.setText("Searching:");
        this._$23099.setText("Found:");
        this._$21140.setText("0 matches.");
        this.add((Component)this._$23095, "Center");
        this._$23095.add((Component)this._$6180, "Center");
        this.add((Component)this._$23096, "North");
        this._$23096.add((Component)this._$23098, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$23096.add((Component)this._$23097, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this._$23096.add((Component)this._$17384, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this._$23096.add((Component)this._$10979, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this._$23096.add((Component)this._$23099, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._$23096.add((Component)this._$21140, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void cellDisplay(JCCellDisplayEvent e) {
        if (e.getColumn() == 1 && e.getCellData() instanceof MIBObject) {
            MIBObject o = (MIBObject)e.getDisplayData();
            e.setDisplayData(o.getName());
        }
    }
}

