/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.MIBCompiler;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.klg.jclass.datasource.BaseColumn;
import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeData;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ParserLogTree
extends TreeData {
    private static final Object[][] _$15451 = new Object[][]{{"Status", String.class}, {"File", String.class}, {"Errors", Integer.class}, {"Path", String.class}, {"MIB Modules", String.class}};
    private static final Object[][] _$15452 = new Object[][]{{"Number", Integer.class}, {"Error Code", Integer.class}, {"Description", String.class}};
    static final int COL_STATUS = 0;
    static final int COL_FILE = 1;
    static final int COL_ERRORS = 2;
    static final int COL_PATH = 3;
    static final int COL_MODULES = 4;
    private BaseMetaData _$15457;
    private BaseMetaData _$15458;
    private FilesTable _$9392;
    private DataModelListener _$6345;
    private HashMap _$15460 = new HashMap();
    private static final String _$15461 = "OK";

    public ParserLogTree() {
        try {
            this.createMetaData();
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public List getFiles() {
        return (List)this._$9392.getUserData("files");
    }

    protected void createMetaData() throws DataModelException {
        BaseColumn column;
        int i;
        this._$15457 = new BaseMetaData(this);
        this._$15457.setDescription("MIB Files");
        this._$15458 = new BaseMetaData(this);
        this._$15458.setDescription("Compilation Errors");
        ((DataSourceTreeModel)this.getMetaDataTree()).setRoot(this._$15457);
        this._$15457.add(this._$15458);
        this._$15457.setCacheChildren(true);
        for (i = 0; i < _$15451.length; ++i) {
            column = new BaseColumn();
            column.setColumnName((String)_$15451[i][0]);
            column.setColumnClassName(((Class)_$15451[i][1]).getName());
            this._$15457.addColumn(column);
        }
        for (i = 0; i < _$15452.length; ++i) {
            column = new BaseColumn();
            column.setColumnName((String)_$15452[i][0]);
            column.setColumnClassName(((Class)_$15452[i][1]).getName());
            this._$15458.addColumn(column);
        }
        this._$9392 = new FilesTable(this._$15457);
        ((DataSourceTreeModel)this.getDataTableTree()).setRoot(this._$9392);
    }

    BaseMetaData getErrorsListMetaData() {
        return this._$15458;
    }

    public void replaceModules(int fileIndex, Vector modules) {
        Object[] row = (Object[])this.getFiles().get(fileIndex);
        row[4] = modules != null ? MIBRepository.buildStringEnumeration(modules.elements()) : "";
        row[0] = _$15461;
        row[2] = new Integer(0);
        try {
            this.replaceErrors(fileIndex, null);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void replaceErrors(int fileIndex, SMIParseException pex) throws DataModelException {
        Object[] row = (Object[])this.getFiles().get(fileIndex);
        row[2] = new Integer(this._$15470(pex));
        long bookmark = this._$9392.getRowIdentifier(fileIndex);
        Object old = this._$15460.remove(new Long(bookmark));
        for (int i = 0; i < this._$9392.getChildCount(); ++i) {
            BaseDataTable node = (BaseDataTable)this._$9392.getChildAt(i);
            if (node != old) continue;
            node.removeFromParent();
            break;
        }
        if (pex != null) {
            this._$13745(bookmark, (Object[])this.getFiles().get(fileIndex), pex);
        }
    }

    public long add(Object file, SMIParseException pex, Vector modules) throws DataModelException {
        LinkedList<Object[]> files;
        this.enableDataModelEvents(false);
        Object[] row = new Object[_$15451.length];
        int errors = 0;
        if (pex != null) {
            row[0] = "Failed";
            errors = this._$15470(pex);
        } else {
            row[0] = _$15461;
        }
        row[1] = file instanceof MIBCompiler.ZipReference ? ((MIBCompiler.ZipReference)file).entry.getName() : ((File)file).getName();
        row[2] = new Integer(errors);
        row[3] = file;
        row[4] = modules != null ? MIBRepository.buildStringEnumeration(modules.elements()) : "";
        long id = this._$9392.addInternalRow(row);
        if (pex != null) {
            this._$13745(id, row, pex);
        }
        if ((files = this.getFiles()) == null) {
            files = new LinkedList<Object[]>();
            this._$9392.setUserData("files", files);
        }
        files.add(row);
        this.enableDataModelEvents(true);
        return id;
    }

    private int _$15470(SMIParseException pex) {
        if (pex == null) {
            return 0;
        }
        return pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1;
    }

    private DataTableModel _$13745(long id, Object[] parentRow, SMIParseException pex) throws DataModelException {
        ErrorsTable errorsTable = (ErrorsTable)this._$9392.createTable(this._$6345, id, this._$15458);
        this._$15460.put(new Long(id), errorsTable);
        List<SMIParseException> errorList = pex.getErrorList();
        if (errorList == null || errorList.size() == 0) {
            errorList = Arrays.asList(pex);
        }
        for (int i = 0; i < errorList.size(); ++i) {
            SMIParseException ex = errorList.get(i);
            Object[] errRow = new Object[_$15452.length];
            int n = 0;
            errRow[n++] = new Integer(i + 1);
            errRow[n++] = new Integer(ex.errorType);
            errRow[n++] = DefaultRepositoryManager.getErrorText(ex, false).replace('\r', ' ').replace('\n', ' ');
            errorsTable.addInternalRow(errRow);
        }
        errorsTable.setUserData("errors", errorList);
        errorsTable.setUserData("file", parentRow);
        return errorsTable;
    }

    public ErrorsTable getErrorTable(long bookmark) {
        return (ErrorsTable)this._$15460.get(new Long(bookmark));
    }

    protected void refreshFinished() {
        this.enableDataModelEvents(true);
        try {
            super.requeryAll(this._$6345);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void setDataModelListener(DataModelListener dataModelListener) {
        this._$6345 = dataModelListener;
    }

    public BaseDataTable getRoot() {
        return this._$9392;
    }

    public class ErrorsTable
    extends BaseDataTable {
        public ErrorsTable(MetaDataModel model, long parentRow) {
            super(model, parentRow);
        }
    }

    public class FilesTable
    extends BaseDataTable {
        public FilesTable(MetaDataModel model) {
            super(model);
        }

        public DataTableModel materializeTable(DataModelListener listener, long bookmark, TreeNode node) throws DataModelException {
            ErrorsTable newTable = ParserLogTree.this.getErrorTable(bookmark);
            if (newTable != null) {
                return newTable;
            }
            newTable = new ErrorsTable((BaseMetaData)node, bookmark);
            this.add(newTable);
            return newTable;
        }
    }
}

