/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.SshAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.ssh.SshSession;
import org.snmp4j.transport.ssh.SshTransportAdapter;

public class DefaultSshTransportMapping
extends AbstractTransportMapping<SshAddress> {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultSshTransportMapping.class);
    private final Map<SessionID, SshSession> sessions = new HashMap<SessionID, SshSession>();
    private SshTransportAdapter transportAdapter;
    private CounterSupport counterSupport;

    public DefaultSshTransportMapping(SshTransportAdapter transportAdapter) {
        this.transportAdapter = transportAdapter;
        this.counterSupport = CounterSupport.getInstance();
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return SshAddress.class;
    }

    @Override
    public SshAddress getListenAddress() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(SshAddress address, byte[] message, TransportStateReference tmStateReference) throws IOException {
        SessionID sessionKey = new SessionID(tmStateReference.getSecurityName(), address);
        SshSession session = null;
        Map<SessionID, SshSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionKey);
        }
        if (session == null) {
            if (tmStateReference.isSameSecurity()) {
                logger.warn((Serializable)((Object)"Cannot (re)open session because tmStateReference requires 'sameSecurity'"));
                throw new IOException("Session '" + address + "' for '" + tmStateReference.getSecurityName() + "' closed/unavailable");
            }
            session = this.openSession(address, tmStateReference, this.maxInboundMessageSize);
        }
    }

    protected SshSession openSession(SshAddress address, TransportStateReference tmStateReference, int maxMessageSize) {
        this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpSshtmSessionOpens));
        return this.transportAdapter.openClientSession(tmStateReference, maxMessageSize);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void listen() throws IOException {
    }

    @Override
    public boolean isListening() {
        return false;
    }

    protected void fireIncrementCounter(CounterEvent e2) {
        this.counterSupport.fireIncrementCounter(e2);
    }

    protected class SessionID {
        private OctetString tmSecurityName;
        private SshAddress address;

        public SessionID(OctetString tmSecurityName, SshAddress address) {
            this.tmSecurityName = tmSecurityName;
            this.address = address;
        }

        public String toString() {
            return "DefaultSshTransportMapping.SessionID[tmSecurityName=" + this.tmSecurityName + ", address=" + this.address + ']';
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            SessionID sessionID = (SessionID)o2;
            if (this.address != null ? !this.address.equals(sessionID.address) : sessionID.address != null) {
                return false;
            }
            return !(this.tmSecurityName == null ? sessionID.tmSecurityName != null : !this.tmSecurityName.equals(sessionID.tmSecurityName));
        }

        public int hashCode() {
            int result = this.tmSecurityName != null ? this.tmSecurityName.hashCode() : 0;
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            return result;
        }
    }
}

