/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.OctetString;

public class UsmUserTable
implements Serializable {
    private static final long serialVersionUID = 6936547777550957622L;
    private static final LogAdapter logger = LogFactory.getLogger(UsmUserTable.class);
    private Map<UsmUserKey, UsmUserEntry> table = new TreeMap<UsmUserKey, UsmUserEntry>();

    public synchronized UsmUserEntry addUser(UsmUserEntry user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Adding user " + user.getUserName() + " = " + user.getUsmUser())));
        }
        return this.table.put(new UsmUserKey(user), user);
    }

    public synchronized void setUsers(Collection<UsmUserEntry> c2) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Setting users to " + c2)));
        }
        this.table.clear();
        for (UsmUserEntry user : c2) {
            this.table.put(new UsmUserKey(user), user);
        }
    }

    public synchronized List<UsmUserEntry> getUserEntries(OctetString userName) {
        LinkedList<UsmUserEntry> users = new LinkedList<UsmUserEntry>();
        for (UsmUserEntry value : this.table.values()) {
            if (!userName.equals(value.getUserName())) continue;
            users.add(value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Returning user entries for " + userName + " = " + users)));
        }
        return users;
    }

    public synchronized List<UsmUserEntry> getUserEntries() {
        LinkedList<UsmUserEntry> l2 = new LinkedList<UsmUserEntry>();
        for (UsmUserEntry usmUserEntry : this.table.values()) {
            l2.add(usmUserEntry);
        }
        return l2;
    }

    public synchronized List<UsmUserEntry> removeAllUsers(OctetString securityName, OctetString engineID) {
        if (engineID == null) {
            ArrayList<UsmUserEntry> deleted = new ArrayList<UsmUserEntry>();
            Iterator<UsmUserEntry> usmUserEntryIterator = this.table.values().iterator();
            while (usmUserEntryIterator.hasNext()) {
                UsmUserEntry usmUserEntry = usmUserEntryIterator.next();
                if (!securityName.equals(usmUserEntry.getUsmUser().getSecurityName())) continue;
                deleted.add(usmUserEntry);
                usmUserEntryIterator.remove();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Serializable)((Object)("Removed user " + usmUserEntry)));
            }
            return deleted;
        }
        UsmUserEntry entry = this.table.remove(new UsmUserKey(engineID, securityName));
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Removed user with secName=" + securityName + " and engineID=" + engineID)));
        }
        return entry != null ? Collections.singletonList(entry) : Collections.emptyList();
    }

    public synchronized UsmUserEntry removeUser(OctetString engineID, OctetString securityName) {
        UsmUserEntry entry = this.table.remove(new UsmUserKey(engineID, securityName));
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Removed user with secName=" + securityName + " and engineID=" + engineID)));
        }
        return entry;
    }

    public synchronized UsmUserEntry getUser(OctetString engineID, OctetString securityName) {
        return this.table.get(new UsmUserKey(engineID, securityName));
    }

    public synchronized UsmUserEntry getUser(OctetString securityName) {
        return this.table.get(new UsmUserKey(new OctetString(), securityName));
    }

    public synchronized void clear() {
        this.table.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)"Cleared UsmUserTable"));
        }
    }

    public static class UsmUserKey
    implements Comparable {
        OctetString engineID;
        OctetString securityName;

        public UsmUserKey(UsmUserEntry entry) {
            this.setEngineID(entry.getEngineID());
            this.securityName = entry.getUsmUser().getSecurityName();
        }

        public UsmUserKey(OctetString engineID, OctetString securityName) {
            this.setEngineID(engineID);
            this.securityName = securityName;
        }

        private void setEngineID(OctetString engineID) {
            this.engineID = engineID == null ? new OctetString() : engineID;
        }

        public int hashCode() {
            return this.engineID.hashCode() ^ 2 + this.securityName.hashCode();
        }

        public boolean equals(Object o2) {
            if (o2 instanceof UsmUserEntry || o2 instanceof UsmUserKey) {
                return this.compareTo(o2) == 0;
            }
            return false;
        }

        public int compareTo(Object o2) {
            if (o2 instanceof UsmUserEntry) {
                return this.compareTo(new UsmUserKey((UsmUserEntry)o2));
            }
            UsmUserKey other = (UsmUserKey)o2;
            int result = 0;
            if (this.engineID != null && other.engineID != null) {
                result = this.engineID.compareTo(other.engineID);
            } else if (this.engineID != null) {
                result = 1;
            } else if (other.engineID != null) {
                result = -1;
            }
            if (result == 0) {
                result = this.securityName.compareTo(other.securityName);
            }
            return result;
        }
    }
}

