/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.snmp4j.model.snmp.proxy.ChangeSet;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.smi.VariableBinding;

public class SnmpValuesChangeSet
implements ChangeSet<SnmpValueChange> {
    private List<SnmpValueChange> changes = new ArrayList<SnmpValueChange>();
    private ChangeSet.ChangeStatus status;
    private Object userReference;

    public SnmpValuesChangeSet() {
    }

    public SnmpValuesChangeSet(Collection<SnmpValueChange> changes, Object userReference) {
        this();
        this.changes.addAll(changes);
        this.userReference = userReference;
    }

    public void addChange(SnmpValueChange change) {
        this.changes.add(change);
    }

    @Override
    public List<SnmpValueChange> getChanges() {
        return this.changes;
    }

    public List getNewValues() {
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (SnmpValueChange change : this.changes) {
            newValues.add(change.getNewValue());
        }
        return newValues;
    }

    public boolean isVariableSetOk() {
        for (SnmpValueChange change : this.changes) {
            if (change.getVariable() != null) continue;
            return false;
        }
        return true;
    }

    public List<? extends VariableBinding> getVariableBindings() {
        return this.changes;
    }

    @Override
    public ChangeSet.ChangeStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(ChangeSet.ChangeStatus status) {
        this.status = status;
    }

    @Override
    public SnmpErrorStatus getErrorStatus() {
        for (SnmpValueChange change : this.changes) {
            if (change.getErrorStatus() == null) continue;
            return change.getErrorStatus();
        }
        return null;
    }

    public Object getUserReference() {
        return this.userReference;
    }

    public String toString() {
        return "SnmpValuesChangeSet{changes=" + this.changes + ", status=" + (Object)((Object)this.status) + ", userReference=" + this.userReference + '}';
    }
}

