/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.proxy.impl;

import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.Target;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.SnmpSubTreeRO;
import org.snmp4j.model.snmp.proxy.TaskId;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectImpl;
import org.snmp4j.model.snmp.spi.SnmpException;
import org.snmp4j.model.snmp.spi.SnmpProxyReloadListener;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class SnmpSubTreeImplRO<T>
extends SnmpProxyObjectImpl
implements SnmpSubTreeRO<T> {
    private SortedMap<OID, T> values = new TreeMap<OID, T>();
    private Class<T> valueClass;

    public SnmpSubTreeImplRO(OID oid, OctetString context, Class<T> valueClass) {
        super(context, oid);
        this.valueClass = valueClass;
    }

    @Override
    public SortedMap<OID, T> getValues() {
        return this.values;
    }

    @Override
    public OID getOID() {
        return this.oid;
    }

    @Override
    public TaskId reload(SnmpService snmpService, Target target, VariableBindingMapper variableBindingMapper, SnmpProxyReloadListener reloadListener) {
        try {
            List<? extends VariableBinding> vbs = snmpService.get(target, Collections.singletonList(this.getOID()));
            TreeMap<OID, Object> reloaded = new TreeMap<OID, Object>();
            for (VariableBinding variableBinding : vbs) {
                reloaded.put(variableBinding.getOid(), variableBindingMapper.toObject(variableBinding, this.valueClass));
            }
        }
        catch (SnmpException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean waitForTask(TaskId taskId, long timeout) {
        return false;
    }

    @Override
    public String toString() {
        return "SnmpSubTreeImplRO{" + super.toString() + ", valueClass=" + this.valueClass + ", values=" + this.values + "} ";
    }
}

