/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.snmp.api;

import java.util.Arrays;
import org.snmp4j.smi.OctetString;

public class SnmpProxyId
implements Comparable<SnmpProxyId> {
    private String moduleName;
    private String objectName;
    private Object[] indexValues;
    private OctetString contextName;

    public SnmpProxyId(OctetString contextName, String moduleName, String objectName, Object ... indexValues) {
        this.contextName = contextName;
        this.moduleName = moduleName;
        this.objectName = objectName;
        this.indexValues = indexValues;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    public Object[] getIndexValues() {
        return this.indexValues;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SnmpProxyId that = (SnmpProxyId)o2;
        if (this.moduleName != null ? !this.moduleName.equals(that.moduleName) : that.moduleName != null) {
            return false;
        }
        if (!this.objectName.equals(that.objectName)) {
            return false;
        }
        if (!Arrays.equals(this.indexValues, that.indexValues)) {
            return false;
        }
        return this.contextName != null ? this.contextName.equals(that.contextName) : that.contextName == null;
    }

    public int hashCode() {
        int result = this.moduleName != null ? this.moduleName.hashCode() : 0;
        result = 31 * result + this.objectName.hashCode();
        result = 31 * result + Arrays.hashCode(this.indexValues);
        result = 31 * result + (this.contextName != null ? this.contextName.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(SnmpProxyId o2) {
        int c2 = this.objectName.compareTo(o2.getObjectName());
        if (c2 == 0) {
            int n2 = this.getContextName() != null ? this.getContextName().compareTo(o2.getContextName()) : (c2 = o2.getContextName() == null ? 0 : -1);
            if (c2 == 0) {
                int n3 = this.getModuleName() != null ? this.getModuleName().compareTo(o2.getModuleName()) : (c2 = o2.getModuleName() == null ? 0 : -1);
                if (c2 == 0 && this.indexValues != null && o2.indexValues != null && (c2 = this.indexValues.length - o2.indexValues.length) == 0) {
                    for (int i2 = 0; c2 == 0 && i2 < this.indexValues.length; ++i2) {
                        c2 = ((Comparable)this.indexValues[i2]).compareTo(o2.indexValues[i2]);
                    }
                }
            }
        }
        return c2;
    }
}

