/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.model.demo.mibbrowser;

import com.snmp4j.smi.SmiManager;
import com.snmp4j.smi.SmiObjectType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.snmp4j.Target;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.SnmpTable;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectHelper;
import org.snmp4j.model.snmp.spi.SnmpService;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public abstract class SimpleMibTableBrowser {
    private SnmpService snmpService;
    private SmiManager smiManager;
    private Target target;
    private VariableBindingMapper variableBindingMapper;
    SnmpTable table;
    private JTable snmpTable;
    private TableColumnModel columnModel;
    private JButton refreshButton;
    private JButton saveButton;
    private JButton closeButton;
    private JPanel rootPanel;
    private JButton addButton;

    public SimpleMibTableBrowser(final SnmpTable table, TableColumnModel columnModel, final SnmpService snmpService, final SmiManager smiManager, final Target target, final VariableBindingMapper variableBindingMapper) {
        this.table = table;
        this.smiManager = smiManager;
        this.columnModel = columnModel;
        this.snmpService = snmpService;
        this.target = target;
        this.variableBindingMapper = variableBindingMapper;
        this.$$$setupUI$$$();
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.reload(snmpService, target, variableBindingMapper, null);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SimpleMibTableBrowser.this.close();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.getCommitter().commitChanges(table);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String indexString = JOptionPane.showInputDialog(this, (Object)"Row index value:");
                if (indexString != null) {
                    SnmpColumn firstColumn = (SnmpColumn)table.getColumns().get(0);
                    OID indexOID = new OID(firstColumn.getOID() + "." + indexString);
                    indexOID = new OID(indexOID.getValue(), firstColumn.getOID().size(), indexOID.size() - firstColumn.getOID().size());
                    List<VariableBinding> indexVBs = table.getIndexVariableBindings(indexOID);
                    ArrayList<VariableBinding> initialVBs = new ArrayList<VariableBinding>();
                    for (SnmpColumn snmpColumn : table.getColumns()) {
                        OID cellOID = new OID(snmpColumn.getOID().getValue(), indexOID.getValue());
                        SmiObjectType objectType = (SmiObjectType)smiManager.findSmiObject(snmpColumn.getOID());
                        VariableBinding vb = new VariableBinding(cellOID, objectType.createNewVariable());
                        initialVBs.add(vb);
                    }
                    Object newRow = table.getRowFactory().createProxyRow(indexOID, SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, indexVBs, table.getIndexColumns()), SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, initialVBs, table.getColumns()));
                    table.insertRow(newRow);
                }
            }
        });
    }

    public abstract void close();

    private void createUIComponents() {
        this.snmpTable = new JTable(this.table, this.columnModel);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new GridBagLayout());
        JPanel spacer1 = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.rootPanel.add((Component)spacer1, gbc);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(2, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        this.rootPanel.add((Component)panel1, gbc);
        this.refreshButton = new JButton();
        this.refreshButton.setText("Refresh");
        panel1.add(this.refreshButton);
        this.addButton = new JButton();
        this.addButton.setText("Add Row");
        panel1.add(this.addButton);
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        panel1.add(this.saveButton);
        this.closeButton = new JButton();
        this.closeButton.setText("Close");
        panel1.add(this.closeButton);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.rootPanel.add((Component)scrollPane1, gbc);
        scrollPane1.setViewportView(this.snmpTable);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

