/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.smi;

import java.util.Arrays;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraint;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class EnumerationConstraint
implements ValueConstraint {
    private int[] allowedValues;

    public EnumerationConstraint(int[] allowedValues) {
        this.allowedValues = new int[allowedValues.length];
        System.arraycopy(allowedValues, 0, this.allowedValues, 0, allowedValues.length);
        Arrays.sort(this.allowedValues);
    }

    @Override
    public int validate(Variable variable) {
        if (variable instanceof Integer32) {
            if (Arrays.binarySearch(this.allowedValues, ((Integer32)variable).getValue()) < 0) {
                return 10;
            }
            return 0;
        }
        if (variable instanceof OctetString) {
            OctetString s = (OctetString)variable;
            int maxLength = 0;
            if (this.allowedValues.length > 0) {
                maxLength = this.allowedValues[this.allowedValues.length - 1] / 8 + 1;
            }
            if (s.length() > maxLength) {
                return 8;
            }
            for (int i2 = 0; i2 < s.length(); ++i2) {
                byte b2 = s.get(i2);
                for (int j2 = 0; j2 < 8; ++j2) {
                    if ((b2 & 1 << 7 - j2) <= 0 || Arrays.binarySearch(this.allowedValues, i2 * 8 + j2) >= 0) continue;
                    return 10;
                }
            }
            return 0;
        }
        return 7;
    }
}

