/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpTagValue
extends MOMutableColumn {
    public SnmpTagValue(int columnID, MOAccess access, OctetString defaultValue) {
        super(columnID, 4, access, defaultValue);
    }

    public SnmpTagValue(int columnID, MOAccess access, OctetString defaultValue, boolean mutableInService) {
        super(columnID, 4, access, defaultValue, mutableInService);
    }

    public static boolean isDelimiter(byte b2) {
        return b2 == 32 || b2 == 9 || b2 == 13 || b2 == 11;
    }

    @Override
    public synchronized int validate(Variable newValue, Variable oldValue) {
        int status = super.validate(newValue, oldValue);
        if (status == 0) {
            status = SnmpTagValue.isValidTagValue(newValue);
        }
        return status;
    }

    public static int isValidTagValue(Variable newValue) {
        if (!(newValue instanceof OctetString)) {
            return 7;
        }
        int status = 0;
        OctetString os = (OctetString)newValue;
        if (os.length() > 255) {
            status = 8;
        } else {
            for (int i2 = 0; i2 < os.length(); ++i2) {
                if (!SnmpTagValue.isDelimiter(os.get(i2))) continue;
                status = 3;
                break;
            }
        }
        return status;
    }
}

