/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.Context;
import org.snmp4j.agent.io.MOInfo;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class MOServerPersistence {
    private static final LogAdapter logger = LogFactory.getLogger(MOServerPersistence.class);
    private MOServer[] servers;

    public MOServerPersistence(MOServer server) {
        this(new MOServer[]{server});
    }

    public MOServerPersistence(MOServer[] moServers) {
        this.servers = moServers;
    }

    private HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject>> buildCache() {
        HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject>> serializableMO = new HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject>>();
        serializableMO.clear();
        for (MOServer server : this.servers) {
            Iterator<Map.Entry<MOScope, ManagedObject>> it = server.iterator();
            while (it.hasNext()) {
                LinkedHashMap<OID, SerializableManagedObject> objects;
                Map.Entry<MOScope, ManagedObject> entry = it.next();
                MOScope scope = entry.getKey();
                ManagedObject value = entry.getValue();
                if (!(value instanceof SerializableManagedObject) || ((SerializableManagedObject)value).isVolatile()) continue;
                OctetString context = null;
                if (scope instanceof MOContextScope) {
                    context = ((MOContextScope)scope).getContext();
                }
                if ((objects = serializableMO.get(context)) == null) {
                    objects = new LinkedHashMap();
                    serializableMO.put(context, objects);
                }
                objects.put(((SerializableManagedObject)value).getID(), (SerializableManagedObject)value);
            }
        }
        return serializableMO;
    }

    public synchronized void loadData(MOInput input) throws IOException {
        int i2;
        HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject>> serializableMO = this.buildCache();
        LinkedHashMap<OID, SerializableManagedObject> mos = serializableMO.get(null);
        if (mos != null) {
            MOServerPersistence.readData(input, mos);
        } else {
            Sequence seq = input.readSequence();
            for (i2 = 0; i2 < seq.getSize(); ++i2) {
                MOInfo mo = input.readManagedObject();
                input.skipManagedObject(mo);
            }
        }
        Sequence contextSequence = input.readSequence();
        if (contextSequence != null) {
            for (i2 = 0; i2 < contextSequence.getSize(); ++i2) {
                Context context = input.readContext();
                boolean skip = true;
                for (int s = 0; skip && s < this.servers.length; ++s) {
                    if (!this.servers[s].isContextSupported(context.getContext())) continue;
                    skip = false;
                }
                if (skip) {
                    logger.warn((Serializable)((Object)("Context '" + context.getContext() + "' is no longer supported by agent")));
                    input.skipContext(context);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Loading data for context '" + context.getContext() + "'")));
                }
                if ((mos = serializableMO.get(context.getContext())) == null) {
                    input.skipContext(context);
                    continue;
                }
                MOServerPersistence.readData(input, mos);
                input.skipContext(context);
            }
        }
    }

    private static void readData(MOInput input, LinkedHashMap<OID, SerializableManagedObject> mos) throws IOException {
        Sequence moGroup = input.readSequence();
        if (moGroup != null) {
            for (int j2 = 0; j2 < moGroup.getSize(); ++j2) {
                SerializableManagedObject mo;
                MOInfo moid = input.readManagedObject();
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Looking up object " + moid.getOID())));
                }
                if ((mo = mos.get(moid.getOID())) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Loading data for object " + moid.getOID())));
                    }
                    mo.load(input);
                }
                input.skipManagedObject(moid);
            }
        }
    }

    public synchronized void saveData(MOOutput output) throws IOException {
        HashMap<OctetString, LinkedHashMap<OID, SerializableManagedObject>> serializableMO = this.buildCache();
        LinkedHashMap<OID, SerializableManagedObject> mos = serializableMO.get(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)"Trying to write MIB data for all contexts"));
        }
        if (mos != null) {
            MOServerPersistence.writeData(output, null, mos);
        } else {
            output.writeSequence(new Sequence(0));
        }
        HashSet<OctetString> contextSet = new HashSet<OctetString>();
        for (MOServer server : this.servers) {
            contextSet.addAll(Arrays.asList(server.getContexts()));
        }
        OctetString[] contexts = contextSet.toArray(new OctetString[contextSet.size()]);
        output.writeSequence(new Sequence(contexts.length));
        for (OctetString context : contexts) {
            Context c2 = new Context(context);
            output.writeContextBegin(c2);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Trying to write MIB data for context '" + c2.getContext() + "'")));
            }
            if ((mos = serializableMO.get(c2.getContext())) != null) {
                MOServerPersistence.writeData(output, c2, mos);
            }
            output.writeContextEnd(c2);
        }
    }

    private static void writeData(MOOutput output, Context c2, LinkedHashMap<? extends OID, SerializableManagedObject> mos) throws IOException {
        if (logger.isDebugEnabled()) {
            if (c2 == null) {
                logger.debug((Serializable)((Object)("Writing " + mos.size() + " context independent managed objects")));
            } else {
                logger.debug((Serializable)((Object)("Writing " + mos.size() + " managed objects for context '" + c2.getContext() + "'")));
            }
        }
        output.writeSequence(new Sequence(mos.size()));
        for (SerializableManagedObject mo : mos.values()) {
            MOInfo moInfo = new MOInfo(mo.getID());
            output.writeManagedObjectBegin(moInfo);
            mo.save(output);
            output.writeManagedObjectEnd(moInfo);
        }
    }
}

