/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.snmp4j.agent.ContextEvent;
import org.snmp4j.agent.ContextListener;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.ManagedObjectValueAccess;
import org.snmp4j.agent.RegisteredManagedObject;
import org.snmp4j.agent.UpdatableManagedObject;
import org.snmp4j.agent.UpdateStrategy;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.lock.DefaultMOLockStrategy;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.agent.mo.lock.MOLockStrategy;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class DefaultMOServer
implements MOServer {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultMOServer.class);
    private Set<OctetString> contexts;
    private SortedMap<MOScope, ManagedObject> registry;
    private Map<ManagedObject, Lock> lockList;
    private Map<ManagedObject, List<MOServerLookupListener>> lookupListener;
    private transient Vector<ContextListener> contextListeners;
    private UpdateStrategy updateStrategy;
    private MOLockStrategy lockStrategy = new DefaultMOLockStrategy();

    public DefaultMOServer() {
        this.registry = new TreeMap<MOScope, ManagedObject>(new MOScopeComparator());
        this.contexts = new LinkedHashSet<OctetString>(10);
        this.lockList = new Hashtable<ManagedObject, Lock>(10);
    }

    @Override
    public ManagedObject lookup(MOQuery query) {
        return this.lookup(query, false, null);
    }

    @Override
    public ManagedObject lookup(MOQuery query, LockRequest lockRequest) {
        return this.lookup(query, false, lockRequest);
    }

    public MOLockStrategy getLockStrategy() {
        return this.lockStrategy;
    }

    public void setLockStrategy(MOLockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    private ManagedObject lookup(MOQuery query, boolean specificRegistrationsOnly, LockRequest lockRequest) {
        SortedMap<MOScope, ManagedObject> scope = this.registry.tailMap(query);
        boolean timedOut = false;
        if (lockRequest != null) {
            lockRequest.setLockRequestStatus(LockRequest.LockStatus.notRequired);
        }
        for (Map.Entry<MOScope, ManagedObject> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            if (!MOScopeComparator.isQueryContextMatching(query, key) || specificRegistrationsOnly && (key instanceof MOContextScope && ((MOContextScope)key).getContext() == null || !(key instanceof MOContextScope))) continue;
            ManagedObject mo = entry.getValue();
            MOScope moScope = mo.getScope();
            if (!query.getScope().isOverlapping(moScope)) continue;
            this.fireQueryEvent(mo, query);
            if (this.lockStrategy != null && lockRequest != null && lockRequest.getLockOwner() != null && this.lockStrategy.isLockNeeded(mo, query)) {
                if (!this.lock(lockRequest.getLockOwner(), mo, lockRequest.getTimeoutMillis())) {
                    timedOut = true;
                    continue;
                }
                lockRequest.setLockRequestStatus(timedOut ? LockRequest.LockStatus.lockedAfterTimeout : LockRequest.LockStatus.locked);
            }
            if (mo instanceof UpdatableManagedObject) {
                this.checkForUpdate((UpdatableManagedObject)mo, query);
            }
            if (query.matchesQuery(mo)) {
                this.fireLookupEvent(mo, query);
                return mo;
            }
            if (lockRequest == null) continue;
            this.unlock(lockRequest.getLockOwner(), mo);
        }
        if (timedOut) {
            lockRequest.setLockRequestStatus(LockRequest.LockStatus.lockTimedOut);
        }
        return null;
    }

    protected void checkForUpdate(UpdatableManagedObject mo, MOQuery query) {
        if (this.updateStrategy != null && this.updateStrategy.isUpdateNeeded(this, mo, query)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Updating UpdatableManagedObject " + mo + " on behalf of query " + query)));
            }
            mo.update(query);
        }
    }

    public ManagedObject getManagedObject(OID key, OctetString context, boolean fireLookupEvents) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        DefaultMOQuery query = new DefaultMOQuery(scope);
        SortedMap<MOScope, ManagedObject> reducedScope = this.registry.tailMap(query);
        for (Map.Entry<MOScope, ManagedObject> entry : reducedScope.entrySet()) {
            ManagedObject mo;
            MOScope compareScope = entry.getKey();
            if (!MOScopeComparator.isQueryContextMatching(query, compareScope) || (!((mo = entry.getValue()) instanceof RegisteredManagedObject) || !((RegisteredManagedObject)mo).getID().equals(key)) && (mo instanceof RegisteredManagedObject || !key.equals(mo.getScope().getLowerBound()))) continue;
            if (fireLookupEvents) {
                this.fireQueryEvent(mo, query);
                boolean locked = false;
                if (mo instanceof UpdatableManagedObject && (locked = this.lock(this, mo))) {
                    this.checkForUpdate((UpdatableManagedObject)mo, query);
                }
                this.fireLookupEvent(mo, query);
                if (locked) {
                    this.unlock(this, mo);
                }
            }
            return mo;
        }
        return null;
    }

    public ManagedObject getManagedObject(OID key, OctetString context) {
        return this.getManagedObject(key, context, true);
    }

    public static Variable getValue(MOServer server, OctetString context, OID key) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        ManagedObject mo = server.lookup(new DefaultMOQuery(scope));
        if (mo instanceof ManagedObjectValueAccess) {
            return ((ManagedObjectValueAccess)mo).getValue(key);
        }
        return null;
    }

    public static boolean setValue(MOServer server, OctetString context, VariableBinding newValueAndKey) {
        OID key = newValueAndKey.getOid();
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        ManagedObject mo = server.lookup(new DefaultMOQuery(scope));
        if (mo instanceof ManagedObjectValueAccess) {
            return ((ManagedObjectValueAccess)mo).setValue(newValueAndKey);
        }
        return false;
    }

    protected void fireLookupEvent(ManagedObject mo, MOQuery query) {
        List<MOServerLookupListener> l2;
        if (this.lookupListener != null && (l2 = this.lookupListener.get(mo)) != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query);
            l2 = new ArrayList<MOServerLookupListener>(l2);
            for (MOServerLookupListener item : l2) {
                item.lookupEvent(event);
            }
        }
    }

    protected void fireQueryEvent(ManagedObject mo, MOQuery query) {
        List<MOServerLookupListener> l2;
        if (this.lookupListener != null && (l2 = this.lookupListener.get(mo)) != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query);
            l2 = new ArrayList<MOServerLookupListener>(l2);
            for (MOServerLookupListener item : l2) {
                item.queryEvent(event);
            }
        }
    }

    @Override
    public OctetString[] getContexts() {
        return this.contexts.toArray(new OctetString[this.contexts.size()]);
    }

    @Override
    public boolean isContextSupported(OctetString context) {
        if (context == null || context.length() == 0) {
            return true;
        }
        return this.contexts.contains(context);
    }

    public SortedMap<MOScope, ManagedObject> getRegistry() {
        return this.registry;
    }

    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    @Override
    public void register(ManagedObject mo, OctetString context) throws DuplicateRegistrationException {
        if (context == null || context.length() == 0) {
            DefaultMOContextScope contextScope = new DefaultMOContextScope(null, mo.getScope());
            ManagedObject other = this.lookup(new DefaultMOQuery(contextScope));
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(mo.getScope(), mo);
            if (logger.isInfoEnabled()) {
                logger.info("Registered MO [" + mo.getClass().getSimpleName() + "] in default context with scope " + mo.getScope());
            }
        } else {
            DefaultMOContextScope contextScope = new DefaultMOContextScope(context, mo.getScope());
            ManagedObject other = this.lookup(new DefaultMOQuery(contextScope), true, null);
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(contextScope, mo);
            if (logger.isInfoEnabled()) {
                logger.info("Registered MO [" + mo.getClass().getSimpleName() + "] in context " + context + " with scope " + contextScope);
            }
        }
    }

    @Override
    public ManagedObject unregister(ManagedObject mo, OctetString context) {
        MOScope key = context == null || context.length() == 0 ? mo.getScope() : new DefaultMOContextScope(context, mo.getScope());
        ManagedObject r2 = (ManagedObject)this.registry.remove(key);
        if (r2 == null) {
            SortedMap<MOScope, ManagedObject> tailMap = this.registry.tailMap(key);
            Iterator<Map.Entry<MOScope, ManagedObject>> it = tailMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MOScope, ManagedObject> entry = it.next();
                MOScope entryKey = entry.getKey();
                if (!entry.getValue().equals(mo) || (context == null || !(entryKey instanceof MOContextScope) || !context.equals(((MOContextScope)entryKey).getContext())) && context != null) continue;
                r2 = entry.getValue();
                it.remove();
                break;
            }
        }
        if (logger.isInfoEnabled()) {
            if (r2 != null) {
                logger.info("Removed registration " + r2 + " for " + mo.getScope() + " in context '" + context + "' successfully");
            } else {
                logger.warn((Serializable)((Object)("Removing registration failed for " + mo.getScope() + " in context '" + context + "'")));
            }
        }
        return r2;
    }

    @Override
    public void addContext(OctetString context) {
        this.contexts.add(context);
    }

    @Override
    public void removeContext(OctetString context) {
        this.contexts.remove(context);
    }

    @Override
    public synchronized boolean lock(Object owner, ManagedObject managedObject) {
        return this.lock(owner, managedObject, 0L);
    }

    @Override
    public synchronized boolean lock(Object owner, ManagedObject managedObject, long timeoutMillis) {
        long start = System.nanoTime();
        do {
            Lock lock;
            if ((lock = this.lockList.get(managedObject)) == null || lock.getOwner() != owner && lock.getCount() <= 0) {
                this.lockList.put(managedObject, new Lock(owner));
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Acquired lock on " + managedObject + " for " + owner)));
                }
                return true;
            }
            if (lock.getOwner() != owner) {
                try {
                    while (lock.getCount() > 0 && (System.nanoTime() - start) / 1000000L < timeoutMillis) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Waiting for lock on " + managedObject)));
                        }
                        if (timeoutMillis <= 0L) {
                            this.wait();
                            continue;
                        }
                        this.wait(Math.max(timeoutMillis - (System.nanoTime() - start) / 1000000L, 1L));
                    }
                    continue;
                }
                catch (InterruptedException ex) {
                    logger.warn((Serializable)((Object)("Waiting for lock on " + managedObject + " has been interrupted!")));
                    break;
                }
            }
            lock.add();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Added lock on " + managedObject + " for " + owner)));
            }
            return true;
        } while (timeoutMillis <= 0L || (System.nanoTime() - start) / 1000000L < timeoutMillis);
        return false;
    }

    @Override
    public synchronized boolean unlock(Object owner, ManagedObject managedObject) {
        Lock lock;
        if (managedObject != null && (lock = this.lockList.get(managedObject)) != null) {
            if (lock.getOwner() != owner) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Object '" + owner + "' is not owner of lock: " + lock)));
                }
            } else if (lock.remove()) {
                this.lockList.remove(managedObject);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Removed lock on " + managedObject + " by " + owner)));
                }
                this.notify();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<MOScope, ManagedObject>> iterator() {
        SortedMap<MOScope, ManagedObject> m2;
        SortedMap<MOScope, ManagedObject> sortedMap = m2 = this.getRegistry();
        synchronized (sortedMap) {
            TreeMap<MOScope, ManagedObject> r2 = new TreeMap<MOScope, ManagedObject>(new MOScopeComparator());
            r2.putAll(m2);
            return r2.entrySet().iterator();
        }
    }

    @Override
    public synchronized void addLookupListener(MOServerLookupListener listener, ManagedObject mo) {
        List<MOServerLookupListener> l2;
        if (this.lookupListener == null) {
            this.lookupListener = Collections.synchronizedMap(new HashMap());
        }
        if ((l2 = this.lookupListener.get(mo)) == null) {
            l2 = Collections.synchronizedList(new LinkedList());
            this.lookupListener.put(mo, l2);
        }
        l2.add(listener);
    }

    @Override
    public synchronized boolean removeLookupListener(MOServerLookupListener listener, ManagedObject mo) {
        List<MOServerLookupListener> l2;
        if (this.lookupListener != null && (l2 = this.lookupListener.get(mo)) != null) {
            return l2.remove(listener);
        }
        return false;
    }

    @Override
    public synchronized void addContextListener(ContextListener l2) {
        if (this.contextListeners == null) {
            this.contextListeners = new Vector(2);
        }
        this.contextListeners.add(l2);
    }

    @Override
    public synchronized void removeContextListener(ContextListener l2) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(l2);
        }
    }

    protected void fireContextChanged(ContextEvent event) {
        if (this.contextListeners != null) {
            Vector<ContextListener> listeners = this.contextListeners;
            for (ContextListener listener : listeners) {
                listener.contextChanged(event);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append("[contexts=");
        buf.append(this.contexts);
        buf.append("[keys={");
        Iterator<MOScope> it = this.registry.keySet().iterator();
        while (it.hasNext()) {
            MOScope scope = it.next();
            buf.append(scope.getLowerBound());
            if (scope.isLowerIncluded()) {
                buf.append("+");
            }
            buf.append("-");
            buf.append(scope.getUpperBound());
            if (scope.isUpperIncluded()) {
                buf.append("+");
            }
            if (scope instanceof MOContextScope) {
                buf.append("(").append(((MOContextScope)scope).getContext()).append(")");
            }
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        buf.append(",registry=").append(this.registry);
        buf.append(",lockList=").append(this.lockList);
        buf.append(",lookupListener=").append(this.lookupListener);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public OctetString[] getRegisteredContexts(ManagedObject managedObject) {
        HashSet<OctetString> contextSet = new HashSet<OctetString>();
        SortedMap<MOScope, ManagedObject> scope = this.registry.tailMap(new DefaultMOContextScope(null, managedObject.getScope()));
        for (Map.Entry<MOScope, ManagedObject> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            ManagedObject o2 = entry.getValue();
            if (!managedObject.equals(o2)) continue;
            if (key instanceof MOContextScope) {
                contextSet.add(((MOContextScope)key).getContext());
                continue;
            }
            contextSet.add(null);
        }
        return contextSet.toArray(new OctetString[contextSet.size()]);
    }

    public static <R extends MOTableRow, T extends MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>>> void registerTableRowListener(MOServer server, MOTableRowListener<R> listener) {
        Iterator<Map.Entry<MOScope, ManagedObject>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject mo = it.next().getValue();
            if (!(mo instanceof MOTable)) continue;
            ((MOTable)mo).addMOTableRowListener(listener);
        }
    }

    public static <R extends MOTableRow, T extends MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>>> void unregisterTableRowListener(MOServer server, MOTableRowListener<R> listener) {
        Iterator<Map.Entry<MOScope, ManagedObject>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject mo = it.next().getValue();
            if (!(mo instanceof MOTable)) continue;
            ((MOTable)mo).removeMOTableRowListener(listener);
        }
    }

    static class Lock {
        private Object owner;
        private long creationTime = System.currentTimeMillis();
        private int count = 0;

        private Lock() {
        }

        Lock(Object owner) {
            this();
            this.owner = owner;
            this.count = 1;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public int getCount() {
            return this.count;
        }

        public synchronized void add() {
            ++this.count;
        }

        public synchronized boolean remove() {
            if (--this.count <= 0) {
                if (this.count != 0) {
                    this.count = 0;
                }
                return true;
            }
            return false;
        }

        public Object getOwner() {
            return this.owner;
        }

        public String toString() {
            return "Lock[owner=" + this.owner + ", creationTime=" + this.creationTime + ", count=" + this.count + ']';
        }
    }
}

