/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class PDU
implements BERSerializable,
Serializable {
    private static final long serialVersionUID = 7607672475629607472L;
    public static final int GET = -96;
    public static final int GETNEXT = -95;
    public static final int RESPONSE = -94;
    public static final int SET = -93;
    public static final int V1TRAP = -92;
    public static final int GETBULK = -91;
    public static final int INFORM = -90;
    public static final int TRAP = -89;
    public static final int NOTIFICATION = -89;
    public static final int REPORT = -88;
    public static final int noError = 0;
    public static final int tooBig = 1;
    public static final int noSuchName = 2;
    public static final int badValue = 3;
    public static final int readOnly = 4;
    public static final int genErr = 5;
    public static final int noAccess = 6;
    public static final int wrongType = 7;
    public static final int wrongLength = 8;
    public static final int wrongValue = 10;
    public static final int wrongEncoding = 9;
    public static final int noCreation = 11;
    public static final int inconsistentValue = 12;
    public static final int resourceUnavailable = 13;
    public static final int commitFailed = 14;
    public static final int undoFailed = 15;
    public static final int authorizationError = 16;
    public static final int notWritable = 17;
    public static final int inconsistentName = 18;
    protected Vector<VariableBinding> variableBindings = new Vector();
    protected Integer32 errorStatus = new Integer32();
    protected Integer32 errorIndex = new Integer32();
    protected Integer32 requestID = new Integer32();
    protected int type = -96;

    public PDU() {
    }

    public PDU(PDU other) {
        this.variableBindings = new Vector(other.size());
        for (VariableBinding vb : other.variableBindings) {
            this.variableBindings.add((VariableBinding)vb.clone());
        }
        this.errorIndex = (Integer32)other.errorIndex.clone();
        this.errorStatus = (Integer32)other.errorStatus.clone();
        this.type = other.type;
        if (other.requestID != null) {
            this.requestID = (Integer32)other.requestID.clone();
        }
    }

    public PDU(int pduType, List<? extends VariableBinding> vbs) {
        this.type = pduType;
        this.variableBindings = new Vector(vbs.size());
        for (VariableBinding variableBinding : vbs) {
            this.variableBindings.add((VariableBinding)variableBinding.clone());
        }
    }

    public void add(VariableBinding vb) {
        this.variableBindings.add(vb);
    }

    public void addOID(VariableBinding vb) {
        VariableBinding cvb = new VariableBinding(vb.getOid());
        this.variableBindings.add(cvb);
    }

    public void addAll(VariableBinding[] vbs) {
        this.variableBindings.ensureCapacity(this.variableBindings.size() + vbs.length);
        for (VariableBinding vb : vbs) {
            this.add(vb);
        }
    }

    public void addAll(List<? extends VariableBinding> vbs) {
        this.variableBindings.addAll(vbs);
    }

    public void addAllOIDs(VariableBinding[] vbs) {
        this.variableBindings.ensureCapacity(this.variableBindings.size() + vbs.length);
        for (VariableBinding vb : vbs) {
            this.addOID(vb);
        }
    }

    public VariableBinding get(int index) {
        return this.variableBindings.get(index);
    }

    public Variable getVariable(OID prefix) {
        for (VariableBinding vb : this.variableBindings) {
            if (!vb.getOid().startsWith(prefix)) continue;
            return vb.getVariable();
        }
        return null;
    }

    public List<VariableBinding> getBindingList(OID prefix) {
        ArrayList<VariableBinding> list = new ArrayList<VariableBinding>(this.variableBindings.size());
        for (VariableBinding vb : this.variableBindings) {
            if (!vb.getOid().startsWith(prefix)) continue;
            list.add(vb);
        }
        return list;
    }

    public VariableBinding set(int index, VariableBinding vb) {
        if (vb == null) {
            throw new NullPointerException("Variable binding must not be null");
        }
        return this.variableBindings.set(index, vb);
    }

    public void remove(int index) {
        this.variableBindings.remove(index);
    }

    public int size() {
        return this.variableBindings.size();
    }

    public Vector<? extends VariableBinding> getVariableBindings() {
        return this.variableBindings;
    }

    public void setVariableBindings(List<? extends VariableBinding> vbs) {
        if (vbs == null) {
            throw new NullPointerException();
        }
        this.variableBindings = new Vector<VariableBinding>(vbs);
    }

    public void trim() {
        if (this.variableBindings.size() > 0) {
            this.variableBindings.remove(this.variableBindings.size() - 1);
        }
    }

    public void setErrorStatus(int errorStatus) {
        this.errorStatus.setValue(errorStatus);
    }

    public int getErrorStatus() {
        return this.errorStatus.getValue();
    }

    public String getErrorStatusText() {
        return PDU.toErrorStatusText(this.errorStatus.getValue());
    }

    public static String toErrorStatusText(int errorStatus) {
        try {
            if (errorStatus < 0) {
                return SnmpConstants.SNMP_TP_ERROR_MESSAGES[Math.abs(errorStatus) - 1];
            }
            return SnmpConstants.SNMP_ERROR_MESSAGES[errorStatus];
        }
        catch (ArrayIndexOutOfBoundsException iobex) {
            return "Unknown error: " + errorStatus;
        }
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex.setValue(errorIndex);
    }

    public int getErrorIndex() {
        return this.errorIndex.getValue();
    }

    public boolean isConfirmedPdu() {
        return this.type != -88 && this.type != -94 && this.type != -89 && this.type != -92;
    }

    public boolean isResponsePdu() {
        return this.type == -94 || this.type == -88;
    }

    @Override
    public int getBERLength() {
        int length = this.getBERPayloadLengthPDU();
        length += BER.getBERLengthOfLength(length) + 1;
        return length;
    }

    @Override
    public int getBERPayloadLength() {
        return this.getBERPayloadLengthPDU();
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte pduType = new BER.MutableByte();
        int length = BER.decodeHeader(inputStream, pduType);
        int pduStartPos = (int)inputStream.getPosition();
        switch (pduType.getValue()) {
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -91: 
            case -90: 
            case -89: 
            case -88: {
                break;
            }
            default: {
                throw new IOException("Unsupported PDU type: " + pduType.getValue());
            }
        }
        this.type = pduType.getValue();
        this.requestID.decodeBER(inputStream);
        this.errorStatus.decodeBER(inputStream);
        this.errorIndex.decodeBER(inputStream);
        pduType = new BER.MutableByte();
        int vbLength = BER.decodeHeader(inputStream, pduType);
        if (pduType.getValue() != 48) {
            throw new IOException("Encountered invalid tag, SEQUENCE expected: " + pduType.getValue());
        }
        int startPos = (int)inputStream.getPosition();
        this.variableBindings = new Vector();
        while (inputStream.getPosition() - (long)startPos < (long)vbLength) {
            VariableBinding vb = new VariableBinding();
            vb.decodeBER(inputStream);
            this.variableBindings.add(vb);
        }
        if (inputStream.getPosition() - (long)startPos != (long)vbLength) {
            throw new IOException("Length of VB sequence (" + vbLength + ") does not match real length: " + ((int)inputStream.getPosition() - startPos));
        }
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(length, (int)inputStream.getPosition() - pduStartPos, this);
        }
    }

    public static int getBERLength(List<? extends VariableBinding> variableBindings) {
        int length = 0;
        for (VariableBinding variableBinding : variableBindings) {
            length += variableBinding.getBERLength();
        }
        return length;
    }

    protected int getBERPayloadLengthPDU() {
        int length = PDU.getBERLength(this.variableBindings);
        length += BER.getBERLengthOfLength(length) + 1;
        Integer32 i32 = new Integer32(this.requestID.getValue());
        length += i32.getBERLength();
        i32 = this.errorStatus;
        length += i32.getBERLength();
        i32 = this.errorIndex;
        length += i32.getBERLength();
        i32 = null;
        return length;
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, this.type, this.getBERPayloadLengthPDU());
        this.requestID.encodeBER(outputStream);
        this.errorStatus.encodeBER(outputStream);
        this.errorIndex.encodeBER(outputStream);
        int vbLength = 0;
        for (VariableBinding vb : this.variableBindings) {
            vbLength += vb.getBERLength();
        }
        BER.encodeHeader(outputStream, 48, vbLength);
        for (VariableBinding vb : this.variableBindings) {
            vb.encodeBER(outputStream);
        }
    }

    public void clear() {
        this.variableBindings.clear();
        this.setRequestID(new Integer32(0));
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Object clone() {
        return new PDU(this);
    }

    public Integer32 getRequestID() {
        return this.requestID;
    }

    public void setRequestID(Integer32 requestID) {
        this.requestID = requestID;
    }

    public static String getTypeString(int type) {
        switch (type) {
            case -96: {
                return "GET";
            }
            case -93: {
                return "SET";
            }
            case -95: {
                return "GETNEXT";
            }
            case -91: {
                return "GETBULK";
            }
            case -90: {
                return "INFORM";
            }
            case -94: {
                return "RESPONSE";
            }
            case -88: {
                return "REPORT";
            }
            case -89: {
                return "TRAP";
            }
            case -92: {
                return "V1TRAP";
            }
        }
        return "unknown";
    }

    public static int getTypeFromString(String type) {
        if (type.equals("GET")) {
            return -96;
        }
        if (type.equals("SET")) {
            return -93;
        }
        if (type.equals("GETNEXT")) {
            return -95;
        }
        if (type.equals("GETBULK")) {
            return -91;
        }
        if (type.equals("INFORM")) {
            return -90;
        }
        if (type.equals("RESPONSE")) {
            return -94;
        }
        if (type.equals("TRAP")) {
            return -89;
        }
        if (type.equals("V1TRAP")) {
            return -92;
        }
        if (type.equals("REPORT")) {
            return -88;
        }
        return Integer.MIN_VALUE;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(PDU.getTypeString(this.type));
        buf.append("[requestID=");
        buf.append(this.requestID);
        buf.append(", errorStatus=");
        buf.append(this.getErrorStatusText()).append("(").append(this.errorStatus).append(")");
        buf.append(", errorIndex=");
        buf.append(this.errorIndex);
        buf.append(", VBS[");
        for (int i2 = 0; i2 < this.variableBindings.size(); ++i2) {
            buf.append(this.variableBindings.get(i2));
            if (i2 + 1 >= this.variableBindings.size()) continue;
            buf.append("; ");
        }
        buf.append("]]");
        return buf.toString();
    }

    public int getMaxRepetitions() {
        return this.errorIndex.getValue();
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.errorIndex.setValue(maxRepetitions);
    }

    public int getNonRepeaters() {
        return this.errorStatus.getValue();
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.errorStatus.setValue(nonRepeaters);
    }

    public VariableBinding[] toArray() {
        VariableBinding[] vbs = new VariableBinding[this.variableBindings.size()];
        this.variableBindings.toArray(vbs);
        return vbs;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDU) {
            PDU o2 = (PDU)obj;
            return this.type == o2.type && AbstractVariable.equal(this.requestID, o2.requestID) && AbstractVariable.equal(this.errorStatus, o2.errorStatus) && AbstractVariable.equal(this.errorIndex, o2.errorIndex) && this.variableBindings.equals(o2.variableBindings);
        }
        return false;
    }
}

