/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttributeList;
import org.dom4j.bean.BeanDocumentFactory;
import org.dom4j.bean.BeanElement;

public class BeanMetaData {
    protected static final Object[] NULL_ARGS = new Object[0];
    private static Map singletonCache = new HashMap();
    private static final DocumentFactory DOCUMENT_FACTORY = BeanDocumentFactory.getInstance();
    private Class beanClass;
    private PropertyDescriptor[] propertyDescriptors;
    private QName[] qNames;
    private Method[] readMethods;
    private Method[] writeMethods;
    private Map nameMap = new HashMap();

    public BeanMetaData(Class beanClass) {
        this.beanClass = beanClass;
        if (beanClass != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                this.propertyDescriptors = beanInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException e2) {
                this.handleException(e2);
            }
        }
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new PropertyDescriptor[0];
        }
        int size = this.propertyDescriptors.length;
        this.qNames = new QName[size];
        this.readMethods = new Method[size];
        this.writeMethods = new Method[size];
        for (int i2 = 0; i2 < size; ++i2) {
            QName qName;
            PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i2];
            String name = propertyDescriptor.getName();
            this.qNames[i2] = qName = DOCUMENT_FACTORY.createQName(name);
            this.readMethods[i2] = propertyDescriptor.getReadMethod();
            this.writeMethods[i2] = propertyDescriptor.getWriteMethod();
            Integer index = new Integer(i2);
            this.nameMap.put(name, index);
            this.nameMap.put(qName, index);
        }
    }

    public static BeanMetaData get(Class beanClass) {
        BeanMetaData answer = (BeanMetaData)singletonCache.get(beanClass);
        if (answer == null) {
            answer = new BeanMetaData(beanClass);
            singletonCache.put(beanClass, answer);
        }
        return answer;
    }

    public int attributeCount() {
        return this.propertyDescriptors.length;
    }

    public BeanAttributeList createAttributeList(BeanElement parent) {
        return new BeanAttributeList(parent, this);
    }

    public QName getQName(int index) {
        return this.qNames[index];
    }

    public int getIndex(String name) {
        Integer index = (Integer)this.nameMap.get(name);
        return index != null ? index : -1;
    }

    public int getIndex(QName qName) {
        Integer index = (Integer)this.nameMap.get(qName);
        return index != null ? index : -1;
    }

    public Object getData(int index, Object bean) {
        try {
            Method method = this.readMethods[index];
            return method.invoke(bean, NULL_ARGS);
        }
        catch (Exception e2) {
            this.handleException(e2);
            return null;
        }
    }

    public void setData(int index, Object bean, Object data) {
        try {
            Method method = this.writeMethods[index];
            Object[] args = new Object[]{data};
            method.invoke(bean, args);
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    protected void handleException(Exception e2) {
    }
}

